/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.net.NetworkCapabilities;
import android.net.connectivity.com.android.net.module.util.CollectionUtils;
import com.android.internal.annotations.VisibleForTesting;

public class NetworkCapabilitiesUtils {
    private static final int[] DISPLAY_TRANSPORT_PRIORITIES = new int[]{4, 0, 5, 2, 1, 3, 8};
    @VisibleForTesting
    public static final long RESTRICTED_CAPABILITIES = NetworkCapabilitiesUtils.packBitList(31, 5, 2, 10, 29, 3, 7, 4, 23, 8, 27, 30, 9, 33);
    private static final long FORCE_RESTRICTED_CAPABILITIES = NetworkCapabilitiesUtils.packBitList(29, 22, 26);
    @VisibleForTesting
    public static final long UNRESTRICTED_CAPABILITIES = NetworkCapabilitiesUtils.packBitList(12, 0, 1, 6);

    public static int getDisplayTransport(int[] transports) {
        for (int transport : DISPLAY_TRANSPORT_PRIORITIES) {
            if (!CollectionUtils.contains(transports, transport)) continue;
            return transport;
        }
        if (transports.length < 1) {
            throw new IllegalArgumentException("No transport in the provided array");
        }
        return transports[0];
    }

    public static boolean inferRestrictedCapability(NetworkCapabilities nc) {
        for (int capability : NetworkCapabilitiesUtils.unpackBits(FORCE_RESTRICTED_CAPABILITIES)) {
            if (!nc.hasCapability(capability)) continue;
            return true;
        }
        for (int capability : NetworkCapabilitiesUtils.unpackBits(UNRESTRICTED_CAPABILITIES)) {
            if (!nc.hasCapability(capability)) continue;
            return false;
        }
        for (int capability : NetworkCapabilitiesUtils.unpackBits(RESTRICTED_CAPABILITIES)) {
            if (!nc.hasCapability(capability)) continue;
            return true;
        }
        return false;
    }

    public static int[] unpackBits(long val) {
        int size = Long.bitCount(val);
        int[] result = new int[size];
        int index = 0;
        int bitPos = 0;
        while (val != 0L) {
            if ((val & 1L) == 1L) {
                result[index++] = bitPos;
            }
            val >>>= 1;
            ++bitPos;
        }
        return result;
    }

    public static long packBitList(int ... bits) {
        return NetworkCapabilitiesUtils.packBits(bits);
    }

    public static long packBits(int[] bits) {
        long packed = 0L;
        for (int b : bits) {
            packed |= 1L << b;
        }
        return packed;
    }
}

