/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nl80211;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class PnoNetwork
implements Parcelable {
    private boolean mIsHidden;
    private byte[] mSsid;
    private int[] mFrequencies;
    public static final Parcelable.Creator<PnoNetwork> CREATOR = new Parcelable.Creator<PnoNetwork>(){

        @Override
        public PnoNetwork createFromParcel(Parcel in) {
            PnoNetwork result = new PnoNetwork();
            result.mIsHidden = in.readInt() != 0;
            result.mSsid = in.createByteArray();
            if (result.mSsid == null) {
                result.mSsid = new byte[0];
            }
            result.mFrequencies = in.createIntArray();
            if (result.mFrequencies == null) {
                result.mFrequencies = new int[0];
            }
            return result;
        }

        public PnoNetwork[] newArray(int size) {
            return new PnoNetwork[size];
        }
    };

    public boolean isHidden() {
        return this.mIsHidden;
    }

    public void setHidden(boolean isHidden) {
        this.mIsHidden = isHidden;
    }

    public byte[] getSsid() {
        return this.mSsid;
    }

    public void setSsid(byte[] ssid) {
        if (ssid == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.mSsid = ssid;
    }

    public int[] getFrequenciesMhz() {
        return this.mFrequencies;
    }

    public void setFrequenciesMhz(int[] frequenciesMhz) {
        if (frequenciesMhz == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.mFrequencies = frequenciesMhz;
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (!(rhs instanceof PnoNetwork)) {
            return false;
        }
        PnoNetwork network = (PnoNetwork)rhs;
        return Arrays.equals(this.mSsid, network.mSsid) && Arrays.equals(this.mFrequencies, network.mFrequencies) && this.mIsHidden == network.mIsHidden;
    }

    public int hashCode() {
        return Objects.hash(this.mIsHidden, Arrays.hashCode(this.mSsid), Arrays.hashCode(this.mFrequencies));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mIsHidden ? 1 : 0);
        out.writeByteArray(this.mSsid);
        out.writeIntArray(this.mFrequencies);
    }
}

