/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Pair;
import android.util.ResolvingAttributeSet;
import android.view.ContextThemeWrapper;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewStub;
import android.widget.AbsListView;
import android.widget.AbsSpinner;
import android.widget.AdapterView;
import android.widget.ExpandableListView;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.NumberPicker;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.MockView;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.android.support.DrawerLayoutUtil;
import com.android.layoutlib.bridge.android.support.RecyclerViewUtil;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.impl.binding.FakeAdapter;
import com.android.layoutlib.bridge.impl.binding.FakeExpandableAdapter;
import com.android.layoutlib.common.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.xmlpull.v1.XmlPullParser;

public final class BridgeInflater
extends LayoutInflater {
    private static final String INFLATER_CLASS_ATTR_NAME = "viewInflaterClass";
    private static final ResourceReference RES_AUTO_INFLATER_CLASS_ATTR = ResourceReference.attr((ResourceNamespace)ResourceNamespace.RES_AUTO, (String)"viewInflaterClass");
    private static final ResourceReference LEGACY_APPCOMPAT_INFLATER_CLASS_ATTR = ResourceReference.attr((ResourceNamespace)ResourceNamespace.APPCOMPAT_LEGACY, (String)"viewInflaterClass");
    private static final ResourceReference ANDROIDX_APPCOMPAT_INFLATER_CLASS_ATTR = ResourceReference.attr((ResourceNamespace)ResourceNamespace.APPCOMPAT, (String)"viewInflaterClass");
    private static final String LEGACY_DEFAULT_APPCOMPAT_INFLATER_NAME = "android.support.v7.app.AppCompatViewInflater";
    private static final String ANDROIDX_DEFAULT_APPCOMPAT_INFLATER_NAME = "androidx.appcompat.app.AppCompatViewInflater";
    private final LayoutlibCallback mLayoutlibCallback;
    private boolean mIsInMerge = false;
    private ResourceReference mResourceReference;
    private Map<View, String> mOpenDrawerLayouts;
    private static final int[] ATTRS_THEME = new int[]{0x1010000};
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit.", "android.app."};
    private BiFunction<String, AttributeSet, View> mCustomInflater;

    public static String[] getClassPrefixList() {
        return sClassPrefixList;
    }

    private BridgeInflater(LayoutInflater original, Context newContext) {
        super(original, newContext);
        newContext = BridgeContext.getBaseContext(newContext);
        this.mLayoutlibCallback = newContext instanceof BridgeContext ? ((BridgeContext)newContext).getLayoutlibCallback() : null;
    }

    public BridgeInflater(BridgeContext context, LayoutlibCallback layoutlibCallback) {
        super(context);
        this.mLayoutlibCallback = layoutlibCallback;
        this.mConstructorArgs[0] = context;
    }

    @Override
    public View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
        View view = this.createViewFromCustomInflater(name, attrs);
        if (view == null) {
            try {
                for (String prefix : sClassPrefixList) {
                    try {
                        view = this.createView(name, prefix, attrs);
                        if (view == null) continue;
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                try {
                    if (view == null) {
                        view = super.onCreateView(name, attrs);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (view == null) {
                    view = this.loadCustomView(name, attrs);
                }
            }
            catch (InflateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ClassNotFoundException("onCreateView", e);
            }
        }
        return view;
    }

    private static Method getCreateViewMethod(Class<?> customInflaterClass) throws NoSuchMethodException {
        Class<?> current = customInflaterClass;
        while (true) {
            try {
                Method method = current.getDeclaredMethod("createView", View.class, String.class, Context.class, AttributeSet.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ((current = current.getSuperclass()) != null && current != Object.class) continue;
                throw new NoSuchMethodException();
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Class<?> findCustomInflater(BridgeContext bc, LayoutlibCallback layoutlibCallback) {
        String inflaterName;
        ResourceReference attrRef;
        if (layoutlibCallback.isResourceNamespacingRequired()) {
            if (layoutlibCallback.hasLegacyAppCompat()) {
                attrRef = LEGACY_APPCOMPAT_INFLATER_CLASS_ATTR;
            } else {
                if (!layoutlibCallback.hasAndroidXAppCompat()) return null;
                attrRef = ANDROIDX_APPCOMPAT_INFLATER_CLASS_ATTR;
            }
        } else {
            attrRef = RES_AUTO_INFLATER_CLASS_ATTR;
        }
        ResourceValue value = bc.getRenderResources().findItemInTheme(attrRef);
        String string2 = inflaterName = value != null ? value.getValue() : null;
        if (inflaterName != null) {
            try {
                return layoutlibCallback.findClass(inflaterName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        } else {
            if (!bc.isAppCompatTheme()) return null;
            try {
                if (layoutlibCallback.hasLegacyAppCompat()) {
                    return layoutlibCallback.findClass(LEGACY_DEFAULT_APPCOMPAT_INFLATER_NAME);
                }
                if (!layoutlibCallback.hasAndroidXAppCompat()) return null;
                return layoutlibCallback.findClass(ANDROIDX_DEFAULT_APPCOMPAT_INFLATER_NAME);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private View createViewFromCustomInflater(String name, AttributeSet attrs) {
        if (this.mCustomInflater == null) {
            BridgeContext bc;
            Class<?> inflaterClass;
            Context context = this.getContext();
            if ((context = BridgeContext.getBaseContext(context)) instanceof BridgeContext && (inflaterClass = BridgeInflater.findCustomInflater(bc = (BridgeContext)context, this.mLayoutlibCallback)) != null) {
                try {
                    Constructor<?> constructor = inflaterClass.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    Object inflater = constructor.newInstance(new Object[0]);
                    Method method = BridgeInflater.getCreateViewMethod(inflaterClass);
                    this.mCustomInflater = (viewName, attributeSet) -> {
                        try {
                            return (View)method.invoke(inflater, null, viewName, this.mConstructorArgs[0], attributeSet, false, false, true, true);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            Bridge.getLog().error("broken", e.getMessage(), (Throwable)e, null, null);
                            return null;
                        }
                    };
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            if (this.mCustomInflater == null) {
                this.mCustomInflater = (s, attributeSet) -> null;
            }
        }
        return this.mCustomInflater.apply(name, attrs);
    }

    @Override
    public View createViewFromTag(View parent, String name, Context context, AttributeSet attrs, boolean ignoreThemeAttr) {
        View view = null;
        if (name.equals("view") && (name = attrs.getAttributeValue(null, "class")) == null) {
            Bridge.getLog().error("broken", "Unable to inflate view tag without class attribute", null, null);
            view = new MockView(context, attrs);
            ((MockView)view).setText("view");
        }
        try {
            if (view == null) {
                view = super.createViewFromTag(parent, name, context, attrs, ignoreThemeAttr);
            }
        }
        catch (InflateException e) {
            if (!ignoreThemeAttr) {
                TypedArray ta = context.obtainStyledAttributes(attrs, ATTRS_THEME);
                int themeResId = ta.getResourceId(0, 0);
                if (themeResId != 0) {
                    context = new ContextThemeWrapper(context, themeResId);
                }
                ta.recycle();
            }
            if (!(e.getCause() instanceof ClassNotFoundException)) {
                view = new MockView(context, attrs);
                ((MockView)view).setText(name);
                Bridge.getLog().error("broken", e.getMessage(), (Throwable)e, null, null);
            }
            Object lastContext = this.mConstructorArgs[0];
            this.mConstructorArgs[0] = context;
            try {
                view = this.loadCustomView(name, attrs);
            }
            catch (Exception e2) {
                InflateException exception = new InflateException();
                if (!e2.getClass().equals(ClassNotFoundException.class)) {
                    exception.initCause(e2);
                } else {
                    exception.initCause(e);
                }
                throw exception;
            }
            finally {
                this.mConstructorArgs[0] = lastContext;
            }
        }
        this.setupViewInContext(view, attrs);
        return view;
    }

    @Override
    public View inflate(int resource, ViewGroup root) {
        Context context = this.getContext();
        if ((context = BridgeContext.getBaseContext(context)) instanceof BridgeContext) {
            BridgeContext bridgeContext = (BridgeContext)context;
            ResourceValue value = null;
            ResourceReference layoutInfo = Bridge.resolveResourceId(resource);
            if (layoutInfo == null) {
                layoutInfo = this.mLayoutlibCallback.resolveResourceId(resource);
            }
            if (layoutInfo != null) {
                value = bridgeContext.getRenderResources().getResolvedResource(layoutInfo);
            }
            if (value != null) {
                String path = value.getValue();
                try {
                    XmlPullParser parser = ParserFactory.create(path, true);
                    if (parser == null) {
                        return null;
                    }
                    BridgeXmlBlockParser bridgeParser = new BridgeXmlBlockParser(parser, bridgeContext, value.getNamespace());
                    return this.inflate(bridgeParser, root);
                }
                catch (Exception e) {
                    Bridge.getLog().error("resources.read", "Failed to parse file " + path, (Throwable)e, null, null);
                    return null;
                }
            }
        }
        return null;
    }

    private View loadCustomView(String name, AttributeSet attrs, boolean silent) throws Exception {
        if (this.mLayoutlibCallback != null) {
            Object customView;
            if (name.equals("view") && (name = attrs.getAttributeValue(null, "class")) == null) {
                return null;
            }
            this.mConstructorArgs[1] = attrs;
            Object object = customView = silent ? this.mLayoutlibCallback.loadClass(name, mConstructorSignature, this.mConstructorArgs) : this.mLayoutlibCallback.loadView(name, mConstructorSignature, this.mConstructorArgs);
            if (customView instanceof View) {
                return (View)customView;
            }
        }
        return null;
    }

    private View loadCustomView(String name, AttributeSet attrs) throws Exception {
        return this.loadCustomView(name, attrs, false);
    }

    private void setupViewInContext(final View view, AttributeSet attrs) {
        String scrollPosY;
        String scrollPosX;
        Context context = this.getContext();
        if (!((context = BridgeContext.getBaseContext(context)) instanceof BridgeContext)) {
            return;
        }
        BridgeContext bc = (BridgeContext)context;
        Object viewKey = BridgeInflater.getViewKeyFromParser(attrs, bc, this.mResourceReference, this.mIsInMerge);
        if (viewKey != null) {
            bc.addViewKey(view, viewKey);
        }
        if ((scrollPosX = attrs.getAttributeValue("http://schemas.android.com/apk/res/android", "scrollX")) != null && scrollPosX.endsWith("px")) {
            int value = Integer.parseInt(scrollPosX.substring(0, scrollPosX.length() - 2));
            bc.setScrollXPos(view, value);
        }
        if ((scrollPosY = attrs.getAttributeValue("http://schemas.android.com/apk/res/android", "scrollY")) != null && scrollPosY.endsWith("px")) {
            int value = Integer.parseInt(scrollPosY.substring(0, scrollPosY.length() - 2));
            bc.setScrollYPos(view, value);
        }
        if (ReflectionUtils.isInstanceOf((Object)view, RecyclerViewUtil.CN_RECYCLER_VIEW)) {
            ResourceValue attrListItemValue;
            int resourceId = 0;
            int attrItemCountValue = attrs.getAttributeIntValue("http://schemas.android.com/tools", "itemCount", -1);
            if (attrs instanceof ResolvingAttributeSet && (attrListItemValue = ((ResolvingAttributeSet)attrs).getResolvedAttributeValue("http://schemas.android.com/tools", "listitem")) != null) {
                resourceId = bc.getResourceId(attrListItemValue.asReference(), 0);
            }
            RecyclerViewUtil.setAdapter(view, bc, this.mLayoutlibCallback, resourceId, attrItemCountValue);
        } else if (ReflectionUtils.isInstanceOf((Object)view, DrawerLayoutUtil.CN_DRAWER_LAYOUT)) {
            String attrVal = attrs.getAttributeValue("http://schemas.android.com/tools", "openDrawer");
            if (attrVal != null) {
                this.getDrawerLayoutMap().put(view, attrVal);
            }
        } else if (view instanceof NumberPicker) {
            String maxValue;
            NumberPicker numberPicker = (NumberPicker)view;
            String minValue = attrs.getAttributeValue("http://schemas.android.com/tools", "minValue");
            if (minValue != null) {
                numberPicker.setMinValue(Integer.parseInt(minValue));
            }
            if ((maxValue = attrs.getAttributeValue("http://schemas.android.com/tools", "maxValue")) != null) {
                numberPicker.setMaxValue(Integer.parseInt(maxValue));
            }
        } else if (view instanceof ImageView) {
            ImageView img = (ImageView)view;
            Drawable drawable2 = img.getDrawable();
            if (drawable2 instanceof Animatable && !((Animatable)((Object)drawable2)).isRunning()) {
                ((Animatable)((Object)drawable2)).start();
            }
        } else if (view instanceof ViewStub) {
            String visibility = attrs.getAttributeValue("http://schemas.android.com/tools", "visibility");
            boolean isVisible = "visible".equals(visibility);
            if (isVisible || "invisible".equals(visibility)) {
                final int visibilityValue = isVisible ? 0 : 4;
                view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                    @Override
                    public void onViewAttachedToWindow(View v) {
                        v.removeOnAttachStateChangeListener(this);
                        view.setVisibility(visibilityValue);
                    }

                    @Override
                    public void onViewDetachedFromWindow(View v) {
                    }
                });
            }
        } else if (view instanceof AdapterView) {
            if (BridgeInflater.isGlanceView(view)) {
                return;
            }
            int id2 = view.getId();
            ResourceReference listRef = bc.resolveId(id2);
            if (listRef != null) {
                AdapterBinding binding;
                HashMap<String, String> bindingAttributes = new HashMap<String, String>(4);
                String header = attrs.getAttributeValue("http://schemas.android.com/tools", "listheader");
                String footer = attrs.getAttributeValue("http://schemas.android.com/tools", "listfooter");
                String layout2 = attrs.getAttributeValue("http://schemas.android.com/tools", "listitem");
                String columns = attrs.getAttributeValue("http://schemas.android.com/apk/res/android", "numColumns");
                if (header != null) {
                    bindingAttributes.put("listheader", header);
                }
                if (footer != null) {
                    bindingAttributes.put("listfooter", footer);
                }
                if (layout2 != null) {
                    bindingAttributes.put("listitem", layout2);
                }
                if (columns != null) {
                    bindingAttributes.put("numColumns", columns);
                }
                if ((binding = this.mLayoutlibCallback.getAdapterBinding((Object)view, bindingAttributes)) != null) {
                    this.setAdapterBinding(view, bc, listRef, binding);
                }
            }
        }
    }

    private void setAdapterBinding(View view, BridgeContext bc, ResourceReference listRef, AdapterBinding binding) {
        if (view instanceof AbsListView) {
            if ((binding.getFooterCount() > 0 || binding.getHeaderCount() > 0) && view instanceof ListView) {
                Pair<View, Boolean> pair;
                int i;
                ListView list = (ListView)view;
                boolean skipCallbackParser = false;
                int count = binding.getHeaderCount();
                for (i = 0; i < count; ++i) {
                    pair = bc.inflateView(binding.getHeaderAt(i), list, false, skipCallbackParser);
                    if (pair.first != null) {
                        list.addHeaderView((View)pair.first);
                    }
                    skipCallbackParser |= ((Boolean)pair.second).booleanValue();
                }
                count = binding.getFooterCount();
                for (i = 0; i < count; ++i) {
                    pair = bc.inflateView(binding.getFooterAt(i), list, false, skipCallbackParser);
                    if (pair.first != null) {
                        list.addFooterView((View)pair.first);
                    }
                    skipCallbackParser |= ((Boolean)pair.second).booleanValue();
                }
            }
            if (view instanceof ExpandableListView) {
                ((ExpandableListView)view).setAdapter(new FakeExpandableAdapter(listRef, binding, this.mLayoutlibCallback));
            } else {
                ((AbsListView)view).setAdapter(new FakeAdapter(listRef, binding, this.mLayoutlibCallback));
            }
        } else if (view instanceof AbsSpinner) {
            ((AbsSpinner)view).setAdapter(new FakeAdapter(listRef, binding, this.mLayoutlibCallback));
        }
    }

    private static boolean isGlanceAdapter(Class<?> clazz) {
        return clazz.getName().equals("androidx.glance.appwidget.preview.GlanceAppWidgetViewAdapter");
    }

    private static boolean isGlanceView(View view) {
        if (BridgeInflater.isGlanceAdapter(view.getClass())) {
            return true;
        }
        for (ViewParent parent = view.getParent(); parent != null; parent = parent.getParent()) {
            if (!BridgeInflater.isGlanceAdapter(parent.getClass())) continue;
            return true;
        }
        return false;
    }

    public void setIsInMerge(boolean isInMerge) {
        this.mIsInMerge = isInMerge;
    }

    public void setResourceReference(ResourceReference reference) {
        this.mResourceReference = reference;
    }

    @Override
    public LayoutInflater cloneInContext(Context newContext) {
        return new BridgeInflater(this, newContext);
    }

    static Object getViewKeyFromParser(AttributeSet attrs, BridgeContext bc, ResourceReference resourceReference, boolean isInMerge) {
        if (!(attrs instanceof BridgeXmlBlockParser)) {
            return null;
        }
        BridgeXmlBlockParser parser = (BridgeXmlBlockParser)attrs;
        Object viewKey = parser.getViewCookie();
        if (viewKey == null) {
            int currentDepth = parser.getDepth();
            BridgeXmlBlockParser previousParser = bc.getPreviousParser();
            if (previousParser != null) {
                int testDepth;
                int n = testDepth = isInMerge ? 2 : 1;
                if (currentDepth == testDepth && (viewKey = previousParser.getViewCookie()) != null && isInMerge) {
                    viewKey = new MergeCookie(viewKey);
                }
            } else if (resourceReference != null && currentDepth == 1) {
                viewKey = resourceReference;
            }
        }
        return viewKey;
    }

    public void postInflateProcess(View view) {
        if (this.mOpenDrawerLayouts != null) {
            String gravity = this.mOpenDrawerLayouts.get(view);
            if (gravity != null) {
                DrawerLayoutUtil.openDrawer(view, gravity);
            }
            this.mOpenDrawerLayouts.remove(view);
        }
    }

    private Map<View, String> getDrawerLayoutMap() {
        if (this.mOpenDrawerLayouts == null) {
            this.mOpenDrawerLayouts = new HashMap<View, String>(4);
        }
        return this.mOpenDrawerLayouts;
    }

    public void onDoneInflation() {
        if (this.mOpenDrawerLayouts != null) {
            this.mOpenDrawerLayouts.clear();
        }
    }
}

