/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.InsetsState;

public interface ISurfaceControlViewHost
extends IInterface {
    public static final String DESCRIPTOR = "android.view.ISurfaceControlViewHost";

    public void onConfigurationChanged(Configuration var1) throws RemoteException;

    public void onDispatchDetachedFromWindow() throws RemoteException;

    public void onInsetsChanged(InsetsState var1, Rect var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISurfaceControlViewHost {
        static final int TRANSACTION_onConfigurationChanged = 1;
        static final int TRANSACTION_onDispatchDetachedFromWindow = 2;
        static final int TRANSACTION_onInsetsChanged = 3;

        public Stub() {
            this.attachInterface(this, ISurfaceControlViewHost.DESCRIPTOR);
        }

        public static ISurfaceControlViewHost asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISurfaceControlViewHost.DESCRIPTOR);
            if (iin != null && iin instanceof ISurfaceControlViewHost) {
                return (ISurfaceControlViewHost)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onConfigurationChanged";
                }
                case 2: {
                    return "onDispatchDetachedFromWindow";
                }
                case 3: {
                    return "onInsetsChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISurfaceControlViewHost.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Configuration _arg0 = data.readTypedObject(Configuration.CREATOR);
                    data.enforceNoDataAvail();
                    this.onConfigurationChanged(_arg0);
                    break;
                }
                case 2: {
                    this.onDispatchDetachedFromWindow();
                    break;
                }
                case 3: {
                    InsetsState _arg0 = data.readTypedObject(InsetsState.CREATOR);
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.onInsetsChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements ISurfaceControlViewHost {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISurfaceControlViewHost.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigurationChanged(Configuration newConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISurfaceControlViewHost.DESCRIPTOR);
                    _data.writeTypedObject(newConfig, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onDispatchDetachedFromWindow() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISurfaceControlViewHost.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInsetsChanged(InsetsState state, Rect insetFrame) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISurfaceControlViewHost.DESCRIPTOR);
                    _data.writeTypedObject(state, 0);
                    _data.writeTypedObject(insetFrame, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISurfaceControlViewHost {
        @Override
        public void onConfigurationChanged(Configuration newConfig) throws RemoteException {
        }

        @Override
        public void onDispatchDetachedFromWindow() throws RemoteException {
        }

        @Override
        public void onInsetsChanged(InsetsState state, Rect insetFrame) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

