/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.drawable.Icon;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.KeyEvent;
import com.android.internal.util.Preconditions;

public class KeyboardShortcutInfo
implements Parcelable {
    private final CharSequence mLabel;
    private final Icon mIcon;
    private final char mBaseCharacter;
    private final int mKeycode;
    private final int mModifiers;
    public static final Parcelable.Creator<KeyboardShortcutInfo> CREATOR = new Parcelable.Creator<KeyboardShortcutInfo>(){

        @Override
        public KeyboardShortcutInfo createFromParcel(Parcel source) {
            return new KeyboardShortcutInfo(source);
        }

        public KeyboardShortcutInfo[] newArray(int size) {
            return new KeyboardShortcutInfo[size];
        }
    };

    public KeyboardShortcutInfo(CharSequence label, Icon icon, int keycode, int modifiers) {
        this.mLabel = label;
        this.mIcon = icon;
        this.mBaseCharacter = '\u0000';
        Preconditions.checkArgument(keycode >= 0 && keycode <= KeyEvent.getMaxKeyCode());
        this.mKeycode = keycode;
        this.mModifiers = modifiers;
    }

    public KeyboardShortcutInfo(CharSequence label, int keycode, int modifiers) {
        this(label, null, keycode, modifiers);
    }

    public KeyboardShortcutInfo(CharSequence label, char baseCharacter, int modifiers) {
        this.mLabel = label;
        Preconditions.checkArgument(baseCharacter != '\u0000');
        this.mBaseCharacter = baseCharacter;
        this.mKeycode = 0;
        this.mModifiers = modifiers;
        this.mIcon = null;
    }

    private KeyboardShortcutInfo(Parcel source) {
        this.mLabel = source.readCharSequence();
        this.mIcon = source.readParcelable(null, Icon.class);
        this.mBaseCharacter = (char)source.readInt();
        this.mKeycode = source.readInt();
        this.mModifiers = source.readInt();
    }

    public CharSequence getLabel() {
        return this.mLabel;
    }

    public Icon getIcon() {
        return this.mIcon;
    }

    public int getKeycode() {
        return this.mKeycode;
    }

    public char getBaseCharacter() {
        return this.mBaseCharacter;
    }

    public int getModifiers() {
        return this.mModifiers;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeCharSequence(this.mLabel);
        dest.writeParcelable(this.mIcon, 0);
        dest.writeInt(this.mBaseCharacter);
        dest.writeInt(this.mKeycode);
        dest.writeInt(this.mModifiers);
    }
}

