/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.SuppressLint;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.Application;
import android.app.LoadedApk;
import android.app.PendingIntent;
import android.app.RemoteInput;
import android.appwidget.AppWidgetHostView;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.loader.ResourcesLoader;
import android.graphics.Bitmap;
import android.graphics.BlendMode;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.graphics.drawable.RippleDrawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.DisplayMetrics;
import android.util.IntArray;
import android.util.Log;
import android.util.LongArray;
import android.util.Pair;
import android.util.SizeF;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewManager;
import android.view.ViewOutlineProvider;
import android.view.ViewParent;
import android.view.ViewStub;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.AdapterViewAnimator;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.RadioGroup;
import android.widget.RemoteCollectionItemsAdapter;
import android.widget.RemoteViewsAdapter;
import android.widget.RemoteViewsListAdapter;
import android.widget.RemoteViews_Delegate;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.util.ContrastColorUtil;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class RemoteViews
implements Parcelable,
LayoutInflater.Filter {
    private static final String LOG_TAG = "RemoteViews";
    public static final String EXTRA_CHECKED = "android.widget.extra.CHECKED";
    static final String EXTRA_REMOTEADAPTER_APPWIDGET_ID = "remoteAdapterAppWidgetId";
    static final String EXTRA_REMOTEADAPTER_ON_LIGHT_BACKGROUND = "remoteAdapterOnLightBackground";
    public static final String EXTRA_SHARED_ELEMENT_BOUNDS = "android.widget.extra.SHARED_ELEMENT_BOUNDS";
    private static final int MAX_NESTED_VIEWS = 10;
    private static final int MAX_INIT_VIEW_COUNT = 16;
    private static final int SET_ON_CLICK_RESPONSE_TAG = 1;
    private static final int REFLECTION_ACTION_TAG = 2;
    private static final int SET_DRAWABLE_TINT_TAG = 3;
    private static final int VIEW_GROUP_ACTION_ADD_TAG = 4;
    private static final int VIEW_CONTENT_NAVIGATION_TAG = 5;
    private static final int SET_EMPTY_VIEW_ACTION_TAG = 6;
    private static final int VIEW_GROUP_ACTION_REMOVE_TAG = 7;
    private static final int SET_PENDING_INTENT_TEMPLATE_TAG = 8;
    private static final int SET_REMOTE_VIEW_ADAPTER_INTENT_TAG = 10;
    private static final int TEXT_VIEW_DRAWABLE_ACTION_TAG = 11;
    private static final int BITMAP_REFLECTION_ACTION_TAG = 12;
    private static final int TEXT_VIEW_SIZE_ACTION_TAG = 13;
    private static final int VIEW_PADDING_ACTION_TAG = 14;
    private static final int SET_REMOTE_VIEW_ADAPTER_LIST_TAG = 15;
    private static final int SET_REMOTE_INPUTS_ACTION_TAG = 18;
    private static final int LAYOUT_PARAM_ACTION_TAG = 19;
    private static final int OVERRIDE_TEXT_COLORS_TAG = 20;
    private static final int SET_RIPPLE_DRAWABLE_COLOR_TAG = 21;
    private static final int SET_INT_TAG_TAG = 22;
    private static final int REMOVE_FROM_PARENT_ACTION_TAG = 23;
    private static final int RESOURCE_REFLECTION_ACTION_TAG = 24;
    private static final int COMPLEX_UNIT_DIMENSION_REFLECTION_ACTION_TAG = 25;
    private static final int SET_COMPOUND_BUTTON_CHECKED_TAG = 26;
    private static final int SET_RADIO_GROUP_CHECKED = 27;
    private static final int SET_VIEW_OUTLINE_RADIUS_TAG = 28;
    private static final int SET_ON_CHECKED_CHANGE_RESPONSE_TAG = 29;
    private static final int NIGHT_MODE_REFLECTION_ACTION_TAG = 30;
    private static final int SET_REMOTE_COLLECTION_ITEMS_ADAPTER_TAG = 31;
    private static final int ATTRIBUTE_REFLECTION_ACTION_TAG = 32;
    public static final int MARGIN_LEFT = 0;
    public static final int MARGIN_TOP = 1;
    public static final int MARGIN_RIGHT = 2;
    public static final int MARGIN_BOTTOM = 3;
    public static final int MARGIN_START = 4;
    public static final int MARGIN_END = 5;
    static final int VALUE_TYPE_RAW = 1;
    static final int VALUE_TYPE_COMPLEX_UNIT = 2;
    static final int VALUE_TYPE_RESOURCE = 3;
    static final int VALUE_TYPE_ATTRIBUTE = 4;
    public static final int FLAG_REAPPLY_DISALLOWED = 1;
    public static final int FLAG_WIDGET_IS_COLLECTION_CHILD = 2;
    public static final int FLAG_USE_LIGHT_BACKGROUND_LAYOUT = 4;
    static final int FLAG_MASK_TO_PROPAGATE = 6;
    private static final Parcel.ReadWriteHelper ALTERNATIVE_DEFAULT = new Parcel.ReadWriteHelper();
    private static final LayoutInflater.Filter INFLATER_FILTER = clazz -> clazz.isAnnotationPresent(RemoteView.class);
    @UnsupportedAppUsage
    public ApplicationInfo mApplication;
    @UnsupportedAppUsage
    private int mLayoutId;
    private int mLightBackgroundLayoutId = 0;
    @UnsupportedAppUsage
    private ArrayList<Action> mActions;
    @UnsupportedAppUsage
    private BitmapCache mBitmapCache = new BitmapCache();
    private ApplicationInfoCache mApplicationInfoCache = new ApplicationInfoCache();
    private boolean mIsRoot = true;
    private static final int MODE_NORMAL = 0;
    private static final int MODE_HAS_LANDSCAPE_AND_PORTRAIT = 1;
    private static final int MODE_HAS_SIZED_REMOTEVIEWS = 2;
    private RemoteViews mLandscape = null;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private RemoteViews mPortrait = null;
    private List<RemoteViews> mSizedRemoteViews = null;
    private SizeF mIdealSize = null;
    private int mApplyFlags = 0;
    private int mViewId = -1;
    private long mProviderInstanceId = -1L;
    private Map<Class, Object> mClassCookies;
    private static final InteractionHandler DEFAULT_INTERACTION_HANDLER = (view, pendingIntent, response) -> RemoteViews.startPendingIntent(view, pendingIntent, response.getLaunchOptions(view));
    private static final ArrayMap<MethodKey, MethodArgs> sMethods = new ArrayMap();
    private static final MethodKey sLookupKey = new MethodKey();
    private static final Action ACTION_NOOP = new RuntimeAction(){

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
        }
    };
    public static final Parcelable.Creator<RemoteViews> CREATOR = new Parcelable.Creator<RemoteViews>(){

        @Override
        public RemoteViews createFromParcel(Parcel parcel) {
            return new RemoteViews(parcel);
        }

        public RemoteViews[] newArray(int size) {
            return new RemoteViews[size];
        }
    };

    public void setRemoteInputs(int viewId, RemoteInput[] remoteInputs) {
        this.mActions.add(new SetRemoteInputsAction(viewId, remoteInputs));
    }

    public void reduceImageSizes(int maxWidth, int maxHeight) {
        ArrayList<Bitmap> cache = this.mBitmapCache.mBitmaps;
        for (int i = 0; i < cache.size(); ++i) {
            Bitmap bitmap = cache.get(i);
            cache.set(i, Icon.scaleDownIfNecessary(bitmap, maxWidth, maxHeight));
        }
    }

    public void overrideTextColors(int textColor) {
        this.addAction(new OverrideTextColorsAction(textColor));
    }

    public void setIntTag(int viewId, int key, int tag) {
        this.addAction(new SetIntTagAction(viewId, key, tag));
    }

    public void addFlags(int flags) {
        this.mApplyFlags |= flags;
        int flagsToPropagate = flags & 6;
        if (flagsToPropagate != 0) {
            if (this.hasSizedRemoteViews()) {
                for (RemoteViews remoteView : this.mSizedRemoteViews) {
                    remoteView.addFlags(flagsToPropagate);
                }
            } else if (this.hasLandscapeAndPortraitLayouts()) {
                this.mLandscape.addFlags(flagsToPropagate);
                this.mPortrait.addFlags(flagsToPropagate);
            }
        }
    }

    public boolean hasFlags(int flag) {
        return (this.mApplyFlags & flag) == flag;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void mergeRemoteViews(RemoteViews newRv) {
        if (newRv == null) {
            return;
        }
        RemoteViews copy = new RemoteViews(newRv);
        HashMap<String, Action> map = new HashMap<String, Action>();
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        int count = this.mActions.size();
        for (int i = 0; i < count; ++i) {
            Action a = this.mActions.get(i);
            map.put(a.getUniqueKey(), a);
        }
        ArrayList<Action> newActions = copy.mActions;
        if (newActions == null) {
            return;
        }
        count = newActions.size();
        for (int i = 0; i < count; ++i) {
            Action a = newActions.get(i);
            String key = newActions.get(i).getUniqueKey();
            int mergeBehavior = newActions.get(i).mergeBehavior();
            if (map.containsKey(key) && mergeBehavior == 0) {
                this.mActions.remove(map.get(key));
                map.remove(key);
            }
            if (mergeBehavior != 0 && mergeBehavior != 1) continue;
            this.mActions.add(a);
        }
        this.reconstructCaches();
    }

    public void visitUris(Consumer<Uri> visitor) {
        if (this.mActions != null) {
            for (int i = 0; i < this.mActions.size(); ++i) {
                this.mActions.get(i).visitUris(visitor);
            }
        }
        if (this.mLandscape != null) {
            this.mLandscape.visitUris(visitor);
        }
        if (this.mPortrait != null) {
            this.mPortrait.visitUris(visitor);
        }
    }

    private static void visitIconUri(Icon icon, Consumer<Uri> visitor) {
        if (icon != null && (icon.getType() == 4 || icon.getType() == 6)) {
            visitor.accept(icon.getUri());
        }
    }

    public static Rect getSourceBounds(View v) {
        float appScale = v.getContext().getResources().getCompatibilityInfo().applicationScale;
        int[] pos = new int[2];
        v.getLocationOnScreen(pos);
        Rect rect = new Rect();
        rect.left = (int)((float)pos[0] * appScale + 0.5f);
        rect.top = (int)((float)pos[1] * appScale + 0.5f);
        rect.right = (int)((float)(pos[0] + v.getWidth()) * appScale + 0.5f);
        rect.bottom = (int)((float)(pos[1] + v.getHeight()) * appScale + 0.5f);
        return rect;
    }

    private static Class<?> getParameterType(int type) {
        switch (type) {
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Byte.TYPE;
            }
            case 3: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case 5: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Double.TYPE;
            }
            case 8: {
                return Character.TYPE;
            }
            case 9: {
                return String.class;
            }
            case 10: {
                return CharSequence.class;
            }
            case 11: {
                return Uri.class;
            }
            case 12: {
                return Bitmap.class;
            }
            case 13: {
                return Bundle.class;
            }
            case 14: {
                return Intent.class;
            }
            case 15: {
                return ColorStateList.class;
            }
            case 16: {
                return Icon.class;
            }
            case 17: {
                return BlendMode.class;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodHandle getMethod(View view, String methodName, Class<?> paramType, boolean async) {
        Class<?> klass = view.getClass();
        ArrayMap<MethodKey, MethodArgs> arrayMap = sMethods;
        synchronized (arrayMap) {
            sLookupKey.set(klass, paramType, methodName);
            MethodArgs result = sMethods.get(sLookupKey);
            if (result == null) {
                try {
                    Method method = paramType == null ? klass.getMethod(methodName, new Class[0]) : klass.getMethod(methodName, paramType);
                    if (!method.isAnnotationPresent(RemotableViewMethod.class)) {
                        throw new ActionException("view: " + klass.getName() + " can't use method with RemoteViews: " + methodName + RemoteViews.getParameters(paramType));
                    }
                    result = new MethodArgs();
                    result.syncMethod = MethodHandles.publicLookup().unreflect(method);
                    result.asyncMethodName = method.getAnnotation(RemotableViewMethod.class).asyncImpl();
                }
                catch (IllegalAccessException | NoSuchMethodException ex) {
                    throw new ActionException("view: " + klass.getName() + " doesn't have method: " + methodName + RemoteViews.getParameters(paramType));
                }
                MethodKey key = new MethodKey();
                key.set(klass, paramType, methodName);
                sMethods.put(key, result);
            }
            if (!async) {
                return result.syncMethod;
            }
            if (result.asyncMethodName.isEmpty()) {
                return null;
            }
            if (result.asyncMethod == null) {
                MethodType asyncType = result.syncMethod.type().dropParameterTypes(0, 1).changeReturnType(Runnable.class);
                try {
                    result.asyncMethod = MethodHandles.publicLookup().findVirtual(klass, result.asyncMethodName, asyncType);
                }
                catch (IllegalAccessException | NoSuchMethodException ex) {
                    throw new ActionException("Async implementation declared as " + result.asyncMethodName + " but not defined for " + methodName + ": public Runnable " + result.asyncMethodName + " (" + TextUtils.join((CharSequence)",", asyncType.parameterArray()) + ")");
                }
            }
            return result.asyncMethod;
        }
    }

    private static String getParameters(Class<?> paramType) {
        if (paramType == null) {
            return "()";
        }
        return "(" + paramType + ")";
    }

    private static boolean hasStableId(View view) {
        Object tag = view.getTag(16909405);
        return tag != null;
    }

    private static int getStableId(View view) {
        Integer id2 = (Integer)view.getTag(16909405);
        return id2 == null ? -1 : id2;
    }

    private static void setStableId(View view, int stableId) {
        view.setTagInternal(16909405, stableId);
    }

    private static int getNextRecyclableChild(ViewGroup vg) {
        Integer tag = (Integer)vg.getTag(16909403);
        return tag == null ? -1 : tag;
    }

    private static int getViewLayoutId(View v) {
        return (Integer)v.getTag(16908312);
    }

    private static void setNextRecyclableChild(ViewGroup vg, int nextChild, int numChildren) {
        if (nextChild < 0 || nextChild >= numChildren) {
            vg.setTagInternal(16909403, -1);
        } else {
            vg.setTagInternal(16909403, nextChild);
        }
    }

    private void finalizeViewRecycling(ViewGroup root) {
        int nextChild = RemoteViews.getNextRecyclableChild(root);
        if (nextChild >= 0 && nextChild < root.getChildCount()) {
            root.removeViews(nextChild, root.getChildCount() - nextChild);
        }
        RemoteViews.setNextRecyclableChild(root, -1, 0);
        for (int i = 0; i < root.getChildCount(); ++i) {
            View child = root.getChildAt(i);
            if (!(child instanceof ViewGroup) || child.isRootNamespace()) continue;
            this.finalizeViewRecycling((ViewGroup)child);
        }
    }

    public RemoteViews(String packageName, int layoutId) {
        this(RemoteViews.getApplicationInfo(packageName, UserHandle.myUserId()), layoutId);
    }

    public RemoteViews(String packageName, int layoutId, int viewId) {
        this(packageName, layoutId);
        this.mViewId = viewId;
    }

    protected RemoteViews(ApplicationInfo application, int layoutId) {
        this.mApplication = application;
        this.mLayoutId = layoutId;
        this.mApplicationInfoCache.put(application);
    }

    private boolean hasMultipleLayouts() {
        return this.hasLandscapeAndPortraitLayouts() || this.hasSizedRemoteViews();
    }

    private boolean hasLandscapeAndPortraitLayouts() {
        return this.mLandscape != null && this.mPortrait != null;
    }

    private boolean hasSizedRemoteViews() {
        return this.mSizedRemoteViews != null;
    }

    private SizeF getIdealSize() {
        return this.mIdealSize;
    }

    private void setIdealSize(SizeF size) {
        this.mIdealSize = size;
    }

    private RemoteViews findSmallestRemoteView() {
        return this.mSizedRemoteViews.get(this.mSizedRemoteViews.size() - 1);
    }

    public RemoteViews(RemoteViews landscape, RemoteViews portrait) {
        if (landscape == null || portrait == null) {
            throw new IllegalArgumentException("Both RemoteViews must be non-null");
        }
        if (!landscape.hasSameAppInfo(portrait.mApplication)) {
            throw new IllegalArgumentException("Both RemoteViews must share the same package and user");
        }
        this.mApplication = portrait.mApplication;
        this.mLayoutId = portrait.mLayoutId;
        this.mViewId = portrait.mViewId;
        this.mLightBackgroundLayoutId = portrait.mLightBackgroundLayoutId;
        this.mLandscape = landscape;
        this.mPortrait = portrait;
        this.mClassCookies = portrait.mClassCookies != null ? portrait.mClassCookies : landscape.mClassCookies;
        this.configureDescendantsAsChildren();
    }

    public RemoteViews(Map<SizeF, RemoteViews> remoteViews) {
        if (remoteViews.isEmpty()) {
            throw new IllegalArgumentException("The set of RemoteViews cannot be empty");
        }
        if (remoteViews.size() > 16) {
            throw new IllegalArgumentException("Too many RemoteViews in constructor");
        }
        if (remoteViews.size() == 1) {
            RemoteViews single = remoteViews.values().iterator().next();
            this.initializeFrom(single, single);
            return;
        }
        this.mClassCookies = this.initializeSizedRemoteViews(remoteViews.entrySet().stream().map(entry -> {
            ((RemoteViews)entry.getValue()).setIdealSize((SizeF)entry.getKey());
            return (RemoteViews)entry.getValue();
        }).iterator());
        RemoteViews smallestView = this.findSmallestRemoteView();
        this.mApplication = smallestView.mApplication;
        this.mLayoutId = smallestView.mLayoutId;
        this.mViewId = smallestView.mViewId;
        this.mLightBackgroundLayoutId = smallestView.mLightBackgroundLayoutId;
        this.configureDescendantsAsChildren();
    }

    private Map<Class, Object> initializeSizedRemoteViews(Iterator<RemoteViews> remoteViews) {
        ArrayList<RemoteViews> sizedRemoteViews = new ArrayList<RemoteViews>();
        Map<Class, Object> classCookies = null;
        float viewArea = Float.MAX_VALUE;
        RemoteViews smallestView = null;
        while (remoteViews.hasNext()) {
            RemoteViews view = remoteViews.next();
            SizeF size = view.getIdealSize();
            if (size == null) {
                throw new IllegalStateException("Expected RemoteViews to have ideal size");
            }
            float newViewArea = size.getWidth() * size.getHeight();
            if (smallestView != null && !view.hasSameAppInfo(smallestView.mApplication)) {
                throw new IllegalArgumentException("All RemoteViews must share the same package and user");
            }
            if (smallestView == null || newViewArea < viewArea) {
                if (smallestView != null) {
                    sizedRemoteViews.add(smallestView);
                }
                viewArea = newViewArea;
                smallestView = view;
            } else {
                sizedRemoteViews.add(view);
            }
            view.setIdealSize(size);
            if (classCookies != null) continue;
            classCookies = view.mClassCookies;
        }
        sizedRemoteViews.add(smallestView);
        this.mSizedRemoteViews = sizedRemoteViews;
        return classCookies;
    }

    public RemoteViews(RemoteViews src) {
        this.initializeFrom(src, null);
    }

    private RemoteViews() {
    }

    private static RemoteViews createInitializedFrom(RemoteViews src, RemoteViews hierarchyRoot) {
        RemoteViews child = new RemoteViews();
        child.initializeFrom(src, hierarchyRoot);
        return child;
    }

    private void initializeFrom(RemoteViews src, RemoteViews hierarchyRoot) {
        if (hierarchyRoot == null) {
            this.mBitmapCache = src.mBitmapCache;
            this.mApplicationInfoCache = src.mApplicationInfoCache;
        } else {
            this.mBitmapCache = hierarchyRoot.mBitmapCache;
            this.mApplicationInfoCache = hierarchyRoot.mApplicationInfoCache;
        }
        if (hierarchyRoot == null || src.mIsRoot) {
            this.mIsRoot = true;
            hierarchyRoot = this;
        } else {
            this.mIsRoot = false;
        }
        this.mApplication = src.mApplication;
        this.mLayoutId = src.mLayoutId;
        this.mLightBackgroundLayoutId = src.mLightBackgroundLayoutId;
        this.mApplyFlags = src.mApplyFlags;
        this.mClassCookies = src.mClassCookies;
        this.mIdealSize = src.mIdealSize;
        this.mProviderInstanceId = src.mProviderInstanceId;
        if (src.hasLandscapeAndPortraitLayouts()) {
            this.mLandscape = RemoteViews.createInitializedFrom(src.mLandscape, hierarchyRoot);
            this.mPortrait = RemoteViews.createInitializedFrom(src.mPortrait, hierarchyRoot);
        }
        if (src.hasSizedRemoteViews()) {
            this.mSizedRemoteViews = new ArrayList<RemoteViews>(src.mSizedRemoteViews.size());
            for (RemoteViews srcView : src.mSizedRemoteViews) {
                this.mSizedRemoteViews.add(RemoteViews.createInitializedFrom(srcView, hierarchyRoot));
            }
        }
        if (src.mActions != null) {
            Parcel p = Parcel.obtain();
            p.putClassCookies(this.mClassCookies);
            src.writeActionsToParcel(p, 0);
            p.setDataPosition(0);
            this.readActionsFromParcel(p, 0);
            p.recycle();
        }
        if (this.mIsRoot) {
            this.reconstructCaches();
        }
    }

    public RemoteViews(Parcel parcel) {
        this(parcel, null, null, 0);
    }

    private RemoteViews(Parcel parcel, HierarchyRootData rootData, ApplicationInfo info, int depth) {
        if (depth > 10 && UserHandle.getAppId(Binder.getCallingUid()) != 1000) {
            throw new IllegalArgumentException("Too many nested views.");
        }
        ++depth;
        int mode = parcel.readInt();
        if (rootData == null) {
            this.mBitmapCache = new BitmapCache(parcel);
            this.mClassCookies = parcel.copyClassCookies();
        } else {
            this.configureAsChild(rootData);
        }
        if (mode == 0) {
            this.mApplication = ApplicationInfo.CREATOR.createFromParcel(parcel);
            this.mIdealSize = parcel.readInt() == 0 ? null : SizeF.CREATOR.createFromParcel(parcel);
            this.mLayoutId = parcel.readInt();
            this.mViewId = parcel.readInt();
            this.mLightBackgroundLayoutId = parcel.readInt();
            this.readActionsFromParcel(parcel, depth);
        } else if (mode == 2) {
            int numViews = parcel.readInt();
            if (numViews > 16) {
                throw new IllegalArgumentException("Too many views in mapping from size to RemoteViews.");
            }
            ArrayList<RemoteViews> remoteViews = new ArrayList<RemoteViews>(numViews);
            for (int i = 0; i < numViews; ++i) {
                RemoteViews view = new RemoteViews(parcel, this.getHierarchyRootData(), info, depth);
                info = view.mApplication;
                remoteViews.add(view);
            }
            this.initializeSizedRemoteViews(remoteViews.iterator());
            RemoteViews smallestView = this.findSmallestRemoteView();
            this.mApplication = smallestView.mApplication;
            this.mLayoutId = smallestView.mLayoutId;
            this.mViewId = smallestView.mViewId;
            this.mLightBackgroundLayoutId = smallestView.mLightBackgroundLayoutId;
        } else {
            this.mLandscape = new RemoteViews(parcel, this.getHierarchyRootData(), info, depth);
            this.mPortrait = new RemoteViews(parcel, this.getHierarchyRootData(), this.mLandscape.mApplication, depth);
            this.mApplication = this.mPortrait.mApplication;
            this.mLayoutId = this.mPortrait.mLayoutId;
            this.mViewId = this.mPortrait.mViewId;
            this.mLightBackgroundLayoutId = this.mPortrait.mLightBackgroundLayoutId;
        }
        this.mApplyFlags = parcel.readInt();
        this.mProviderInstanceId = parcel.readLong();
        if (this.mIsRoot) {
            this.configureDescendantsAsChildren();
        }
    }

    private void readActionsFromParcel(Parcel parcel, int depth) {
        int count = parcel.readInt();
        if (count > 0) {
            this.mActions = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                this.mActions.add(this.getActionFromParcel(parcel, depth));
            }
        }
    }

    private Action getActionFromParcel(Parcel parcel, int depth) {
        int tag = parcel.readInt();
        switch (tag) {
            case 1: {
                return new SetOnClickResponse(parcel);
            }
            case 3: {
                return new SetDrawableTint(parcel);
            }
            case 2: {
                return new ReflectionAction(parcel);
            }
            case 4: {
                return new ViewGroupActionAdd(parcel, this.mApplication, depth);
            }
            case 7: {
                return new ViewGroupActionRemove(parcel);
            }
            case 5: {
                return new ViewContentNavigation(parcel);
            }
            case 6: {
                return new SetEmptyView(parcel);
            }
            case 8: {
                return new SetPendingIntentTemplate(parcel);
            }
            case 10: {
                return new SetRemoteViewsAdapterIntent(parcel);
            }
            case 11: {
                return new TextViewDrawableAction(parcel);
            }
            case 13: {
                return new TextViewSizeAction(parcel);
            }
            case 14: {
                return new ViewPaddingAction(parcel);
            }
            case 12: {
                return new BitmapReflectionAction(parcel);
            }
            case 15: {
                return new SetRemoteViewsAdapterList(parcel);
            }
            case 18: {
                return new SetRemoteInputsAction(parcel);
            }
            case 19: {
                return new LayoutParamAction(parcel);
            }
            case 20: {
                return new OverrideTextColorsAction(parcel);
            }
            case 21: {
                return new SetRippleDrawableColor(parcel);
            }
            case 22: {
                return new SetIntTagAction(parcel);
            }
            case 23: {
                return new RemoveFromParentAction(parcel);
            }
            case 24: {
                return new ResourceReflectionAction(parcel);
            }
            case 25: {
                return new ComplexUnitDimensionReflectionAction(parcel);
            }
            case 26: {
                return new SetCompoundButtonCheckedAction(parcel);
            }
            case 27: {
                return new SetRadioGroupCheckedAction(parcel);
            }
            case 28: {
                return new SetViewOutlinePreferredRadiusAction(parcel);
            }
            case 29: {
                return new SetOnCheckedChangeResponse(parcel);
            }
            case 30: {
                return new NightModeReflectionAction(parcel);
            }
            case 31: {
                return new SetRemoteCollectionItemListAdapterAction(parcel);
            }
            case 32: {
                return new AttributeReflectionAction(parcel);
            }
        }
        throw new ActionException("Tag " + tag + " not found");
    }

    @Deprecated
    public RemoteViews clone() {
        Preconditions.checkState(this.mIsRoot, "RemoteView has been attached to another RemoteView. May only clone the root of a RemoteView hierarchy.");
        return new RemoteViews(this);
    }

    public String getPackage() {
        return this.mApplication != null ? this.mApplication.packageName : null;
    }

    public int getLayoutId() {
        return this.hasFlags(4) && this.mLightBackgroundLayoutId != 0 ? this.mLightBackgroundLayoutId : this.mLayoutId;
    }

    private void configureAsChild(HierarchyRootData rootData) {
        this.mIsRoot = false;
        this.mBitmapCache = rootData.mBitmapCache;
        this.mApplicationInfoCache = rootData.mApplicationInfoCache;
        this.mClassCookies = rootData.mClassCookies;
        this.configureDescendantsAsChildren();
    }

    private void configureDescendantsAsChildren() {
        block3: {
            HierarchyRootData rootData;
            block4: {
                block2: {
                    this.mApplication = this.mApplicationInfoCache.getOrPut(this.mApplication);
                    rootData = this.getHierarchyRootData();
                    if (!this.hasSizedRemoteViews()) break block2;
                    for (RemoteViews remoteView : this.mSizedRemoteViews) {
                        remoteView.configureAsChild(rootData);
                    }
                    break block3;
                }
                if (!this.hasLandscapeAndPortraitLayouts()) break block4;
                this.mLandscape.configureAsChild(rootData);
                this.mPortrait.configureAsChild(rootData);
                break block3;
            }
            if (this.mActions == null) break block3;
            for (Action action : this.mActions) {
                action.setHierarchyRootData(rootData);
            }
        }
    }

    private void reconstructCaches() {
        if (!this.mIsRoot) {
            return;
        }
        this.mBitmapCache = new BitmapCache();
        this.mApplicationInfoCache = new ApplicationInfoCache();
        this.mApplication = this.mApplicationInfoCache.getOrPut(this.mApplication);
        this.configureDescendantsAsChildren();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int estimateMemoryUsage() {
        return this.mBitmapCache.getBitmapMemory();
    }

    private void addAction(Action a) {
        if (this.hasMultipleLayouts()) {
            throw new RuntimeException("RemoteViews specifying separate layouts for orientation or size cannot be modified. Instead, fully configure each layouts individually before constructing the combined layout.");
        }
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        this.mActions.add(a);
    }

    public void addView(int viewId, RemoteViews nestedView) {
        this.addAction(nestedView == null ? new ViewGroupActionRemove(viewId) : new ViewGroupActionAdd(viewId, nestedView));
    }

    public void addStableView(int viewId, RemoteViews nestedView, int stableId) {
        this.addAction(new ViewGroupActionAdd(viewId, nestedView, -1, stableId));
    }

    @UnsupportedAppUsage
    public void addView(int viewId, RemoteViews nestedView, int index) {
        this.addAction(new ViewGroupActionAdd(viewId, nestedView, index));
    }

    public void removeAllViews(int viewId) {
        this.addAction(new ViewGroupActionRemove(viewId));
    }

    public void removeAllViewsExceptId(int viewId, int viewIdToKeep) {
        this.addAction(new ViewGroupActionRemove(viewId, viewIdToKeep));
    }

    public void removeFromParent(int viewId) {
        this.addAction(new RemoveFromParentAction(viewId));
    }

    @Deprecated
    public void showNext(int viewId) {
        this.addAction(new ViewContentNavigation(viewId, true));
    }

    @Deprecated
    public void showPrevious(int viewId) {
        this.addAction(new ViewContentNavigation(viewId, false));
    }

    public void setDisplayedChild(int viewId, int childIndex) {
        this.setInt(viewId, "setDisplayedChild", childIndex);
    }

    public void setViewVisibility(int viewId, int visibility) {
        this.setInt(viewId, "setVisibility", visibility);
    }

    public void setTextViewText(int viewId, CharSequence text) {
        this.setCharSequence(viewId, "setText", text);
    }

    public void setTextViewTextSize(int viewId, int units, float size) {
        this.addAction(new TextViewSizeAction(viewId, units, size));
    }

    public void setTextViewCompoundDrawables(int viewId, int left, int top, int right, int bottom) {
        this.addAction(new TextViewDrawableAction(viewId, false, left, top, right, bottom));
    }

    public void setTextViewCompoundDrawablesRelative(int viewId, int start, int top, int end, int bottom) {
        this.addAction(new TextViewDrawableAction(viewId, true, start, top, end, bottom));
    }

    public void setTextViewCompoundDrawables(int viewId, Icon left, Icon top, Icon right, Icon bottom) {
        this.addAction(new TextViewDrawableAction(viewId, false, left, top, right, bottom));
    }

    public void setTextViewCompoundDrawablesRelative(int viewId, Icon start, Icon top, Icon end, Icon bottom) {
        this.addAction(new TextViewDrawableAction(viewId, true, start, top, end, bottom));
    }

    public void setImageViewResource(int viewId, int srcId) {
        this.setInt(viewId, "setImageResource", srcId);
    }

    public void setImageViewUri(int viewId, Uri uri) {
        this.setUri(viewId, "setImageURI", uri);
    }

    public void setImageViewBitmap(int viewId, Bitmap bitmap) {
        this.setBitmap(viewId, "setImageBitmap", bitmap);
    }

    public void setImageViewIcon(int viewId, Icon icon) {
        this.setIcon(viewId, "setImageIcon", icon);
    }

    public void setEmptyView(int viewId, int emptyViewId) {
        this.addAction(new SetEmptyView(viewId, emptyViewId));
    }

    public void setChronometer(int viewId, long base, String format, boolean started) {
        this.setLong(viewId, "setBase", base);
        this.setString(viewId, "setFormat", format);
        this.setBoolean(viewId, "setStarted", started);
    }

    public void setChronometerCountDown(int viewId, boolean isCountDown) {
        this.setBoolean(viewId, "setCountDown", isCountDown);
    }

    public void setProgressBar(int viewId, int max, int progress, boolean indeterminate) {
        this.setBoolean(viewId, "setIndeterminate", indeterminate);
        if (!indeterminate) {
            this.setInt(viewId, "setMax", max);
            this.setInt(viewId, "setProgress", progress);
        }
    }

    public void setOnClickPendingIntent(int viewId, PendingIntent pendingIntent) {
        this.setOnClickResponse(viewId, RemoteResponse.fromPendingIntent(pendingIntent));
    }

    public void setOnClickResponse(int viewId, RemoteResponse response) {
        this.addAction(new SetOnClickResponse(viewId, response));
    }

    public void setPendingIntentTemplate(int viewId, PendingIntent pendingIntentTemplate) {
        this.addAction(new SetPendingIntentTemplate(viewId, pendingIntentTemplate));
    }

    public void setOnClickFillInIntent(int viewId, Intent fillInIntent) {
        this.setOnClickResponse(viewId, RemoteResponse.fromFillInIntent(fillInIntent));
    }

    public void setOnCheckedChangeResponse(int viewId, RemoteResponse response) {
        this.addAction(new SetOnCheckedChangeResponse(viewId, response.setInteractionType(1)));
    }

    public void setDrawableTint(int viewId, boolean targetBackground, int colorFilter, PorterDuff.Mode mode) {
        this.addAction(new SetDrawableTint(viewId, targetBackground, colorFilter, mode));
    }

    public void setRippleDrawableColor(int viewId, ColorStateList colorStateList) {
        this.addAction(new SetRippleDrawableColor(viewId, colorStateList));
    }

    public void setProgressTintList(int viewId, ColorStateList tint) {
        this.addAction(new ReflectionAction(viewId, "setProgressTintList", 15, tint));
    }

    public void setProgressBackgroundTintList(int viewId, ColorStateList tint) {
        this.addAction(new ReflectionAction(viewId, "setProgressBackgroundTintList", 15, tint));
    }

    public void setProgressIndeterminateTintList(int viewId, ColorStateList tint) {
        this.addAction(new ReflectionAction(viewId, "setIndeterminateTintList", 15, tint));
    }

    public void setTextColor(int viewId, int color2) {
        this.setInt(viewId, "setTextColor", color2);
    }

    public void setTextColor(int viewId, ColorStateList colors) {
        this.addAction(new ReflectionAction(viewId, "setTextColor", 15, colors));
    }

    @Deprecated
    public void setRemoteAdapter(int appWidgetId, int viewId, Intent intent) {
        this.setRemoteAdapter(viewId, intent);
    }

    public void setRemoteAdapter(int viewId, Intent intent) {
        this.addAction(new SetRemoteViewsAdapterIntent(viewId, intent));
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setRemoteAdapter(int viewId, ArrayList<RemoteViews> list, int viewTypeCount) {
        this.addAction(new SetRemoteViewsAdapterList(viewId, list, viewTypeCount));
    }

    public void setRemoteAdapter(int viewId, RemoteCollectionItems items) {
        this.addAction(new SetRemoteCollectionItemListAdapterAction(viewId, items));
    }

    public void setScrollPosition(int viewId, int position) {
        this.setInt(viewId, "smoothScrollToPosition", position);
    }

    public void setRelativeScrollPosition(int viewId, int offset) {
        this.setInt(viewId, "smoothScrollByOffset", offset);
    }

    public void setViewPadding(int viewId, int left, int top, int right, int bottom) {
        this.addAction(new ViewPaddingAction(viewId, left, top, right, bottom));
    }

    public void setViewLayoutMarginDimen(int viewId, int type, int dimen2) {
        this.addAction(new LayoutParamAction(viewId, type, dimen2, 3));
    }

    public void setViewLayoutMarginAttr(int viewId, int type, int attr2) {
        this.addAction(new LayoutParamAction(viewId, type, attr2, 4));
    }

    public void setViewLayoutMargin(int viewId, int type, float value, int units) {
        this.addAction(new LayoutParamAction(viewId, type, value, units));
    }

    public void setViewLayoutWidth(int viewId, float width, int units) {
        this.addAction(new LayoutParamAction(viewId, 8, width, units));
    }

    public void setViewLayoutWidthDimen(int viewId, int widthDimen) {
        this.addAction(new LayoutParamAction(viewId, 8, widthDimen, 3));
    }

    public void setViewLayoutWidthAttr(int viewId, int widthAttr) {
        this.addAction(new LayoutParamAction(viewId, 8, widthAttr, 4));
    }

    public void setViewLayoutHeight(int viewId, float height, int units) {
        this.addAction(new LayoutParamAction(viewId, 9, height, units));
    }

    public void setViewLayoutHeightDimen(int viewId, int heightDimen) {
        this.addAction(new LayoutParamAction(viewId, 9, heightDimen, 3));
    }

    public void setViewLayoutHeightAttr(int viewId, int heightAttr) {
        this.addAction(new LayoutParamAction(viewId, 9, heightAttr, 4));
    }

    public void setViewOutlinePreferredRadius(int viewId, float radius, int units) {
        this.addAction(new SetViewOutlinePreferredRadiusAction(viewId, radius, units));
    }

    public void setViewOutlinePreferredRadiusDimen(int viewId, int resId) {
        this.addAction(new SetViewOutlinePreferredRadiusAction(viewId, resId, 3));
    }

    public void setViewOutlinePreferredRadiusAttr(int viewId, int attrId) {
        this.addAction(new SetViewOutlinePreferredRadiusAction(viewId, attrId, 4));
    }

    public void setBoolean(int viewId, String methodName, boolean value) {
        this.addAction(new ReflectionAction(viewId, methodName, 1, value));
    }

    public void setByte(int viewId, String methodName, byte value) {
        this.addAction(new ReflectionAction(viewId, methodName, 2, value));
    }

    public void setShort(int viewId, String methodName, short value) {
        this.addAction(new ReflectionAction(viewId, methodName, 3, value));
    }

    public void setInt(int viewId, String methodName, int value) {
        this.addAction(new ReflectionAction(viewId, methodName, 4, value));
    }

    public void setIntDimen(int viewId, String methodName, int dimenResource) {
        this.addAction(new ResourceReflectionAction(viewId, methodName, 4, 1, dimenResource));
    }

    public void setIntDimen(int viewId, String methodName, float value, int unit) {
        this.addAction(new ComplexUnitDimensionReflectionAction(viewId, methodName, 4, value, unit));
    }

    public void setIntDimenAttr(int viewId, String methodName, int dimenAttr) {
        this.addAction(new AttributeReflectionAction(viewId, methodName, 4, 1, dimenAttr));
    }

    public void setColor(int viewId, String methodName, int colorResource) {
        this.addAction(new ResourceReflectionAction(viewId, methodName, 4, 2, colorResource));
    }

    public void setColorAttr(int viewId, String methodName, int colorAttribute) {
        this.addAction(new AttributeReflectionAction(viewId, methodName, 4, 2, colorAttribute));
    }

    public void setColorInt(int viewId, String methodName, int notNight, int night) {
        this.addAction(new NightModeReflectionAction(viewId, methodName, 4, notNight, night));
    }

    public void setColorStateList(int viewId, String methodName, ColorStateList value) {
        this.addAction(new ReflectionAction(viewId, methodName, 15, value));
    }

    public void setColorStateList(int viewId, String methodName, ColorStateList notNight, ColorStateList night) {
        this.addAction(new NightModeReflectionAction(viewId, methodName, 15, notNight, night));
    }

    public void setColorStateList(int viewId, String methodName, int colorResource) {
        this.addAction(new ResourceReflectionAction(viewId, methodName, 15, 2, colorResource));
    }

    public void setColorStateListAttr(int viewId, String methodName, int colorAttr) {
        this.addAction(new AttributeReflectionAction(viewId, methodName, 15, 2, colorAttr));
    }

    public void setLong(int viewId, String methodName, long value) {
        this.addAction(new ReflectionAction(viewId, methodName, 5, value));
    }

    public void setFloat(int viewId, String methodName, float value) {
        this.addAction(new ReflectionAction(viewId, methodName, 6, Float.valueOf(value)));
    }

    public void setFloatDimen(int viewId, String methodName, int dimenResource) {
        this.addAction(new ResourceReflectionAction(viewId, methodName, 6, 1, dimenResource));
    }

    public void setFloatDimen(int viewId, String methodName, float value, int unit) {
        this.addAction(new ComplexUnitDimensionReflectionAction(viewId, methodName, 6, value, unit));
    }

    public void setFloatDimenAttr(int viewId, String methodName, int dimenAttr) {
        this.addAction(new AttributeReflectionAction(viewId, methodName, 6, 1, dimenAttr));
    }

    public void setDouble(int viewId, String methodName, double value) {
        this.addAction(new ReflectionAction(viewId, methodName, 7, value));
    }

    public void setChar(int viewId, String methodName, char value) {
        this.addAction(new ReflectionAction(viewId, methodName, 8, Character.valueOf(value)));
    }

    public void setString(int viewId, String methodName, String value) {
        this.addAction(new ReflectionAction(viewId, methodName, 9, value));
    }

    public void setCharSequence(int viewId, String methodName, CharSequence value) {
        this.addAction(new ReflectionAction(viewId, methodName, 10, value));
    }

    public void setCharSequence(int viewId, String methodName, int stringResource) {
        this.addAction(new ResourceReflectionAction(viewId, methodName, 10, 3, stringResource));
    }

    public void setCharSequenceAttr(int viewId, String methodName, int stringAttribute) {
        this.addAction(new AttributeReflectionAction(viewId, methodName, 10, 3, stringAttribute));
    }

    public void setUri(int viewId, String methodName, Uri value) {
        if (value != null) {
            value = value.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                value.checkFileUriExposed("RemoteViews.setUri()");
            }
        }
        this.addAction(new ReflectionAction(viewId, methodName, 11, value));
    }

    public void setBitmap(int viewId, String methodName, Bitmap value) {
        this.addAction(new BitmapReflectionAction(viewId, methodName, value));
    }

    public void setBlendMode(int viewId, String methodName, BlendMode value) {
        this.addAction(new ReflectionAction(viewId, methodName, 17, (Object)value));
    }

    public void setBundle(int viewId, String methodName, Bundle value) {
        this.addAction(new ReflectionAction(viewId, methodName, 13, value));
    }

    public void setIntent(int viewId, String methodName, Intent value) {
        this.addAction(new ReflectionAction(viewId, methodName, 14, value));
    }

    public void setIcon(int viewId, String methodName, Icon value) {
        this.addAction(new ReflectionAction(viewId, methodName, 16, value));
    }

    public void setIcon(int viewId, String methodName, Icon notNight, Icon night) {
        this.addAction(new NightModeReflectionAction(viewId, methodName, 16, notNight, night));
    }

    public void setContentDescription(int viewId, CharSequence contentDescription) {
        this.setCharSequence(viewId, "setContentDescription", contentDescription);
    }

    public void setAccessibilityTraversalBefore(int viewId, int nextId) {
        this.setInt(viewId, "setAccessibilityTraversalBefore", nextId);
    }

    public void setAccessibilityTraversalAfter(int viewId, int nextId) {
        this.setInt(viewId, "setAccessibilityTraversalAfter", nextId);
    }

    public void setLabelFor(int viewId, int labeledId) {
        this.setInt(viewId, "setLabelFor", labeledId);
    }

    public void setCompoundButtonChecked(int viewId, boolean checked) {
        this.addAction(new SetCompoundButtonCheckedAction(viewId, checked));
    }

    public void setRadioGroupChecked(int viewId, int checkedId) {
        this.addAction(new SetRadioGroupCheckedAction(viewId, checkedId));
    }

    public void setLightBackgroundLayoutId(int layoutId) {
        this.mLightBackgroundLayoutId = layoutId;
    }

    public RemoteViews getDarkTextViews() {
        if (this.hasFlags(4)) {
            return this;
        }
        try {
            this.addFlags(4);
            RemoteViews remoteViews = new RemoteViews(this);
            return remoteViews;
        }
        finally {
            this.mApplyFlags &= 0xFFFFFFFB;
        }
    }

    private RemoteViews getRemoteViewsToApply(Context context) {
        if (this.hasLandscapeAndPortraitLayouts()) {
            int orientation = context.getResources().getConfiguration().orientation;
            if (orientation == 2) {
                return this.mLandscape;
            }
            return this.mPortrait;
        }
        if (this.hasSizedRemoteViews()) {
            return this.findSmallestRemoteView();
        }
        return this;
    }

    private static float squareDistance(SizeF p1, SizeF p2) {
        float dx = p1.getWidth() - p2.getWidth();
        float dy = p1.getHeight() - p2.getHeight();
        return dx * dx + dy * dy;
    }

    private static boolean fitsIn(SizeF sizeLayout, SizeF sizeWidget) {
        return sizeWidget != null && Math.ceil(sizeWidget.getWidth()) + 1.0 > (double)sizeLayout.getWidth() && Math.ceil(sizeWidget.getHeight()) + 1.0 > (double)sizeLayout.getHeight();
    }

    private RemoteViews findBestFitLayout(SizeF widgetSize) {
        RemoteViews bestFit = null;
        float bestSqDist = Float.MAX_VALUE;
        for (RemoteViews layout2 : this.mSizedRemoteViews) {
            SizeF layoutSize = layout2.getIdealSize();
            if (layoutSize == null) {
                throw new IllegalStateException("Expected RemoteViews to have ideal size");
            }
            if (!RemoteViews.fitsIn(layoutSize, widgetSize)) continue;
            if (bestFit == null) {
                bestFit = layout2;
                bestSqDist = RemoteViews.squareDistance(layoutSize, widgetSize);
                continue;
            }
            float newSqDist = RemoteViews.squareDistance(layoutSize, widgetSize);
            if (!(newSqDist < bestSqDist)) continue;
            bestFit = layout2;
            bestSqDist = newSqDist;
        }
        if (bestFit == null) {
            Log.w(LOG_TAG, "Could not find a RemoteViews fitting the current size: " + widgetSize);
            return this.findSmallestRemoteView();
        }
        return bestFit;
    }

    public RemoteViews getRemoteViewsToApply(Context context, SizeF widgetSize) {
        if (!this.hasSizedRemoteViews() || widgetSize == null) {
            return this.getRemoteViewsToApply(context);
        }
        return this.findBestFitLayout(widgetSize);
    }

    public RemoteViews getRemoteViewsToApplyIfDifferent(SizeF oldSize, SizeF newSize) {
        RemoteViews newBestFit;
        if (!this.hasSizedRemoteViews()) {
            return null;
        }
        RemoteViews oldBestFit = oldSize == null ? this.findSmallestRemoteView() : this.findBestFitLayout(oldSize);
        if (oldBestFit != (newBestFit = this.findBestFitLayout(newSize))) {
            return newBestFit;
        }
        return null;
    }

    public View apply(Context context, ViewGroup parent) {
        return this.apply(context, parent, null);
    }

    public View apply(Context context, ViewGroup parent, InteractionHandler handler) {
        return this.apply(context, parent, handler, null);
    }

    public View apply(Context context, ViewGroup parent, InteractionHandler handler, SizeF size) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context, size);
        View result = this.inflateView(context, rvToApply, parent);
        rvToApply.performApply(result, parent, handler, null);
        return result;
    }

    public View applyWithTheme(Context context, ViewGroup parent, InteractionHandler handler, int applyThemeResId) {
        return this.applyWithTheme(context, parent, handler, applyThemeResId, null);
    }

    public View applyWithTheme(Context context, ViewGroup parent, InteractionHandler handler, int applyThemeResId, SizeF size) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context, size);
        View result = this.inflateView(context, rvToApply, parent, applyThemeResId, null);
        rvToApply.performApply(result, parent, handler, null);
        return result;
    }

    public View apply(Context context, ViewGroup parent, InteractionHandler handler, SizeF size, ColorResources colorResources) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context, size);
        View result = this.inflateView(context, rvToApply, parent, 0, colorResources);
        rvToApply.performApply(result, parent, handler, colorResources);
        return result;
    }

    private View applyNestedViews(Context context, ViewGroup directParent, ViewGroup rootParent, InteractionHandler handler, SizeF size, ColorResources colorResources) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context, size);
        View result = this.inflateView(context, rvToApply, directParent, 0, colorResources);
        rvToApply.performApply(result, rootParent, handler, colorResources);
        return result;
    }

    private View inflateView(Context context, RemoteViews rv, ViewGroup parent) {
        return this.inflateView(context, rv, parent, 0, null);
    }

    private View inflateView(Context context, RemoteViews rv, ViewGroup parent, int applyThemeResId, ColorResources colorResources) {
        Context contextForResources = this.getContextForResourcesEnsuringCorrectCachedApkPaths(context);
        if (colorResources != null) {
            colorResources.apply(contextForResources);
        }
        ContextWrapper inflationContext = new RemoteViewsContextWrapper(context, contextForResources);
        if (applyThemeResId != 0) {
            inflationContext = new ContextThemeWrapper((Context)inflationContext, applyThemeResId);
        }
        LayoutInflater inflater = LayoutInflater.from(context);
        inflater = inflater.cloneInContext(inflationContext);
        inflater.setFilter(this.shouldUseStaticFilter() ? INFLATER_FILTER : this);
        View v = inflater.inflate(rv.getLayoutId(), parent, false);
        if (this.mViewId != -1) {
            v.setId(this.mViewId);
            v.setTagInternal(16909404, this.mViewId);
        }
        v.setTagInternal(16908312, rv.getLayoutId());
        return v;
    }

    protected boolean shouldUseStaticFilter() {
        return this.getClass().equals(RemoteViews.class);
    }

    public CancellationSignal applyAsync(Context context, ViewGroup parent, Executor executor, OnViewAppliedListener listener) {
        return this.applyAsync(context, parent, executor, listener, null);
    }

    public CancellationSignal applyAsync(Context context, ViewGroup parent, Executor executor, OnViewAppliedListener listener, InteractionHandler handler) {
        return this.applyAsync(context, parent, executor, listener, handler, null);
    }

    public CancellationSignal applyAsync(Context context, ViewGroup parent, Executor executor, OnViewAppliedListener listener, InteractionHandler handler, SizeF size) {
        return this.applyAsync(context, parent, executor, listener, handler, size, null);
    }

    public CancellationSignal applyAsync(Context context, ViewGroup parent, Executor executor, OnViewAppliedListener listener, InteractionHandler handler, SizeF size, ColorResources colorResources) {
        return new AsyncApplyTask(this.getRemoteViewsToApply(context, size), parent, context, listener, handler, colorResources, null, true).startTaskOnExecutor(executor);
    }

    private AsyncApplyTask getInternalAsyncApplyTask(Context context, ViewGroup parent, OnViewAppliedListener listener, InteractionHandler handler, SizeF size, ColorResources colorResources, View result) {
        return new AsyncApplyTask(this.getRemoteViewsToApply(context, size), parent, context, listener, handler, colorResources, result, false);
    }

    public void reapply(Context context, View v) {
        this.reapply(context, v, null);
    }

    public void reapply(Context context, View v, InteractionHandler handler) {
        this.reapply(context, v, handler, null, null);
    }

    public void reapply(Context context, View v, InteractionHandler handler, SizeF size, ColorResources colorResources) {
        this.reapply(context, v, handler, size, colorResources, true);
    }

    public boolean canRecycleView(View v) {
        if (v == null) {
            return false;
        }
        Integer previousLayoutId = (Integer)v.getTag(16908312);
        if (previousLayoutId == null) {
            return false;
        }
        Integer overrideIdTag = (Integer)v.getTag(16909404);
        int overrideId = overrideIdTag == null ? -1 : overrideIdTag;
        return previousLayoutId.intValue() == this.getLayoutId() && this.mViewId == overrideId;
    }

    private RemoteViews getRemoteViewsToReapply(Context context, View v, SizeF size) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context, size);
        if ((this.hasMultipleLayouts() || rvToApply.mViewId != -1 || v.getTag(16909404) != null) && !rvToApply.canRecycleView(v)) {
            throw new RuntimeException("Attempting to re-apply RemoteViews to a view that that does not share the same root layout id.");
        }
        return rvToApply;
    }

    private void reapply(Context context, View v, InteractionHandler handler, SizeF size, ColorResources colorResources, boolean topLevel) {
        RemoteViews rvToApply = this.getRemoteViewsToReapply(context, v, size);
        rvToApply.performApply(v, (ViewGroup)v.getParent(), handler, colorResources);
        if (topLevel && v instanceof ViewGroup) {
            this.finalizeViewRecycling((ViewGroup)v);
        }
    }

    private void reapplyNestedViews(Context context, View v, ViewGroup rootParent, InteractionHandler handler, SizeF size, ColorResources colorResources) {
        RemoteViews rvToApply = this.getRemoteViewsToReapply(context, v, size);
        rvToApply.performApply(v, rootParent, handler, colorResources);
    }

    public CancellationSignal reapplyAsync(Context context, View v, Executor executor, OnViewAppliedListener listener) {
        return this.reapplyAsync(context, v, executor, listener, null);
    }

    public CancellationSignal reapplyAsync(Context context, View v, Executor executor, OnViewAppliedListener listener, InteractionHandler handler) {
        return this.reapplyAsync(context, v, executor, listener, handler, null, null);
    }

    public CancellationSignal reapplyAsync(Context context, View v, Executor executor, OnViewAppliedListener listener, InteractionHandler handler, SizeF size, ColorResources colorResources) {
        RemoteViews rvToApply = this.getRemoteViewsToReapply(context, v, size);
        return new AsyncApplyTask(rvToApply, (ViewGroup)v.getParent(), context, listener, handler, colorResources, v, true).startTaskOnExecutor(executor);
    }

    private void performApply(View v, ViewGroup parent, InteractionHandler handler, ColorResources colorResources) {
        if (this.mActions != null) {
            handler = handler == null ? DEFAULT_INTERACTION_HANDLER : handler;
            int count = this.mActions.size();
            for (int i = 0; i < count; ++i) {
                Action a = this.mActions.get(i);
                a.apply(v, parent, handler, colorResources);
            }
        }
    }

    public boolean prefersAsyncApply() {
        if (this.mActions != null) {
            int count = this.mActions.size();
            for (int i = 0; i < count; ++i) {
                if (!this.mActions.get(i).prefersAsyncApply()) continue;
                return true;
            }
        }
        return false;
    }

    public void updateAppInfo(ApplicationInfo info) {
        ApplicationInfo existing = this.mApplicationInfoCache.get(info);
        if (existing != null && !existing.sourceDir.equals(info.sourceDir)) {
            return;
        }
        this.mApplicationInfoCache.put(info);
        this.configureDescendantsAsChildren();
    }

    private Context getContextForResourcesEnsuringCorrectCachedApkPaths(Context context) {
        if (this.mApplication != null) {
            if (context.getUserId() == UserHandle.getUserId(this.mApplication.uid) && context.getPackageName().equals(this.mApplication.packageName)) {
                return context;
            }
            try {
                LoadedApk.checkAndUpdateApkPaths(this.mApplication);
                return context.createApplicationContext(this.mApplication, 4);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(LOG_TAG, "Package name " + this.mApplication.packageName + " not found");
            }
        }
        return context;
    }

    public int getSequenceNumber() {
        return this.mActions == null ? 0 : this.mActions.size();
    }

    @Override
    @Deprecated
    public boolean onLoadClass(Class clazz) {
        return clazz.isAnnotationPresent(RemoteView.class);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        boolean prevSquashingAllowed = dest.allowSquashing();
        if (!this.hasMultipleLayouts()) {
            dest.writeInt(0);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(dest, flags);
            }
            this.mApplication.writeToParcel(dest, flags);
            if (this.mIsRoot || this.mIdealSize == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                this.mIdealSize.writeToParcel(dest, flags);
            }
            dest.writeInt(this.mLayoutId);
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mLightBackgroundLayoutId);
            this.writeActionsToParcel(dest, flags);
        } else if (this.hasSizedRemoteViews()) {
            dest.writeInt(2);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(dest, flags);
            }
            dest.writeInt(this.mSizedRemoteViews.size());
            for (RemoteViews view : this.mSizedRemoteViews) {
                view.writeToParcel(dest, flags);
            }
        } else {
            dest.writeInt(1);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(dest, flags);
            }
            this.mLandscape.writeToParcel(dest, flags);
            this.mPortrait.writeToParcel(dest, flags);
        }
        dest.writeInt(this.mApplyFlags);
        dest.writeLong(this.mProviderInstanceId);
        dest.restoreAllowSquashing(prevSquashingAllowed);
    }

    private void writeActionsToParcel(Parcel parcel, int flags) {
        int count = this.mActions != null ? this.mActions.size() : 0;
        parcel.writeInt(count);
        for (int i = 0; i < count; ++i) {
            Action a = this.mActions.get(i);
            parcel.writeInt(a.getActionTag());
            a.writeToParcel(parcel, flags);
        }
    }

    static ApplicationInfo getApplicationInfo_Original(String packageName, int userId) {
        if (packageName == null) {
            return null;
        }
        Application application = ActivityThread.currentApplication();
        if (application == null) {
            throw new IllegalStateException("Cannot create remote views out of an aplication.");
        }
        ApplicationInfo applicationInfo = application.getApplicationInfo();
        if (UserHandle.getUserId(applicationInfo.uid) != userId || !applicationInfo.packageName.equals(packageName)) {
            try {
                Context context = application.getBaseContext().createPackageContextAsUser(packageName, 0, new UserHandle(userId));
                applicationInfo = context.getApplicationInfo();
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                throw new IllegalArgumentException("No such package " + packageName);
            }
        }
        return applicationInfo;
    }

    @LayoutlibDelegate
    private static ApplicationInfo getApplicationInfo(String string2, int n) {
        return RemoteViews_Delegate.getApplicationInfo(string2, n);
    }

    public boolean hasSameAppInfo(ApplicationInfo info) {
        return this.mApplication.packageName.equals(info.packageName) && this.mApplication.uid == info.uid;
    }

    public static boolean startPendingIntent(View view, PendingIntent pendingIntent, Pair<Intent, ActivityOptions> options) {
        try {
            Context context = view.getContext();
            context.startIntentSender(pendingIntent.getIntentSender(), (Intent)options.first, 0, 0, 0, ((ActivityOptions)options.second).toBundle());
        }
        catch (IntentSender.SendIntentException e) {
            Log.e(LOG_TAG, "Cannot send pending intent: ", e);
            return false;
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Cannot send pending intent due to unknown exception: ", e);
            return false;
        }
        return true;
    }

    public int getViewId() {
        return this.mViewId;
    }

    public void setProviderInstanceId(long id2) {
        this.mProviderInstanceId = id2;
    }

    public long getProviderInstanceId() {
        return this.mProviderInstanceId;
    }

    private int getChildId(RemoteViews child) {
        if (child == this) {
            return 0;
        }
        if (this.hasSizedRemoteViews()) {
            for (int i = 0; i < this.mSizedRemoteViews.size(); ++i) {
                if (this.mSizedRemoteViews.get(i) != child) continue;
                return i + 1;
            }
        }
        if (this.hasLandscapeAndPortraitLayouts()) {
            if (this.mLandscape == child) {
                return 1;
            }
            if (this.mPortrait == child) {
                return 2;
            }
        }
        return 0;
    }

    public long computeUniqueId(RemoteViews parent) {
        if (this.mIsRoot) {
            long viewId = this.getProviderInstanceId();
            if (viewId != -1L) {
                viewId <<= 8;
            }
            return viewId;
        }
        if (parent == null) {
            return -1L;
        }
        long viewId = parent.getProviderInstanceId();
        if (viewId == -1L) {
            return -1L;
        }
        int childId = parent.getChildId(this);
        if (childId == -1) {
            return -1L;
        }
        viewId <<= 8;
        return viewId |= (long)childId;
    }

    private static Pair<String, Integer> getPackageUserKey(ApplicationInfo info) {
        if (info == null || info.packageName == null) {
            return null;
        }
        return Pair.create(info.packageName, info.uid);
    }

    private HierarchyRootData getHierarchyRootData() {
        return new HierarchyRootData(this.mBitmapCache, this.mApplicationInfoCache, this.mClassCookies);
    }

    private static class HierarchyRootData {
        final BitmapCache mBitmapCache;
        final ApplicationInfoCache mApplicationInfoCache;
        final Map<Class, Object> mClassCookies;

        HierarchyRootData(BitmapCache bitmapCache, ApplicationInfoCache applicationInfoCache, Map<Class, Object> classCookies) {
            this.mBitmapCache = bitmapCache;
            this.mApplicationInfoCache = applicationInfoCache;
            this.mClassCookies = classCookies;
        }
    }

    public static class RemoteCollectionItems
    implements Parcelable {
        private final long[] mIds;
        private final RemoteViews[] mViews;
        private final boolean mHasStableIds;
        private final int mViewTypeCount;
        private HierarchyRootData mHierarchyRootData;
        public static final Parcelable.Creator<RemoteCollectionItems> CREATOR = new Parcelable.Creator<RemoteCollectionItems>(){

            @Override
            public RemoteCollectionItems createFromParcel(Parcel source) {
                return new RemoteCollectionItems(source, null);
            }

            public RemoteCollectionItems[] newArray(int size) {
                return new RemoteCollectionItems[size];
            }
        };

        RemoteCollectionItems(long[] ids, RemoteViews[] views, boolean hasStableIds, int viewTypeCount) {
            this.mIds = ids;
            this.mViews = views;
            this.mHasStableIds = hasStableIds;
            this.mViewTypeCount = viewTypeCount;
            if (ids.length != views.length) {
                throw new IllegalArgumentException("RemoteCollectionItems has different number of ids and views");
            }
            if (viewTypeCount < 1) {
                throw new IllegalArgumentException("View type count must be >= 1");
            }
            int layoutIdCount = (int)Arrays.stream(views).mapToInt(RemoteViews::getLayoutId).distinct().count();
            if (layoutIdCount > viewTypeCount) {
                throw new IllegalArgumentException("View type count is set to " + viewTypeCount + ", but the collection contains " + layoutIdCount + " different layout ids");
            }
            if (views.length > 0) {
                this.setHierarchyRootData(views[0].getHierarchyRootData());
                views[0].mIsRoot = true;
            }
        }

        RemoteCollectionItems(Parcel in, HierarchyRootData hierarchyRootData) {
            int firstChildIndex;
            this.mHasStableIds = in.readBoolean();
            this.mViewTypeCount = in.readInt();
            int length = in.readInt();
            this.mIds = new long[length];
            in.readLongArray(this.mIds);
            boolean attached = in.readBoolean();
            this.mViews = new RemoteViews[length];
            if (attached) {
                if (hierarchyRootData == null) {
                    throw new IllegalStateException("Cannot unparcel a RemoteCollectionItems that was parceled as attached without providing data for a root RemoteViews");
                }
                this.mHierarchyRootData = hierarchyRootData;
                firstChildIndex = 0;
            } else {
                this.mViews[0] = new RemoteViews(in);
                this.mHierarchyRootData = this.mViews[0].getHierarchyRootData();
                firstChildIndex = 1;
            }
            for (int i = firstChildIndex; i < length; ++i) {
                this.mViews[i] = new RemoteViews(in, this.mHierarchyRootData, null, 0);
            }
        }

        void setHierarchyRootData(HierarchyRootData rootData) {
            this.mHierarchyRootData = rootData;
            for (RemoteViews view : this.mViews) {
                view.configureAsChild(rootData);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.writeToParcel(dest, flags, false);
        }

        private void writeToParcel(Parcel dest, int flags, boolean attached) {
            boolean prevAllowSquashing = dest.allowSquashing();
            dest.writeBoolean(this.mHasStableIds);
            dest.writeInt(this.mViewTypeCount);
            dest.writeInt(this.mIds.length);
            dest.writeLongArray(this.mIds);
            if (attached && this.mHierarchyRootData == null) {
                throw new IllegalStateException("Cannot call writeToParcelAttached for a RemoteCollectionItems without first calling setHierarchyRootData()");
            }
            dest.writeBoolean(attached);
            boolean restoreRoot = false;
            if (!attached && this.mViews.length > 0 && !this.mViews[0].mIsRoot) {
                restoreRoot = true;
                this.mViews[0].mIsRoot = true;
            }
            for (RemoteViews view : this.mViews) {
                view.writeToParcel(dest, flags);
            }
            if (restoreRoot) {
                this.mViews[0].mIsRoot = false;
            }
            dest.restoreAllowSquashing(prevAllowSquashing);
        }

        public long getItemId(int position) {
            return this.mIds[position];
        }

        public RemoteViews getItemView(int position) {
            return this.mViews[position];
        }

        public int getItemCount() {
            return this.mIds.length;
        }

        public int getViewTypeCount() {
            return this.mViewTypeCount;
        }

        public boolean hasStableIds() {
            return this.mHasStableIds;
        }

        public static class Builder {
            private final LongArray mIds = new LongArray();
            private final List<RemoteViews> mViews = new ArrayList<RemoteViews>();
            private boolean mHasStableIds;
            private int mViewTypeCount;

            @SuppressLint(value={"MissingGetterMatchingBuilder"})
            public Builder addItem(long id2, RemoteViews view) {
                if (view == null) {
                    throw new NullPointerException();
                }
                if (view.hasMultipleLayouts()) {
                    throw new IllegalArgumentException("RemoteViews used in a RemoteCollectionItems cannot specify separate layouts for orientations or sizes.");
                }
                this.mIds.add(id2);
                this.mViews.add(view);
                return this;
            }

            public Builder setHasStableIds(boolean hasStableIds) {
                this.mHasStableIds = hasStableIds;
                return this;
            }

            public Builder setViewTypeCount(int viewTypeCount) {
                this.mViewTypeCount = viewTypeCount;
                return this;
            }

            public RemoteCollectionItems build() {
                if (this.mViewTypeCount < 1) {
                    this.mViewTypeCount = (int)this.mViews.stream().mapToInt(RemoteViews::getLayoutId).distinct().count();
                }
                return new RemoteCollectionItems(this.mIds.toArray(), this.mViews.toArray(new RemoteViews[0]), this.mHasStableIds, Math.max(this.mViewTypeCount, 1));
            }
        }
    }

    public static class RemoteResponse {
        public static final int INTERACTION_TYPE_CLICK = 0;
        public static final int INTERACTION_TYPE_CHECKED_CHANGE = 1;
        private PendingIntent mPendingIntent;
        private Intent mFillIntent;
        private int mInteractionType = 0;
        private IntArray mViewIds;
        private ArrayList<String> mElementNames;

        public static RemoteResponse fromPendingIntent(PendingIntent pendingIntent) {
            RemoteResponse response = new RemoteResponse();
            response.mPendingIntent = pendingIntent;
            return response;
        }

        public static RemoteResponse fromFillInIntent(Intent fillIntent) {
            RemoteResponse response = new RemoteResponse();
            response.mFillIntent = fillIntent;
            return response;
        }

        public RemoteResponse addSharedElement(int viewId, String sharedElementName) {
            if (this.mViewIds == null) {
                this.mViewIds = new IntArray();
                this.mElementNames = new ArrayList();
            }
            this.mViewIds.add(viewId);
            this.mElementNames.add(sharedElementName);
            return this;
        }

        public RemoteResponse setInteractionType(int type) {
            this.mInteractionType = type;
            return this;
        }

        private void writeToParcel(Parcel dest, int flags) {
            PendingIntent.writePendingIntentOrNullToParcel(this.mPendingIntent, dest);
            if (this.mPendingIntent == null) {
                dest.writeTypedObject(this.mFillIntent, flags);
            }
            dest.writeInt(this.mInteractionType);
            dest.writeIntArray(this.mViewIds == null ? null : this.mViewIds.toArray());
            dest.writeStringList(this.mElementNames);
        }

        private void readFromParcel(Parcel parcel) {
            this.mPendingIntent = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
            if (this.mPendingIntent == null) {
                this.mFillIntent = parcel.readTypedObject(Intent.CREATOR);
            }
            this.mInteractionType = parcel.readInt();
            int[] viewIds = parcel.createIntArray();
            this.mViewIds = viewIds == null ? null : IntArray.wrap(viewIds);
            this.mElementNames = parcel.createStringArrayList();
        }

        private void handleViewInteraction(View v, InteractionHandler handler) {
            PendingIntent pi;
            if (this.mPendingIntent != null) {
                pi = this.mPendingIntent;
            } else if (this.mFillIntent != null) {
                AdapterView<?> ancestor = RemoteResponse.getAdapterViewAncestor(v);
                if (ancestor == null) {
                    Log.e(RemoteViews.LOG_TAG, "Collection item doesn't have AdapterView parent");
                    return;
                }
                if (!(ancestor.getTag() instanceof PendingIntent)) {
                    Log.e(RemoteViews.LOG_TAG, "Attempting setOnClickFillInIntent or setOnCheckedChangeFillInIntent without calling setPendingIntentTemplate on parent.");
                    return;
                }
                pi = (PendingIntent)ancestor.getTag();
            } else {
                Log.e(RemoteViews.LOG_TAG, "Response has neither pendingIntent nor fillInIntent");
                return;
            }
            handler.onInteraction(v, pi, this);
        }

        private static AdapterView<?> getAdapterViewAncestor(View view) {
            View parent;
            if (view == null) {
                return null;
            }
            for (parent = (View)((Object)view.getParent()); !(parent == null || parent instanceof AdapterView || parent instanceof AppWidgetHostView && !(parent instanceof RemoteViewsAdapter.RemoteViewsFrameLayout)); parent = (View)((Object)parent.getParent())) {
            }
            return parent instanceof AdapterView ? (AdapterView)parent : null;
        }

        public Pair<Intent, ActivityOptions> getLaunchOptions(View view) {
            Intent intent = this.mPendingIntent != null ? new Intent() : new Intent(this.mFillIntent);
            intent.setSourceBounds(RemoteViews.getSourceBounds(view));
            if (view instanceof CompoundButton && this.mInteractionType == 1) {
                intent.putExtra(RemoteViews.EXTRA_CHECKED, ((CompoundButton)view).isChecked());
            }
            ActivityOptions opts = null;
            Context context = view.getContext();
            if (context.getResources().getBoolean(17891718)) {
                TypedArray windowStyle = context.getTheme().obtainStyledAttributes(R.styleable.Window);
                int windowAnimations = windowStyle.getResourceId(8, 0);
                TypedArray windowAnimationStyle = context.obtainStyledAttributes(windowAnimations, R.styleable.WindowAnimation);
                int enterAnimationId = windowAnimationStyle.getResourceId(26, 0);
                windowStyle.recycle();
                windowAnimationStyle.recycle();
                if (enterAnimationId != 0) {
                    opts = ActivityOptions.makeCustomAnimation(context, enterAnimationId, 0);
                    opts.setPendingIntentLaunchFlags(0x10000000);
                }
            }
            if (opts == null && this.mViewIds != null && this.mElementNames != null) {
                View parent;
                for (parent = (View)((Object)view.getParent()); parent != null && !(parent instanceof AppWidgetHostView); parent = (View)((Object)parent.getParent())) {
                }
                if (parent instanceof AppWidgetHostView) {
                    opts = ((AppWidgetHostView)parent).createSharedElementActivityOptions(this.mViewIds.toArray(), this.mElementNames.toArray(new String[this.mElementNames.size()]), intent);
                }
            }
            if (opts == null) {
                opts = ActivityOptions.makeBasic();
                opts.setPendingIntentLaunchFlags(0x10000000);
            }
            if (view.getDisplay() != null) {
                opts.setLaunchDisplayId(view.getDisplay().getDisplayId());
            } else {
                Log.w(RemoteViews.LOG_TAG, "getLaunchOptions: view.getDisplay() is null!", new Exception());
            }
            return Pair.create(intent, opts);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface InteractionType {
        }
    }

    private static class ViewTree {
        private static final int INSERT_AT_END_INDEX = -1;
        private View mRoot;
        private ArrayList<ViewTree> mChildren;

        private ViewTree(View root) {
            this.mRoot = root;
        }

        public void createTree() {
            if (this.mChildren != null) {
                return;
            }
            this.mChildren = new ArrayList();
            if (this.mRoot instanceof ViewGroup) {
                ViewGroup vg = (ViewGroup)this.mRoot;
                int count = vg.getChildCount();
                for (int i = 0; i < count; ++i) {
                    this.addViewChild(vg.getChildAt(i));
                }
            }
        }

        public ViewTree findViewTreeById(int id2) {
            if (this.mRoot.getId() == id2) {
                return this;
            }
            if (this.mChildren == null) {
                return null;
            }
            for (ViewTree tree : this.mChildren) {
                ViewTree result = tree.findViewTreeById(id2);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public ViewTree findViewTreeParentOf(ViewTree child) {
            if (this.mChildren == null) {
                return null;
            }
            for (ViewTree tree : this.mChildren) {
                if (tree == child) {
                    return this;
                }
                ViewTree result = tree.findViewTreeParentOf(child);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public void replaceView(View v) {
            this.mRoot = v;
            this.mChildren = null;
            this.createTree();
        }

        public <T extends View> T findViewById(int id2) {
            if (this.mChildren == null) {
                return this.mRoot.findViewById(id2);
            }
            ViewTree tree = this.findViewTreeById(id2);
            return (T)(tree == null ? null : tree.mRoot);
        }

        public void addChild(ViewTree child) {
            this.addChild(child, -1);
        }

        public void addChild(ViewTree child, int index) {
            if (this.mChildren == null) {
                this.mChildren = new ArrayList();
            }
            child.createTree();
            if (index == -1) {
                this.mChildren.add(child);
                return;
            }
            this.mChildren.add(index, child);
        }

        public void removeChildren(int start, int count) {
            if (this.mChildren != null) {
                for (int i = 0; i < count; ++i) {
                    this.mChildren.remove(start);
                }
            }
        }

        private void addViewChild(View v) {
            ViewTree target;
            if (v.isRootNamespace()) {
                return;
            }
            if (v.getId() != 0) {
                ViewTree tree = new ViewTree(v);
                this.mChildren.add(tree);
                target = tree;
            } else {
                target = this;
            }
            if (v instanceof ViewGroup && target.mChildren == null) {
                target.mChildren = new ArrayList();
                ViewGroup vg = (ViewGroup)v;
                int count = vg.getChildCount();
                for (int i = 0; i < count; ++i) {
                    target.addViewChild(vg.getChildAt(i));
                }
            }
        }

        public int findChildIndex(Predicate<View> condition) {
            return this.findChildIndex(0, condition);
        }

        public int findChildIndex(int startIndex, Predicate<View> condition) {
            if (this.mChildren == null) {
                return -1;
            }
            for (int i = startIndex; i < this.mChildren.size(); ++i) {
                if (!condition.test(this.mChildren.get((int)i).mRoot)) continue;
                return i;
            }
            return -1;
        }
    }

    public static class ColorResources {
        private static final int FIRST_RESOURCE_COLOR_ID = 17170461;
        private static final int LAST_RESOURCE_COLOR_ID = 17170525;
        private static final int ARSC_ENTRY_SIZE = 16;
        private ResourcesLoader mLoader;

        private ColorResources(ResourcesLoader loader) {
            this.mLoader = loader;
        }

        public void apply(Context context) {
            context.getResources().addLoaders(this.mLoader);
        }

        private static ByteArrayOutputStream readFileContent(InputStream input) throws IOException {
            ByteArrayOutputStream content = new ByteArrayOutputStream(2048);
            byte[] buffer = new byte[4096];
            while (input.available() > 0) {
                int read = input.read(buffer);
                content.write(buffer, 0, read);
            }
            return content;
        }

        private static byte[] createCompiledResourcesContent(Context context, SparseIntArray colorResources) throws IOException {
            byte[] content;
            try (InputStream input = context.getResources().openRawResource(0x1100006);){
                ByteArrayOutputStream rawContent = ColorResources.readFileContent(input);
                content = rawContent.toByteArray();
            }
            int valuesOffset = content.length - 1488 - 4;
            if (valuesOffset < 0) {
                Log.e(RemoteViews.LOG_TAG, "ARSC file for theme colors is invalid.");
                return null;
            }
            for (int colorRes = 17170461; colorRes <= 17170525; ++colorRes) {
                int index = colorRes & 0xFFFF;
                int offset = valuesOffset + index * 16;
                int value = colorResources.get(colorRes, context.getColor(colorRes));
                for (int b = 0; b < 4; ++b) {
                    content[offset + b] = (byte)(value & 0xFF);
                    value >>= 8;
                }
            }
            return content;
        }

        /*
         * Exception decompiling
         */
        public static ColorResources create(Context context, SparseIntArray colorMapping) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class AsyncApplyTask
    extends AsyncTask<Void, Void, ViewTree>
    implements CancellationSignal.OnCancelListener {
        final CancellationSignal mCancelSignal = new CancellationSignal();
        final RemoteViews mRV;
        final ViewGroup mParent;
        final Context mContext;
        final OnViewAppliedListener mListener;
        final InteractionHandler mHandler;
        final ColorResources mColorResources;
        final boolean mTopLevel;
        private View mResult;
        private ViewTree mTree;
        private Action[] mActions;
        private Exception mError;

        private AsyncApplyTask(RemoteViews rv, ViewGroup parent, Context context, OnViewAppliedListener listener, InteractionHandler handler, ColorResources colorResources, View result, boolean topLevel) {
            this.mRV = rv;
            this.mParent = parent;
            this.mContext = context;
            this.mListener = listener;
            this.mColorResources = colorResources;
            this.mHandler = handler;
            this.mTopLevel = topLevel;
            this.mResult = result;
        }

        protected ViewTree doInBackground(Void ... params) {
            try {
                if (this.mResult == null) {
                    this.mResult = RemoteViews.this.inflateView(this.mContext, this.mRV, this.mParent, 0, this.mColorResources);
                }
                this.mTree = new ViewTree(this.mResult);
                if (this.mRV.mActions != null) {
                    int count = this.mRV.mActions.size();
                    this.mActions = new Action[count];
                    for (int i = 0; i < count && !this.isCancelled(); ++i) {
                        this.mActions[i] = this.mRV.mActions.get(i).initActionAsync(this.mTree, this.mParent, this.mHandler, this.mColorResources);
                    }
                } else {
                    this.mActions = null;
                }
                return this.mTree;
            }
            catch (Exception e) {
                this.mError = e;
                return null;
            }
        }

        @Override
        protected void onPostExecute(ViewTree viewTree) {
            this.mCancelSignal.setOnCancelListener(null);
            if (this.mError == null) {
                if (this.mListener != null) {
                    this.mListener.onViewInflated(viewTree.mRoot);
                }
                try {
                    if (this.mActions != null) {
                        InteractionHandler handler = this.mHandler == null ? DEFAULT_INTERACTION_HANDLER : this.mHandler;
                        for (Action a : this.mActions) {
                            a.apply(viewTree.mRoot, this.mParent, handler, this.mColorResources);
                        }
                    }
                    if (this.mTopLevel && this.mResult instanceof ViewGroup) {
                        RemoteViews.this.finalizeViewRecycling((ViewGroup)this.mResult);
                    }
                }
                catch (Exception e) {
                    this.mError = e;
                }
            }
            if (this.mListener != null) {
                if (this.mError != null) {
                    this.mListener.onError(this.mError);
                } else {
                    this.mListener.onViewApplied(viewTree.mRoot);
                }
            } else if (this.mError != null) {
                if (this.mError instanceof ActionException) {
                    throw (ActionException)this.mError;
                }
                throw new ActionException(this.mError);
            }
        }

        @Override
        public void onCancel() {
            this.cancel(true);
        }

        private CancellationSignal startTaskOnExecutor(Executor executor) {
            this.mCancelSignal.setOnCancelListener(this);
            this.executeOnExecutor(executor == null ? AsyncTask.THREAD_POOL_EXECUTOR : executor, new Void[0]);
            return this.mCancelSignal;
        }
    }

    public static interface OnViewAppliedListener {
        default public void onViewInflated(View v) {
        }

        public void onViewApplied(View var1);

        public void onError(Exception var1);
    }

    public static class RemoteViewOutlineProvider
    extends ViewOutlineProvider {
        private final float mRadius;

        public RemoteViewOutlineProvider(float radius) {
            this.mRadius = radius;
        }

        public float getRadius() {
            return this.mRadius;
        }

        @Override
        public void getOutline(View view, Outline outline) {
            outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), this.mRadius);
        }
    }

    private static class SetViewOutlinePreferredRadiusAction
    extends Action {
        private final int mValueType;
        private final int mValue;

        SetViewOutlinePreferredRadiusAction(int viewId, int value, int valueType) {
            this.viewId = viewId;
            this.mValueType = valueType;
            this.mValue = value;
        }

        SetViewOutlinePreferredRadiusAction(int viewId, float radius, int units) {
            this.viewId = viewId;
            this.mValueType = 2;
            this.mValue = TypedValue.createComplexDimension(radius, units);
        }

        SetViewOutlinePreferredRadiusAction(Parcel in) {
            this.viewId = in.readInt();
            this.mValueType = in.readInt();
            this.mValue = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.mValueType);
            dest.writeInt(this.mValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) throws ActionException {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            try {
                float radius;
                switch (this.mValueType) {
                    case 4: {
                        TypedArray typedArray = ((View)target).getContext().obtainStyledAttributes(new int[]{this.mValue});
                        try {
                            radius = typedArray.getDimension(0, 0.0f);
                            break;
                        }
                        finally {
                            typedArray.recycle();
                        }
                    }
                    case 3: {
                        radius = this.mValue == 0 ? 0.0f : ((View)target).getResources().getDimension(this.mValue);
                        break;
                    }
                    case 2: {
                        radius = TypedValue.complexToDimension(this.mValue, ((View)target).getResources().getDisplayMetrics());
                        break;
                    }
                    default: {
                        radius = this.mValue;
                    }
                }
                ((View)target).setOutlineProvider(new RemoteViewOutlineProvider(radius));
            }
            catch (Throwable t) {
                throw new ActionException(t);
            }
        }

        @Override
        public int getActionTag() {
            return 28;
        }
    }

    private static class SetRadioGroupCheckedAction
    extends Action {
        private final int mCheckedId;

        SetRadioGroupCheckedAction(int viewId, int checkedId) {
            this.viewId = viewId;
            this.mCheckedId = checkedId;
        }

        SetRadioGroupCheckedAction(Parcel in) {
            this.viewId = in.readInt();
            this.mCheckedId = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.mCheckedId);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) throws ActionException {
            Object tag;
            View child;
            int i;
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(target instanceof RadioGroup)) {
                Log.w(RemoteViews.LOG_TAG, "Cannot check " + this.viewId + " because it's not a RadioGroup");
                return;
            }
            RadioGroup group = (RadioGroup)target;
            for (i = 0; i < group.getChildCount(); ++i) {
                child = group.getChildAt(i);
                if (!(child instanceof CompoundButton) || !((tag = child.getTag(16909397)) instanceof CompoundButton.OnCheckedChangeListener)) continue;
                ((CompoundButton)child).setOnCheckedChangeListener(null);
            }
            group.check(this.mCheckedId);
            for (i = 0; i < group.getChildCount(); ++i) {
                child = group.getChildAt(i);
                if (!(child instanceof CompoundButton) || !((tag = child.getTag(16909397)) instanceof CompoundButton.OnCheckedChangeListener)) continue;
                ((CompoundButton)child).setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)tag);
            }
        }

        @Override
        public int getActionTag() {
            return 27;
        }
    }

    private static class SetCompoundButtonCheckedAction
    extends Action {
        private final boolean mChecked;

        SetCompoundButtonCheckedAction(int viewId, boolean checked) {
            this.viewId = viewId;
            this.mChecked = checked;
        }

        SetCompoundButtonCheckedAction(Parcel in) {
            this.viewId = in.readInt();
            this.mChecked = in.readBoolean();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeBoolean(this.mChecked);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) throws ActionException {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(target instanceof CompoundButton)) {
                Log.w(RemoteViews.LOG_TAG, "Cannot set checked to view " + this.viewId + " because it is not a CompoundButton");
                return;
            }
            CompoundButton button = (CompoundButton)target;
            Object tag = button.getTag(16909397);
            if (tag instanceof CompoundButton.OnCheckedChangeListener) {
                button.setOnCheckedChangeListener(null);
                button.setChecked(this.mChecked);
                button.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)tag);
            } else {
                button.setChecked(this.mChecked);
            }
        }

        @Override
        public int getActionTag() {
            return 26;
        }
    }

    private class SetIntTagAction
    extends Action {
        private final int mViewId;
        private final int mKey;
        private final int mTag;

        SetIntTagAction(int viewId, int key, int tag) {
            this.mViewId = viewId;
            this.mKey = key;
            this.mTag = tag;
        }

        SetIntTagAction(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mKey = parcel.readInt();
            this.mTag = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mKey);
            dest.writeInt(this.mTag);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            ((View)target).setTagInternal(this.mKey, this.mTag);
        }

        @Override
        public int getActionTag() {
            return 22;
        }
    }

    private class OverrideTextColorsAction
    extends Action {
        private final int textColor;

        public OverrideTextColorsAction(int textColor) {
            this.textColor = textColor;
        }

        public OverrideTextColorsAction(Parcel parcel) {
            this.textColor = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.textColor);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Stack<View> viewsToProcess = new Stack<View>();
            viewsToProcess.add(root);
            while (!viewsToProcess.isEmpty()) {
                View v = (View)viewsToProcess.pop();
                if (v instanceof TextView) {
                    TextView textView = (TextView)v;
                    textView.setText(ContrastColorUtil.clearColorSpans(textView.getText()));
                    textView.setTextColor(this.textColor);
                }
                if (!(v instanceof ViewGroup)) continue;
                ViewGroup viewGroup = (ViewGroup)v;
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    viewsToProcess.push(viewGroup.getChildAt(i));
                }
            }
        }

        @Override
        public int getActionTag() {
            return 20;
        }
    }

    private class SetRemoteInputsAction
    extends Action {
        final Parcelable[] remoteInputs;

        public SetRemoteInputsAction(int viewId, RemoteInput[] remoteInputs) {
            this.viewId = viewId;
            this.remoteInputs = remoteInputs;
        }

        public SetRemoteInputsAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.remoteInputs = parcel.createTypedArray(RemoteInput.CREATOR);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeTypedArray(this.remoteInputs, flags);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            ((View)target).setTagInternal(16909401, this.remoteInputs);
        }

        @Override
        public int getActionTag() {
            return 18;
        }
    }

    private static class LayoutParamAction
    extends Action {
        static final int LAYOUT_MARGIN_LEFT = 0;
        static final int LAYOUT_MARGIN_TOP = 1;
        static final int LAYOUT_MARGIN_RIGHT = 2;
        static final int LAYOUT_MARGIN_BOTTOM = 3;
        static final int LAYOUT_MARGIN_START = 4;
        static final int LAYOUT_MARGIN_END = 5;
        static final int LAYOUT_WIDTH = 8;
        static final int LAYOUT_HEIGHT = 9;
        final int mProperty;
        final int mValueType;
        final int mValue;

        LayoutParamAction(int viewId, int property, float value, int units) {
            this.viewId = viewId;
            this.mProperty = property;
            this.mValueType = 2;
            this.mValue = TypedValue.createComplexDimension(value, units);
        }

        LayoutParamAction(int viewId, int property, int value, int valueType) {
            this.viewId = viewId;
            this.mProperty = property;
            this.mValueType = valueType;
            this.mValue = value;
        }

        public LayoutParamAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.mProperty = parcel.readInt();
            this.mValueType = parcel.readInt();
            this.mValue = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.mProperty);
            dest.writeInt(this.mValueType);
            dest.writeInt(this.mValue);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            ViewGroup.LayoutParams layoutParams = ((View)target).getLayoutParams();
            if (layoutParams == null) {
                return;
            }
            switch (this.mProperty) {
                case 0: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).leftMargin = this.getPixelOffset((View)target);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 1: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).topMargin = this.getPixelOffset((View)target);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 2: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).rightMargin = this.getPixelOffset((View)target);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 3: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).bottomMargin = this.getPixelOffset((View)target);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 4: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).setMarginStart(this.getPixelOffset((View)target));
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 5: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).setMarginEnd(this.getPixelOffset((View)target));
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 8: {
                    layoutParams.width = this.getPixelSize((View)target);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 9: {
                    layoutParams.height = this.getPixelSize((View)target);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown property " + this.mProperty);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int getPixelOffset(View target) {
            try {
                switch (this.mValueType) {
                    case 4: {
                        TypedArray typedArray = target.getContext().obtainStyledAttributes(new int[]{this.mValue});
                        try {
                            int n = typedArray.getDimensionPixelOffset(0, 0);
                            return n;
                        }
                        finally {
                            typedArray.recycle();
                        }
                    }
                    case 3: {
                        if (this.mValue != 0) return target.getResources().getDimensionPixelOffset(this.mValue);
                        return 0;
                    }
                    case 2: {
                        return TypedValue.complexToDimensionPixelOffset(this.mValue, target.getResources().getDisplayMetrics());
                    }
                }
                return this.mValue;
            }
            catch (Throwable t) {
                throw new ActionException(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int getPixelSize(View target) {
            try {
                switch (this.mValueType) {
                    case 4: {
                        TypedArray typedArray = target.getContext().obtainStyledAttributes(new int[]{this.mValue});
                        try {
                            int n = typedArray.getDimensionPixelSize(0, 0);
                            return n;
                        }
                        finally {
                            typedArray.recycle();
                        }
                    }
                    case 3: {
                        if (this.mValue != 0) return target.getResources().getDimensionPixelSize(this.mValue);
                        return 0;
                    }
                    case 2: {
                        return TypedValue.complexToDimensionPixelSize(this.mValue, target.getResources().getDisplayMetrics());
                    }
                }
                return this.mValue;
            }
            catch (Throwable t) {
                throw new ActionException(t);
            }
        }

        @Override
        public int getActionTag() {
            return 19;
        }

        @Override
        public String getUniqueKey() {
            return super.getUniqueKey() + this.mProperty;
        }
    }

    private class ViewPaddingAction
    extends Action {
        int left;
        int top;
        int right;
        int bottom;

        public ViewPaddingAction(int viewId, int left, int top, int right, int bottom) {
            this.viewId = viewId;
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }

        public ViewPaddingAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.left = parcel.readInt();
            this.top = parcel.readInt();
            this.right = parcel.readInt();
            this.bottom = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.left);
            dest.writeInt(this.top);
            dest.writeInt(this.right);
            dest.writeInt(this.bottom);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            ((View)target).setPadding(this.left, this.top, this.right, this.bottom);
        }

        @Override
        public int getActionTag() {
            return 14;
        }
    }

    private class TextViewSizeAction
    extends Action {
        int units;
        float size;

        TextViewSizeAction(int viewId, int units, float size) {
            this.viewId = viewId;
            this.units = units;
            this.size = size;
        }

        TextViewSizeAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.units = parcel.readInt();
            this.size = parcel.readFloat();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.units);
            dest.writeFloat(this.size);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            TextView target = (TextView)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            target.setTextSize(this.units, this.size);
        }

        @Override
        public int getActionTag() {
            return 13;
        }
    }

    private class TextViewDrawableAction
    extends Action {
        boolean isRelative = false;
        boolean useIcons = false;
        int d1;
        int d2;
        int d3;
        int d4;
        Icon i1;
        Icon i2;
        Icon i3;
        Icon i4;
        boolean drawablesLoaded = false;
        Drawable id1;
        Drawable id2;
        Drawable id3;
        Drawable id4;

        public TextViewDrawableAction(int viewId, boolean isRelative, int d1, int d2, int d3, int d4) {
            this.viewId = viewId;
            this.isRelative = isRelative;
            this.useIcons = false;
            this.d1 = d1;
            this.d2 = d2;
            this.d3 = d3;
            this.d4 = d4;
        }

        public TextViewDrawableAction(int viewId, boolean isRelative, Icon i1, Icon i2, Icon i3, Icon i4) {
            this.viewId = viewId;
            this.isRelative = isRelative;
            this.useIcons = true;
            this.i1 = i1;
            this.i2 = i2;
            this.i3 = i3;
            this.i4 = i4;
        }

        public TextViewDrawableAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.isRelative = parcel.readInt() != 0;
            boolean bl = this.useIcons = parcel.readInt() != 0;
            if (this.useIcons) {
                this.i1 = parcel.readTypedObject(Icon.CREATOR);
                this.i2 = parcel.readTypedObject(Icon.CREATOR);
                this.i3 = parcel.readTypedObject(Icon.CREATOR);
                this.i4 = parcel.readTypedObject(Icon.CREATOR);
            } else {
                this.d1 = parcel.readInt();
                this.d2 = parcel.readInt();
                this.d3 = parcel.readInt();
                this.d4 = parcel.readInt();
            }
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.isRelative ? 1 : 0);
            dest.writeInt(this.useIcons ? 1 : 0);
            if (this.useIcons) {
                dest.writeTypedObject(this.i1, 0);
                dest.writeTypedObject(this.i2, 0);
                dest.writeTypedObject(this.i3, 0);
                dest.writeTypedObject(this.i4, 0);
            } else {
                dest.writeInt(this.d1);
                dest.writeInt(this.d2);
                dest.writeInt(this.d3);
                dest.writeInt(this.d4);
            }
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            TextView target = (TextView)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (this.drawablesLoaded) {
                if (this.isRelative) {
                    target.setCompoundDrawablesRelativeWithIntrinsicBounds(this.id1, this.id2, this.id3, this.id4);
                } else {
                    target.setCompoundDrawablesWithIntrinsicBounds(this.id1, this.id2, this.id3, this.id4);
                }
            } else if (this.useIcons) {
                Drawable id4;
                Context ctx = target.getContext();
                Drawable id1 = this.i1 == null ? null : this.i1.loadDrawable(ctx);
                Drawable id2 = this.i2 == null ? null : this.i2.loadDrawable(ctx);
                Drawable id3 = this.i3 == null ? null : this.i3.loadDrawable(ctx);
                Drawable drawable2 = id4 = this.i4 == null ? null : this.i4.loadDrawable(ctx);
                if (this.isRelative) {
                    target.setCompoundDrawablesRelativeWithIntrinsicBounds(id1, id2, id3, id4);
                } else {
                    target.setCompoundDrawablesWithIntrinsicBounds(id1, id2, id3, id4);
                }
            } else if (this.isRelative) {
                target.setCompoundDrawablesRelativeWithIntrinsicBounds(this.d1, this.d2, this.d3, this.d4);
            } else {
                target.setCompoundDrawablesWithIntrinsicBounds(this.d1, this.d2, this.d3, this.d4);
            }
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            TextView target = (TextView)root.findViewById(this.viewId);
            if (target == null) {
                return ACTION_NOOP;
            }
            TextViewDrawableAction copy = this.useIcons ? new TextViewDrawableAction(this.viewId, this.isRelative, this.i1, this.i2, this.i3, this.i4) : new TextViewDrawableAction(this.viewId, this.isRelative, this.d1, this.d2, this.d3, this.d4);
            copy.drawablesLoaded = true;
            Context ctx = target.getContext();
            if (this.useIcons) {
                copy.id1 = this.i1 == null ? null : this.i1.loadDrawable(ctx);
                copy.id2 = this.i2 == null ? null : this.i2.loadDrawable(ctx);
                copy.id3 = this.i3 == null ? null : this.i3.loadDrawable(ctx);
                copy.id4 = this.i4 == null ? null : this.i4.loadDrawable(ctx);
            } else {
                copy.id1 = this.d1 == 0 ? null : ctx.getDrawable(this.d1);
                copy.id2 = this.d2 == 0 ? null : ctx.getDrawable(this.d2);
                copy.id3 = this.d3 == 0 ? null : ctx.getDrawable(this.d3);
                copy.id4 = this.d4 == 0 ? null : ctx.getDrawable(this.d4);
            }
            return copy;
        }

        @Override
        public boolean prefersAsyncApply() {
            return this.useIcons;
        }

        @Override
        public int getActionTag() {
            return 11;
        }

        @Override
        public void visitUris(Consumer<Uri> visitor) {
            if (this.useIcons) {
                RemoteViews.visitIconUri(this.i1, visitor);
                RemoteViews.visitIconUri(this.i2, visitor);
                RemoteViews.visitIconUri(this.i3, visitor);
                RemoteViews.visitIconUri(this.i4, visitor);
            }
        }
    }

    private class RemoveFromParentAction
    extends Action {
        RemoveFromParentAction(int viewId) {
            this.viewId = viewId;
        }

        RemoveFromParentAction(Parcel parcel) {
            this.viewId = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object target = root.findViewById(this.viewId);
            if (target == null || target == root) {
                return;
            }
            ViewParent parent = ((View)target).getParent();
            if (parent instanceof ViewManager) {
                ((ViewManager)((Object)parent)).removeView((View)target);
            }
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            root.createTree();
            final ViewTree target = root.findViewTreeById(this.viewId);
            if (target == null || target == root) {
                return ACTION_NOOP;
            }
            ViewTree parent = root.findViewTreeParentOf(target);
            if (parent == null || !(parent.mRoot instanceof ViewManager)) {
                return ACTION_NOOP;
            }
            final ViewManager parentVg = (ViewManager)((Object)parent.mRoot);
            parent.mChildren.remove(target);
            return new RuntimeAction(){

                @Override
                public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) throws ActionException {
                    parentVg.removeView(target.mRoot);
                }
            };
        }

        @Override
        public int getActionTag() {
            return 23;
        }

        @Override
        public int mergeBehavior() {
            return 1;
        }
    }

    private class ViewGroupActionRemove
    extends Action {
        private static final int REMOVE_ALL_VIEWS_ID = -2;
        private int mViewIdToKeep;

        ViewGroupActionRemove(int viewId) {
            this(viewId, -2);
        }

        ViewGroupActionRemove(int viewId, int viewIdToKeep) {
            this.viewId = viewId;
            this.mViewIdToKeep = viewIdToKeep;
        }

        ViewGroupActionRemove(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.mViewIdToKeep = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.mViewIdToKeep);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            ViewGroup target = (ViewGroup)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (this.mViewIdToKeep == -2) {
                for (int i = target.getChildCount() - 1; i >= 0; --i) {
                    if (RemoteViews.hasStableId(target.getChildAt(i))) continue;
                    target.removeViewAt(i);
                }
                RemoteViews.setNextRecyclableChild(target, 0, target.getChildCount());
                return;
            }
            this.removeAllViewsExceptIdToKeep(target);
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            root.createTree();
            ViewTree target = root.findViewTreeById(this.viewId);
            if (target == null || !(target.mRoot instanceof ViewGroup)) {
                return ACTION_NOOP;
            }
            final ViewGroup targetVg = (ViewGroup)target.mRoot;
            if (this.mViewIdToKeep == -2) {
                target.mChildren.removeIf(childTree -> !RemoteViews.hasStableId(childTree.mRoot));
                RemoteViews.setNextRecyclableChild(targetVg, 0, target.mChildren.size());
            } else {
                target.mChildren.removeIf(childTree -> childTree.mRoot.getId() != this.mViewIdToKeep);
                if (target.mChildren.isEmpty()) {
                    target.mChildren = null;
                }
            }
            return new RuntimeAction(){

                @Override
                public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) throws ActionException {
                    if (ViewGroupActionRemove.this.mViewIdToKeep == -2) {
                        for (int i = targetVg.getChildCount() - 1; i >= 0; --i) {
                            if (RemoteViews.hasStableId(targetVg.getChildAt(i))) continue;
                            targetVg.removeViewAt(i);
                        }
                        return;
                    }
                    ViewGroupActionRemove.this.removeAllViewsExceptIdToKeep(targetVg);
                }
            };
        }

        private void removeAllViewsExceptIdToKeep(ViewGroup viewGroup) {
            for (int index = viewGroup.getChildCount() - 1; index >= 0; --index) {
                if (viewGroup.getChildAt(index).getId() == this.mViewIdToKeep) continue;
                viewGroup.removeViewAt(index);
            }
        }

        @Override
        public int getActionTag() {
            return 7;
        }

        @Override
        public int mergeBehavior() {
            return 1;
        }
    }

    private class ViewGroupActionAdd
    extends Action {
        static final int NO_ID = -1;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private RemoteViews mNestedViews;
        private int mIndex;
        private int mStableId;

        ViewGroupActionAdd(int viewId, RemoteViews nestedViews) {
            this(viewId, nestedViews, -1, -1);
        }

        ViewGroupActionAdd(int viewId, RemoteViews nestedViews, int index) {
            this(viewId, nestedViews, index, -1);
        }

        ViewGroupActionAdd(int viewId, RemoteViews nestedViews, int index, int stableId) {
            this.viewId = viewId;
            this.mNestedViews = nestedViews;
            this.mIndex = index;
            this.mStableId = stableId;
            nestedViews.configureAsChild(RemoteViews.this.getHierarchyRootData());
        }

        ViewGroupActionAdd(Parcel parcel, ApplicationInfo info, int depth) {
            this.viewId = parcel.readInt();
            this.mIndex = parcel.readInt();
            this.mStableId = parcel.readInt();
            this.mNestedViews = new RemoteViews(parcel, RemoteViews.this.getHierarchyRootData(), info, depth);
            this.mNestedViews.addFlags(RemoteViews.this.mApplyFlags);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.mIndex);
            dest.writeInt(this.mStableId);
            this.mNestedViews.writeToParcel(dest, flags);
        }

        @Override
        public void setHierarchyRootData(HierarchyRootData root) {
            this.mNestedViews.configureAsChild(root);
        }

        private int findViewIndexToRecycle(ViewGroup target, RemoteViews newContent) {
            for (int nextChild = RemoteViews.getNextRecyclableChild(target); nextChild < target.getChildCount(); ++nextChild) {
                View child = target.getChildAt(nextChild);
                if (RemoteViews.getStableId(child) != this.mStableId) continue;
                return nextChild;
            }
            return -1;
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            int recycledViewIndex;
            Context context = root.getContext();
            ViewGroup target = (ViewGroup)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            int nextChild = RemoteViews.getNextRecyclableChild(target);
            RemoteViews rvToApply = this.mNestedViews.getRemoteViewsToApply(context);
            int flagsToPropagate = RemoteViews.this.mApplyFlags & 6;
            if (flagsToPropagate != 0) {
                rvToApply.addFlags(flagsToPropagate);
            }
            if (nextChild >= 0 && this.mStableId != -1 && (recycledViewIndex = this.findViewIndexToRecycle(target, rvToApply)) >= 0) {
                View child = target.getChildAt(recycledViewIndex);
                if (rvToApply.canRecycleView(child)) {
                    if (nextChild < recycledViewIndex) {
                        target.removeViews(nextChild, recycledViewIndex - nextChild);
                    }
                    RemoteViews.setNextRecyclableChild(target, nextChild + 1, target.getChildCount());
                    rvToApply.reapplyNestedViews(context, child, rootParent, handler, null, colorResources);
                    return;
                }
                target.removeViews(nextChild, recycledViewIndex - nextChild + 1);
            }
            View nestedView = rvToApply.applyNestedViews(context, target, rootParent, handler, null, colorResources);
            if (this.mStableId != -1) {
                RemoteViews.setStableId(nestedView, this.mStableId);
            }
            target.addView(nestedView, this.mIndex >= 0 ? this.mIndex : nextChild);
            if (nextChild >= 0) {
                RemoteViews.setNextRecyclableChild(target, nextChild + 1, target.getChildCount());
            }
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            root.createTree();
            ViewTree target = root.findViewTreeById(this.viewId);
            if (target == null || !(target.mRoot instanceof ViewGroup)) {
                return ACTION_NOOP;
            }
            final ViewGroup targetVg = (ViewGroup)target.mRoot;
            Context context = root.mRoot.getContext();
            final int nextChild = RemoteViews.getNextRecyclableChild(targetVg);
            if (nextChild >= 0 && this.mStableId != -1) {
                RemoteViews rvToApply = this.mNestedViews.getRemoteViewsToApply(context);
                final int recycledViewIndex = target.findChildIndex(nextChild, view -> RemoteViews.getStableId(view) == this.mStableId);
                if (recycledViewIndex >= 0) {
                    ViewTree recycled = target.mChildren.get(recycledViewIndex);
                    if (rvToApply.canRecycleView(recycled.mRoot)) {
                        if (recycledViewIndex > nextChild) {
                            target.removeChildren(nextChild, recycledViewIndex - nextChild);
                        }
                        RemoteViews.setNextRecyclableChild(targetVg, nextChild + 1, target.mChildren.size());
                        final AsyncApplyTask reapplyTask = rvToApply.getInternalAsyncApplyTask(context, targetVg, null, handler, null, colorResources, recycled.mRoot);
                        final ViewTree tree = reapplyTask.doInBackground(new Void[0]);
                        if (tree == null) {
                            throw new ActionException(reapplyTask.mError);
                        }
                        return new RuntimeAction(){

                            @Override
                            public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) throws ActionException {
                                reapplyTask.onPostExecute(tree);
                                if (recycledViewIndex > nextChild) {
                                    targetVg.removeViews(nextChild, recycledViewIndex - nextChild);
                                }
                            }
                        };
                    }
                    target.removeChildren(nextChild, recycledViewIndex - nextChild + 1);
                    return this.insertNewView(context, target, handler, colorResources, () -> targetVg.removeViews(nextChild, recycledViewIndex - nextChild + 1));
                }
            }
            return this.insertNewView(context, target, handler, colorResources, () -> {});
        }

        private Action insertNewView(Context context, ViewTree target, InteractionHandler handler, ColorResources colorResources, final Runnable finalizeAction) {
            final ViewGroup targetVg = (ViewGroup)target.mRoot;
            int nextChild = RemoteViews.getNextRecyclableChild(targetVg);
            final AsyncApplyTask task = this.mNestedViews.getInternalAsyncApplyTask(context, targetVg, null, handler, null, colorResources, null);
            final ViewTree tree = task.doInBackground(new Void[0]);
            if (tree == null) {
                throw new ActionException(task.mError);
            }
            if (this.mStableId != -1) {
                RemoteViews.setStableId(task.mResult, this.mStableId);
            }
            final int insertIndex = this.mIndex >= 0 ? this.mIndex : nextChild;
            target.addChild(tree, insertIndex);
            if (nextChild >= 0) {
                RemoteViews.setNextRecyclableChild(targetVg, nextChild + 1, target.mChildren.size());
            }
            return new RuntimeAction(){

                @Override
                public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) throws ActionException {
                    task.onPostExecute(tree);
                    finalizeAction.run();
                    targetVg.addView(task.mResult, insertIndex);
                }
            };
        }

        @Override
        public int mergeBehavior() {
            return 1;
        }

        @Override
        public boolean prefersAsyncApply() {
            return this.mNestedViews.prefersAsyncApply();
        }

        @Override
        public int getActionTag() {
            return 4;
        }

        @Override
        public void visitUris(Consumer<Uri> visitor) {
            this.mNestedViews.visitUris(visitor);
        }
    }

    private static class RunnableAction
    extends RuntimeAction {
        private final Runnable mRunnable;

        RunnableAction(Runnable r) {
            this.mRunnable = r;
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            this.mRunnable.run();
        }
    }

    private class NightModeReflectionAction
    extends BaseReflectionAction {
        private final Object mLightValue;
        private final Object mDarkValue;

        NightModeReflectionAction(int viewId, String methodName, int type, Object lightValue, Object darkValue) {
            super(viewId, methodName, type);
            this.mLightValue = lightValue;
            this.mDarkValue = darkValue;
        }

        NightModeReflectionAction(Parcel in) {
            super(in);
            switch (this.type) {
                case 16: {
                    this.mLightValue = in.readTypedObject(Icon.CREATOR);
                    this.mDarkValue = in.readTypedObject(Icon.CREATOR);
                    break;
                }
                case 15: {
                    this.mLightValue = in.readTypedObject(ColorStateList.CREATOR);
                    this.mDarkValue = in.readTypedObject(ColorStateList.CREATOR);
                    break;
                }
                case 4: {
                    this.mLightValue = in.readInt();
                    this.mDarkValue = in.readInt();
                    break;
                }
                default: {
                    throw new ActionException("Unexpected night mode action type: " + this.type);
                }
            }
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            switch (this.type) {
                case 15: 
                case 16: {
                    out.writeTypedObject((Parcelable)this.mLightValue, flags);
                    out.writeTypedObject((Parcelable)this.mDarkValue, flags);
                    break;
                }
                case 4: {
                    out.writeInt((Integer)this.mLightValue);
                    out.writeInt((Integer)this.mDarkValue);
                }
            }
        }

        @Override
        protected Object getParameterValue(View view) throws ActionException {
            if (view == null) {
                return null;
            }
            Configuration configuration = view.getResources().getConfiguration();
            return configuration.isNightModeActive() ? this.mDarkValue : this.mLightValue;
        }

        @Override
        public int getActionTag() {
            return 30;
        }

        @Override
        public void visitUris(Consumer<Uri> visitor) {
            if (this.type == 16) {
                RemoteViews.visitIconUri((Icon)this.mDarkValue, visitor);
                RemoteViews.visitIconUri((Icon)this.mLightValue, visitor);
            }
        }
    }

    private class ComplexUnitDimensionReflectionAction
    extends BaseReflectionAction {
        private final float mValue;
        private final int mUnit;

        ComplexUnitDimensionReflectionAction(int viewId, String methodName, int parameterType, float value, int unit) {
            super(viewId, methodName, parameterType);
            this.mValue = value;
            this.mUnit = unit;
        }

        ComplexUnitDimensionReflectionAction(Parcel in) {
            super(in);
            this.mValue = in.readFloat();
            this.mUnit = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeFloat(this.mValue);
            dest.writeInt(this.mUnit);
        }

        @Override
        protected Object getParameterValue(View view) throws ActionException {
            if (view == null) {
                return null;
            }
            DisplayMetrics dm = view.getContext().getResources().getDisplayMetrics();
            try {
                int data = TypedValue.createComplexDimension(this.mValue, this.mUnit);
                switch (this.type) {
                    case 4: {
                        return TypedValue.complexToDimensionPixelSize(data, dm);
                    }
                    case 6: {
                        return Float.valueOf(TypedValue.complexToDimension(data, dm));
                    }
                }
                throw new ActionException("parameter type must be INT or FLOAT, not " + this.type);
            }
            catch (ActionException ex) {
                throw ex;
            }
            catch (Throwable t) {
                throw new ActionException(t);
            }
        }

        @Override
        public int getActionTag() {
            return 25;
        }
    }

    private class AttributeReflectionAction
    extends BaseReflectionAction {
        static final int DIMEN_RESOURCE = 1;
        static final int COLOR_RESOURCE = 2;
        static final int STRING_RESOURCE = 3;
        private final int mResourceType;
        private final int mAttrId;

        AttributeReflectionAction(int viewId, String methodName, int parameterType, int resourceType, int attrId) {
            super(viewId, methodName, parameterType);
            this.mResourceType = resourceType;
            this.mAttrId = attrId;
        }

        AttributeReflectionAction(Parcel in) {
            super(in);
            this.mResourceType = in.readInt();
            this.mAttrId = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mResourceType);
            dest.writeInt(this.mAttrId);
        }

        /*
         * Exception decompiling
         */
        @Override
        protected Object getParameterValue(View view) throws ActionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CASE], 8[SWITCH]], but top level block is 7[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public int getActionTag() {
            return 32;
        }
    }

    private class ResourceReflectionAction
    extends BaseReflectionAction {
        static final int DIMEN_RESOURCE = 1;
        static final int COLOR_RESOURCE = 2;
        static final int STRING_RESOURCE = 3;
        private final int mResourceType;
        private final int mResId;

        ResourceReflectionAction(int viewId, String methodName, int parameterType, int resourceType, int resId) {
            super(viewId, methodName, parameterType);
            this.mResourceType = resourceType;
            this.mResId = resId;
        }

        ResourceReflectionAction(Parcel in) {
            super(in);
            this.mResourceType = in.readInt();
            this.mResId = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mResourceType);
            dest.writeInt(this.mResId);
        }

        @Override
        protected Object getParameterValue(View view) throws ActionException {
            if (view == null) {
                return null;
            }
            Resources resources = view.getContext().getResources();
            try {
                switch (this.mResourceType) {
                    case 1: {
                        switch (this.type) {
                            case 4: {
                                return this.mResId == 0 ? 0 : resources.getDimensionPixelSize(this.mResId);
                            }
                            case 6: {
                                return Float.valueOf(this.mResId == 0 ? 0.0f : resources.getDimension(this.mResId));
                            }
                        }
                        throw new ActionException("dimen resources must be used as INT or FLOAT, not " + this.type);
                    }
                    case 2: {
                        switch (this.type) {
                            case 4: {
                                return this.mResId == 0 ? 0 : view.getContext().getColor(this.mResId);
                            }
                            case 15: {
                                return this.mResId == 0 ? null : view.getContext().getColorStateList(this.mResId);
                            }
                        }
                        throw new ActionException("color resources must be used as INT or COLOR_STATE_LIST, not " + this.type);
                    }
                    case 3: {
                        switch (this.type) {
                            case 10: {
                                return this.mResId == 0 ? null : resources.getText(this.mResId);
                            }
                            case 9: {
                                return this.mResId == 0 ? null : resources.getString(this.mResId);
                            }
                        }
                        throw new ActionException("string resources must be used as STRING or CHAR_SEQUENCE, not " + this.type);
                    }
                }
                throw new ActionException("unknown resource type: " + this.mResourceType);
            }
            catch (ActionException ex) {
                throw ex;
            }
            catch (Throwable t) {
                throw new ActionException(t);
            }
        }

        @Override
        public int getActionTag() {
            return 24;
        }
    }

    private class ReflectionAction
    extends BaseReflectionAction {
        @UnsupportedAppUsage
        Object value;

        ReflectionAction(int viewId, String methodName, int type, Object value) {
            super(viewId, methodName, type);
            this.value = value;
        }

        ReflectionAction(Parcel in) {
            super(in);
            switch (this.type) {
                case 1: {
                    this.value = in.readBoolean();
                    break;
                }
                case 2: {
                    this.value = in.readByte();
                    break;
                }
                case 3: {
                    this.value = (short)in.readInt();
                    break;
                }
                case 4: {
                    this.value = in.readInt();
                    break;
                }
                case 5: {
                    this.value = in.readLong();
                    break;
                }
                case 6: {
                    this.value = Float.valueOf(in.readFloat());
                    break;
                }
                case 7: {
                    this.value = in.readDouble();
                    break;
                }
                case 8: {
                    this.value = Character.valueOf((char)in.readInt());
                    break;
                }
                case 9: {
                    this.value = in.readString8();
                    break;
                }
                case 10: {
                    this.value = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    break;
                }
                case 11: {
                    this.value = in.readTypedObject(Uri.CREATOR);
                    break;
                }
                case 12: {
                    this.value = in.readTypedObject(Bitmap.CREATOR);
                    break;
                }
                case 13: {
                    if (in.hasReadWriteHelper()) {
                        this.value = in.readBundle();
                        break;
                    }
                    in.setReadWriteHelper(ALTERNATIVE_DEFAULT);
                    this.value = in.readBundle();
                    in.setReadWriteHelper(null);
                    break;
                }
                case 14: {
                    this.value = in.readTypedObject(Intent.CREATOR);
                    break;
                }
                case 15: {
                    this.value = in.readTypedObject(ColorStateList.CREATOR);
                    break;
                }
                case 16: {
                    this.value = in.readTypedObject(Icon.CREATOR);
                    break;
                }
                case 17: {
                    this.value = BlendMode.fromValue(in.readInt());
                    break;
                }
            }
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            switch (this.type) {
                case 1: {
                    out.writeBoolean((Boolean)this.value);
                    break;
                }
                case 2: {
                    out.writeByte((Byte)this.value);
                    break;
                }
                case 3: {
                    out.writeInt(((Short)this.value).shortValue());
                    break;
                }
                case 4: {
                    out.writeInt((Integer)this.value);
                    break;
                }
                case 5: {
                    out.writeLong((Long)this.value);
                    break;
                }
                case 6: {
                    out.writeFloat(((Float)this.value).floatValue());
                    break;
                }
                case 7: {
                    out.writeDouble((Double)this.value);
                    break;
                }
                case 8: {
                    out.writeInt(((Character)this.value).charValue());
                    break;
                }
                case 9: {
                    out.writeString8((String)this.value);
                    break;
                }
                case 10: {
                    TextUtils.writeToParcel((CharSequence)this.value, out, flags);
                    break;
                }
                case 13: {
                    out.writeBundle((Bundle)this.value);
                    break;
                }
                case 17: {
                    out.writeInt(BlendMode.toValue((BlendMode)((Object)this.value)));
                    break;
                }
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: {
                    out.writeTypedObject((Parcelable)this.value, flags);
                    break;
                }
            }
        }

        @Override
        protected Object getParameterValue(View view) throws ActionException {
            return this.value;
        }

        @Override
        public int getActionTag() {
            return 2;
        }
    }

    private abstract class BaseReflectionAction
    extends Action {
        static final int BOOLEAN = 1;
        static final int BYTE = 2;
        static final int SHORT = 3;
        static final int INT = 4;
        static final int LONG = 5;
        static final int FLOAT = 6;
        static final int DOUBLE = 7;
        static final int CHAR = 8;
        static final int STRING = 9;
        static final int CHAR_SEQUENCE = 10;
        static final int URI = 11;
        static final int BITMAP = 12;
        static final int BUNDLE = 13;
        static final int INTENT = 14;
        static final int COLOR_STATE_LIST = 15;
        static final int ICON = 16;
        static final int BLEND_MODE = 17;
        @UnsupportedAppUsage
        String methodName;
        int type;

        BaseReflectionAction(int viewId, String methodName, int type) {
            this.viewId = viewId;
            this.methodName = methodName;
            this.type = type;
        }

        BaseReflectionAction(Parcel in) {
            this.viewId = in.readInt();
            this.methodName = in.readString8();
            this.type = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.viewId);
            out.writeString8(this.methodName);
            out.writeInt(this.type);
        }

        protected abstract Object getParameterValue(View var1) throws ActionException;

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object view = root.findViewById(this.viewId);
            if (view == null) {
                return;
            }
            Class<?> param = RemoteViews.getParameterType(this.type);
            if (param == null) {
                throw new ActionException("bad type: " + this.type);
            }
            Object value = this.getParameterValue((View)view);
            try {
                RemoteViews.this.getMethod((View)view, this.methodName, param, false).invoke((View)view, value);
            }
            catch (Throwable ex) {
                throw new ActionException(ex);
            }
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object view = root.findViewById(this.viewId);
            if (view == null) {
                return ACTION_NOOP;
            }
            Class<?> param = RemoteViews.getParameterType(this.type);
            if (param == null) {
                throw new ActionException("bad type: " + this.type);
            }
            Object value = this.getParameterValue((View)view);
            try {
                MethodHandle method = RemoteViews.this.getMethod((View)view, this.methodName, param, true);
                if (method != null) {
                    Runnable endAction = method.invoke((View)view, value);
                    if (endAction == null) {
                        return ACTION_NOOP;
                    }
                    if (endAction instanceof ViewStub.ViewReplaceRunnable) {
                        root.createTree();
                        root.findViewTreeById(this.viewId).replaceView(((ViewStub.ViewReplaceRunnable)endAction).view);
                    }
                    return new RunnableAction(endAction);
                }
            }
            catch (Throwable ex) {
                throw new ActionException(ex);
            }
            return this;
        }

        @Override
        public int mergeBehavior() {
            if (this.methodName.equals("smoothScrollBy")) {
                return 1;
            }
            return 0;
        }

        @Override
        public String getUniqueKey() {
            return super.getUniqueKey() + this.methodName + this.type;
        }

        @Override
        public boolean prefersAsyncApply() {
            return this.type == 11 || this.type == 16;
        }

        @Override
        public void visitUris(Consumer<Uri> visitor) {
            switch (this.type) {
                case 11: {
                    Uri uri = (Uri)this.getParameterValue(null);
                    if (uri == null) break;
                    visitor.accept(uri);
                    break;
                }
                case 16: {
                    Icon icon = (Icon)this.getParameterValue(null);
                    if (icon == null) break;
                    RemoteViews.visitIconUri(icon, visitor);
                }
            }
        }
    }

    private class BitmapReflectionAction
    extends Action {
        int bitmapId;
        @UnsupportedAppUsage
        Bitmap bitmap;
        @UnsupportedAppUsage
        String methodName;

        BitmapReflectionAction(int viewId, String methodName, Bitmap bitmap) {
            this.bitmap = bitmap;
            this.viewId = viewId;
            this.methodName = methodName;
            this.bitmapId = RemoteViews.this.mBitmapCache.getBitmapId(bitmap);
        }

        BitmapReflectionAction(Parcel in) {
            this.viewId = in.readInt();
            this.methodName = in.readString8();
            this.bitmapId = in.readInt();
            this.bitmap = RemoteViews.this.mBitmapCache.getBitmapForId(this.bitmapId);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeString8(this.methodName);
            dest.writeInt(this.bitmapId);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) throws ActionException {
            ReflectionAction ra = new ReflectionAction(this.viewId, this.methodName, 12, this.bitmap);
            ra.apply(root, rootParent, handler, colorResources);
        }

        @Override
        public void setHierarchyRootData(HierarchyRootData rootData) {
            this.bitmapId = rootData.mBitmapCache.getBitmapId(this.bitmap);
        }

        @Override
        public int getActionTag() {
            return 12;
        }
    }

    private static class BitmapCache {
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        ArrayList<Bitmap> mBitmaps;
        SparseIntArray mBitmapHashes;
        int mBitmapMemory = -1;

        public BitmapCache() {
            this.mBitmaps = new ArrayList();
            this.mBitmapHashes = new SparseIntArray();
        }

        public BitmapCache(Parcel source) {
            this.mBitmaps = source.createTypedArrayList(Bitmap.CREATOR);
            this.mBitmapHashes = new SparseIntArray();
            for (int i = 0; i < this.mBitmaps.size(); ++i) {
                Bitmap b = this.mBitmaps.get(i);
                if (b == null) continue;
                this.mBitmapHashes.put(b.hashCode(), i);
            }
        }

        public int getBitmapId(Bitmap b) {
            if (b == null) {
                return -1;
            }
            int hash = b.hashCode();
            int hashId = this.mBitmapHashes.get(hash, -1);
            if (hashId != -1) {
                return hashId;
            }
            if (b.isMutable()) {
                b = b.asShared();
            }
            this.mBitmaps.add(b);
            this.mBitmapHashes.put(hash, this.mBitmaps.size() - 1);
            this.mBitmapMemory = -1;
            return this.mBitmaps.size() - 1;
        }

        public Bitmap getBitmapForId(int id2) {
            if (id2 == -1 || id2 >= this.mBitmaps.size()) {
                return null;
            }
            return this.mBitmaps.get(id2);
        }

        public void writeBitmapsToParcel(Parcel dest, int flags) {
            dest.writeTypedList(this.mBitmaps, flags);
        }

        public int getBitmapMemory() {
            if (this.mBitmapMemory < 0) {
                this.mBitmapMemory = 0;
                int count = this.mBitmaps.size();
                for (int i = 0; i < count; ++i) {
                    this.mBitmapMemory += this.mBitmaps.get(i).getAllocationByteCount();
                }
            }
            return this.mBitmapMemory;
        }
    }

    @Deprecated
    private class ViewContentNavigation
    extends Action {
        final boolean mNext;

        ViewContentNavigation(int viewId, boolean next) {
            this.viewId = viewId;
            this.mNext = next;
        }

        ViewContentNavigation(Parcel in) {
            this.viewId = in.readInt();
            this.mNext = in.readBoolean();
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.viewId);
            out.writeBoolean(this.mNext);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object view = root.findViewById(this.viewId);
            if (view == null) {
                return;
            }
            try {
                RemoteViews.this.getMethod((View)view, this.mNext ? "showNext" : "showPrevious", null, false).invoke((View)view);
            }
            catch (Throwable ex) {
                throw new ActionException(ex);
            }
        }

        @Override
        public int mergeBehavior() {
            return 2;
        }

        @Override
        public int getActionTag() {
            return 5;
        }
    }

    private class SetRippleDrawableColor
    extends Action {
        ColorStateList mColorStateList;

        SetRippleDrawableColor(int id2, ColorStateList colorStateList) {
            this.viewId = id2;
            this.mColorStateList = colorStateList;
        }

        SetRippleDrawableColor(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.mColorStateList = parcel.readParcelable(null, ColorStateList.class);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeParcelable(this.mColorStateList, 0);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            Drawable targetDrawable = ((View)target).getBackground();
            if (targetDrawable instanceof RippleDrawable) {
                ((RippleDrawable)targetDrawable.mutate()).setColor(this.mColorStateList);
            }
        }

        @Override
        public int getActionTag() {
            return 21;
        }
    }

    private class SetDrawableTint
    extends Action {
        boolean targetBackground;
        int colorFilter;
        PorterDuff.Mode filterMode;

        SetDrawableTint(int id2, boolean targetBackground, int colorFilter, PorterDuff.Mode mode) {
            this.viewId = id2;
            this.targetBackground = targetBackground;
            this.colorFilter = colorFilter;
            this.filterMode = mode;
        }

        SetDrawableTint(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.targetBackground = parcel.readInt() != 0;
            this.colorFilter = parcel.readInt();
            this.filterMode = PorterDuff.intToMode(parcel.readInt());
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.targetBackground ? 1 : 0);
            dest.writeInt(this.colorFilter);
            dest.writeInt(PorterDuff.modeToInt(this.filterMode));
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            Drawable targetDrawable = null;
            if (this.targetBackground) {
                targetDrawable = ((View)target).getBackground();
            } else if (target instanceof ImageView) {
                ImageView imageView = (ImageView)target;
                targetDrawable = imageView.getDrawable();
            }
            if (targetDrawable != null) {
                targetDrawable.mutate().setColorFilter(this.colorFilter, this.filterMode);
            }
        }

        @Override
        public int getActionTag() {
            return 3;
        }
    }

    private class SetOnCheckedChangeResponse
    extends Action {
        private final RemoteResponse mResponse;

        SetOnCheckedChangeResponse(int id2, RemoteResponse response) {
            this.viewId = id2;
            this.mResponse = response;
        }

        SetOnCheckedChangeResponse(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.mResponse = new RemoteResponse();
            this.mResponse.readFromParcel(parcel);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            this.mResponse.writeToParcel(dest, flags);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(target instanceof CompoundButton)) {
                Log.w(RemoteViews.LOG_TAG, "setOnCheckedChange methods cannot be used on non-CompoundButton child (id: " + this.viewId + ")");
                return;
            }
            CompoundButton button = (CompoundButton)target;
            if (this.mResponse.mPendingIntent != null) {
                if (RemoteViews.this.hasFlags(2)) {
                    Log.w(RemoteViews.LOG_TAG, "Cannot setOnCheckedChangePendingIntent for collection item (id: " + this.viewId + ")");
                    return;
                }
                ((View)target).setTagInternal(16909336, this.mResponse.mPendingIntent);
            } else if (this.mResponse.mFillIntent != null) {
                if (!RemoteViews.this.hasFlags(2)) {
                    Log.e(RemoteViews.LOG_TAG, "The method setOnCheckedChangeFillInIntent is available only from RemoteViewsFactory (ie. on collection items).");
                    return;
                }
            } else {
                button.setOnCheckedChangeListener(null);
                button.setTagInternal(16909397, null);
                return;
            }
            CompoundButton.OnCheckedChangeListener onCheckedChangeListener = (v, isChecked) -> this.mResponse.handleViewInteraction(v, handler);
            button.setTagInternal(16909397, onCheckedChangeListener);
            button.setOnCheckedChangeListener(onCheckedChangeListener);
        }

        @Override
        public int getActionTag() {
            return 29;
        }
    }

    private class SetOnClickResponse
    extends Action {
        final RemoteResponse mResponse;

        SetOnClickResponse(int id2, RemoteResponse response) {
            this.viewId = id2;
            this.mResponse = response;
        }

        SetOnClickResponse(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.mResponse = new RemoteResponse();
            this.mResponse.readFromParcel(parcel);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            this.mResponse.writeToParcel(dest, flags);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (this.mResponse.mPendingIntent != null) {
                if (RemoteViews.this.hasFlags(2)) {
                    Log.w(RemoteViews.LOG_TAG, "Cannot SetOnClickResponse for collection item (id: " + this.viewId + ")");
                    ApplicationInfo appInfo = root.getContext().getApplicationInfo();
                    if (appInfo != null && appInfo.targetSdkVersion >= 16) {
                        return;
                    }
                }
                ((View)target).setTagInternal(16909336, this.mResponse.mPendingIntent);
            } else if (this.mResponse.mFillIntent != null) {
                if (!RemoteViews.this.hasFlags(2)) {
                    Log.e(RemoteViews.LOG_TAG, "The method setOnClickFillInIntent is available only from RemoteViewsFactory (ie. on collection items).");
                    return;
                }
                if (target == root) {
                    ((View)target).setTagInternal(16909004, this.mResponse);
                    return;
                }
            } else {
                ((View)target).setOnClickListener(null);
                ((View)target).setTagInternal(16909336, null);
                ((View)target).setTagInternal(16909004, null);
                return;
            }
            ((View)target).setOnClickListener(v -> this.mResponse.handleViewInteraction(v, handler));
        }

        @Override
        public int getActionTag() {
            return 1;
        }
    }

    private class SetRemoteViewsAdapterIntent
    extends Action {
        Intent intent;
        boolean isAsync = false;

        public SetRemoteViewsAdapterIntent(int id2, Intent intent) {
            this.viewId = id2;
            this.intent = intent;
        }

        public SetRemoteViewsAdapterIntent(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.intent = parcel.readTypedObject(Intent.CREATOR);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeTypedObject(this.intent, flags);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(rootParent instanceof AppWidgetHostView)) {
                Log.e(RemoteViews.LOG_TAG, "setRemoteAdapter can only be used for AppWidgets (root id: " + this.viewId + ")");
                return;
            }
            if (!(target instanceof AbsListView) && !(target instanceof AdapterViewAnimator)) {
                Log.e(RemoteViews.LOG_TAG, "Cannot setRemoteAdapter on a view which is not an AbsListView or AdapterViewAnimator (id: " + this.viewId + ")");
                return;
            }
            AppWidgetHostView host = (AppWidgetHostView)rootParent;
            this.intent.putExtra(RemoteViews.EXTRA_REMOTEADAPTER_APPWIDGET_ID, host.getAppWidgetId()).putExtra(RemoteViews.EXTRA_REMOTEADAPTER_ON_LIGHT_BACKGROUND, RemoteViews.this.hasFlags(4));
            if (target instanceof AbsListView) {
                AbsListView v = (AbsListView)target;
                v.setRemoteViewsAdapter(this.intent, this.isAsync);
                v.setRemoteViewsInteractionHandler(handler);
            } else if (target instanceof AdapterViewAnimator) {
                AdapterViewAnimator v = (AdapterViewAnimator)target;
                v.setRemoteViewsAdapter(this.intent, this.isAsync);
                v.setRemoteViewsOnClickHandler(handler);
            }
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            SetRemoteViewsAdapterIntent copy = new SetRemoteViewsAdapterIntent(this.viewId, this.intent);
            copy.isAsync = true;
            return copy;
        }

        @Override
        public int getActionTag() {
            return 10;
        }
    }

    private class SetRemoteCollectionItemListAdapterAction
    extends Action {
        private final RemoteCollectionItems mItems;

        SetRemoteCollectionItemListAdapterAction(int id2, RemoteCollectionItems items) {
            this.viewId = id2;
            this.mItems = items;
            this.mItems.setHierarchyRootData(RemoteViews.this.getHierarchyRootData());
        }

        SetRemoteCollectionItemListAdapterAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.mItems = new RemoteCollectionItems(parcel, RemoteViews.this.getHierarchyRootData());
        }

        @Override
        public void setHierarchyRootData(HierarchyRootData rootData) {
            this.mItems.setHierarchyRootData(rootData);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            this.mItems.writeToParcel(dest, flags, true);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) throws ActionException {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(rootParent instanceof AppWidgetHostView)) {
                Log.e(RemoteViews.LOG_TAG, "setRemoteAdapter can only be used for AppWidgets (root id: " + this.viewId + ")");
                return;
            }
            if (!(target instanceof AdapterView)) {
                Log.e(RemoteViews.LOG_TAG, "Cannot call setRemoteAdapter on a view which is not an AdapterView (id: " + this.viewId + ")");
                return;
            }
            AdapterView adapterView = (AdapterView)target;
            Object adapter = adapterView.getAdapter();
            if (adapter instanceof RemoteCollectionItemsAdapter && adapter.getViewTypeCount() >= this.mItems.getViewTypeCount()) {
                try {
                    ((RemoteCollectionItemsAdapter)adapter).setData(this.mItems, handler, colorResources);
                }
                catch (Throwable throwable) {
                    throw new ActionException(throwable);
                }
                return;
            }
            try {
                adapterView.setAdapter(new RemoteCollectionItemsAdapter(this.mItems, handler, colorResources));
            }
            catch (Throwable throwable) {
                throw new ActionException(throwable);
            }
        }

        @Override
        public int getActionTag() {
            return 31;
        }
    }

    private static class ApplicationInfoCache {
        private final Map<Pair<String, Integer>, ApplicationInfo> mPackageUserToApplicationInfo = new ArrayMap<Pair<String, Integer>, ApplicationInfo>();

        ApplicationInfoCache() {
        }

        ApplicationInfo getOrPut(ApplicationInfo applicationInfo) {
            Pair<String, Integer> key = RemoteViews.getPackageUserKey(applicationInfo);
            if (key == null) {
                return null;
            }
            return this.mPackageUserToApplicationInfo.computeIfAbsent(key, ignored -> applicationInfo);
        }

        void put(ApplicationInfo applicationInfo) {
            Pair<String, Integer> key = RemoteViews.getPackageUserKey(applicationInfo);
            if (key == null) {
                return;
            }
            this.mPackageUserToApplicationInfo.put(key, applicationInfo);
        }

        ApplicationInfo get(ApplicationInfo applicationInfo) {
            Pair<String, Integer> key = RemoteViews.getPackageUserKey(applicationInfo);
            if (key == null) {
                return null;
            }
            return this.mPackageUserToApplicationInfo.get(key);
        }
    }

    private class SetRemoteViewsAdapterList
    extends Action {
        int viewTypeCount;
        ArrayList<RemoteViews> list;

        public SetRemoteViewsAdapterList(int id2, ArrayList<RemoteViews> list, int viewTypeCount) {
            this.viewId = id2;
            this.list = list;
            this.viewTypeCount = viewTypeCount;
        }

        public SetRemoteViewsAdapterList(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.viewTypeCount = parcel.readInt();
            this.list = parcel.createTypedArrayList(CREATOR);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.viewTypeCount);
            dest.writeTypedList(this.list, flags);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(rootParent instanceof AppWidgetHostView)) {
                Log.e(RemoteViews.LOG_TAG, "SetRemoteViewsAdapterIntent action can only be used for AppWidgets (root id: " + this.viewId + ")");
                return;
            }
            if (!(target instanceof AbsListView) && !(target instanceof AdapterViewAnimator)) {
                Log.e(RemoteViews.LOG_TAG, "Cannot setRemoteViewsAdapter on a view which is not an AbsListView or AdapterViewAnimator (id: " + this.viewId + ")");
                return;
            }
            if (target instanceof AbsListView) {
                AbsListView v = (AbsListView)target;
                Object a = v.getAdapter();
                if (a instanceof RemoteViewsListAdapter && this.viewTypeCount <= a.getViewTypeCount()) {
                    ((RemoteViewsListAdapter)a).setViewsList(this.list);
                } else {
                    v.setAdapter(new RemoteViewsListAdapter(v.getContext(), this.list, this.viewTypeCount, colorResources));
                }
            } else if (target instanceof AdapterViewAnimator) {
                AdapterViewAnimator v = (AdapterViewAnimator)target;
                Adapter a = v.getAdapter();
                if (a instanceof RemoteViewsListAdapter && this.viewTypeCount <= a.getViewTypeCount()) {
                    ((RemoteViewsListAdapter)a).setViewsList(this.list);
                } else {
                    v.setAdapter(new RemoteViewsListAdapter(v.getContext(), this.list, this.viewTypeCount, colorResources));
                }
            }
        }

        @Override
        public int getActionTag() {
            return 15;
        }
    }

    private class SetPendingIntentTemplate
    extends Action {
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        PendingIntent pendingIntentTemplate;

        public SetPendingIntentTemplate(int id2, PendingIntent pendingIntentTemplate) {
            this.viewId = id2;
            this.pendingIntentTemplate = pendingIntentTemplate;
        }

        public SetPendingIntentTemplate(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.pendingIntentTemplate = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            PendingIntent.writePendingIntentOrNullToParcel(this.pendingIntentTemplate, dest);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(target instanceof AdapterView)) {
                Log.e(RemoteViews.LOG_TAG, "Cannot setPendingIntentTemplate on a view which is notan AdapterView (id: " + this.viewId + ")");
                return;
            }
            AdapterView av = (AdapterView)target;
            AdapterView.OnItemClickListener listener = (parent, view, position, id2) -> {
                RemoteResponse response = this.findRemoteResponseTag(view);
                if (response != null) {
                    response.handleViewInteraction(view, handler);
                }
            };
            av.setOnItemClickListener(listener);
            av.setTag(this.pendingIntentTemplate);
        }

        private RemoteResponse findRemoteResponseTag(View rootView) {
            if (rootView == null) {
                return null;
            }
            ArrayDeque<View> viewsToCheck = new ArrayDeque<View>();
            viewsToCheck.addLast(rootView);
            while (!viewsToCheck.isEmpty()) {
                View view = (View)viewsToCheck.removeFirst();
                Object tag = view.getTag(16909004);
                if (tag instanceof RemoteResponse) {
                    return (RemoteResponse)tag;
                }
                if (!(view instanceof ViewGroup)) continue;
                ViewGroup viewGroup = (ViewGroup)view;
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    viewsToCheck.addLast(viewGroup.getChildAt(i));
                }
            }
            return null;
        }

        @Override
        public int getActionTag() {
            return 8;
        }
    }

    private class SetEmptyView
    extends Action {
        int emptyViewId;

        SetEmptyView(int viewId, int emptyViewId) {
            this.viewId = viewId;
            this.emptyViewId = emptyViewId;
        }

        SetEmptyView(Parcel in) {
            this.viewId = in.readInt();
            this.emptyViewId = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.viewId);
            out.writeInt(this.emptyViewId);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            Object view = root.findViewById(this.viewId);
            if (!(view instanceof AdapterView)) {
                return;
            }
            AdapterView adapterView = (AdapterView)view;
            Object emptyView = root.findViewById(this.emptyViewId);
            if (emptyView == null) {
                return;
            }
            adapterView.setEmptyView((View)emptyView);
        }

        @Override
        public int getActionTag() {
            return 6;
        }
    }

    private static class RemoteViewsContextWrapper
    extends ContextWrapper {
        private final Context mContextForResources;

        RemoteViewsContextWrapper(Context context, Context contextForResources) {
            super(context);
            this.mContextForResources = contextForResources;
        }

        @Override
        public Resources getResources() {
            return this.mContextForResources.getResources();
        }

        @Override
        public Resources.Theme getTheme() {
            return this.mContextForResources.getTheme();
        }

        @Override
        public String getPackageName() {
            return this.mContextForResources.getPackageName();
        }

        @Override
        public UserHandle getUser() {
            return this.mContextForResources.getUser();
        }

        @Override
        public int getUserId() {
            return this.mContextForResources.getUserId();
        }

        @Override
        public boolean isRestricted() {
            return this.mContextForResources.isRestricted();
        }
    }

    private static abstract class RuntimeAction
    extends Action {
        private RuntimeAction() {
        }

        @Override
        public int getActionTag() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class Action
    implements Parcelable {
        public static final int MERGE_REPLACE = 0;
        public static final int MERGE_APPEND = 1;
        public static final int MERGE_IGNORE = 2;
        @UnsupportedAppUsage
        int viewId;

        private Action() {
        }

        public abstract void apply(View var1, ViewGroup var2, InteractionHandler var3, ColorResources var4) throws ActionException;

        @Override
        public int describeContents() {
            return 0;
        }

        public void setHierarchyRootData(HierarchyRootData root) {
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public int mergeBehavior() {
            return 0;
        }

        public abstract int getActionTag();

        public String getUniqueKey() {
            return this.getActionTag() + "_" + this.viewId;
        }

        public Action initActionAsync(ViewTree root, ViewGroup rootParent, InteractionHandler handler, ColorResources colorResources) {
            return this;
        }

        public boolean prefersAsyncApply() {
            return false;
        }

        public void visitUris(Consumer<Uri> visitor) {
        }
    }

    public static interface InteractionHandler {
        public boolean onInteraction(View var1, PendingIntent var2, RemoteResponse var3);
    }

    public static class ActionException
    extends RuntimeException {
        public ActionException(Exception ex) {
            super(ex);
        }

        public ActionException(String message) {
            super(message);
        }

        public ActionException(Throwable t) {
            super(t);
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RemoteView {
    }

    static class MethodArgs {
        public MethodHandle syncMethod;
        public MethodHandle asyncMethod;
        public String asyncMethodName;

        MethodArgs() {
        }
    }

    static class MethodKey {
        public Class targetClass;
        public Class paramClass;
        public String methodName;

        MethodKey() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodKey)) {
                return false;
            }
            MethodKey p = (MethodKey)o;
            return Objects.equals(p.targetClass, this.targetClass) && Objects.equals(p.paramClass, this.paramClass) && Objects.equals(p.methodName, this.methodName);
        }

        public int hashCode() {
            return Objects.hashCode(this.targetClass) ^ Objects.hashCode(this.paramClass) ^ Objects.hashCode(this.methodName);
        }

        public void set(Class targetClass, Class paramClass, String methodName) {
            this.targetClass = targetClass;
            this.paramClass = paramClass;
            this.methodName = methodName;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApplyFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ValueType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MarginType {
    }
}

