/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.jank;

import android.content.Context;
import android.os.HandlerExecutor;
import android.os.HandlerThread;
import android.os._Original_Build;
import android.provider.DeviceConfig;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.Choreographer;
import android.view.SurfaceControl;
import android.view.View;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.jank.FrameTracker;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.PerfettoTrigger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class InteractionJankMonitor {
    private static final String TAG = InteractionJankMonitor.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final String ACTION_PREFIX = InteractionJankMonitor.class.getCanonicalName();
    private static final String DEFAULT_WORKER_NAME = TAG + "-Worker";
    private static final long DEFAULT_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(2L);
    private static final String SETTINGS_ENABLED_KEY = "enabled";
    private static final String SETTINGS_SAMPLING_INTERVAL_KEY = "sampling_interval";
    private static final String SETTINGS_THRESHOLD_MISSED_FRAMES_KEY = "trace_threshold_missed_frames";
    private static final String SETTINGS_THRESHOLD_FRAME_TIME_MILLIS_KEY = "trace_threshold_frame_time_millis";
    private static final boolean DEFAULT_ENABLED = _Original_Build.IS_DEBUGGABLE;
    private static final int DEFAULT_SAMPLING_INTERVAL = 1;
    private static final int DEFAULT_TRACE_THRESHOLD_MISSED_FRAMES = 3;
    private static final int DEFAULT_TRACE_THRESHOLD_FRAME_TIME_MILLIS = 64;
    public static final String ACTION_SESSION_END = ACTION_PREFIX + ".ACTION_SESSION_END";
    public static final String ACTION_SESSION_CANCEL = ACTION_PREFIX + ".ACTION_SESSION_CANCEL";
    public static final int CUJ_NOTIFICATION_SHADE_EXPAND_COLLAPSE = 0;
    public static final int CUJ_NOTIFICATION_SHADE_EXPAND_COLLAPSE_LOCK = 1;
    public static final int CUJ_NOTIFICATION_SHADE_SCROLL_FLING = 2;
    public static final int CUJ_NOTIFICATION_SHADE_ROW_EXPAND = 3;
    public static final int CUJ_NOTIFICATION_SHADE_ROW_SWIPE = 4;
    public static final int CUJ_NOTIFICATION_SHADE_QS_EXPAND_COLLAPSE = 5;
    public static final int CUJ_NOTIFICATION_SHADE_QS_SCROLL_SWIPE = 6;
    public static final int CUJ_LAUNCHER_APP_LAUNCH_FROM_RECENTS = 7;
    public static final int CUJ_LAUNCHER_APP_LAUNCH_FROM_ICON = 8;
    public static final int CUJ_LAUNCHER_APP_CLOSE_TO_HOME = 9;
    public static final int CUJ_LAUNCHER_APP_CLOSE_TO_PIP = 10;
    public static final int CUJ_LAUNCHER_QUICK_SWITCH = 11;
    public static final int CUJ_NOTIFICATION_HEADS_UP_APPEAR = 12;
    public static final int CUJ_NOTIFICATION_HEADS_UP_DISAPPEAR = 13;
    public static final int CUJ_NOTIFICATION_ADD = 14;
    public static final int CUJ_NOTIFICATION_REMOVE = 15;
    public static final int CUJ_NOTIFICATION_APP_START = 16;
    public static final int CUJ_LOCKSCREEN_PASSWORD_APPEAR = 17;
    public static final int CUJ_LOCKSCREEN_PATTERN_APPEAR = 18;
    public static final int CUJ_LOCKSCREEN_PIN_APPEAR = 19;
    public static final int CUJ_LOCKSCREEN_PASSWORD_DISAPPEAR = 20;
    public static final int CUJ_LOCKSCREEN_PATTERN_DISAPPEAR = 21;
    public static final int CUJ_LOCKSCREEN_PIN_DISAPPEAR = 22;
    public static final int CUJ_LOCKSCREEN_TRANSITION_FROM_AOD = 23;
    public static final int CUJ_LOCKSCREEN_TRANSITION_TO_AOD = 24;
    public static final int CUJ_LAUNCHER_OPEN_ALL_APPS = 25;
    public static final int CUJ_LAUNCHER_ALL_APPS_SCROLL = 26;
    public static final int CUJ_LAUNCHER_APP_LAUNCH_FROM_WIDGET = 27;
    public static final int CUJ_SETTINGS_PAGE_SCROLL = 28;
    public static final int CUJ_LOCKSCREEN_UNLOCK_ANIMATION = 29;
    public static final int CUJ_SHADE_APP_LAUNCH_FROM_HISTORY_BUTTON = 30;
    public static final int CUJ_SHADE_APP_LAUNCH_FROM_MEDIA_PLAYER = 31;
    public static final int CUJ_SHADE_APP_LAUNCH_FROM_QS_TILE = 32;
    public static final int CUJ_SHADE_APP_LAUNCH_FROM_SETTINGS_BUTTON = 33;
    public static final int CUJ_STATUS_BAR_APP_LAUNCH_FROM_CALL_CHIP = 34;
    public static final int CUJ_PIP_TRANSITION = 35;
    public static final int CUJ_WALLPAPER_TRANSITION = 36;
    public static final int CUJ_USER_SWITCH = 37;
    public static final int CUJ_SPLASHSCREEN_AVD = 38;
    public static final int CUJ_SPLASHSCREEN_EXIT_ANIM = 39;
    public static final int CUJ_SCREEN_OFF = 40;
    public static final int CUJ_SCREEN_OFF_SHOW_AOD = 41;
    public static final int CUJ_ONE_HANDED_ENTER_TRANSITION = 42;
    public static final int CUJ_ONE_HANDED_EXIT_TRANSITION = 43;
    public static final int CUJ_UNFOLD_ANIM = 44;
    public static final int CUJ_SUW_LOADING_TO_SHOW_INFO_WITH_ACTIONS = 45;
    public static final int CUJ_SUW_SHOW_FUNCTION_SCREEN_WITH_ACTIONS = 46;
    public static final int CUJ_SUW_LOADING_TO_NEXT_FLOW = 47;
    public static final int CUJ_SUW_LOADING_SCREEN_FOR_STATUS = 48;
    public static final int CUJ_SPLIT_SCREEN_ENTER = 49;
    public static final int CUJ_SPLIT_SCREEN_EXIT = 50;
    public static final int CUJ_LOCKSCREEN_LAUNCH_CAMERA = 51;
    public static final int CUJ_SPLIT_SCREEN_RESIZE = 52;
    public static final int CUJ_SETTINGS_SLIDER = 53;
    public static final int CUJ_TAKE_SCREENSHOT = 54;
    public static final int CUJ_VOLUME_CONTROL = 55;
    public static final int CUJ_BIOMETRIC_PROMPT_TRANSITION = 56;
    public static final int CUJ_SETTINGS_TOGGLE = 57;
    private static final int NO_STATSD_LOGGING = -1;
    @VisibleForTesting
    public static final int[] CUJ_TO_STATSD_INTERACTION_TYPE = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58};
    private static volatile InteractionJankMonitor sInstance;
    private final DeviceConfig.OnPropertiesChangedListener mPropertiesChangedListener = this::updateProperties;
    private final FrameTracker.FrameMetricsWrapper mMetrics;
    private final SparseArray<FrameTracker> mRunningTrackers;
    private final SparseArray<Runnable> mTimeoutActions;
    private final HandlerThread mWorker;
    private final Object mLock = new Object();
    private boolean mEnabled = DEFAULT_ENABLED;
    private int mSamplingInterval = 1;
    private int mTraceThresholdMissedFrames = 3;
    private int mTraceThresholdFrameTimeMillis = 64;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InteractionJankMonitor getInstance() {
        if (sInstance != null) return sInstance;
        Class<InteractionJankMonitor> clazz = InteractionJankMonitor.class;
        synchronized (InteractionJankMonitor.class) {
            if (sInstance != null) return sInstance;
            sInstance = new InteractionJankMonitor(new HandlerThread(DEFAULT_WORKER_NAME));
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @VisibleForTesting
    public InteractionJankMonitor(HandlerThread worker) {
        this.mRunningTrackers = new SparseArray();
        this.mTimeoutActions = new SparseArray();
        this.mWorker = worker;
        this.mMetrics = new FrameTracker.FrameMetricsWrapper();
        this.mWorker.start();
        this.mEnabled = DEFAULT_ENABLED;
        this.mSamplingInterval = 1;
        this.mWorker.getThreadHandler().post(() -> this.mPropertiesChangedListener.onPropertiesChanged(DeviceConfig.getProperties("interaction_jank_monitor", new String[0])));
        DeviceConfig.addOnPropertiesChangedListener("interaction_jank_monitor", new HandlerExecutor(this.mWorker.getThreadHandler()), this.mPropertiesChangedListener);
    }

    Object getLock() {
        return this.mLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public FrameTracker createFrameTracker(Configuration config, Session session) {
        View view = config.mView;
        FrameTracker.ThreadedRendererWrapper threadedRenderer = view == null ? null : new FrameTracker.ThreadedRendererWrapper(view.getThreadedRenderer());
        FrameTracker.ViewRootWrapper viewRoot = view == null ? null : new FrameTracker.ViewRootWrapper(view.getViewRootImpl());
        FrameTracker.SurfaceControlWrapper surfaceControl = new FrameTracker.SurfaceControlWrapper();
        FrameTracker.ChoreographerWrapper choreographer = new FrameTracker.ChoreographerWrapper(Choreographer.getInstance());
        Object object = this.mLock;
        synchronized (object) {
            FrameTracker.FrameTrackerListener eventsListener = (s, act) -> this.handleCujEvents(act, s);
            return new FrameTracker(session, this.mWorker.getThreadHandler(), threadedRenderer, viewRoot, surfaceControl, choreographer, this.mMetrics, new FrameTracker.StatsLogWrapper(), this.mTraceThresholdMissedFrames, this.mTraceThresholdFrameTimeMillis, eventsListener, config);
        }
    }

    private void handleCujEvents(String action, Session session) {
        if (this.needRemoveTasks(action, session)) {
            this.removeTimeout(session.getCuj());
            this.removeTracker(session.getCuj());
        }
    }

    private boolean needRemoveTasks(String action, Session session) {
        boolean badEnd = action.equals(ACTION_SESSION_END) && session.getReason() != 0;
        boolean badCancel = action.equals(ACTION_SESSION_CANCEL) && session.getReason() != 16 && session.getReason() != 19;
        return badEnd || badCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTimeout(int cujType) {
        Object object = this.mLock;
        synchronized (object) {
            Runnable timeout = this.mTimeoutActions.get(cujType);
            if (timeout != null) {
                this.mWorker.getThreadHandler().removeCallbacks(timeout);
                this.mTimeoutActions.remove(cujType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstrumenting(int cujType) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRunningTrackers.contains(cujType);
        }
    }

    public boolean begin(View v, int cujType) {
        try {
            return this.beginInternal(Configuration.Builder.withView(cujType, v).build());
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "Build configuration failed!", ex);
            return false;
        }
    }

    public boolean begin(Configuration.Builder builder) {
        try {
            return this.beginInternal(builder.build());
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "Build configuration failed!", ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beginInternal(Configuration conf) {
        Object object = this.mLock;
        synchronized (object) {
            int cujType = conf.mCujType;
            if (!this.shouldMonitor(cujType)) {
                return false;
            }
            FrameTracker tracker = this.getTracker(cujType);
            if (tracker != null) {
                return false;
            }
            tracker = this.createFrameTracker(conf, new Session(cujType, conf.mTag));
            this.mRunningTrackers.put(cujType, tracker);
            tracker.begin();
            this.scheduleTimeoutAction(cujType, conf.mTimeout, () -> this.cancel(cujType, 19));
            return true;
        }
    }

    @VisibleForTesting
    public boolean shouldMonitor(int cujType) {
        boolean shouldSample;
        boolean bl = shouldSample = ThreadLocalRandom.current().nextInt() % this.mSamplingInterval == 0;
        return this.mEnabled && shouldSample;
    }

    @VisibleForTesting
    public void scheduleTimeoutAction(int cuj, long timeout, Runnable action) {
        this.mTimeoutActions.put(cuj, action);
        this.mWorker.getThreadHandler().postDelayed(action, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean end(int cujType) {
        Object object = this.mLock;
        synchronized (object) {
            this.removeTimeout(cujType);
            FrameTracker tracker = this.getTracker(cujType);
            if (tracker == null) {
                return false;
            }
            if (tracker.end(0)) {
                this.removeTracker(cujType);
            }
            return true;
        }
    }

    public boolean cancel(int cujType) {
        return this.cancel(cujType, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean cancel(int cujType, int reason) {
        Object object = this.mLock;
        synchronized (object) {
            this.removeTimeout(cujType);
            FrameTracker tracker = this.getTracker(cujType);
            if (tracker == null) {
                return false;
            }
            if (tracker.cancel(reason)) {
                this.removeTracker(cujType);
            }
            return true;
        }
    }

    private FrameTracker getTracker(int cuj) {
        return this.mRunningTrackers.get(cuj);
    }

    private void removeTracker(int cuj) {
        this.mRunningTrackers.remove(cuj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProperties(DeviceConfig.Properties properties) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSamplingInterval = properties.getInt(SETTINGS_SAMPLING_INTERVAL_KEY, 1);
            this.mEnabled = properties.getBoolean(SETTINGS_ENABLED_KEY, DEFAULT_ENABLED);
            this.mTraceThresholdMissedFrames = properties.getInt(SETTINGS_THRESHOLD_MISSED_FRAMES_KEY, 3);
            this.mTraceThresholdFrameTimeMillis = properties.getInt(SETTINGS_THRESHOLD_FRAME_TIME_MILLIS_KEY, 64);
        }
    }

    @VisibleForTesting
    public DeviceConfig.OnPropertiesChangedListener getPropertiesChangedListener() {
        return this.mPropertiesChangedListener;
    }

    @VisibleForTesting
    public void trigger(Session session) {
        this.mWorker.getThreadHandler().post(() -> PerfettoTrigger.trigger(session.getPerfettoTrigger()));
    }

    public static String getNameOfInteraction(int interactionType) {
        return InteractionJankMonitor.getNameOfCuj(InteractionJankMonitor.getCujTypeFromInteraction(interactionType));
    }

    private static int getCujTypeFromInteraction(int interactionType) {
        return interactionType - 1;
    }

    public static String getNameOfCuj(int cujType) {
        switch (cujType) {
            case 0: {
                return "SHADE_EXPAND_COLLAPSE";
            }
            case 1: {
                return "SHADE_EXPAND_COLLAPSE_LOCK";
            }
            case 2: {
                return "SHADE_SCROLL_FLING";
            }
            case 3: {
                return "SHADE_ROW_EXPAND";
            }
            case 4: {
                return "SHADE_ROW_SWIPE";
            }
            case 5: {
                return "SHADE_QS_EXPAND_COLLAPSE";
            }
            case 6: {
                return "SHADE_QS_SCROLL_SWIPE";
            }
            case 7: {
                return "LAUNCHER_APP_LAUNCH_FROM_RECENTS";
            }
            case 8: {
                return "LAUNCHER_APP_LAUNCH_FROM_ICON";
            }
            case 9: {
                return "LAUNCHER_APP_CLOSE_TO_HOME";
            }
            case 10: {
                return "LAUNCHER_APP_CLOSE_TO_PIP";
            }
            case 11: {
                return "LAUNCHER_QUICK_SWITCH";
            }
            case 12: {
                return "NOTIFICATION_HEADS_UP_APPEAR";
            }
            case 13: {
                return "NOTIFICATION_HEADS_UP_DISAPPEAR";
            }
            case 14: {
                return "NOTIFICATION_ADD";
            }
            case 15: {
                return "NOTIFICATION_REMOVE";
            }
            case 16: {
                return "NOTIFICATION_APP_START";
            }
            case 17: {
                return "LOCKSCREEN_PASSWORD_APPEAR";
            }
            case 18: {
                return "LOCKSCREEN_PATTERN_APPEAR";
            }
            case 19: {
                return "LOCKSCREEN_PIN_APPEAR";
            }
            case 20: {
                return "LOCKSCREEN_PASSWORD_DISAPPEAR";
            }
            case 21: {
                return "LOCKSCREEN_PATTERN_DISAPPEAR";
            }
            case 22: {
                return "LOCKSCREEN_PIN_DISAPPEAR";
            }
            case 23: {
                return "LOCKSCREEN_TRANSITION_FROM_AOD";
            }
            case 24: {
                return "LOCKSCREEN_TRANSITION_TO_AOD";
            }
            case 25: {
                return "LAUNCHER_OPEN_ALL_APPS";
            }
            case 26: {
                return "LAUNCHER_ALL_APPS_SCROLL";
            }
            case 27: {
                return "LAUNCHER_APP_LAUNCH_FROM_WIDGET";
            }
            case 28: {
                return "SETTINGS_PAGE_SCROLL";
            }
            case 29: {
                return "LOCKSCREEN_UNLOCK_ANIMATION";
            }
            case 30: {
                return "SHADE_APP_LAUNCH_FROM_HISTORY_BUTTON";
            }
            case 31: {
                return "SHADE_APP_LAUNCH_FROM_MEDIA_PLAYER";
            }
            case 32: {
                return "SHADE_APP_LAUNCH_FROM_QS_TILE";
            }
            case 33: {
                return "SHADE_APP_LAUNCH_FROM_SETTINGS_BUTTON";
            }
            case 34: {
                return "STATUS_BAR_APP_LAUNCH_FROM_CALL_CHIP";
            }
            case 35: {
                return "PIP_TRANSITION";
            }
            case 36: {
                return "WALLPAPER_TRANSITION";
            }
            case 37: {
                return "USER_SWITCH";
            }
            case 38: {
                return "SPLASHSCREEN_AVD";
            }
            case 39: {
                return "SPLASHSCREEN_EXIT_ANIM";
            }
            case 40: {
                return "SCREEN_OFF";
            }
            case 41: {
                return "SCREEN_OFF_SHOW_AOD";
            }
            case 42: {
                return "ONE_HANDED_ENTER_TRANSITION";
            }
            case 43: {
                return "ONE_HANDED_EXIT_TRANSITION";
            }
            case 44: {
                return "UNFOLD_ANIM";
            }
            case 45: {
                return "SUW_LOADING_TO_SHOW_INFO_WITH_ACTIONS";
            }
            case 46: {
                return "SUW_SHOW_FUNCTION_SCREEN_WITH_ACTIONS";
            }
            case 47: {
                return "SUW_LOADING_TO_NEXT_FLOW";
            }
            case 48: {
                return "SUW_LOADING_SCREEN_FOR_STATUS";
            }
            case 49: {
                return "SPLIT_SCREEN_ENTER";
            }
            case 50: {
                return "SPLIT_SCREEN_EXIT";
            }
            case 51: {
                return "CUJ_LOCKSCREEN_LAUNCH_CAMERA";
            }
            case 52: {
                return "CUJ_SPLIT_SCREEN_RESIZE";
            }
            case 53: {
                return "SETTINGS_SLIDER";
            }
            case 54: {
                return "TAKE_SCREENSHOT";
            }
            case 55: {
                return "VOLUME_CONTROL";
            }
            case 56: {
                return "BIOMETRIC_PROMPT_TRANSITION";
            }
            case 57: {
                return "SETTINGS_TOGGLE";
            }
        }
        return "UNKNOWN";
    }

    public static class Session {
        private final int mCujType;
        private final long mTimeStamp;
        private int mReason = -1;
        private final String mName;

        public Session(int cujType, String postfix) {
            this.mCujType = cujType;
            this.mTimeStamp = System_Delegate.nanoTime();
            this.mName = TextUtils.isEmpty(postfix) ? String.format("J<%s>", InteractionJankMonitor.getNameOfCuj(this.mCujType)) : String.format("J<%s::%s>", InteractionJankMonitor.getNameOfCuj(this.mCujType), postfix);
        }

        public int getCuj() {
            return this.mCujType;
        }

        public int getStatsdInteractionType() {
            return CUJ_TO_STATSD_INTERACTION_TYPE[this.mCujType];
        }

        public boolean logToStatsd() {
            return this.getStatsdInteractionType() != -1;
        }

        public String getPerfettoTrigger() {
            return String.format(Locale.US, "com.android.telemetry.interaction-jank-monitor-%d", this.mCujType);
        }

        public String getName() {
            return this.mName;
        }

        public long getTimeStamp() {
            return this.mTimeStamp;
        }

        public void setReason(int reason) {
            this.mReason = reason;
        }

        public int getReason() {
            return this.mReason;
        }
    }

    public static class Configuration {
        private final View mView;
        private final Context mContext;
        private final long mTimeout;
        private final String mTag;
        private final boolean mSurfaceOnly;
        private final SurfaceControl mSurfaceControl;
        private final int mCujType;
        private final boolean mDeferMonitor;

        private Configuration(int cuj, View view, String tag, long timeout, boolean surfaceOnly, Context context, SurfaceControl surfaceControl, boolean deferMonitor) {
            this.mCujType = cuj;
            this.mTag = tag;
            this.mTimeout = timeout;
            this.mView = view;
            this.mSurfaceOnly = surfaceOnly;
            this.mContext = context != null ? context : (view != null ? view.getContext().getApplicationContext() : null);
            this.mSurfaceControl = surfaceControl;
            this.mDeferMonitor = deferMonitor;
            this.validate();
        }

        private void validate() {
            boolean shouldThrow = false;
            StringBuilder msg = new StringBuilder();
            if (this.mTag == null) {
                shouldThrow = true;
                msg.append("Invalid tag; ");
            }
            if (this.mTimeout < 0L) {
                shouldThrow = true;
                msg.append("Invalid timeout value; ");
            }
            if (this.mSurfaceOnly) {
                if (this.mContext == null) {
                    shouldThrow = true;
                    msg.append("Must pass in a context if only instrument surface; ");
                }
                if (this.mSurfaceControl == null || !this.mSurfaceControl.isValid()) {
                    shouldThrow = true;
                    msg.append("Must pass in a valid surface control if only instrument surface; ");
                }
            } else if (this.mView == null || !this.mView.isAttachedToWindow()) {
                shouldThrow = true;
                msg.append("Null view or unattached view while instrumenting view; ");
            }
            if (shouldThrow) {
                throw new IllegalArgumentException(msg.toString());
            }
        }

        public boolean isSurfaceOnly() {
            return this.mSurfaceOnly;
        }

        public SurfaceControl getSurfaceControl() {
            return this.mSurfaceControl;
        }

        View getView() {
            return this.mView;
        }

        Context getContext() {
            return this.mContext;
        }

        public boolean shouldDeferMonitor() {
            return this.mDeferMonitor;
        }

        public static class Builder {
            private View mAttrView = null;
            private Context mAttrContext = null;
            private long mAttrTimeout = DEFAULT_TIMEOUT_MS;
            private String mAttrTag = "";
            private boolean mAttrSurfaceOnly;
            private SurfaceControl mAttrSurfaceControl;
            private int mAttrCujType;
            private boolean mAttrDeferMonitor = true;

            public static Builder withSurface(int cuj, Context context, SurfaceControl surfaceControl) {
                return new Builder(cuj).setContext(context).setSurfaceControl(surfaceControl).setSurfaceOnly(true);
            }

            public static Builder withView(int cuj, View view) {
                return new Builder(cuj).setView(view).setContext(view.getContext());
            }

            private Builder(int cuj) {
                this.mAttrCujType = cuj;
            }

            private Builder setView(View view) {
                this.mAttrView = view;
                return this;
            }

            public Builder setTimeout(long timeout) {
                this.mAttrTimeout = timeout;
                return this;
            }

            public Builder setTag(String tag) {
                this.mAttrTag = tag;
                return this;
            }

            private Builder setSurfaceOnly(boolean surfaceOnly) {
                this.mAttrSurfaceOnly = surfaceOnly;
                return this;
            }

            private Builder setContext(Context context) {
                this.mAttrContext = context;
                return this;
            }

            private Builder setSurfaceControl(SurfaceControl surfaceControl) {
                this.mAttrSurfaceControl = surfaceControl;
                return this;
            }

            public Builder setDeferMonitorForAnimationStart(boolean defer) {
                this.mAttrDeferMonitor = defer;
                return this;
            }

            public Configuration build() throws IllegalArgumentException {
                return new Configuration(this.mAttrCujType, this.mAttrView, this.mAttrTag, this.mAttrTimeout, this.mAttrSurfaceOnly, this.mAttrContext, this.mAttrSurfaceControl, this.mAttrDeferMonitor);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CujType {
    }
}

