/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.ipsec.ike.crypto;

import android.net.IpSecAlgorithm;
import com.android.internal.net.ipsec.ike.crypto.IkeCipher;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class IkeCombinedModeCipher
extends IkeCipher {
    private final int mChecksumLen;

    IkeCombinedModeCipher(int algorithmId, int keyLength, int ivLength, String algorithmName, int saltLen) {
        this(algorithmId, keyLength, ivLength, algorithmName, saltLen, 0);
    }

    IkeCombinedModeCipher(int algorithmId, int keyLength, int ivLength, String algorithmName, int saltLen, int blockSize) {
        super(algorithmId, keyLength, ivLength, algorithmName, true, saltLen, blockSize);
        switch (algorithmId) {
            case 18: {
                this.mChecksumLen = 8;
                break;
            }
            case 19: {
                this.mChecksumLen = 12;
                break;
            }
            case 20: {
                this.mChecksumLen = 16;
                break;
            }
            case 28: {
                this.mChecksumLen = 16;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized Encryption Algorithm ID: " + algorithmId);
            }
        }
    }

    private byte[] doCipherAction(byte[] data, byte[] additionalAuthData, byte[] keyBytes, byte[] ivBytes, int opmode) throws AEADBadTagException {
        try {
            ByteBuffer secretKeyAndSaltBuffer = ByteBuffer.wrap(keyBytes);
            byte[] secretKeyBytes = new byte[keyBytes.length - this.mSaltLen];
            byte[] salt = new byte[this.mSaltLen];
            secretKeyAndSaltBuffer.get(secretKeyBytes);
            secretKeyAndSaltBuffer.get(salt);
            SecretKeySpec key = new SecretKeySpec(secretKeyBytes, this.getAlgorithmName());
            ByteBuffer nonceBuffer = ByteBuffer.allocate(this.mSaltLen + ivBytes.length);
            nonceBuffer.put(salt);
            nonceBuffer.put(ivBytes);
            this.mCipher.init(opmode, (Key)key, this.getParamSpec(nonceBuffer.array()));
            this.mCipher.updateAAD(additionalAuthData);
            ByteBuffer inputBuffer = ByteBuffer.wrap(data);
            int outputLen = data.length;
            if (opmode == 1) {
                outputLen += this.mChecksumLen;
            }
            ByteBuffer outputBuffer = ByteBuffer.allocate(outputLen);
            this.mCipher.doFinal(inputBuffer, outputBuffer);
            return outputBuffer.array();
        }
        catch (AEADBadTagException e) {
            throw e;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            String errorMessage = 1 == opmode ? "Failed to encrypt data: " : "Failed to decrypt data: ";
            throw new IllegalArgumentException(errorMessage, e);
        }
    }

    private AlgorithmParameterSpec getParamSpec(byte[] nonce) {
        switch (this.getAlgorithmId()) {
            case 18: 
            case 19: 
            case 20: {
                return new GCMParameterSpec(this.mChecksumLen * 8, nonce);
            }
            case 28: {
                return new IvParameterSpec(nonce);
            }
        }
        throw new IllegalArgumentException("Unrecognized Encryption Algorithm ID: " + this.getAlgorithmId());
    }

    public byte[] encrypt(byte[] paddedData, byte[] additionalAuthData, byte[] keyBytes, byte[] ivBytes) {
        try {
            return this.doCipherAction(paddedData, additionalAuthData, keyBytes, ivBytes, 1);
        }
        catch (AEADBadTagException e) {
            throw new IllegalArgumentException("Failed to encrypt data: ", e);
        }
    }

    public byte[] decrypt(byte[] paddedDataWithChecksum, byte[] additionalAuthData, byte[] keyBytes, byte[] ivBytes) throws AEADBadTagException {
        byte[] decryptPaddedDataAndAuthTag = this.doCipherAction(paddedDataWithChecksum, additionalAuthData, keyBytes, ivBytes, 2);
        int decryptPaddedDataLen = decryptPaddedDataAndAuthTag.length - this.mChecksumLen;
        return Arrays.copyOf(decryptPaddedDataAndAuthTag, decryptPaddedDataLen);
    }

    public int getChecksumLen() {
        return this.mChecksumLen;
    }

    @Override
    protected IpSecAlgorithm buildIpSecAlgorithmWithKeyImpl(byte[] key) {
        return new IpSecAlgorithm(IkeCombinedModeCipher.getIpSecAlgorithmName(this.getAlgorithmId()), key, this.mChecksumLen * 8);
    }
}

