/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.util.SparseArray;
import com.android.internal.os.PowerCalculator;
import java.util.List;

public class SensorPowerCalculator
extends PowerCalculator {
    private final SparseArray<Sensor> mSensors;

    public SensorPowerCalculator(SensorManager sensorManager) {
        List<Sensor> sensors = sensorManager.getSensorList(-1);
        this.mSensors = new SparseArray(sensors.size());
        for (int i = 0; i < sensors.size(); ++i) {
            Sensor sensor = sensors.get(i);
            this.mSensors.put(sensor.getHandle(), sensor);
        }
    }

    @Override
    public boolean isPowerComponentSupported(int powerComponent) {
        return powerComponent == 9;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        double appsPowerMah = 0.0;
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            if (app.isVirtualUid()) continue;
            appsPowerMah += this.calculateApp(app, app.getBatteryStatsUid(), rawRealtimeUs);
        }
        builder.getAggregateBatteryConsumerBuilder(0).setConsumedPower(9, appsPowerMah);
        builder.getAggregateBatteryConsumerBuilder(1).setConsumedPower(9, appsPowerMah);
    }

    private double calculateApp(UidBatteryConsumer.Builder app, BatteryStats.Uid u, long rawRealtimeUs) {
        double powerMah = this.calculatePowerMah(u, rawRealtimeUs, 0);
        ((UidBatteryConsumer.Builder)app.setUsageDurationMillis(9, this.calculateDuration(u, rawRealtimeUs, 0))).setConsumedPower(9, powerMah);
        return powerMah;
    }

    private long calculateDuration(BatteryStats.Uid u, long rawRealtimeUs, int statsType) {
        long durationMs = 0L;
        SparseArray<? extends BatteryStats.Uid.Sensor> sensorStats = u.getSensorStats();
        int NSE = sensorStats.size();
        for (int ise = 0; ise < NSE; ++ise) {
            int sensorHandle = sensorStats.keyAt(ise);
            if (sensorHandle == -10000) continue;
            BatteryStats.Uid.Sensor sensor = sensorStats.valueAt(ise);
            BatteryStats.Timer timer = sensor.getSensorTime();
            durationMs += timer.getTotalTimeLocked(rawRealtimeUs, statsType) / 1000L;
        }
        return durationMs;
    }

    private double calculatePowerMah(BatteryStats.Uid u, long rawRealtimeUs, int statsType) {
        double powerMah = 0.0;
        SparseArray<? extends BatteryStats.Uid.Sensor> sensorStats = u.getSensorStats();
        int count = sensorStats.size();
        for (int ise = 0; ise < count; ++ise) {
            Sensor s;
            BatteryStats.Uid.Sensor sensor;
            BatteryStats.Timer timer;
            long sensorTime;
            int sensorHandle = sensorStats.keyAt(ise);
            if (sensorHandle == -10000 || (sensorTime = (timer = (sensor = sensorStats.valueAt(ise)).getSensorTime()).getTotalTimeLocked(rawRealtimeUs, statsType) / 1000L) == 0L || (s = this.mSensors.get(sensorHandle)) == null) continue;
            powerMah += (double)((float)sensorTime * s.getPower() / 3600000.0f);
        }
        return powerMah;
    }
}

