/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Rect;
import android.os.CancellationSignal;
import android.view.View;
import android.view.ViewGroup;
import java.util.function.Consumer;

public interface ScrollCaptureViewHelper<V extends View> {
    public static final int UP = -1;
    public static final int DOWN = 1;

    public boolean onAcceptSession(V var1);

    default public Rect onComputeScrollBounds(V view) {
        Rect bounds = new Rect(0, 0, ((View)view).getWidth(), ((View)view).getHeight());
        if (view instanceof ViewGroup && ((ViewGroup)view).getClipToPadding()) {
            bounds.inset(((View)view).getPaddingLeft(), ((View)view).getPaddingTop(), ((View)view).getPaddingRight(), ((View)view).getPaddingBottom());
        }
        return bounds;
    }

    public void onPrepareForStart(V var1, Rect var2);

    public void onScrollRequested(V var1, Rect var2, Rect var3, CancellationSignal var4, Consumer<ScrollResult> var5);

    public void onPrepareForEnd(V var1);

    public static class ScrollResult {
        public Rect requestedArea;
        public Rect availableArea;
        public int scrollDelta;

        public String toString() {
            return "ScrollResult{requestedArea=" + this.requestedArea + ", availableArea=" + this.availableArea + ", scrollDelta=" + this.scrollDelta + '}';
        }
    }
}

