/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.validator;

import android.view.View;
import com.android.tools.idea.validator.AtfBufferedImage;
import com.android.tools.idea.validator.LayoutValidator;
import com.android.tools.idea.validator.ValidatorData;
import com.android.tools.idea.validator.ValidatorHierarchy;
import com.android.tools.idea.validator.ValidatorResult;
import com.android.tools.idea.validator.hierarchy.CustomHierarchyHelper;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPreset;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.checks.EditableContentDescCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.SpeakableTextPresentCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.TextContrastCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.TouchTargetSizeCheck;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.CompoundFixSuggestions;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.FixSuggestion;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.FixSuggestionPreset;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.RemoveViewAttributeFixSuggestion;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.SetViewAttributeFixSuggestion;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.ViewAttribute;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchyAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.CustomViewBuilderAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.DefaultCustomViewBuilderAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElementAndroid;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

public class ValidatorUtil {
    protected static DefaultCustomViewBuilderAndroid sDefaultCustomViewBuilderAndroid;
    private static final ImmutableSet<Class<? extends AccessibilityHierarchyCheck>> sAllowedCheckResultClassSet4Fix;
    public static final int CHARACTER_LOCATION_ARG_MAX_LENGTH = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidatorHierarchy buildHierarchy(ValidatorData.Policy policy, View view, BufferedImage image, float scaleX, float scaleY) {
        ValidatorHierarchy hierarchy = new ValidatorHierarchy();
        if (!policy.mTypes.contains((Object)ValidatorData.Type.ACCESSIBILITY)) {
            return hierarchy;
        }
        ValidatorResult.Builder builder = new ValidatorResult.Builder();
        Parameters parameters = null;
        builder.mMetric.startHierarchyCreationTimer();
        try {
            hierarchy.mView = AccessibilityHierarchyAndroid.newBuilder(view).setViewOriginMap(builder.mSrcMap).setNodeInfoOriginMap(builder.mNodeInfoMap).setObtainCharacterLocations(LayoutValidator.obtainCharacterLocations()).setCharacterLocationArgMaxLength(100).setCustomViewBuilder(new CustomViewBuilderAndroid(){

                @Override
                public Class<?> getClassByName(ViewHierarchyElementAndroid viewHierarchyElementAndroid, String className) {
                    Class<?> toReturn = sDefaultCustomViewBuilderAndroid.getClassByName(viewHierarchyElementAndroid, className);
                    if (toReturn == null) {
                        toReturn = CustomHierarchyHelper.getClassByName(className);
                    }
                    return toReturn;
                }

                @Override
                public boolean isCheckable(View view) {
                    return CustomHierarchyHelper.isCheckable(view);
                }
            }).build();
            if (image != null) {
                parameters = new Parameters();
                parameters.putScreenCapture(new AtfBufferedImage(image, builder.mMetric, scaleX, scaleY));
            }
        }
        finally {
            builder.mMetric.recordHierarchyCreationTime();
        }
        hierarchy.mBuilder = builder;
        hierarchy.mParameters = parameters;
        return hierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidatorResult generateResults(ValidatorData.Policy policy, ValidatorHierarchy hierarchy) {
        ValidatorResult.Builder builder = hierarchy.mBuilder;
        try {
            if (!hierarchy.isHierarchyBuilt()) {
                builder = new ValidatorResult.Builder();
                String errorMsg = hierarchy.mErrorMessage != null ? hierarchy.mErrorMessage : "Hierarchy is not built yet.";
                builder.mIssues.add(new ValidatorData.Issue.IssueBuilder().setCategory("Accessibility").setType(ValidatorData.Type.INTERNAL_ERROR).setMsg(errorMsg).setLevel(ValidatorData.Level.ERROR).setSourceClass("ValidatorHierarchy").build());
                ValidatorResult validatorResult = builder.build();
                return validatorResult;
            }
            builder.mMetric.startGenerateResultsTimer();
            AccessibilityHierarchyAndroid view = hierarchy.mView;
            Parameters parameters = hierarchy.mParameters;
            EnumSet<ValidatorData.Level> filter = policy.mLevels;
            ArrayList<AccessibilityHierarchyCheckResult> a11yResults = new ArrayList<AccessibilityHierarchyCheckResult>();
            HashSet<AccessibilityHierarchyCheck> policyChecks = policy.mChecks;
            HashSet<AccessibilityHierarchyCheck> checks = policyChecks.isEmpty() ? AccessibilityCheckPreset.getAccessibilityHierarchyChecksForPreset(AccessibilityCheckPreset.LATEST) : policyChecks;
            for (AccessibilityHierarchyCheck check : checks) {
                a11yResults.addAll(check.runCheckOnHierarchy(view, null, parameters));
            }
            for (AccessibilityHierarchyCheckResult result : a11yResults) {
                String category = ValidatorUtil.getCheckClassCategory(result.getSourceCheckClass());
                ValidatorData.Level level = ValidatorUtil.convertLevel(result.getType());
                if (!filter.contains((Object)level)) continue;
                try {
                    AccessibilityHierarchyCheck subclass;
                    ValidatorData.Issue.IssueBuilder issueBuilder = new ValidatorData.Issue.IssueBuilder().setCategory(category).setMsg(result.getMessage(Locale.ENGLISH).toString()).setLevel(level).setFix(ValidatorUtil.generateFix(result, view, parameters)).setSourceClass(result.getSourceCheckClass().getSimpleName());
                    if (result.getElement() != null) {
                        issueBuilder.setSrcId(result.getElement().getCondensedUniqueId());
                    }
                    if ((subclass = AccessibilityCheckPreset.getHierarchyCheckForClass(result.getSourceCheckClass().asSubclass(AccessibilityHierarchyCheck.class))) != null) {
                        issueBuilder.setHelpfulUrl(subclass.getHelpUrl());
                    }
                    builder.mIssues.add(issueBuilder.build());
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    builder.mIssues.add(new ValidatorData.Issue.IssueBuilder().setCategory(category).setType(ValidatorData.Type.INTERNAL_ERROR).setMsg(sw.toString()).setLevel(ValidatorData.Level.ERROR).setSourceClass("ValidatorHierarchy").build());
                }
            }
        }
        finally {
            builder.mMetric.recordGenerateResultsTime();
        }
        return builder.build();
    }

    public static List<ValidatorData.Issue> filterInternalErrors(List<ValidatorData.Issue> results) {
        return ValidatorUtil.filterByTypes(results, EnumSet.of(ValidatorData.Type.INTERNAL_ERROR));
    }

    public static List<ValidatorData.Issue> filter(List<ValidatorData.Issue> results, EnumSet<ValidatorData.Level> errors) {
        return results.stream().filter(issue -> errors.contains((Object)issue.mLevel)).collect(Collectors.toList());
    }

    public static List<ValidatorData.Issue> filter(List<ValidatorData.Issue> results, String sourceClass) {
        return results.stream().filter(issue -> sourceClass.equals(issue.mSourceClass)).collect(Collectors.toList());
    }

    public static List<ValidatorData.Issue> filterByTypes(List<ValidatorData.Issue> results, EnumSet<ValidatorData.Type> types) {
        return results.stream().filter(issue -> types.contains((Object)issue.mType)).collect(Collectors.toList());
    }

    private static String getCheckClassCategory(Class<?> checkClass) {
        try {
            Class<AccessibilityHierarchyCheck> subClass = checkClass.asSubclass(AccessibilityHierarchyCheck.class);
            AccessibilityHierarchyCheck check = AccessibilityCheckPreset.getHierarchyCheckForClass(subClass);
            return check == null ? "Accessibility" : check.getCategory().name();
        }
        catch (ClassCastException e) {
            return "Accessibility";
        }
    }

    private static ValidatorData.Level convertLevel(AccessibilityCheckResult.AccessibilityCheckResultType type) {
        switch (type) {
            case ERROR: {
                return ValidatorData.Level.ERROR;
            }
            case WARNING: {
                return ValidatorData.Level.WARNING;
            }
            case INFO: {
                return ValidatorData.Level.INFO;
            }
        }
        return ValidatorData.Level.VERBOSE;
    }

    private static ValidatorData.Fix generateFix(AccessibilityHierarchyCheckResult result, AccessibilityHierarchy hierarchy, Parameters parameters) {
        if (sAllowedCheckResultClassSet4Fix.contains(result.getSourceCheckClass())) {
            ImmutableList<FixSuggestion> fixSuggestions = FixSuggestionPreset.provideFixSuggestions(result, hierarchy, parameters);
            return fixSuggestions.isEmpty() ? null : ValidatorUtil.convertFix((FixSuggestion)fixSuggestions.get(0));
        }
        return null;
    }

    private static ValidatorData.Fix convertFix(FixSuggestion fixSuggestion) {
        if (fixSuggestion instanceof CompoundFixSuggestions) {
            CompoundFixSuggestions compoundFixSuggestions = (CompoundFixSuggestions)fixSuggestion;
            List<ValidatorData.Fix> fixes = compoundFixSuggestions.getFixSuggestions().stream().map(ValidatorUtil::convertFix).collect(Collectors.toList());
            return new ValidatorData.CompoundFix(fixes, compoundFixSuggestions.getDescription(Locale.ENGLISH));
        }
        if (fixSuggestion instanceof RemoveViewAttributeFixSuggestion) {
            RemoveViewAttributeFixSuggestion removeViewAttributeFix = (RemoveViewAttributeFixSuggestion)fixSuggestion;
            return new ValidatorData.RemoveViewAttributeFix(ValidatorUtil.convertViewAttribute(removeViewAttributeFix.getViewAttribute()), removeViewAttributeFix.getDescription(Locale.ENGLISH));
        }
        if (fixSuggestion instanceof SetViewAttributeFixSuggestion) {
            SetViewAttributeFixSuggestion setViewAttributeFixSuggestion = (SetViewAttributeFixSuggestion)fixSuggestion;
            return new ValidatorData.SetViewAttributeFix(ValidatorUtil.convertViewAttribute(setViewAttributeFixSuggestion.getViewAttribute()), setViewAttributeFixSuggestion.getSuggestedValue(), setViewAttributeFixSuggestion.getDescription(Locale.ENGLISH));
        }
        return null;
    }

    private static ValidatorData.ViewAttribute convertViewAttribute(ViewAttribute viewAttribute) {
        return new ValidatorData.ViewAttribute(viewAttribute.getNamespaceUri(), viewAttribute.getNamespace(), viewAttribute.getAttributeName());
    }

    static {
        StringManager.setResourceBundleProvider(locale -> ResourceBundle.getBundle("strings"));
        AccessibilityHierarchyAndroid.viewOverlayEnabled = true;
        sDefaultCustomViewBuilderAndroid = new DefaultCustomViewBuilderAndroid();
        sAllowedCheckResultClassSet4Fix = ImmutableSet.of(SpeakableTextPresentCheck.class, TextContrastCheck.class, TouchTargetSizeCheck.class, EditableContentDescCheck.class);
    }
}

