/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.view.View;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPreset;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityEventCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AnnouncementEventCheck;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ViewChecker;
import com.google.android.apps.common.testing.accessibility.framework.checks.ClassNameCheck;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AccessibilityCheckPresetAndroid {
    @Deprecated
    public static ImmutableSet<AccessibilityViewHierarchyCheck> getViewChecksForPreset(AccessibilityCheckPreset preset) {
        if (preset == AccessibilityCheckPreset.VERSION_3_0_CHECKS) {
            preset = AccessibilityCheckPreset.VERSION_2_0_CHECKS;
        }
        ImmutableSet checks = AccessibilityCheckPreset.getAccessibilityHierarchyChecksForPreset(preset);
        if (preset == AccessibilityCheckPreset.VERSION_3_1_CHECKS) {
            checks = Sets.difference(checks, (Set)ImmutableSet.of((Object)AccessibilityCheckPreset.getHierarchyCheckForClass(ClassNameCheck.class))).immutableCopy();
        }
        ImmutableSet.Builder viewChecks = ImmutableSet.builder();
        for (AccessibilityHierarchyCheck check : checks) {
            viewChecks.add((Object)AccessibilityCheckPresetAndroid.getDelegatedCheck(check.getClass()));
        }
        return viewChecks.build();
    }

    public static ImmutableSet<AccessibilityEventCheck> getEventChecksForPreset(AccessibilityCheckPreset preset) {
        ImmutableSet.Builder checks = ImmutableSet.builder();
        if (preset == AccessibilityCheckPreset.NO_CHECKS || preset == AccessibilityCheckPreset.VERSION_1_0_CHECKS) {
            return checks.build();
        }
        checks.add((Object)new AnnouncementEventCheck());
        if (preset == AccessibilityCheckPreset.VERSION_2_0_CHECKS) {
            return checks.build();
        }
        if (preset == AccessibilityCheckPreset.VERSION_3_0_CHECKS || preset == AccessibilityCheckPreset.VERSION_3_1_CHECKS || preset == AccessibilityCheckPreset.VERSION_4_0_CHECKS) {
            return checks.build();
        }
        if (preset == AccessibilityCheckPreset.LATEST) {
            return checks.build();
        }
        if (preset == AccessibilityCheckPreset.PRERELEASE) {
            return checks.build();
        }
        throw new IllegalArgumentException();
    }

    private static AccessibilityViewHierarchyCheck getDelegatedCheck(Class<? extends AccessibilityHierarchyCheck> clazz) {
        return new DelegatedViewHierarchyCheck((AccessibilityHierarchyCheck)Preconditions.checkNotNull((Object)AccessibilityCheckPreset.getHierarchyCheckForClass(clazz)));
    }

    private AccessibilityCheckPresetAndroid() {
    }

    static class DelegatedViewHierarchyCheck
    extends AccessibilityViewHierarchyCheck {
        private final AccessibilityHierarchyCheck toCheck;

        DelegatedViewHierarchyCheck(AccessibilityHierarchyCheck toCheck) {
            this.toCheck = toCheck;
        }

        AccessibilityHierarchyCheck getAccessibilityHierarchyCheck() {
            return this.toCheck;
        }

        @Override
        public List<AccessibilityViewCheckResult> runCheckOnViewHierarchy(View root, @Nullable Parameters parameters) {
            return new ViewChecker().runCheckOnView(this.toCheck, root, parameters);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DelegatedViewHierarchyCheck)) {
                return false;
            }
            DelegatedViewHierarchyCheck other = (DelegatedViewHierarchyCheck)o;
            return this.toCheck.equals(other.getAccessibilityHierarchyCheck());
        }

        public int hashCode() {
            return this.toCheck.hashCode();
        }
    }
}

