/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.suggestions;

import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.ContrastUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum MaterialDesignColor {
    RED("Red", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-5138).put((Object)((Object)Shade.PRIMARY_100), (Object)-12846).put((Object)((Object)Shade.PRIMARY_200), (Object)-1074534).put((Object)((Object)Shade.PRIMARY_300), (Object)-1739917).put((Object)((Object)Shade.PRIMARY_400), (Object)-1092784).put((Object)((Object)Shade.PRIMARY_500), (Object)-769226).put((Object)((Object)Shade.PRIMARY_600), (Object)-1754827).put((Object)((Object)Shade.PRIMARY_700), (Object)-2937041).put((Object)((Object)Shade.PRIMARY_800), (Object)-3790808).put((Object)((Object)Shade.PRIMARY_900), (Object)-4776932).put((Object)((Object)Shade.ACCENT_100), (Object)-30080).put((Object)((Object)Shade.ACCENT_200), (Object)-44462).put((Object)((Object)Shade.ACCENT_400), (Object)-59580).put((Object)((Object)Shade.ACCENT_700), (Object)-2818048).buildOrThrow()),
    PINK("Pink", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-203540).put((Object)((Object)Shade.PRIMARY_100), (Object)-476208).put((Object)((Object)Shade.PRIMARY_200), (Object)-749647).put((Object)((Object)Shade.PRIMARY_300), (Object)-1023342).put((Object)((Object)Shade.PRIMARY_400), (Object)-1294214).put((Object)((Object)Shade.PRIMARY_500), (Object)-1499549).put((Object)((Object)Shade.PRIMARY_600), (Object)-2614432).put((Object)((Object)Shade.PRIMARY_700), (Object)-4056997).put((Object)((Object)Shade.PRIMARY_800), (Object)-5434281).put((Object)((Object)Shade.PRIMARY_900), (Object)-7860657).put((Object)((Object)Shade.ACCENT_100), (Object)-32597).put((Object)((Object)Shade.ACCENT_200), (Object)-49023).put((Object)((Object)Shade.ACCENT_400), (Object)-720809).put((Object)((Object)Shade.ACCENT_700), (Object)-3862174).buildOrThrow()),
    PURPLE("Purple", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-793099).put((Object)((Object)Shade.PRIMARY_100), (Object)-1982745).put((Object)((Object)Shade.PRIMARY_200), (Object)-3238952).put((Object)((Object)Shade.PRIMARY_300), (Object)-4560696).put((Object)((Object)Shade.PRIMARY_400), (Object)-5552196).put((Object)((Object)Shade.PRIMARY_500), (Object)-6543440).put((Object)((Object)Shade.PRIMARY_600), (Object)-7461718).put((Object)((Object)Shade.PRIMARY_700), (Object)-8708190).put((Object)((Object)Shade.PRIMARY_800), (Object)-9823334).put((Object)((Object)Shade.PRIMARY_900), (Object)-11922292).put((Object)((Object)Shade.ACCENT_100), (Object)-1408772).put((Object)((Object)Shade.ACCENT_200), (Object)-2080517).put((Object)((Object)Shade.ACCENT_400), (Object)-2817799).put((Object)((Object)Shade.ACCENT_700), (Object)-5635841).buildOrThrow()),
    DEEP_PURPLE("Deep Purple", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-1185802).put((Object)((Object)Shade.PRIMARY_100), (Object)-3029783).put((Object)((Object)Shade.PRIMARY_200), (Object)-5005861).put((Object)((Object)Shade.PRIMARY_300), (Object)-6982195).put((Object)((Object)Shade.PRIMARY_400), (Object)-8497214).put((Object)((Object)Shade.PRIMARY_500), (Object)-10011977).put((Object)((Object)Shade.PRIMARY_600), (Object)-10603087).put((Object)((Object)Shade.PRIMARY_700), (Object)-11457112).put((Object)((Object)Shade.PRIMARY_800), (Object)-12245088).put((Object)((Object)Shade.PRIMARY_900), (Object)-13558894).put((Object)((Object)Shade.ACCENT_100), (Object)-5011201).put((Object)((Object)Shade.ACCENT_200), (Object)-8630785).put((Object)((Object)Shade.ACCENT_400), (Object)-10149889).put((Object)((Object)Shade.ACCENT_700), (Object)-10354454).buildOrThrow()),
    INDIGO("Indigo", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-1512714).put((Object)((Object)Shade.PRIMARY_100), (Object)-3814679).put((Object)((Object)Shade.PRIMARY_200), (Object)-6313766).put((Object)((Object)Shade.PRIMARY_300), (Object)-8812853).put((Object)((Object)Shade.PRIMARY_400), (Object)-10720320).put((Object)((Object)Shade.PRIMARY_500), (Object)-12627531).put((Object)((Object)Shade.PRIMARY_600), (Object)-13022805).put((Object)((Object)Shade.PRIMARY_700), (Object)-13615201).put((Object)((Object)Shade.PRIMARY_800), (Object)-14142061).put((Object)((Object)Shade.PRIMARY_900), (Object)-15064194).put((Object)((Object)Shade.ACCENT_100), (Object)-7561473).put((Object)((Object)Shade.ACCENT_200), (Object)-11309570).put((Object)((Object)Shade.ACCENT_400), (Object)-12756226).put((Object)((Object)Shade.ACCENT_700), (Object)-13611010).buildOrThrow()),
    BLUE("Blue", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-1838339).put((Object)((Object)Shade.PRIMARY_100), (Object)-4464901).put((Object)((Object)Shade.PRIMARY_200), (Object)-7288071).put((Object)((Object)Shade.PRIMARY_300), (Object)-10177034).put((Object)((Object)Shade.PRIMARY_400), (Object)-12409355).put((Object)((Object)Shade.PRIMARY_500), (Object)-14575885).put((Object)((Object)Shade.PRIMARY_600), (Object)-14776091).put((Object)((Object)Shade.PRIMARY_700), (Object)-15108398).put((Object)((Object)Shade.PRIMARY_800), (Object)-15374912).put((Object)((Object)Shade.PRIMARY_900), (Object)-15906911).put((Object)((Object)Shade.ACCENT_100), (Object)-8211969).put((Object)((Object)Shade.ACCENT_200), (Object)-12285185).put((Object)((Object)Shade.ACCENT_400), (Object)-14059009).put((Object)((Object)Shade.ACCENT_700), (Object)-14064897).buildOrThrow()),
    LIGHT_BLUE("Light Blue", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-1968642).put((Object)((Object)Shade.PRIMARY_100), (Object)-4987396).put((Object)((Object)Shade.PRIMARY_200), (Object)-8268550).put((Object)((Object)Shade.PRIMARY_300), (Object)-11549705).put((Object)((Object)Shade.PRIMARY_400), (Object)-14043402).put((Object)((Object)Shade.PRIMARY_500), (Object)-16537100).put((Object)((Object)Shade.PRIMARY_600), (Object)-16540699).put((Object)((Object)Shade.PRIMARY_700), (Object)-16611119).put((Object)((Object)Shade.PRIMARY_800), (Object)-16615491).put((Object)((Object)Shade.PRIMARY_900), (Object)-16689253).put((Object)((Object)Shade.ACCENT_100), (Object)-8333057).put((Object)((Object)Shade.ACCENT_200), (Object)-12532481).put((Object)((Object)Shade.ACCENT_400), (Object)-16731905).put((Object)((Object)Shade.ACCENT_700), (Object)-16739862).buildOrThrow()),
    CYAN("Cyan", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-2033670).put((Object)((Object)Shade.PRIMARY_100), (Object)-5051406).put((Object)((Object)Shade.PRIMARY_200), (Object)-8331542).put((Object)((Object)Shade.PRIMARY_300), (Object)-11677471).put((Object)((Object)Shade.PRIMARY_400), (Object)-14235942).put((Object)((Object)Shade.PRIMARY_500), (Object)-16728876).put((Object)((Object)Shade.PRIMARY_600), (Object)-16732991).put((Object)((Object)Shade.PRIMARY_700), (Object)-16738393).put((Object)((Object)Shade.PRIMARY_800), (Object)-16743537).put((Object)((Object)Shade.PRIMARY_900), (Object)-16752540).put((Object)((Object)Shade.ACCENT_100), (Object)-8060929).put((Object)((Object)Shade.ACCENT_200), (Object)-15138817).put((Object)((Object)Shade.ACCENT_400), (Object)-16718337).put((Object)((Object)Shade.ACCENT_700), (Object)-16729900).buildOrThrow()),
    TEAL("Teal", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-2034959).put((Object)((Object)Shade.PRIMARY_100), (Object)-5054501).put((Object)((Object)Shade.PRIMARY_200), (Object)-8336444).put((Object)((Object)Shade.PRIMARY_300), (Object)-11684180).put((Object)((Object)Shade.PRIMARY_400), (Object)-14244198).put((Object)((Object)Shade.PRIMARY_500), (Object)-16738680).put((Object)((Object)Shade.PRIMARY_600), (Object)-16742021).put((Object)((Object)Shade.PRIMARY_700), (Object)-16746133).put((Object)((Object)Shade.PRIMARY_800), (Object)-16750244).put((Object)((Object)Shade.PRIMARY_900), (Object)-16757440).put((Object)((Object)Shade.ACCENT_100), (Object)-5767189).put((Object)((Object)Shade.ACCENT_200), (Object)-10158118).put((Object)((Object)Shade.ACCENT_400), (Object)-14816842).put((Object)((Object)Shade.ACCENT_700), (Object)-16728155).buildOrThrow()),
    GREEN("Green", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-1509911).put((Object)((Object)Shade.PRIMARY_100), (Object)-3610935).put((Object)((Object)Shade.PRIMARY_200), (Object)-5908825).put((Object)((Object)Shade.PRIMARY_300), (Object)-8271996).put((Object)((Object)Shade.PRIMARY_400), (Object)-10044566).put((Object)((Object)Shade.PRIMARY_500), (Object)-11751600).put((Object)((Object)Shade.PRIMARY_600), (Object)-12345273).put((Object)((Object)Shade.PRIMARY_700), (Object)-13070788).put((Object)((Object)Shade.PRIMARY_800), (Object)-13730510).put((Object)((Object)Shade.PRIMARY_900), (Object)-14983648).put((Object)((Object)Shade.ACCENT_100), (Object)-4589878).put((Object)((Object)Shade.ACCENT_200), (Object)-9834322).put((Object)((Object)Shade.ACCENT_400), (Object)-16718218).put((Object)((Object)Shade.ACCENT_700), (Object)-16725933).buildOrThrow()),
    LIGHT_GREEN("Light Green", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-919319).put((Object)((Object)Shade.PRIMARY_100), (Object)-2298424).put((Object)((Object)Shade.PRIMARY_200), (Object)-3808859).put((Object)((Object)Shade.PRIMARY_300), (Object)-5319295).put((Object)((Object)Shade.PRIMARY_400), (Object)-6501275).put((Object)((Object)Shade.PRIMARY_500), (Object)-7617718).put((Object)((Object)Shade.PRIMARY_600), (Object)-8604862).put((Object)((Object)Shade.PRIMARY_700), (Object)-9920712).put((Object)((Object)Shade.PRIMARY_800), (Object)-11171025).put((Object)((Object)Shade.PRIMARY_900), (Object)-13407970).put((Object)((Object)Shade.ACCENT_100), (Object)-3342448).put((Object)((Object)Shade.ACCENT_200), (Object)-5046439).put((Object)((Object)Shade.ACCENT_400), (Object)-8978685).put((Object)((Object)Shade.ACCENT_700), (Object)-10167017).buildOrThrow()),
    LIME("Lime", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-394265).put((Object)((Object)Shade.PRIMARY_100), (Object)-985917).put((Object)((Object)Shade.PRIMARY_200), (Object)-1642852).put((Object)((Object)Shade.PRIMARY_300), (Object)-2300043).put((Object)((Object)Shade.PRIMARY_400), (Object)-2825897).put((Object)((Object)Shade.PRIMARY_500), (Object)-3285959).put((Object)((Object)Shade.PRIMARY_600), (Object)-4142541).put((Object)((Object)Shade.PRIMARY_700), (Object)-5262293).put((Object)((Object)Shade.PRIMARY_800), (Object)-6382300).put((Object)((Object)Shade.PRIMARY_900), (Object)-8227049).put((Object)((Object)Shade.ACCENT_100), (Object)-721023).put((Object)((Object)Shade.ACCENT_200), (Object)-1114303).put((Object)((Object)Shade.ACCENT_400), (Object)-3735808).put((Object)((Object)Shade.ACCENT_700), (Object)-5314048).buildOrThrow()),
    YELLOW("Yellow", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-537).put((Object)((Object)Shade.PRIMARY_100), (Object)-1596).put((Object)((Object)Shade.PRIMARY_200), (Object)-2659).put((Object)((Object)Shade.PRIMARY_300), (Object)-3722).put((Object)((Object)Shade.PRIMARY_400), (Object)-4520).put((Object)((Object)Shade.PRIMARY_500), (Object)-5317).put((Object)((Object)Shade.PRIMARY_600), (Object)-141259).put((Object)((Object)Shade.PRIMARY_700), (Object)-278483).put((Object)((Object)Shade.PRIMARY_800), (Object)-415707).put((Object)((Object)Shade.PRIMARY_900), (Object)-688361).put((Object)((Object)Shade.ACCENT_100), (Object)-115).put((Object)((Object)Shade.ACCENT_200), (Object)-256).put((Object)((Object)Shade.ACCENT_400), (Object)-5632).put((Object)((Object)Shade.ACCENT_700), (Object)-10752).buildOrThrow()),
    AMBER("Amber", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-1823).put((Object)((Object)Shade.PRIMARY_100), (Object)-4941).put((Object)((Object)Shade.PRIMARY_200), (Object)-8062).put((Object)((Object)Shade.PRIMARY_300), (Object)-10929).put((Object)((Object)Shade.PRIMARY_400), (Object)-13784).put((Object)((Object)Shade.PRIMARY_500), (Object)-16121).put((Object)((Object)Shade.PRIMARY_600), (Object)-19712).put((Object)((Object)Shade.PRIMARY_700), (Object)-24576).put((Object)((Object)Shade.PRIMARY_800), (Object)-28928).put((Object)((Object)Shade.PRIMARY_900), (Object)-37120).put((Object)((Object)Shade.ACCENT_100), (Object)-6785).put((Object)((Object)Shade.ACCENT_200), (Object)-10432).put((Object)((Object)Shade.ACCENT_400), (Object)-15360).put((Object)((Object)Shade.ACCENT_700), (Object)-21760).buildOrThrow()),
    ORANGE("Orange", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-3104).put((Object)((Object)Shade.PRIMARY_100), (Object)-8014).put((Object)((Object)Shade.PRIMARY_200), (Object)-13184).put((Object)((Object)Shade.PRIMARY_300), (Object)-18611).put((Object)((Object)Shade.PRIMARY_400), (Object)-22746).put((Object)((Object)Shade.PRIMARY_500), (Object)-26624).put((Object)((Object)Shade.PRIMARY_600), (Object)-291840).put((Object)((Object)Shade.PRIMARY_700), (Object)-689152).put((Object)((Object)Shade.PRIMARY_800), (Object)-1086464).put((Object)((Object)Shade.PRIMARY_900), (Object)-1683200).put((Object)((Object)Shade.ACCENT_100), (Object)-11904).put((Object)((Object)Shade.ACCENT_200), (Object)-21696).put((Object)((Object)Shade.ACCENT_400), (Object)-28416).put((Object)((Object)Shade.ACCENT_700), (Object)-37632).buildOrThrow()),
    DEEP_ORANGE("Deep Orange", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-267801).put((Object)((Object)Shade.PRIMARY_100), (Object)-13124).put((Object)((Object)Shade.PRIMARY_200), (Object)-21615).put((Object)((Object)Shade.PRIMARY_300), (Object)-30107).put((Object)((Object)Shade.PRIMARY_400), (Object)-36797).put((Object)((Object)Shade.PRIMARY_500), (Object)-43230).put((Object)((Object)Shade.PRIMARY_600), (Object)-765666).put((Object)((Object)Shade.PRIMARY_700), (Object)-1684967).put((Object)((Object)Shade.PRIMARY_800), (Object)-2604267).put((Object)((Object)Shade.PRIMARY_900), (Object)-4246004).put((Object)((Object)Shade.ACCENT_100), (Object)-24960).put((Object)((Object)Shade.ACCENT_200), (Object)-37312).put((Object)((Object)Shade.ACCENT_400), (Object)-49920).put((Object)((Object)Shade.ACCENT_700), (Object)-2282496).buildOrThrow()),
    BROWN("Brown", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-1053719).put((Object)((Object)Shade.PRIMARY_100), (Object)-2634552).put((Object)((Object)Shade.PRIMARY_200), (Object)-4412764).put((Object)((Object)Shade.PRIMARY_300), (Object)-6190977).put((Object)((Object)Shade.PRIMARY_400), (Object)-7508381).put((Object)((Object)Shade.PRIMARY_500), (Object)-8825528).put((Object)((Object)Shade.PRIMARY_600), (Object)-9614271).put((Object)((Object)Shade.PRIMARY_700), (Object)-10665929).put((Object)((Object)Shade.PRIMARY_800), (Object)-11652050).put((Object)((Object)Shade.PRIMARY_900), (Object)-12703965).buildOrThrow()),
    GREY("Grey", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-328966).put((Object)((Object)Shade.PRIMARY_100), (Object)-657931).put((Object)((Object)Shade.PRIMARY_200), (Object)-1118482).put((Object)((Object)Shade.PRIMARY_300), (Object)-2039584).put((Object)((Object)Shade.PRIMARY_400), (Object)-4342339).put((Object)((Object)Shade.PRIMARY_500), (Object)-6381922).put((Object)((Object)Shade.PRIMARY_600), (Object)-9079435).put((Object)((Object)Shade.PRIMARY_700), (Object)-10395295).put((Object)((Object)Shade.PRIMARY_800), (Object)-12434878).put((Object)((Object)Shade.PRIMARY_900), (Object)-14606047).buildOrThrow()),
    BLUE_GREY("Blue Grey", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)-1249295).put((Object)((Object)Shade.PRIMARY_100), (Object)-3155748).put((Object)((Object)Shade.PRIMARY_200), (Object)-5194043).put((Object)((Object)Shade.PRIMARY_300), (Object)-7297874).put((Object)((Object)Shade.PRIMARY_400), (Object)-8875876).put((Object)((Object)Shade.PRIMARY_500), (Object)-10453621).put((Object)((Object)Shade.PRIMARY_600), (Object)-11243910).put((Object)((Object)Shade.PRIMARY_700), (Object)-12232092).put((Object)((Object)Shade.PRIMARY_800), (Object)-13154481).put((Object)((Object)Shade.PRIMARY_900), (Object)-14273992).buildOrThrow()),
    BLACK("Black", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.of((Object)((Object)Shade.PRIMARY_500), (Object)-16777216)),
    WHITE("White", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.of((Object)((Object)Shade.PRIMARY_500), (Object)-1));

    private final String name;
    private final ImmutableBiMap<Shade, Integer> colorMap;

    private MaterialDesignColor(String name, ImmutableBiMap<Shade, Integer> colorMap) {
        this.name = name;
        this.colorMap = colorMap;
    }

    public String getName() {
        return this.name;
    }

    public ImmutableBiMap<Shade, Integer> getColorMap() {
        return this.colorMap;
    }

    public static @Nullable MaterialDesignColor fromColor(int color2) {
        for (MaterialDesignColor materialDesignColor : MaterialDesignColor.values()) {
            if (!materialDesignColor.getColorMap().containsValue((Object)color2)) continue;
            return materialDesignColor;
        }
        return null;
    }

    public static boolean isMaterialDesignColor(int color2) {
        return MaterialDesignColor.fromColor(color2) != null;
    }

    public static MaterialDesignColor findClosestColor(int color2) {
        MaterialDesignColor materialDesignColor = MaterialDesignColor.fromColor(color2);
        if (materialDesignColor != null) {
            return materialDesignColor;
        }
        double minColorDistance = Double.MAX_VALUE;
        MaterialDesignColor closestColor = null;
        for (MaterialDesignColor designColor : MaterialDesignColor.values()) {
            UnmodifiableIterator unmodifiableIterator = designColor.getColorMap().values().iterator();
            while (unmodifiableIterator.hasNext()) {
                int testColor = (Integer)unmodifiableIterator.next();
                double colorDistance = ContrastUtils.colorDifference(testColor, color2);
                if (!(minColorDistance > colorDistance)) continue;
                minColorDistance = colorDistance;
                closestColor = designColor;
            }
        }
        return (MaterialDesignColor)((Object)Preconditions.checkNotNull(closestColor));
    }

    public static enum Shade {
        PRIMARY_050("50"),
        PRIMARY_100("100"),
        PRIMARY_200("200"),
        PRIMARY_300("300"),
        PRIMARY_400("400"),
        PRIMARY_500("500"),
        PRIMARY_600("600"),
        PRIMARY_700("700"),
        PRIMARY_800("800"),
        PRIMARY_900("900"),
        ACCENT_100("A100"),
        ACCENT_200("A200"),
        ACCENT_400("A400"),
        ACCENT_700("A700");

        public static ImmutableList<Shade> primaryShades;
        public static ImmutableList<Shade> accentShades;
        private final String code;

        public String getCode() {
            return this.code;
        }

        private Shade(String code) {
            this.code = code;
        }

        static {
            primaryShades = ImmutableList.of((Object)((Object)PRIMARY_050), (Object)((Object)PRIMARY_100), (Object)((Object)PRIMARY_200), (Object)((Object)PRIMARY_300), (Object)((Object)PRIMARY_400), (Object)((Object)PRIMARY_500), (Object)((Object)PRIMARY_600), (Object)((Object)PRIMARY_700), (Object)((Object)PRIMARY_800), (Object)((Object)PRIMARY_900));
            accentShades = ImmutableList.of((Object)((Object)ACCENT_100), (Object)((Object)ACCENT_200), (Object)((Object)ACCENT_400), (Object)((Object)ACCENT_700));
        }
    }
}

