/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.suggestions;

import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.BaseTextContrastFixSuggestionProducer;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.MaterialDesignColor;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.SetViewAttributeFixSuggestion;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.ContrastUtils;
import com.google.common.collect.UnmodifiableIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

class TextBackgroundColorFixSuggestionProducer
extends BaseTextContrastFixSuggestionProducer {
    private static final String VIEW_ATTRIBUTE_BACKGROUND = "background";

    TextBackgroundColorFixSuggestionProducer() {
    }

    @Override
    protected @Nullable SetViewAttributeFixSuggestion produceTextContrastFixSuggestion(int checkResultId, ViewHierarchyElement element, ResultMetadata metadata) {
        switch (checkResultId) {
            case 8: {
                return TextBackgroundColorFixSuggestionProducer.produceBackgroundColorFixSuggestion(metadata);
            }
        }
        return null;
    }

    private static @Nullable SetViewAttributeFixSuggestion produceBackgroundColorFixSuggestion(ResultMetadata resultMetadata) {
        Integer bestColorCandidate = TextBackgroundColorFixSuggestionProducer.findBestBackgroundColorCandidate(TextBackgroundColorFixSuggestionProducer.getTextColor(resultMetadata), TextBackgroundColorFixSuggestionProducer.getBackgroundColor(resultMetadata), TextBackgroundColorFixSuggestionProducer.getRequiredContrastRatio(resultMetadata));
        return bestColorCandidate == null ? null : TextBackgroundColorFixSuggestionProducer.createSetViewAttributeFixSuggestion(VIEW_ATTRIBUTE_BACKGROUND, bestColorCandidate);
    }

    private static @Nullable Integer findBestBackgroundColorCandidate(int textColor, int backgroundColor, double requiredContrastRatio) {
        Integer bestColorCandidate = null;
        double minColorDistance = Double.MAX_VALUE;
        for (MaterialDesignColor designColor : MaterialDesignColor.values()) {
            UnmodifiableIterator unmodifiableIterator = designColor.getColorMap().values().iterator();
            while (unmodifiableIterator.hasNext()) {
                double colorDistance;
                int testColor = (Integer)unmodifiableIterator.next();
                if (ContrastUtils.calculateContrastRatio(textColor, testColor) < requiredContrastRatio || !(minColorDistance > (colorDistance = ContrastUtils.colorDifference(testColor, backgroundColor)))) continue;
                minColorDistance = colorDistance;
                bestColorCandidate = testColor;
            }
        }
        return bestColorCandidate;
    }
}

