/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.AccessibilityGestureEvent;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.accessibilityservice.MagnificationConfig;
import android.graphics.Region;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.accessibility.AccessibilityEvent;
import android.view.inputmethod.EditorInfo;
import com.android.internal.inputmethod.IAccessibilityInputMethodSession;
import com.android.internal.inputmethod.IAccessibilityInputMethodSessionCallback;
import com.android.internal.inputmethod.IRemoteAccessibilityInputConnection;

public interface IAccessibilityServiceClient
extends IInterface {
    public void init(IAccessibilityServiceConnection var1, int var2, IBinder var3) throws RemoteException;

    public void onAccessibilityEvent(AccessibilityEvent var1, boolean var2) throws RemoteException;

    public void onInterrupt() throws RemoteException;

    public void onGesture(AccessibilityGestureEvent var1) throws RemoteException;

    public void clearAccessibilityCache() throws RemoteException;

    public void onKeyEvent(KeyEvent var1, int var2) throws RemoteException;

    public void onMagnificationChanged(int var1, Region var2, MagnificationConfig var3) throws RemoteException;

    public void onMotionEvent(MotionEvent var1) throws RemoteException;

    public void onTouchStateChanged(int var1, int var2) throws RemoteException;

    public void onSoftKeyboardShowModeChanged(int var1) throws RemoteException;

    public void onPerformGestureResult(int var1, boolean var2) throws RemoteException;

    public void onFingerprintCapturingGesturesChanged(boolean var1) throws RemoteException;

    public void onFingerprintGesture(int var1) throws RemoteException;

    public void onAccessibilityButtonClicked(int var1) throws RemoteException;

    public void onAccessibilityButtonAvailabilityChanged(boolean var1) throws RemoteException;

    public void onSystemActionsChanged() throws RemoteException;

    public void createImeSession(IAccessibilityInputMethodSessionCallback var1) throws RemoteException;

    public void setImeSessionEnabled(IAccessibilityInputMethodSession var1, boolean var2) throws RemoteException;

    public void bindInput() throws RemoteException;

    public void unbindInput() throws RemoteException;

    public void startInput(IRemoteAccessibilityInputConnection var1, EditorInfo var2, boolean var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAccessibilityServiceClient {
        public static final String DESCRIPTOR = "android.accessibilityservice.IAccessibilityServiceClient";
        static final int TRANSACTION_init = 1;
        static final int TRANSACTION_onAccessibilityEvent = 2;
        static final int TRANSACTION_onInterrupt = 3;
        static final int TRANSACTION_onGesture = 4;
        static final int TRANSACTION_clearAccessibilityCache = 5;
        static final int TRANSACTION_onKeyEvent = 6;
        static final int TRANSACTION_onMagnificationChanged = 7;
        static final int TRANSACTION_onMotionEvent = 8;
        static final int TRANSACTION_onTouchStateChanged = 9;
        static final int TRANSACTION_onSoftKeyboardShowModeChanged = 10;
        static final int TRANSACTION_onPerformGestureResult = 11;
        static final int TRANSACTION_onFingerprintCapturingGesturesChanged = 12;
        static final int TRANSACTION_onFingerprintGesture = 13;
        static final int TRANSACTION_onAccessibilityButtonClicked = 14;
        static final int TRANSACTION_onAccessibilityButtonAvailabilityChanged = 15;
        static final int TRANSACTION_onSystemActionsChanged = 16;
        static final int TRANSACTION_createImeSession = 17;
        static final int TRANSACTION_setImeSessionEnabled = 18;
        static final int TRANSACTION_bindInput = 19;
        static final int TRANSACTION_unbindInput = 20;
        static final int TRANSACTION_startInput = 21;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAccessibilityServiceClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAccessibilityServiceClient) {
                return (IAccessibilityServiceClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "init";
                }
                case 2: {
                    return "onAccessibilityEvent";
                }
                case 3: {
                    return "onInterrupt";
                }
                case 4: {
                    return "onGesture";
                }
                case 5: {
                    return "clearAccessibilityCache";
                }
                case 6: {
                    return "onKeyEvent";
                }
                case 7: {
                    return "onMagnificationChanged";
                }
                case 8: {
                    return "onMotionEvent";
                }
                case 9: {
                    return "onTouchStateChanged";
                }
                case 10: {
                    return "onSoftKeyboardShowModeChanged";
                }
                case 11: {
                    return "onPerformGestureResult";
                }
                case 12: {
                    return "onFingerprintCapturingGesturesChanged";
                }
                case 13: {
                    return "onFingerprintGesture";
                }
                case 14: {
                    return "onAccessibilityButtonClicked";
                }
                case 15: {
                    return "onAccessibilityButtonAvailabilityChanged";
                }
                case 16: {
                    return "onSystemActionsChanged";
                }
                case 17: {
                    return "createImeSession";
                }
                case 18: {
                    return "setImeSessionEnabled";
                }
                case 19: {
                    return "bindInput";
                }
                case 20: {
                    return "unbindInput";
                }
                case 21: {
                    return "startInput";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IAccessibilityServiceConnection _arg0 = IAccessibilityServiceConnection.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.init(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    AccessibilityEvent _arg0 = data.readTypedObject(AccessibilityEvent.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onAccessibilityEvent(_arg0, _arg1);
                    break;
                }
                case 3: {
                    this.onInterrupt();
                    break;
                }
                case 4: {
                    AccessibilityGestureEvent _arg0 = data.readTypedObject(AccessibilityGestureEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onGesture(_arg0);
                    break;
                }
                case 5: {
                    this.clearAccessibilityCache();
                    break;
                }
                case 6: {
                    KeyEvent _arg0 = data.readTypedObject(KeyEvent.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onKeyEvent(_arg0, _arg1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    Region _arg1 = data.readTypedObject(Region.CREATOR);
                    MagnificationConfig _arg2 = data.readTypedObject(MagnificationConfig.CREATOR);
                    data.enforceNoDataAvail();
                    this.onMagnificationChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 8: {
                    MotionEvent _arg0 = data.readTypedObject(MotionEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onMotionEvent(_arg0);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTouchStateChanged(_arg0, _arg1);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSoftKeyboardShowModeChanged(_arg0);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onPerformGestureResult(_arg0, _arg1);
                    break;
                }
                case 12: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onFingerprintCapturingGesturesChanged(_arg0);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onFingerprintGesture(_arg0);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAccessibilityButtonClicked(_arg0);
                    break;
                }
                case 15: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onAccessibilityButtonAvailabilityChanged(_arg0);
                    break;
                }
                case 16: {
                    this.onSystemActionsChanged();
                    break;
                }
                case 17: {
                    IAccessibilityInputMethodSessionCallback _arg0 = IAccessibilityInputMethodSessionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.createImeSession(_arg0);
                    break;
                }
                case 18: {
                    IAccessibilityInputMethodSession _arg0 = IAccessibilityInputMethodSession.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setImeSessionEnabled(_arg0, _arg1);
                    break;
                }
                case 19: {
                    this.bindInput();
                    break;
                }
                case 20: {
                    this.unbindInput();
                    break;
                }
                case 21: {
                    IRemoteAccessibilityInputConnection _arg0 = IRemoteAccessibilityInputConnection.Stub.asInterface(data.readStrongBinder());
                    EditorInfo _arg1 = data.readTypedObject(EditorInfo.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.startInput(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 20;
        }

        private static class Proxy
        implements IAccessibilityServiceClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void init(IAccessibilityServiceConnection connection, int connectionId, IBinder windowToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(connection);
                    _data.writeInt(connectionId);
                    _data.writeStrongBinder(windowToken);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAccessibilityEvent(AccessibilityEvent event, boolean serviceWantsEvent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    _data.writeBoolean(serviceWantsEvent);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onInterrupt() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGesture(AccessibilityGestureEvent gestureEvent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(gestureEvent, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void clearAccessibilityCache() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onKeyEvent(KeyEvent event, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    _data.writeInt(sequence);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMagnificationChanged(int displayId, Region region, MagnificationConfig config) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(region, 0);
                    _data.writeTypedObject(config, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMotionEvent(MotionEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTouchStateChanged(int displayId, int state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(state);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSoftKeyboardShowModeChanged(int showMode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(showMode);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPerformGestureResult(int sequence, boolean completedSuccessfully) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sequence);
                    _data.writeBoolean(completedSuccessfully);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFingerprintCapturingGesturesChanged(boolean capturing) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(capturing);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFingerprintGesture(int gesture) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(gesture);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAccessibilityButtonClicked(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAccessibilityButtonAvailabilityChanged(boolean available) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(available);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onSystemActionsChanged() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createImeSession(IAccessibilityInputMethodSessionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImeSessionEnabled(IAccessibilityInputMethodSession session, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(session);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void bindInput() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void unbindInput() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startInput(IRemoteAccessibilityInputConnection connection, EditorInfo editorInfo, boolean restarting) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(connection);
                    _data.writeTypedObject(editorInfo, 0);
                    _data.writeBoolean(restarting);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAccessibilityServiceClient {
        @Override
        public void init(IAccessibilityServiceConnection connection, int connectionId, IBinder windowToken) throws RemoteException {
        }

        @Override
        public void onAccessibilityEvent(AccessibilityEvent event, boolean serviceWantsEvent) throws RemoteException {
        }

        @Override
        public void onInterrupt() throws RemoteException {
        }

        @Override
        public void onGesture(AccessibilityGestureEvent gestureEvent) throws RemoteException {
        }

        @Override
        public void clearAccessibilityCache() throws RemoteException {
        }

        @Override
        public void onKeyEvent(KeyEvent event, int sequence) throws RemoteException {
        }

        @Override
        public void onMagnificationChanged(int displayId, Region region, MagnificationConfig config) throws RemoteException {
        }

        @Override
        public void onMotionEvent(MotionEvent event) throws RemoteException {
        }

        @Override
        public void onTouchStateChanged(int displayId, int state) throws RemoteException {
        }

        @Override
        public void onSoftKeyboardShowModeChanged(int showMode) throws RemoteException {
        }

        @Override
        public void onPerformGestureResult(int sequence, boolean completedSuccessfully) throws RemoteException {
        }

        @Override
        public void onFingerprintCapturingGesturesChanged(boolean capturing) throws RemoteException {
        }

        @Override
        public void onFingerprintGesture(int gesture) throws RemoteException {
        }

        @Override
        public void onAccessibilityButtonClicked(int displayId) throws RemoteException {
        }

        @Override
        public void onAccessibilityButtonAvailabilityChanged(boolean available) throws RemoteException {
        }

        @Override
        public void onSystemActionsChanged() throws RemoteException {
        }

        @Override
        public void createImeSession(IAccessibilityInputMethodSessionCallback callback) throws RemoteException {
        }

        @Override
        public void setImeSessionEnabled(IAccessibilityInputMethodSession session, boolean enabled) throws RemoteException {
        }

        @Override
        public void bindInput() throws RemoteException {
        }

        @Override
        public void unbindInput() throws RemoteException {
        }

        @Override
        public void startInput(IRemoteAccessibilityInputConnection connection, EditorInfo editorInfo, boolean restarting) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

