/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AuthenticatorDescription;
import android.accounts.IAccountManagerResponse;
import android.content.IntentSender;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import java.util.HashMap;
import java.util.Map;

public interface IAccountManager
extends IInterface {
    public String getPassword(Account var1) throws RemoteException;

    public String getUserData(Account var1, String var2) throws RemoteException;

    public AuthenticatorDescription[] getAuthenticatorTypes(int var1) throws RemoteException;

    public Account[] getAccountsForPackage(String var1, int var2, String var3) throws RemoteException;

    public Account[] getAccountsByTypeForPackage(String var1, String var2, String var3) throws RemoteException;

    public Account[] getAccountsAsUser(String var1, int var2, String var3) throws RemoteException;

    public void hasFeatures(IAccountManagerResponse var1, Account var2, String[] var3, int var4, String var5) throws RemoteException;

    public void getAccountByTypeAndFeatures(IAccountManagerResponse var1, String var2, String[] var3, String var4) throws RemoteException;

    public void getAccountsByFeatures(IAccountManagerResponse var1, String var2, String[] var3, String var4) throws RemoteException;

    public boolean addAccountExplicitly(Account var1, String var2, Bundle var3, String var4) throws RemoteException;

    public void removeAccountAsUser(IAccountManagerResponse var1, Account var2, boolean var3, int var4) throws RemoteException;

    public boolean removeAccountExplicitly(Account var1) throws RemoteException;

    public void copyAccountToUser(IAccountManagerResponse var1, Account var2, int var3, int var4) throws RemoteException;

    public void invalidateAuthToken(String var1, String var2) throws RemoteException;

    public String peekAuthToken(Account var1, String var2) throws RemoteException;

    public void setAuthToken(Account var1, String var2, String var3) throws RemoteException;

    public void setPassword(Account var1, String var2) throws RemoteException;

    public void clearPassword(Account var1) throws RemoteException;

    public void setUserData(Account var1, String var2, String var3) throws RemoteException;

    public void updateAppPermission(Account var1, String var2, int var3, boolean var4) throws RemoteException;

    public void getAuthToken(IAccountManagerResponse var1, Account var2, String var3, boolean var4, boolean var5, Bundle var6) throws RemoteException;

    public void addAccount(IAccountManagerResponse var1, String var2, String var3, String[] var4, boolean var5, Bundle var6) throws RemoteException;

    public void addAccountAsUser(IAccountManagerResponse var1, String var2, String var3, String[] var4, boolean var5, Bundle var6, int var7) throws RemoteException;

    public void updateCredentials(IAccountManagerResponse var1, Account var2, String var3, boolean var4, Bundle var5) throws RemoteException;

    public void editProperties(IAccountManagerResponse var1, String var2, boolean var3) throws RemoteException;

    public void confirmCredentialsAsUser(IAccountManagerResponse var1, Account var2, Bundle var3, boolean var4, int var5) throws RemoteException;

    public boolean accountAuthenticated(Account var1) throws RemoteException;

    public void getAuthTokenLabel(IAccountManagerResponse var1, String var2, String var3) throws RemoteException;

    public void addSharedAccountsFromParentUser(int var1, int var2, String var3) throws RemoteException;

    public void renameAccount(IAccountManagerResponse var1, Account var2, String var3) throws RemoteException;

    public String getPreviousName(Account var1) throws RemoteException;

    public void startAddAccountSession(IAccountManagerResponse var1, String var2, String var3, String[] var4, boolean var5, Bundle var6) throws RemoteException;

    public void startUpdateCredentialsSession(IAccountManagerResponse var1, Account var2, String var3, boolean var4, Bundle var5) throws RemoteException;

    public void finishSessionAsUser(IAccountManagerResponse var1, Bundle var2, boolean var3, Bundle var4, int var5) throws RemoteException;

    public boolean someUserHasAccount(Account var1) throws RemoteException;

    public void isCredentialsUpdateSuggested(IAccountManagerResponse var1, Account var2, String var3) throws RemoteException;

    public Map getPackagesAndVisibilityForAccount(Account var1) throws RemoteException;

    public boolean addAccountExplicitlyWithVisibility(Account var1, String var2, Bundle var3, Map var4, String var5) throws RemoteException;

    public boolean setAccountVisibility(Account var1, String var2, int var3) throws RemoteException;

    public int getAccountVisibility(Account var1, String var2) throws RemoteException;

    public Map getAccountsAndVisibilityForPackage(String var1, String var2) throws RemoteException;

    public void registerAccountListener(String[] var1, String var2) throws RemoteException;

    public void unregisterAccountListener(String[] var1, String var2) throws RemoteException;

    public boolean hasAccountAccess(Account var1, String var2, UserHandle var3) throws RemoteException;

    public IntentSender createRequestAccountAccessIntentSenderAsUser(Account var1, String var2, UserHandle var3) throws RemoteException;

    public void onAccountAccessed(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAccountManager {
        public static final String DESCRIPTOR = "android.accounts.IAccountManager";
        static final int TRANSACTION_getPassword = 1;
        static final int TRANSACTION_getUserData = 2;
        static final int TRANSACTION_getAuthenticatorTypes = 3;
        static final int TRANSACTION_getAccountsForPackage = 4;
        static final int TRANSACTION_getAccountsByTypeForPackage = 5;
        static final int TRANSACTION_getAccountsAsUser = 6;
        static final int TRANSACTION_hasFeatures = 7;
        static final int TRANSACTION_getAccountByTypeAndFeatures = 8;
        static final int TRANSACTION_getAccountsByFeatures = 9;
        static final int TRANSACTION_addAccountExplicitly = 10;
        static final int TRANSACTION_removeAccountAsUser = 11;
        static final int TRANSACTION_removeAccountExplicitly = 12;
        static final int TRANSACTION_copyAccountToUser = 13;
        static final int TRANSACTION_invalidateAuthToken = 14;
        static final int TRANSACTION_peekAuthToken = 15;
        static final int TRANSACTION_setAuthToken = 16;
        static final int TRANSACTION_setPassword = 17;
        static final int TRANSACTION_clearPassword = 18;
        static final int TRANSACTION_setUserData = 19;
        static final int TRANSACTION_updateAppPermission = 20;
        static final int TRANSACTION_getAuthToken = 21;
        static final int TRANSACTION_addAccount = 22;
        static final int TRANSACTION_addAccountAsUser = 23;
        static final int TRANSACTION_updateCredentials = 24;
        static final int TRANSACTION_editProperties = 25;
        static final int TRANSACTION_confirmCredentialsAsUser = 26;
        static final int TRANSACTION_accountAuthenticated = 27;
        static final int TRANSACTION_getAuthTokenLabel = 28;
        static final int TRANSACTION_addSharedAccountsFromParentUser = 29;
        static final int TRANSACTION_renameAccount = 30;
        static final int TRANSACTION_getPreviousName = 31;
        static final int TRANSACTION_startAddAccountSession = 32;
        static final int TRANSACTION_startUpdateCredentialsSession = 33;
        static final int TRANSACTION_finishSessionAsUser = 34;
        static final int TRANSACTION_someUserHasAccount = 35;
        static final int TRANSACTION_isCredentialsUpdateSuggested = 36;
        static final int TRANSACTION_getPackagesAndVisibilityForAccount = 37;
        static final int TRANSACTION_addAccountExplicitlyWithVisibility = 38;
        static final int TRANSACTION_setAccountVisibility = 39;
        static final int TRANSACTION_getAccountVisibility = 40;
        static final int TRANSACTION_getAccountsAndVisibilityForPackage = 41;
        static final int TRANSACTION_registerAccountListener = 42;
        static final int TRANSACTION_unregisterAccountListener = 43;
        static final int TRANSACTION_hasAccountAccess = 44;
        static final int TRANSACTION_createRequestAccountAccessIntentSenderAsUser = 45;
        static final int TRANSACTION_onAccountAccessed = 46;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAccountManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAccountManager) {
                return (IAccountManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getPassword";
                }
                case 2: {
                    return "getUserData";
                }
                case 3: {
                    return "getAuthenticatorTypes";
                }
                case 4: {
                    return "getAccountsForPackage";
                }
                case 5: {
                    return "getAccountsByTypeForPackage";
                }
                case 6: {
                    return "getAccountsAsUser";
                }
                case 7: {
                    return "hasFeatures";
                }
                case 8: {
                    return "getAccountByTypeAndFeatures";
                }
                case 9: {
                    return "getAccountsByFeatures";
                }
                case 10: {
                    return "addAccountExplicitly";
                }
                case 11: {
                    return "removeAccountAsUser";
                }
                case 12: {
                    return "removeAccountExplicitly";
                }
                case 13: {
                    return "copyAccountToUser";
                }
                case 14: {
                    return "invalidateAuthToken";
                }
                case 15: {
                    return "peekAuthToken";
                }
                case 16: {
                    return "setAuthToken";
                }
                case 17: {
                    return "setPassword";
                }
                case 18: {
                    return "clearPassword";
                }
                case 19: {
                    return "setUserData";
                }
                case 20: {
                    return "updateAppPermission";
                }
                case 21: {
                    return "getAuthToken";
                }
                case 22: {
                    return "addAccount";
                }
                case 23: {
                    return "addAccountAsUser";
                }
                case 24: {
                    return "updateCredentials";
                }
                case 25: {
                    return "editProperties";
                }
                case 26: {
                    return "confirmCredentialsAsUser";
                }
                case 27: {
                    return "accountAuthenticated";
                }
                case 28: {
                    return "getAuthTokenLabel";
                }
                case 29: {
                    return "addSharedAccountsFromParentUser";
                }
                case 30: {
                    return "renameAccount";
                }
                case 31: {
                    return "getPreviousName";
                }
                case 32: {
                    return "startAddAccountSession";
                }
                case 33: {
                    return "startUpdateCredentialsSession";
                }
                case 34: {
                    return "finishSessionAsUser";
                }
                case 35: {
                    return "someUserHasAccount";
                }
                case 36: {
                    return "isCredentialsUpdateSuggested";
                }
                case 37: {
                    return "getPackagesAndVisibilityForAccount";
                }
                case 38: {
                    return "addAccountExplicitlyWithVisibility";
                }
                case 39: {
                    return "setAccountVisibility";
                }
                case 40: {
                    return "getAccountVisibility";
                }
                case 41: {
                    return "getAccountsAndVisibilityForPackage";
                }
                case 42: {
                    return "registerAccountListener";
                }
                case 43: {
                    return "unregisterAccountListener";
                }
                case 44: {
                    return "hasAccountAccess";
                }
                case 45: {
                    return "createRequestAccountAccessIntentSenderAsUser";
                }
                case 46: {
                    return "onAccountAccessed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getPassword(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 2: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getUserData(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getAuthenticatorTypes(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getAccountsForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getAccountsByTypeForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getAccountsAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 7: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    Account _arg1 = data.readTypedObject(Account.CREATOR);
                    String[] _arg2 = data.createStringArray();
                    int _arg3 = data.readInt();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.hasFeatures(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String[] _arg2 = data.createStringArray();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.getAccountByTypeAndFeatures(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String[] _arg2 = data.createStringArray();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.getAccountsByFeatures(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.addAccountExplicitly(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    Account _arg1 = data.readTypedObject(Account.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeAccountAsUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.removeAccountExplicitly(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    Account _arg1 = data.readTypedObject(Account.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.copyAccountToUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.invalidateAuthToken(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.peekAuthToken(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 16: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setAuthToken(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setPassword(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    data.enforceNoDataAvail();
                    this.clearPassword(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setUserData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.updateAppPermission(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    Account _arg1 = data.readTypedObject(Account.CREATOR);
                    String _arg2 = data.readString();
                    boolean _arg3 = data.readBoolean();
                    boolean _arg4 = data.readBoolean();
                    Bundle _arg5 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.getAuthToken(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String[] _arg3 = data.createStringArray();
                    boolean _arg4 = data.readBoolean();
                    Bundle _arg5 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.addAccount(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String[] _arg3 = data.createStringArray();
                    boolean _arg4 = data.readBoolean();
                    Bundle _arg5 = data.readTypedObject(Bundle.CREATOR);
                    int _arg6 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addAccountAsUser(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    Account _arg1 = data.readTypedObject(Account.CREATOR);
                    String _arg2 = data.readString();
                    boolean _arg3 = data.readBoolean();
                    Bundle _arg4 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateCredentials(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.editProperties(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    Account _arg1 = data.readTypedObject(Account.CREATOR);
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    boolean _arg3 = data.readBoolean();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.confirmCredentialsAsUser(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.accountAuthenticated(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 28: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.getAuthTokenLabel(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.addSharedAccountsFromParentUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    Account _arg1 = data.readTypedObject(Account.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.renameAccount(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getPreviousName(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 32: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String[] _arg3 = data.createStringArray();
                    boolean _arg4 = data.readBoolean();
                    Bundle _arg5 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.startAddAccountSession(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    Account _arg1 = data.readTypedObject(Account.CREATOR);
                    String _arg2 = data.readString();
                    boolean _arg3 = data.readBoolean();
                    Bundle _arg4 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.startUpdateCredentialsSession(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.finishSessionAsUser(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.someUserHasAccount(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 36: {
                    IAccountManagerResponse _arg0 = IAccountManagerResponse.Stub.asInterface(data.readStrongBinder());
                    Account _arg1 = data.readTypedObject(Account.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.isCredentialsUpdateSuggested(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    data.enforceNoDataAvail();
                    Map _result = this.getPackagesAndVisibilityForAccount(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 38: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    ClassLoader cl = this.getClass().getClassLoader();
                    HashMap _arg3 = data.readHashMap(cl);
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.addAccountExplicitlyWithVisibility(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setAccountVisibility(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 40: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getAccountVisibility(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 41: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    Map _result = this.getAccountsAndVisibilityForPackage(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 42: {
                    String[] _arg0 = data.createStringArray();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.registerAccountListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    String[] _arg0 = data.createStringArray();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.unregisterAccountListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.hasAccountAccess(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 45: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    IntentSender _result = this.createRequestAccountAccessIntentSenderAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 46: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onAccountAccessed(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 45;
        }

        private static class Proxy
        implements IAccountManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPassword(Account account) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getUserData(Account account, String key) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(key);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AuthenticatorDescription[] getAuthenticatorTypes(int userId) throws RemoteException {
                AuthenticatorDescription[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(AuthenticatorDescription.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Account[] getAccountsForPackage(String packageName, int uid, String opPackageName) throws RemoteException {
                Account[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(uid);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(Account.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Account[] getAccountsByTypeForPackage(String type, String packageName, String opPackageName) throws RemoteException {
                Account[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(type);
                    _data.writeString(packageName);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(Account.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Account[] getAccountsAsUser(String accountType, int userId, String opPackageName) throws RemoteException {
                Account[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(accountType);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(Account.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hasFeatures(IAccountManagerResponse response, Account account, String[] features, int userId, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeTypedObject(account, 0);
                    _data.writeStringArray(features);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAccountByTypeAndFeatures(IAccountManagerResponse response, String accountType, String[] features, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeString(accountType);
                    _data.writeStringArray(features);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAccountsByFeatures(IAccountManagerResponse response, String accountType, String[] features, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeString(accountType);
                    _data.writeStringArray(features);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addAccountExplicitly(Account account, String password, Bundle extras, String opPackageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(password);
                    _data.writeTypedObject(extras, 0);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAccountAsUser(IAccountManagerResponse response, Account account, boolean expectActivityLaunch, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeTypedObject(account, 0);
                    _data.writeBoolean(expectActivityLaunch);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeAccountExplicitly(Account account) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void copyAccountToUser(IAccountManagerResponse response, Account account, int userFrom, int userTo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeTypedObject(account, 0);
                    _data.writeInt(userFrom);
                    _data.writeInt(userTo);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invalidateAuthToken(String accountType, String authToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(accountType);
                    _data.writeString(authToken);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String peekAuthToken(Account account, String authTokenType) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authTokenType);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAuthToken(Account account, String authTokenType, String authToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authTokenType);
                    _data.writeString(authToken);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPassword(Account account, String password) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(password);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearPassword(Account account) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUserData(Account account, String key, String value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(key);
                    _data.writeString(value);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateAppPermission(Account account, String authTokenType, int uid, boolean value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authTokenType);
                    _data.writeInt(uid);
                    _data.writeBoolean(value);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAuthToken(IAccountManagerResponse response, Account account, String authTokenType, boolean notifyOnAuthFailure, boolean expectActivityLaunch, Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authTokenType);
                    _data.writeBoolean(notifyOnAuthFailure);
                    _data.writeBoolean(expectActivityLaunch);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addAccount(IAccountManagerResponse response, String accountType, String authTokenType, String[] requiredFeatures, boolean expectActivityLaunch, Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeString(accountType);
                    _data.writeString(authTokenType);
                    _data.writeStringArray(requiredFeatures);
                    _data.writeBoolean(expectActivityLaunch);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addAccountAsUser(IAccountManagerResponse response, String accountType, String authTokenType, String[] requiredFeatures, boolean expectActivityLaunch, Bundle options, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeString(accountType);
                    _data.writeString(authTokenType);
                    _data.writeStringArray(requiredFeatures);
                    _data.writeBoolean(expectActivityLaunch);
                    _data.writeTypedObject(options, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateCredentials(IAccountManagerResponse response, Account account, String authTokenType, boolean expectActivityLaunch, Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authTokenType);
                    _data.writeBoolean(expectActivityLaunch);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void editProperties(IAccountManagerResponse response, String accountType, boolean expectActivityLaunch) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeString(accountType);
                    _data.writeBoolean(expectActivityLaunch);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void confirmCredentialsAsUser(IAccountManagerResponse response, Account account, Bundle options, boolean expectActivityLaunch, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeTypedObject(account, 0);
                    _data.writeTypedObject(options, 0);
                    _data.writeBoolean(expectActivityLaunch);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean accountAuthenticated(Account account) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAuthTokenLabel(IAccountManagerResponse response, String accountType, String authTokenType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeString(accountType);
                    _data.writeString(authTokenType);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSharedAccountsFromParentUser(int parentUserId, int userId, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(parentUserId);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void renameAccount(IAccountManagerResponse response, Account accountToRename, String newName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeTypedObject(accountToRename, 0);
                    _data.writeString(newName);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPreviousName(Account account) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startAddAccountSession(IAccountManagerResponse response, String accountType, String authTokenType, String[] requiredFeatures, boolean expectActivityLaunch, Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeString(accountType);
                    _data.writeString(authTokenType);
                    _data.writeStringArray(requiredFeatures);
                    _data.writeBoolean(expectActivityLaunch);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startUpdateCredentialsSession(IAccountManagerResponse response, Account account, String authTokenType, boolean expectActivityLaunch, Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authTokenType);
                    _data.writeBoolean(expectActivityLaunch);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishSessionAsUser(IAccountManagerResponse response, Bundle sessionBundle, boolean expectActivityLaunch, Bundle appInfo, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeTypedObject(sessionBundle, 0);
                    _data.writeBoolean(expectActivityLaunch);
                    _data.writeTypedObject(appInfo, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean someUserHasAccount(Account account) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isCredentialsUpdateSuggested(IAccountManagerResponse response, Account account, String statusToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(response);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(statusToken);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getPackagesAndVisibilityForAccount(Account account) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addAccountExplicitlyWithVisibility(Account account, String password, Bundle extras, Map visibility, String opPackageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(password);
                    _data.writeTypedObject(extras, 0);
                    _data.writeMap(visibility);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAccountVisibility(Account a, String packageName, int newVisibility) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(a, 0);
                    _data.writeString(packageName);
                    _data.writeInt(newVisibility);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAccountVisibility(Account a, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(a, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getAccountsAndVisibilityForPackage(String packageName, String accountType) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(accountType);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAccountListener(String[] accountTypes, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(accountTypes);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAccountListener(String[] accountTypes, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(accountTypes);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasAccountAccess(Account account, String packageName, UserHandle userHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(packageName);
                    _data.writeTypedObject(userHandle, 0);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IntentSender createRequestAccountAccessIntentSenderAsUser(Account account, String packageName, UserHandle userHandle) throws RemoteException {
                IntentSender _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(packageName);
                    _data.writeTypedObject(userHandle, 0);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(IntentSender.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAccountAccessed(String token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(token);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAccountManager {
        @Override
        public String getPassword(Account account) throws RemoteException {
            return null;
        }

        @Override
        public String getUserData(Account account, String key) throws RemoteException {
            return null;
        }

        @Override
        public AuthenticatorDescription[] getAuthenticatorTypes(int userId) throws RemoteException {
            return null;
        }

        @Override
        public Account[] getAccountsForPackage(String packageName, int uid, String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public Account[] getAccountsByTypeForPackage(String type, String packageName, String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public Account[] getAccountsAsUser(String accountType, int userId, String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public void hasFeatures(IAccountManagerResponse response, Account account, String[] features, int userId, String opPackageName) throws RemoteException {
        }

        @Override
        public void getAccountByTypeAndFeatures(IAccountManagerResponse response, String accountType, String[] features, String opPackageName) throws RemoteException {
        }

        @Override
        public void getAccountsByFeatures(IAccountManagerResponse response, String accountType, String[] features, String opPackageName) throws RemoteException {
        }

        @Override
        public boolean addAccountExplicitly(Account account, String password, Bundle extras, String opPackageName) throws RemoteException {
            return false;
        }

        @Override
        public void removeAccountAsUser(IAccountManagerResponse response, Account account, boolean expectActivityLaunch, int userId) throws RemoteException {
        }

        @Override
        public boolean removeAccountExplicitly(Account account) throws RemoteException {
            return false;
        }

        @Override
        public void copyAccountToUser(IAccountManagerResponse response, Account account, int userFrom, int userTo) throws RemoteException {
        }

        @Override
        public void invalidateAuthToken(String accountType, String authToken) throws RemoteException {
        }

        @Override
        public String peekAuthToken(Account account, String authTokenType) throws RemoteException {
            return null;
        }

        @Override
        public void setAuthToken(Account account, String authTokenType, String authToken) throws RemoteException {
        }

        @Override
        public void setPassword(Account account, String password) throws RemoteException {
        }

        @Override
        public void clearPassword(Account account) throws RemoteException {
        }

        @Override
        public void setUserData(Account account, String key, String value) throws RemoteException {
        }

        @Override
        public void updateAppPermission(Account account, String authTokenType, int uid, boolean value) throws RemoteException {
        }

        @Override
        public void getAuthToken(IAccountManagerResponse response, Account account, String authTokenType, boolean notifyOnAuthFailure, boolean expectActivityLaunch, Bundle options) throws RemoteException {
        }

        @Override
        public void addAccount(IAccountManagerResponse response, String accountType, String authTokenType, String[] requiredFeatures, boolean expectActivityLaunch, Bundle options) throws RemoteException {
        }

        @Override
        public void addAccountAsUser(IAccountManagerResponse response, String accountType, String authTokenType, String[] requiredFeatures, boolean expectActivityLaunch, Bundle options, int userId) throws RemoteException {
        }

        @Override
        public void updateCredentials(IAccountManagerResponse response, Account account, String authTokenType, boolean expectActivityLaunch, Bundle options) throws RemoteException {
        }

        @Override
        public void editProperties(IAccountManagerResponse response, String accountType, boolean expectActivityLaunch) throws RemoteException {
        }

        @Override
        public void confirmCredentialsAsUser(IAccountManagerResponse response, Account account, Bundle options, boolean expectActivityLaunch, int userId) throws RemoteException {
        }

        @Override
        public boolean accountAuthenticated(Account account) throws RemoteException {
            return false;
        }

        @Override
        public void getAuthTokenLabel(IAccountManagerResponse response, String accountType, String authTokenType) throws RemoteException {
        }

        @Override
        public void addSharedAccountsFromParentUser(int parentUserId, int userId, String opPackageName) throws RemoteException {
        }

        @Override
        public void renameAccount(IAccountManagerResponse response, Account accountToRename, String newName) throws RemoteException {
        }

        @Override
        public String getPreviousName(Account account) throws RemoteException {
            return null;
        }

        @Override
        public void startAddAccountSession(IAccountManagerResponse response, String accountType, String authTokenType, String[] requiredFeatures, boolean expectActivityLaunch, Bundle options) throws RemoteException {
        }

        @Override
        public void startUpdateCredentialsSession(IAccountManagerResponse response, Account account, String authTokenType, boolean expectActivityLaunch, Bundle options) throws RemoteException {
        }

        @Override
        public void finishSessionAsUser(IAccountManagerResponse response, Bundle sessionBundle, boolean expectActivityLaunch, Bundle appInfo, int userId) throws RemoteException {
        }

        @Override
        public boolean someUserHasAccount(Account account) throws RemoteException {
            return false;
        }

        @Override
        public void isCredentialsUpdateSuggested(IAccountManagerResponse response, Account account, String statusToken) throws RemoteException {
        }

        @Override
        public Map getPackagesAndVisibilityForAccount(Account account) throws RemoteException {
            return null;
        }

        @Override
        public boolean addAccountExplicitlyWithVisibility(Account account, String password, Bundle extras, Map visibility, String opPackageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean setAccountVisibility(Account a, String packageName, int newVisibility) throws RemoteException {
            return false;
        }

        @Override
        public int getAccountVisibility(Account a, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public Map getAccountsAndVisibilityForPackage(String packageName, String accountType) throws RemoteException {
            return null;
        }

        @Override
        public void registerAccountListener(String[] accountTypes, String opPackageName) throws RemoteException {
        }

        @Override
        public void unregisterAccountListener(String[] accountTypes, String opPackageName) throws RemoteException {
        }

        @Override
        public boolean hasAccountAccess(Account account, String packageName, UserHandle userHandle) throws RemoteException {
            return false;
        }

        @Override
        public IntentSender createRequestAccountAccessIntentSenderAsUser(Account account, String packageName, UserHandle userHandle) throws RemoteException {
            return null;
        }

        @Override
        public void onAccountAccessed(String token) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

