/*
 * Decompiled with CFR 0.152.
 */
package android.adservices;

import android.adservices.adid.AdIdManager;
import android.adservices.adselection.AdSelectionManager;
import android.adservices.appsetid.AppSetIdManager;
import android.adservices.common.AdServicesCommonManager;
import android.adservices.customaudience.CustomAudienceManager;
import android.adservices.measurement.MeasurementManager;
import android.adservices.topics.TopicsManager;
import android.annotation.SystemApi;
import android.app.SystemServiceRegistry;
import android.app.sdksandbox.SdkSandboxSystemServiceRegistry;
import androidx.annotation.RequiresApi;
import com.android.adservices.LogUtil;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
@RequiresApi(value=31)
public class AdServicesFrameworkInitializer {
    private AdServicesFrameworkInitializer() {
    }

    public static void registerServiceWrappers() {
        LogUtil.d("Registering AdServices's TopicsManager.");
        SystemServiceRegistry.registerContextAwareService("topics_service", TopicsManager.class, c -> new TopicsManager(c));
        SdkSandboxSystemServiceRegistry.getInstance().registerServiceMutator("topics_service", (service, ctx) -> ((TopicsManager)service).initialize(ctx));
        LogUtil.d("Registering AdServices's CustomAudienceManager.");
        SystemServiceRegistry.registerContextAwareService("custom_audience_service", CustomAudienceManager.class, CustomAudienceManager::new);
        SdkSandboxSystemServiceRegistry.getInstance().registerServiceMutator("custom_audience_service", (service, ctx) -> ((CustomAudienceManager)service).initialize(ctx));
        LogUtil.d("Registering AdServices's AdSelectionManager.");
        SystemServiceRegistry.registerContextAwareService("ad_selection_service", AdSelectionManager.class, AdSelectionManager::new);
        SdkSandboxSystemServiceRegistry.getInstance().registerServiceMutator("ad_selection_service", (service, ctx) -> ((AdSelectionManager)service).initialize(ctx));
        LogUtil.d("Registering AdServices's MeasurementManager.");
        SystemServiceRegistry.registerContextAwareService("measurement_service", MeasurementManager.class, MeasurementManager::new);
        SdkSandboxSystemServiceRegistry.getInstance().registerServiceMutator("measurement_service", (service, ctx) -> ((MeasurementManager)service).initialize(ctx));
        LogUtil.d("Registering AdServices's AdIdManager.");
        SystemServiceRegistry.registerContextAwareService("adid_service", AdIdManager.class, c -> new AdIdManager(c));
        SdkSandboxSystemServiceRegistry.getInstance().registerServiceMutator("adid_service", (service, ctx) -> ((AdIdManager)service).initialize(ctx));
        LogUtil.d("Registering AdServices's AppSetIdManager.");
        SystemServiceRegistry.registerContextAwareService("appsetid_service", AppSetIdManager.class, c -> new AppSetIdManager(c));
        SdkSandboxSystemServiceRegistry.getInstance().registerServiceMutator("appsetid_service", (service, ctx) -> ((AppSetIdManager)service).initialize(ctx));
        LogUtil.d("Registering AdServices's AdServicesCommonManager.");
        SystemServiceRegistry.registerContextAwareService("ad_services_common_service", AdServicesCommonManager.class, c -> new AdServicesCommonManager(c));
    }
}

