/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adid;

import android.adservices.adid.AdId;
import android.adservices.adid.GetAdIdParam;
import android.adservices.adid.GetAdIdResult;
import android.adservices.adid.IAdIdService;
import android.adservices.adid.IGetAdIdCallback;
import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.CallerMetadata;
import android.adservices.common.SandboxedSdkContextUtils;
import android.annotation.RequiresPermission;
import android.app.sdksandbox.SandboxedSdkContext;
import android.content.Context;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os._Original_Build;
import androidx.annotation.RequiresApi;
import com.android.adservices.LogUtil;
import com.android.adservices.ServiceBinder;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(value=31)
public class AdIdManager {
    public static final String ADID_SERVICE = "adid_service";
    static final String EMPTY_SDK = "";
    private Context mContext;
    private ServiceBinder<IAdIdService> mServiceBinder;

    public static AdIdManager get(Context context) {
        return _Original_Build.VERSION.SDK_INT >= 33 ? context.getSystemService(AdIdManager.class) : new AdIdManager(context);
    }

    public AdIdManager(Context context) {
        this.initialize(context);
    }

    public AdIdManager initialize(Context context) {
        this.mContext = context;
        this.mServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.ADID_SERVICE", IAdIdService.Stub::asInterface);
        return this;
    }

    private IAdIdService getService() {
        IAdIdService service = this.mServiceBinder.getService();
        if (service == null) {
            throw new IllegalStateException("Unable to find the service");
        }
        return service;
    }

    private Context getContext() {
        return this.mContext;
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_AD_ID")
    public void getAdId(final Executor executor, final OutcomeReceiver<AdId, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        CallerMetadata callerMetadata = new CallerMetadata.Builder().setBinderElapsedTimestamp(SystemClock.elapsedRealtime()).build();
        IAdIdService service = this.getService();
        String appPackageName = EMPTY_SDK;
        String sdkPackageName = EMPTY_SDK;
        Context getAdIdRequestContext = this.getContext();
        SandboxedSdkContext requestContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(getAdIdRequestContext);
        if (requestContext != null) {
            sdkPackageName = requestContext.getSdkPackageName();
            appPackageName = requestContext.getClientPackageName();
        } else {
            appPackageName = getAdIdRequestContext.getPackageName();
        }
        try {
            service.getAdId(new GetAdIdParam.Builder().setAppPackageName(appPackageName).setSdkPackageName(sdkPackageName).build(), callerMetadata, new IGetAdIdCallback.Stub(){

                @Override
                public void onResult(GetAdIdResult resultParcel) {
                    executor.execute(() -> {
                        if (resultParcel.isSuccess()) {
                            callback.onResult(new AdId(resultParcel.getAdId(), resultParcel.isLatEnabled()));
                        } else {
                            callback.onError(AdServicesStatusUtils.asException(resultParcel));
                        }
                    });
                }

                @Override
                public void onError(int resultCode) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(resultCode)));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
            callback.onError(e);
        }
    }

    public void unbindFromService() {
        this.mServiceBinder.unbindFromService();
    }
}

