/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adid;

import android.adservices.common.AdServicesResponse;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class GetAdIdResult
extends AdServicesResponse {
    private final String mAdId;
    private final boolean mLimitAdTrackingEnabled;
    public static final Parcelable.Creator<GetAdIdResult> CREATOR = new Parcelable.Creator<GetAdIdResult>(){

        @Override
        public GetAdIdResult createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new GetAdIdResult(in);
        }

        public GetAdIdResult[] newArray(int size) {
            return new GetAdIdResult[size];
        }
    };

    private GetAdIdResult(int resultCode, String errorMessage, String adId, boolean isLimitAdTrackingEnabled) {
        super(resultCode, errorMessage);
        this.mAdId = adId;
        this.mLimitAdTrackingEnabled = isLimitAdTrackingEnabled;
    }

    private GetAdIdResult(Parcel in) {
        super(in);
        Objects.requireNonNull(in);
        this.mAdId = in.readString();
        this.mLimitAdTrackingEnabled = in.readBoolean();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mStatusCode);
        out.writeString(this.mErrorMessage);
        out.writeString(this.mAdId);
        out.writeBoolean(this.mLimitAdTrackingEnabled);
    }

    @Override
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public String getAdId() {
        return this.mAdId;
    }

    public boolean isLatEnabled() {
        return this.mLimitAdTrackingEnabled;
    }

    public String toString() {
        return "GetAdIdResult{mResultCode=" + this.mStatusCode + ", mErrorMessage='" + this.mErrorMessage + '\'' + ", mAdId=" + this.mAdId + ", mLimitAdTrackingEnabled=" + this.mLimitAdTrackingEnabled + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAdIdResult)) {
            return false;
        }
        GetAdIdResult that = (GetAdIdResult)o;
        return this.mStatusCode == that.mStatusCode && Objects.equals(this.mErrorMessage, that.mErrorMessage) && Objects.equals(this.mAdId, that.mAdId) && this.mLimitAdTrackingEnabled == that.mLimitAdTrackingEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.mStatusCode, this.mErrorMessage, this.mAdId, this.mLimitAdTrackingEnabled);
    }

    public static class Builder {
        private int mStatusCode;
        private String mErrorMessage;
        private String mAdId;
        private boolean mLimitAdTrackingEnabled;

        public Builder setStatusCode(int statusCode) {
            this.mStatusCode = statusCode;
            return this;
        }

        public Builder setErrorMessage(String errorMessage) {
            this.mErrorMessage = errorMessage;
            return this;
        }

        public Builder setAdId(String adId) {
            this.mAdId = adId;
            return this;
        }

        public Builder setLatEnabled(boolean isLimitAdTrackingEnabled) {
            this.mLimitAdTrackingEnabled = isLimitAdTrackingEnabled;
            return this;
        }

        public GetAdIdResult build() {
            if (this.mAdId == null) {
                throw new IllegalArgumentException("adId is null");
            }
            return new GetAdIdResult(this.mStatusCode, this.mErrorMessage, this.mAdId, this.mLimitAdTrackingEnabled);
        }
    }
}

