/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.adselection.ContextualAds;
import android.adservices.common.AdSelectionSignals;
import android.adservices.common.AdTechIdentifier;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdSelectionConfig
implements Parcelable {
    private final AdTechIdentifier mSeller;
    private final Uri mDecisionLogicUri;
    private final List<AdTechIdentifier> mCustomAudienceBuyers;
    private final AdSelectionSignals mAdSelectionSignals;
    private final AdSelectionSignals mSellerSignals;
    private final Map<AdTechIdentifier, AdSelectionSignals> mPerBuyerSignals;
    private final Map<AdTechIdentifier, ContextualAds> mBuyerContextualAds;
    private final Uri mTrustedScoringSignalsUri;
    public static final Parcelable.Creator<AdSelectionConfig> CREATOR = new Parcelable.Creator<AdSelectionConfig>(){

        @Override
        public AdSelectionConfig createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new AdSelectionConfig(in);
        }

        public AdSelectionConfig[] newArray(int size) {
            return new AdSelectionConfig[size];
        }
    };

    private AdSelectionConfig(AdTechIdentifier seller, Uri decisionLogicUri, List<AdTechIdentifier> customAudienceBuyers, AdSelectionSignals adSelectionSignals, AdSelectionSignals sellerSignals, Map<AdTechIdentifier, AdSelectionSignals> perBuyerSignals, Map<AdTechIdentifier, ContextualAds> perBuyerContextualAds, Uri trustedScoringSignalsUri) {
        this.mSeller = seller;
        this.mDecisionLogicUri = decisionLogicUri;
        this.mCustomAudienceBuyers = customAudienceBuyers;
        this.mAdSelectionSignals = adSelectionSignals;
        this.mSellerSignals = sellerSignals;
        this.mPerBuyerSignals = perBuyerSignals;
        this.mBuyerContextualAds = perBuyerContextualAds;
        this.mTrustedScoringSignalsUri = trustedScoringSignalsUri;
    }

    private AdSelectionConfig(Parcel in) {
        Objects.requireNonNull(in);
        this.mSeller = AdTechIdentifier.CREATOR.createFromParcel(in);
        this.mDecisionLogicUri = Uri.CREATOR.createFromParcel(in);
        this.mCustomAudienceBuyers = in.createTypedArrayList(AdTechIdentifier.CREATOR);
        this.mAdSelectionSignals = AdSelectionSignals.CREATOR.createFromParcel(in);
        this.mSellerSignals = AdSelectionSignals.CREATOR.createFromParcel(in);
        this.mPerBuyerSignals = AdServicesParcelableUtil.readMapFromParcel(in, AdTechIdentifier::fromString, AdSelectionSignals.class);
        this.mBuyerContextualAds = AdServicesParcelableUtil.readMapFromParcel(in, AdTechIdentifier::fromString, ContextualAds.class);
        this.mTrustedScoringSignalsUri = Uri.CREATOR.createFromParcel(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        this.mSeller.writeToParcel(dest, flags);
        this.mDecisionLogicUri.writeToParcel(dest, flags);
        dest.writeTypedList(this.mCustomAudienceBuyers);
        this.mAdSelectionSignals.writeToParcel(dest, flags);
        this.mSellerSignals.writeToParcel(dest, flags);
        AdServicesParcelableUtil.writeMapToParcel(dest, this.mPerBuyerSignals);
        AdServicesParcelableUtil.writeMapToParcel(dest, this.mBuyerContextualAds);
        this.mTrustedScoringSignalsUri.writeToParcel(dest, flags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdSelectionConfig)) {
            return false;
        }
        AdSelectionConfig that = (AdSelectionConfig)o;
        return Objects.equals(this.mSeller, that.mSeller) && Objects.equals(this.mDecisionLogicUri, that.mDecisionLogicUri) && Objects.equals(this.mCustomAudienceBuyers, that.mCustomAudienceBuyers) && Objects.equals(this.mAdSelectionSignals, that.mAdSelectionSignals) && Objects.equals(this.mSellerSignals, that.mSellerSignals) && Objects.equals(this.mPerBuyerSignals, that.mPerBuyerSignals) && Objects.equals(this.mBuyerContextualAds, that.mBuyerContextualAds) && Objects.equals(this.mTrustedScoringSignalsUri, that.mTrustedScoringSignalsUri);
    }

    public int hashCode() {
        return Objects.hash(this.mSeller, this.mDecisionLogicUri, this.mCustomAudienceBuyers, this.mAdSelectionSignals, this.mSellerSignals, this.mPerBuyerSignals, this.mBuyerContextualAds, this.mTrustedScoringSignalsUri);
    }

    public Builder cloneToBuilder() {
        return new Builder().setSeller(this.getSeller()).setBuyerContextualAds(this.getBuyerContextualAds()).setAdSelectionSignals(this.getAdSelectionSignals()).setCustomAudienceBuyers(this.getCustomAudienceBuyers()).setDecisionLogicUri(this.getDecisionLogicUri()).setPerBuyerSignals(this.getPerBuyerSignals()).setSellerSignals(this.getSellerSignals()).setTrustedScoringSignalsUri(this.getTrustedScoringSignalsUri());
    }

    public AdTechIdentifier getSeller() {
        return this.mSeller;
    }

    public Uri getDecisionLogicUri() {
        return this.mDecisionLogicUri;
    }

    public List<AdTechIdentifier> getCustomAudienceBuyers() {
        return this.mCustomAudienceBuyers;
    }

    public AdSelectionSignals getAdSelectionSignals() {
        return this.mAdSelectionSignals;
    }

    public AdSelectionSignals getSellerSignals() {
        return this.mSellerSignals;
    }

    public Map<AdTechIdentifier, AdSelectionSignals> getPerBuyerSignals() {
        return this.mPerBuyerSignals;
    }

    public Map<AdTechIdentifier, ContextualAds> getBuyerContextualAds() {
        return this.mBuyerContextualAds;
    }

    public Uri getTrustedScoringSignalsUri() {
        return this.mTrustedScoringSignalsUri;
    }

    public static class Builder {
        private AdTechIdentifier mSeller;
        private Uri mDecisionLogicUri;
        private List<AdTechIdentifier> mCustomAudienceBuyers;
        private AdSelectionSignals mAdSelectionSignals = AdSelectionSignals.EMPTY;
        private AdSelectionSignals mSellerSignals = AdSelectionSignals.EMPTY;
        private Map<AdTechIdentifier, AdSelectionSignals> mPerBuyerSignals = Collections.emptyMap();
        private Map<AdTechIdentifier, ContextualAds> mBuyerContextualAds = Collections.emptyMap();
        private Uri mTrustedScoringSignalsUri;

        public Builder setSeller(AdTechIdentifier seller) {
            Objects.requireNonNull(seller);
            this.mSeller = seller;
            return this;
        }

        public Builder setDecisionLogicUri(Uri decisionLogicUri) {
            Objects.requireNonNull(decisionLogicUri);
            this.mDecisionLogicUri = decisionLogicUri;
            return this;
        }

        public Builder setCustomAudienceBuyers(List<AdTechIdentifier> customAudienceBuyers) {
            Objects.requireNonNull(customAudienceBuyers);
            this.mCustomAudienceBuyers = customAudienceBuyers;
            return this;
        }

        public Builder setAdSelectionSignals(AdSelectionSignals adSelectionSignals) {
            Objects.requireNonNull(adSelectionSignals);
            this.mAdSelectionSignals = adSelectionSignals;
            return this;
        }

        public Builder setSellerSignals(AdSelectionSignals sellerSignals) {
            Objects.requireNonNull(sellerSignals);
            this.mSellerSignals = sellerSignals;
            return this;
        }

        public Builder setPerBuyerSignals(Map<AdTechIdentifier, AdSelectionSignals> perBuyerSignals) {
            Objects.requireNonNull(perBuyerSignals);
            this.mPerBuyerSignals = perBuyerSignals;
            return this;
        }

        public Builder setBuyerContextualAds(Map<AdTechIdentifier, ContextualAds> buyerContextualAds) {
            Objects.requireNonNull(buyerContextualAds);
            this.mBuyerContextualAds = buyerContextualAds;
            return this;
        }

        public Builder setTrustedScoringSignalsUri(Uri trustedScoringSignalsUri) {
            Objects.requireNonNull(trustedScoringSignalsUri);
            this.mTrustedScoringSignalsUri = trustedScoringSignalsUri;
            return this;
        }

        public AdSelectionConfig build() {
            Objects.requireNonNull(this.mSeller);
            Objects.requireNonNull(this.mDecisionLogicUri);
            Objects.requireNonNull(this.mCustomAudienceBuyers);
            Objects.requireNonNull(this.mAdSelectionSignals);
            Objects.requireNonNull(this.mSellerSignals);
            Objects.requireNonNull(this.mPerBuyerSignals);
            Objects.requireNonNull(this.mBuyerContextualAds);
            Objects.requireNonNull(this.mTrustedScoringSignalsUri);
            return new AdSelectionConfig(this.mSeller, this.mDecisionLogicUri, this.mCustomAudienceBuyers, this.mAdSelectionSignals, this.mSellerSignals, this.mPerBuyerSignals, this.mBuyerContextualAds, this.mTrustedScoringSignalsUri);
        }
    }
}

