/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdSelectionSignals;
import android.adservices.common.AdTechIdentifier;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import java.util.List;
import java.util.Objects;

public class AdSelectionFromOutcomesConfig
implements Parcelable {
    private final AdTechIdentifier mSeller;
    private final List<Long> mAdSelectionIds;
    private final AdSelectionSignals mSelectionSignals;
    private final Uri mSelectionLogicUri;
    public static final Parcelable.Creator<AdSelectionFromOutcomesConfig> CREATOR = new Parcelable.Creator<AdSelectionFromOutcomesConfig>(){

        @Override
        public AdSelectionFromOutcomesConfig createFromParcel(Parcel in) {
            return new AdSelectionFromOutcomesConfig(in);
        }

        public AdSelectionFromOutcomesConfig[] newArray(int size) {
            return new AdSelectionFromOutcomesConfig[size];
        }
    };

    private AdSelectionFromOutcomesConfig(AdTechIdentifier seller, List<Long> adSelectionIds, AdSelectionSignals selectionSignals, Uri selectionLogicUri) {
        Objects.requireNonNull(seller);
        Objects.requireNonNull(adSelectionIds);
        Objects.requireNonNull(selectionSignals);
        Objects.requireNonNull(selectionLogicUri);
        this.mSeller = seller;
        this.mAdSelectionIds = adSelectionIds;
        this.mSelectionSignals = selectionSignals;
        this.mSelectionLogicUri = selectionLogicUri;
    }

    private AdSelectionFromOutcomesConfig(Parcel in) {
        Objects.requireNonNull(in);
        this.mSeller = AdTechIdentifier.CREATOR.createFromParcel(in);
        this.mAdSelectionIds = _Original_Build.VERSION.SDK_INT < 33 ? in.readArrayList(Long.class.getClassLoader()) : in.readArrayList(Long.class.getClassLoader(), Long.class);
        this.mSelectionSignals = AdSelectionSignals.CREATOR.createFromParcel(in);
        this.mSelectionLogicUri = Uri.CREATOR.createFromParcel(in);
    }

    public AdTechIdentifier getSeller() {
        return this.mSeller;
    }

    public List<Long> getAdSelectionIds() {
        return this.mAdSelectionIds;
    }

    public AdSelectionSignals getSelectionSignals() {
        return this.mSelectionSignals;
    }

    public Uri getSelectionLogicUri() {
        return this.mSelectionLogicUri;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        this.mSeller.writeToParcel(dest, flags);
        dest.writeList(this.mAdSelectionIds);
        this.mSelectionSignals.writeToParcel(dest, flags);
        this.mSelectionLogicUri.writeToParcel(dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdSelectionFromOutcomesConfig)) {
            return false;
        }
        AdSelectionFromOutcomesConfig that = (AdSelectionFromOutcomesConfig)o;
        return Objects.equals(this.mSeller, that.mSeller) && Objects.equals(this.mAdSelectionIds, that.mAdSelectionIds) && Objects.equals(this.mSelectionSignals, that.mSelectionSignals) && Objects.equals(this.mSelectionLogicUri, that.mSelectionLogicUri);
    }

    public int hashCode() {
        return Objects.hash(this.mSeller, this.mAdSelectionIds, this.mSelectionSignals, this.mSelectionLogicUri);
    }

    public static class Builder {
        private AdTechIdentifier mSeller;
        private List<Long> mAdSelectionIds;
        private AdSelectionSignals mSelectionSignals;
        private Uri mSelectionLogicUri;

        public Builder setSeller(AdTechIdentifier seller) {
            Objects.requireNonNull(seller);
            this.mSeller = seller;
            return this;
        }

        public Builder setAdSelectionIds(List<Long> adSelectionIds) {
            Objects.requireNonNull(adSelectionIds);
            this.mAdSelectionIds = adSelectionIds;
            return this;
        }

        public Builder setSelectionSignals(AdSelectionSignals selectionSignals) {
            Objects.requireNonNull(selectionSignals);
            this.mSelectionSignals = selectionSignals;
            return this;
        }

        public Builder setSelectionLogicUri(Uri selectionLogicUri) {
            Objects.requireNonNull(selectionLogicUri);
            this.mSelectionLogicUri = selectionLogicUri;
            return this;
        }

        public AdSelectionFromOutcomesConfig build() {
            Objects.requireNonNull(this.mSeller);
            Objects.requireNonNull(this.mAdSelectionIds);
            Objects.requireNonNull(this.mSelectionSignals);
            Objects.requireNonNull(this.mSelectionLogicUri);
            return new AdSelectionFromOutcomesConfig(this.mSeller, this.mAdSelectionIds, this.mSelectionSignals, this.mSelectionLogicUri);
        }
    }
}

