/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.adselection.AdSelectionCallback;
import android.adservices.adselection.AdSelectionConfig;
import android.adservices.adselection.AdSelectionFromOutcomesConfig;
import android.adservices.adselection.AdSelectionFromOutcomesInput;
import android.adservices.adselection.AdSelectionInput;
import android.adservices.adselection.AdSelectionOutcome;
import android.adservices.adselection.AdSelectionResponse;
import android.adservices.adselection.AdSelectionService;
import android.adservices.adselection.ReportImpressionCallback;
import android.adservices.adselection.ReportImpressionInput;
import android.adservices.adselection.ReportImpressionRequest;
import android.adservices.adselection.ReportInteractionCallback;
import android.adservices.adselection.ReportInteractionInput;
import android.adservices.adselection.ReportInteractionRequest;
import android.adservices.adselection.SetAppInstallAdvertisersCallback;
import android.adservices.adselection.SetAppInstallAdvertisersInput;
import android.adservices.adselection.SetAppInstallAdvertisersRequest;
import android.adservices.adselection.TestAdSelectionManager;
import android.adservices.adselection.UpdateAdCounterHistogramCallback;
import android.adservices.adselection.UpdateAdCounterHistogramInput;
import android.adservices.adselection.UpdateAdCounterHistogramRequest;
import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.CallerMetadata;
import android.adservices.common.FledgeErrorResponse;
import android.adservices.common.SandboxedSdkContextUtils;
import android.annotation.RequiresPermission;
import android.app.sdksandbox.SandboxedSdkContext;
import android.content.Context;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os._Original_Build;
import androidx.annotation.RequiresApi;
import com.android.adservices.LoggerFactory;
import com.android.adservices.ServiceBinder;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(value=31)
public class AdSelectionManager {
    private static final LoggerFactory.Logger sLogger = LoggerFactory.getFledgeLogger();
    public static final String AD_SELECTION_SERVICE = "ad_selection_service";
    private Context mContext;
    private ServiceBinder<AdSelectionService> mServiceBinder;

    public static AdSelectionManager get(Context context) {
        return _Original_Build.VERSION.SDK_INT >= 33 ? context.getSystemService(AdSelectionManager.class) : new AdSelectionManager(context);
    }

    public AdSelectionManager(Context context) {
        Objects.requireNonNull(context);
        this.initialize(context);
    }

    public AdSelectionManager initialize(Context context) {
        Objects.requireNonNull(context);
        this.mContext = context;
        this.mServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.adselection.AD_SELECTION_SERVICE", AdSelectionService.Stub::asInterface);
        return this;
    }

    public TestAdSelectionManager getTestAdSelectionManager() {
        return new TestAdSelectionManager(this);
    }

    AdSelectionService getService() {
        return this.mServiceBinder.getService();
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void selectAds(AdSelectionConfig adSelectionConfig, final Executor executor, final OutcomeReceiver<AdSelectionOutcome, Exception> receiver) {
        Objects.requireNonNull(adSelectionConfig);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.getService();
            service.selectAds(new AdSelectionInput.Builder().setAdSelectionConfig(adSelectionConfig).setCallerPackageName(this.getCallerPackageName()).build(), new CallerMetadata.Builder().setBinderElapsedTimestamp(SystemClock.elapsedRealtime()).build(), new AdSelectionCallback.Stub(){

                @Override
                public void onSuccess(AdSelectionResponse resultParcel) {
                    executor.execute(() -> receiver.onResult(new AdSelectionOutcome.Builder().setAdSelectionId(resultParcel.getAdSelectionId()).setRenderUri(resultParcel.getRenderUri()).build()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Failure of AdSelection service.");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void selectAds(AdSelectionFromOutcomesConfig adSelectionFromOutcomesConfig, final Executor executor, final OutcomeReceiver<AdSelectionOutcome, Exception> receiver) {
        Objects.requireNonNull(adSelectionFromOutcomesConfig);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.getService();
            service.selectAdsFromOutcomes(new AdSelectionFromOutcomesInput.Builder().setAdSelectionFromOutcomesConfig(adSelectionFromOutcomesConfig).setCallerPackageName(this.getCallerPackageName()).build(), new CallerMetadata.Builder().setBinderElapsedTimestamp(SystemClock.elapsedRealtime()).build(), new AdSelectionCallback.Stub(){

                @Override
                public void onSuccess(AdSelectionResponse resultParcel) {
                    executor.execute(() -> {
                        if (resultParcel == null) {
                            receiver.onResult(AdSelectionOutcome.NO_OUTCOME);
                        } else {
                            receiver.onResult(new AdSelectionOutcome.Builder().setAdSelectionId(resultParcel.getAdSelectionId()).setRenderUri(resultParcel.getRenderUri()).build());
                        }
                    });
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Failure of AdSelection service.");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void reportImpression(ReportImpressionRequest request, final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.getService();
            service.reportImpression(new ReportImpressionInput.Builder().setAdSelectionId(request.getAdSelectionId()).setAdSelectionConfig(request.getAdSelectionConfig()).setCallerPackageName(this.getCallerPackageName()).build(), new ReportImpressionCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void reportInteraction(ReportInteractionRequest request, final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.getService();
            service.reportInteraction(new ReportInteractionInput.Builder().setAdSelectionId(request.getAdSelectionId()).setInteractionKey(request.getInteractionKey()).setInteractionData(request.getInteractionData()).setReportingDestinations(request.getReportingDestinations()).setCallerPackageName(this.getCallerPackageName()).build(), new ReportInteractionCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void setAppInstallAdvertisers(SetAppInstallAdvertisersRequest request, final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.getService();
            service.setAppInstallAdvertisers(new SetAppInstallAdvertisersInput.Builder().setAdvertisers(request.getAdvertisers()).setCallerPackageName(this.getCallerPackageName()).build(), new SetAppInstallAdvertisersCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void updateAdCounterHistogram(UpdateAdCounterHistogramRequest updateAdCounterHistogramRequest, final Executor executor, final OutcomeReceiver<Object, Exception> outcomeReceiver) {
        Objects.requireNonNull(updateAdCounterHistogramRequest, "Request must not be null");
        Objects.requireNonNull(executor, "Executor must not be null");
        Objects.requireNonNull(outcomeReceiver, "Outcome receiver must not be null");
        try {
            AdSelectionService service = Objects.requireNonNull(this.getService());
            service.updateAdCounterHistogram(new UpdateAdCounterHistogramInput.Builder().setAdEventType(updateAdCounterHistogramRequest.getAdEventType()).setAdSelectionId(updateAdCounterHistogramRequest.getAdSelectionId()).setCallerAdTech(updateAdCounterHistogramRequest.getCallerAdTech()).setCallerPackageName(this.getCallerPackageName()).build(), new UpdateAdCounterHistogramCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> outcomeReceiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> outcomeReceiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service");
            outcomeReceiver.onError(new IllegalStateException("Unable to find the AdSelection service", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Remote exception encountered while updating ad counter histogram");
            outcomeReceiver.onError(new IllegalStateException("Failure of AdSelection service", e));
        }
    }

    private String getCallerPackageName() {
        SandboxedSdkContext sandboxedSdkContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(this.mContext);
        return sandboxedSdkContext == null ? this.mContext.getPackageName() : sandboxedSdkContext.getClientPackageName();
    }
}

