/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.net.Uri;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class AdSelectionOutcome {
    public static final AdSelectionOutcome NO_OUTCOME = new AdSelectionOutcome();
    public static final String UNSET_AD_SELECTION_ID_MESSAGE = "Ad selection ID must be set";
    public static final int UNSET_AD_SELECTION_ID = 0;
    private final long mAdSelectionId;
    private final Uri mRenderUri;

    private AdSelectionOutcome() {
        this.mAdSelectionId = 0L;
        this.mRenderUri = Uri.EMPTY;
    }

    private AdSelectionOutcome(long adSelectionId, Uri renderUri) {
        Objects.requireNonNull(renderUri);
        this.mAdSelectionId = adSelectionId;
        this.mRenderUri = renderUri;
    }

    public Uri getRenderUri() {
        return this.mRenderUri;
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    public boolean hasOutcome() {
        return !this.equals(NO_OUTCOME);
    }

    public boolean equals(Object o) {
        if (o instanceof AdSelectionOutcome) {
            AdSelectionOutcome adSelectionOutcome = (AdSelectionOutcome)o;
            return this.mAdSelectionId == adSelectionOutcome.mAdSelectionId && Objects.equals(this.mRenderUri, adSelectionOutcome.mRenderUri);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mAdSelectionId, this.mRenderUri);
    }

    public static class Builder {
        private long mAdSelectionId = 0L;
        private Uri mRenderUri;

        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        public Builder setRenderUri(Uri renderUri) {
            Objects.requireNonNull(renderUri);
            this.mRenderUri = renderUri;
            return this;
        }

        public AdSelectionOutcome build() {
            Objects.requireNonNull(this.mRenderUri);
            Preconditions.checkArgument(this.mAdSelectionId != 0L, AdSelectionOutcome.UNSET_AD_SELECTION_ID_MESSAGE);
            return new AdSelectionOutcome(this.mAdSelectionId, this.mRenderUri);
        }
    }
}

