/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class AdSelectionResponse
implements Parcelable {
    private final long mAdSelectionId;
    private final Uri mRenderUri;
    public static final Parcelable.Creator<AdSelectionResponse> CREATOR = new Parcelable.Creator<AdSelectionResponse>(){

        @Override
        public AdSelectionResponse createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new AdSelectionResponse(in);
        }

        public AdSelectionResponse[] newArray(int size) {
            return new AdSelectionResponse[size];
        }
    };

    private AdSelectionResponse(long adSelectionId, Uri renderUri) {
        Objects.requireNonNull(renderUri);
        this.mAdSelectionId = adSelectionId;
        this.mRenderUri = renderUri;
    }

    private AdSelectionResponse(Parcel in) {
        Objects.requireNonNull(in);
        this.mAdSelectionId = in.readLong();
        this.mRenderUri = Uri.CREATOR.createFromParcel(in);
    }

    public Uri getRenderUri() {
        return this.mRenderUri;
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    public boolean equals(Object o) {
        if (o instanceof AdSelectionResponse) {
            AdSelectionResponse adSelectionResponse = (AdSelectionResponse)o;
            return this.mAdSelectionId == adSelectionResponse.mAdSelectionId && Objects.equals(this.mRenderUri, adSelectionResponse.mRenderUri);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mAdSelectionId, this.mRenderUri);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeLong(this.mAdSelectionId);
        this.mRenderUri.writeToParcel(dest, flags);
    }

    public String toString() {
        return "AdSelectionResponse{mAdSelectionId=" + this.mAdSelectionId + ", mRenderUri=" + this.mRenderUri + '}';
    }

    public static class Builder {
        private long mAdSelectionId = 0L;
        private Uri mRenderUri;

        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        public Builder setRenderUri(Uri renderUri) {
            Objects.requireNonNull(renderUri);
            this.mRenderUri = renderUri;
            return this;
        }

        public AdSelectionResponse build() {
            Objects.requireNonNull(this.mRenderUri);
            Preconditions.checkArgument(this.mAdSelectionId != 0L, "Ad selection ID must be set");
            return new AdSelectionResponse(this.mAdSelectionId, this.mRenderUri);
        }
    }
}

