/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class RemoveAdCounterHistogramOverrideInput
implements Parcelable {
    private final int mAdEventType;
    private final String mAdCounterKey;
    private final AdTechIdentifier mBuyer;
    public static final Parcelable.Creator<RemoveAdCounterHistogramOverrideInput> CREATOR = new Parcelable.Creator<RemoveAdCounterHistogramOverrideInput>(){

        @Override
        public RemoveAdCounterHistogramOverrideInput createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new RemoveAdCounterHistogramOverrideInput(in);
        }

        public RemoveAdCounterHistogramOverrideInput[] newArray(int size) {
            return new RemoveAdCounterHistogramOverrideInput[size];
        }
    };

    private RemoveAdCounterHistogramOverrideInput(Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdEventType = builder.mAdEventType;
        this.mAdCounterKey = builder.mAdCounterKey;
        this.mBuyer = builder.mBuyer;
    }

    private RemoveAdCounterHistogramOverrideInput(Parcel in) {
        Objects.requireNonNull(in);
        this.mAdEventType = in.readInt();
        this.mAdCounterKey = in.readString();
        this.mBuyer = AdTechIdentifier.fromString(in.readString());
    }

    public int getAdEventType() {
        return this.mAdEventType;
    }

    public String getAdCounterKey() {
        return this.mAdCounterKey;
    }

    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "RemoveAdCounterHistogramOverrideInput{mAdEventType=" + this.mAdEventType + ", mAdCounterKey='" + this.mAdCounterKey + "', mBuyer=" + this.mBuyer + '}';
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeInt(this.mAdEventType);
        dest.writeString(this.mAdCounterKey);
        dest.writeString(this.mBuyer.toString());
    }

    public static class Builder {
        private int mAdEventType = -1;
        private String mAdCounterKey;
        private AdTechIdentifier mBuyer;

        public Builder setAdEventType(int adEventType) {
            this.mAdEventType = adEventType;
            return this;
        }

        public Builder setAdCounterKey(String adCounterKey) {
            Objects.requireNonNull(adCounterKey, "Ad counter key must not be null");
            this.mAdCounterKey = adCounterKey;
            return this;
        }

        public Builder setBuyer(AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer, "Buyer must not be null");
            this.mBuyer = buyer;
            return this;
        }

        public RemoveAdCounterHistogramOverrideInput build() throws NullPointerException, IllegalArgumentException {
            Preconditions.checkArgument(this.mAdEventType != -1, "Ad event type must be set");
            Objects.requireNonNull(this.mAdCounterKey, "Ad counter key must not be null");
            Objects.requireNonNull(this.mBuyer, "Buyer must not be null");
            return new RemoveAdCounterHistogramOverrideInput(this);
        }
    }
}

