/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class RemoveAdCounterHistogramOverrideRequest {
    private final int mAdEventType;
    private final String mAdCounterKey;
    private final AdTechIdentifier mBuyer;

    private RemoveAdCounterHistogramOverrideRequest(Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdEventType = builder.mAdEventType;
        this.mAdCounterKey = builder.mAdCounterKey;
        this.mBuyer = builder.mBuyer;
    }

    public int getAdEventType() {
        return this.mAdEventType;
    }

    public String getAdCounterKey() {
        return this.mAdCounterKey;
    }

    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    public String toString() {
        return "RemoveAdCounterHistogramOverrideRequest{mAdEventType=" + this.mAdEventType + ", mAdCounterKey='" + this.mAdCounterKey + "', mBuyer=" + this.mBuyer + '}';
    }

    public static class Builder {
        private int mAdEventType = -1;
        private String mAdCounterKey;
        private AdTechIdentifier mBuyer;

        public Builder setAdEventType(int adEventType) {
            this.mAdEventType = adEventType;
            return this;
        }

        public Builder setAdCounterKey(String adCounterKey) {
            Objects.requireNonNull(adCounterKey, "Ad counter key must not be null");
            this.mAdCounterKey = adCounterKey;
            return this;
        }

        public Builder setBuyer(AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer, "Buyer must not be null");
            this.mBuyer = buyer;
            return this;
        }

        public RemoveAdCounterHistogramOverrideRequest build() throws NullPointerException, IllegalArgumentException {
            Preconditions.checkArgument(this.mAdEventType != -1, "Ad event type must be set");
            Objects.requireNonNull(this.mAdCounterKey, "Ad counter key must not be null");
            Objects.requireNonNull(this.mBuyer, "Buyer must not be null");
            return new RemoveAdCounterHistogramOverrideRequest(this);
        }
    }
}

