/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.adselection.AdSelectionConfig;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class ReportImpressionInput
implements Parcelable {
    private final long mAdSelectionId;
    private final AdSelectionConfig mAdSelectionConfig;
    private final String mCallerPackageName;
    public static final Parcelable.Creator<ReportImpressionInput> CREATOR = new Parcelable.Creator<ReportImpressionInput>(){

        @Override
        public ReportImpressionInput createFromParcel(Parcel in) {
            return new ReportImpressionInput(in);
        }

        public ReportImpressionInput[] newArray(int size) {
            return new ReportImpressionInput[size];
        }
    };

    private ReportImpressionInput(long adSelectionId, AdSelectionConfig adSelectionConfig, String callerPackageName) {
        Objects.requireNonNull(adSelectionConfig);
        this.mAdSelectionId = adSelectionId;
        this.mAdSelectionConfig = adSelectionConfig;
        this.mCallerPackageName = callerPackageName;
    }

    private ReportImpressionInput(Parcel in) {
        Objects.requireNonNull(in);
        this.mAdSelectionId = in.readLong();
        this.mAdSelectionConfig = AdSelectionConfig.CREATOR.createFromParcel(in);
        this.mCallerPackageName = in.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeLong(this.mAdSelectionId);
        this.mAdSelectionConfig.writeToParcel(dest, flags);
        dest.writeString(this.mCallerPackageName);
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    public AdSelectionConfig getAdSelectionConfig() {
        return this.mAdSelectionConfig;
    }

    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    public static class Builder {
        private long mAdSelectionId = 0L;
        private AdSelectionConfig mAdSelectionConfig;
        private String mCallerPackageName;

        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        public Builder setAdSelectionConfig(AdSelectionConfig adSelectionConfig) {
            Objects.requireNonNull(adSelectionConfig);
            this.mAdSelectionConfig = adSelectionConfig;
            return this;
        }

        public Builder setCallerPackageName(String callerPackageName) {
            Objects.requireNonNull(callerPackageName);
            this.mCallerPackageName = callerPackageName;
            return this;
        }

        public ReportImpressionInput build() {
            Objects.requireNonNull(this.mAdSelectionConfig);
            Objects.requireNonNull(this.mCallerPackageName);
            Preconditions.checkArgument(this.mAdSelectionId != 0L, "Ad selection ID must be set");
            return new ReportImpressionInput(this.mAdSelectionId, this.mAdSelectionConfig, this.mCallerPackageName);
        }
    }
}

