/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class ReportInteractionInput
implements Parcelable {
    private static final int UNSET_REPORTING_DESTINATIONS = 0;
    private static final String UNSET_REPORTING_DESTINATIONS_MESSAGE = "Reporting Destinations bitfield not set.";
    private final long mAdSelectionId;
    private final String mInteractionKey;
    private final String mInteractionData;
    private final String mCallerPackageName;
    private final int mReportingDestinations;
    public static final Parcelable.Creator<ReportInteractionInput> CREATOR = new Parcelable.Creator<ReportInteractionInput>(){

        @Override
        public ReportInteractionInput createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new ReportInteractionInput(in);
        }

        public ReportInteractionInput[] newArray(int size) {
            return new ReportInteractionInput[size];
        }
    };

    private ReportInteractionInput(long adSelectionId, String interactionKey, String interactionData, String callerPackageName, int reportingDestinations) {
        Objects.requireNonNull(interactionKey);
        Objects.requireNonNull(interactionData);
        Objects.requireNonNull(callerPackageName);
        this.mAdSelectionId = adSelectionId;
        this.mInteractionKey = interactionKey;
        this.mInteractionData = interactionData;
        this.mCallerPackageName = callerPackageName;
        this.mReportingDestinations = reportingDestinations;
    }

    private ReportInteractionInput(Parcel in) {
        this.mAdSelectionId = in.readLong();
        this.mInteractionKey = in.readString();
        this.mInteractionData = in.readString();
        this.mCallerPackageName = in.readString();
        this.mReportingDestinations = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeLong(this.mAdSelectionId);
        dest.writeString(this.mInteractionKey);
        dest.writeString(this.mInteractionData);
        dest.writeString(this.mCallerPackageName);
        dest.writeInt(this.mReportingDestinations);
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    public String getInteractionKey() {
        return this.mInteractionKey;
    }

    public String getInteractionData() {
        return this.mInteractionData;
    }

    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    public int getReportingDestinations() {
        return this.mReportingDestinations;
    }

    public static class Builder {
        private long mAdSelectionId = 0L;
        private String mInteractionKey;
        private String mInteractionData;
        private String mCallerPackageName;
        private int mReportingDestinations = 0;

        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        public Builder setInteractionKey(String interactionKey) {
            Objects.requireNonNull(interactionKey);
            this.mInteractionKey = interactionKey;
            return this;
        }

        public Builder setInteractionData(String interactionData) {
            Objects.requireNonNull(interactionData);
            this.mInteractionData = interactionData;
            return this;
        }

        public Builder setCallerPackageName(String callerPackageName) {
            Objects.requireNonNull(callerPackageName);
            this.mCallerPackageName = callerPackageName;
            return this;
        }

        public Builder setReportingDestinations(int reportingDestinations) {
            Preconditions.checkArgument(reportingDestinations != 0, ReportInteractionInput.UNSET_REPORTING_DESTINATIONS_MESSAGE);
            this.mReportingDestinations = reportingDestinations;
            return this;
        }

        public ReportInteractionInput build() {
            Objects.requireNonNull(this.mInteractionKey);
            Objects.requireNonNull(this.mInteractionData);
            Objects.requireNonNull(this.mCallerPackageName);
            Preconditions.checkArgument(this.mAdSelectionId != 0L, "Ad selection ID must be set");
            Preconditions.checkArgument(this.mReportingDestinations != 0, ReportInteractionInput.UNSET_REPORTING_DESTINATIONS_MESSAGE);
            return new ReportInteractionInput(this.mAdSelectionId, this.mInteractionKey, this.mInteractionData, this.mCallerPackageName, this.mReportingDestinations);
        }
    }
}

