/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class ReportInteractionRequest {
    public static final int FLAG_REPORTING_DESTINATION_SELLER = 1;
    public static final int FLAG_REPORTING_DESTINATION_BUYER = 2;
    private static final int UNSET_REPORTING_DESTINATIONS = 0;
    private static final String UNSET_REPORTING_DESTINATIONS_MESSAGE = "Reporting destinations bitfield not set.";
    private final long mAdSelectionId;
    private final String mInteractionKey;
    private final String mInteractionData;
    private final int mReportingDestinations;

    public ReportInteractionRequest(long adSelectionId, String interactionKey, String interactionData, int reportingDestinations) {
        Objects.requireNonNull(interactionKey);
        Objects.requireNonNull(interactionData);
        Preconditions.checkArgument(adSelectionId != 0L, "Ad selection ID must be set");
        Preconditions.checkArgument(reportingDestinations != 0, UNSET_REPORTING_DESTINATIONS_MESSAGE);
        this.mAdSelectionId = adSelectionId;
        this.mInteractionKey = interactionKey;
        this.mInteractionData = interactionData;
        this.mReportingDestinations = reportingDestinations;
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    public String getInteractionKey() {
        return this.mInteractionKey;
    }

    public String getInteractionData() {
        return this.mInteractionData;
    }

    public int getReportingDestinations() {
        return this.mReportingDestinations;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ReportingDestination {
    }
}

