/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import com.android.internal.util.Preconditions;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SetAdCounterHistogramOverrideInput
implements Parcelable {
    private final int mAdEventType;
    private final String mAdCounterKey;
    private final List<Instant> mHistogramTimestamps;
    private final AdTechIdentifier mBuyer;
    private final String mCustomAudienceOwner;
    private final String mCustomAudienceName;
    public static final Parcelable.Creator<SetAdCounterHistogramOverrideInput> CREATOR = new Parcelable.Creator<SetAdCounterHistogramOverrideInput>(){

        @Override
        public SetAdCounterHistogramOverrideInput createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new SetAdCounterHistogramOverrideInput(in);
        }

        public SetAdCounterHistogramOverrideInput[] newArray(int size) {
            return new SetAdCounterHistogramOverrideInput[size];
        }
    };

    private SetAdCounterHistogramOverrideInput(Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdEventType = builder.mAdEventType;
        this.mAdCounterKey = builder.mAdCounterKey;
        this.mHistogramTimestamps = builder.mHistogramTimestamps;
        this.mBuyer = builder.mBuyer;
        this.mCustomAudienceOwner = builder.mCustomAudienceOwner;
        this.mCustomAudienceName = builder.mCustomAudienceName;
    }

    private SetAdCounterHistogramOverrideInput(Parcel in) {
        Objects.requireNonNull(in);
        this.mAdEventType = in.readInt();
        this.mAdCounterKey = in.readString();
        this.mHistogramTimestamps = AdServicesParcelableUtil.readInstantListFromParcel(in);
        this.mBuyer = AdTechIdentifier.fromString(in.readString());
        this.mCustomAudienceOwner = in.readString();
        this.mCustomAudienceName = in.readString();
    }

    public int getAdEventType() {
        return this.mAdEventType;
    }

    public String getAdCounterKey() {
        return this.mAdCounterKey;
    }

    public List<Instant> getHistogramTimestamps() {
        return this.mHistogramTimestamps;
    }

    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    public String getCustomAudienceOwner() {
        return this.mCustomAudienceOwner;
    }

    public String getCustomAudienceName() {
        return this.mCustomAudienceName;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "SetAdCounterHistogramOverrideInput{mAdEventType=" + this.mAdEventType + ", mAdCounterKey='" + this.mAdCounterKey + "', mHistogramTimestamps=" + this.mHistogramTimestamps + ", mBuyer=" + this.mBuyer + ", mCustomAudienceOwner='" + this.mCustomAudienceOwner + "', mCustomAudienceName='" + this.mCustomAudienceName + "'}";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeInt(this.mAdEventType);
        dest.writeString(this.mAdCounterKey);
        AdServicesParcelableUtil.writeInstantListToParcel(dest, this.mHistogramTimestamps);
        dest.writeString(this.mBuyer.toString());
        dest.writeString(this.mCustomAudienceOwner);
        dest.writeString(this.mCustomAudienceName);
    }

    public static class Builder {
        private int mAdEventType = -1;
        private String mAdCounterKey;
        private List<Instant> mHistogramTimestamps = new ArrayList<Instant>();
        private AdTechIdentifier mBuyer;
        private String mCustomAudienceOwner;
        private String mCustomAudienceName;

        public Builder setAdEventType(int adEventType) {
            this.mAdEventType = adEventType;
            return this;
        }

        public Builder setAdCounterKey(String adCounterKey) {
            Objects.requireNonNull(adCounterKey, "Ad counter key must not be null");
            this.mAdCounterKey = adCounterKey;
            return this;
        }

        public Builder setHistogramTimestamps(List<Instant> histogramTimestamps) {
            Objects.requireNonNull(histogramTimestamps, "List of histogram timestamps must not be null");
            this.mHistogramTimestamps = histogramTimestamps;
            return this;
        }

        public Builder setBuyer(AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer, "Buyer must not be null");
            this.mBuyer = buyer;
            return this;
        }

        public Builder setCustomAudienceOwner(String customAudienceOwner) {
            Objects.requireNonNull(customAudienceOwner, "Custom audience owner must not be null");
            this.mCustomAudienceOwner = customAudienceOwner;
            return this;
        }

        public Builder setCustomAudienceName(String customAudienceName) {
            Objects.requireNonNull(customAudienceName, "Custom audience name must not be null");
            this.mCustomAudienceName = customAudienceName;
            return this;
        }

        public SetAdCounterHistogramOverrideInput build() throws NullPointerException, IllegalArgumentException {
            Preconditions.checkArgument(this.mAdEventType != -1, "Ad event type must be set");
            Objects.requireNonNull(this.mAdCounterKey, "Ad counter key must not be null");
            Objects.requireNonNull(this.mBuyer, "Buyer must not be null");
            Objects.requireNonNull(this.mCustomAudienceOwner, "Custom audience owner must not be null");
            Objects.requireNonNull(this.mCustomAudienceName, "Custom audience name must not be null");
            return new SetAdCounterHistogramOverrideInput(this);
        }
    }
}

