/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import com.android.internal.util.Preconditions;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SetAdCounterHistogramOverrideRequest {
    public static final String NULL_AD_COUNTER_KEY_MESSAGE = "Ad counter key must not be null";
    public static final String NULL_HISTOGRAM_TIMESTAMPS_MESSAGE = "List of histogram timestamps must not be null";
    public static final String NULL_BUYER_MESSAGE = "Buyer must not be null";
    public static final String NULL_CUSTOM_AUDIENCE_OWNER_MESSAGE = "Custom audience owner must not be null";
    public static final String NULL_CUSTOM_AUDIENCE_NAME_MESSAGE = "Custom audience name must not be null";
    private final int mAdEventType;
    private final String mAdCounterKey;
    private final List<Instant> mHistogramTimestamps;
    private final AdTechIdentifier mBuyer;
    private final String mCustomAudienceOwner;
    private final String mCustomAudienceName;

    private SetAdCounterHistogramOverrideRequest(Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdEventType = builder.mAdEventType;
        this.mAdCounterKey = builder.mAdCounterKey;
        this.mHistogramTimestamps = builder.mHistogramTimestamps;
        this.mBuyer = builder.mBuyer;
        this.mCustomAudienceOwner = builder.mCustomAudienceOwner;
        this.mCustomAudienceName = builder.mCustomAudienceName;
    }

    public int getAdEventType() {
        return this.mAdEventType;
    }

    public String getAdCounterKey() {
        return this.mAdCounterKey;
    }

    public List<Instant> getHistogramTimestamps() {
        return this.mHistogramTimestamps;
    }

    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    public String getCustomAudienceOwner() {
        return this.mCustomAudienceOwner;
    }

    public String getCustomAudienceName() {
        return this.mCustomAudienceName;
    }

    public String toString() {
        return "SetAdCounterHistogramOverrideRequest{mAdEventType=" + this.mAdEventType + ", mAdCounterKey='" + this.mAdCounterKey + "', mHistogramTimestamps=" + this.mHistogramTimestamps + ", mBuyer=" + this.mBuyer + ", mCustomAudienceOwner='" + this.mCustomAudienceOwner + "', mCustomAudienceName='" + this.mCustomAudienceName + "'}";
    }

    public static class Builder {
        private int mAdEventType = -1;
        private String mAdCounterKey;
        private List<Instant> mHistogramTimestamps = new ArrayList<Instant>();
        private AdTechIdentifier mBuyer;
        private String mCustomAudienceOwner;
        private String mCustomAudienceName;

        public Builder setAdEventType(int adEventType) {
            this.mAdEventType = adEventType;
            return this;
        }

        public Builder setAdCounterKey(String adCounterKey) {
            Objects.requireNonNull(adCounterKey, SetAdCounterHistogramOverrideRequest.NULL_AD_COUNTER_KEY_MESSAGE);
            this.mAdCounterKey = adCounterKey;
            return this;
        }

        public Builder setHistogramTimestamps(List<Instant> histogramTimestamps) {
            Objects.requireNonNull(histogramTimestamps, SetAdCounterHistogramOverrideRequest.NULL_HISTOGRAM_TIMESTAMPS_MESSAGE);
            this.mHistogramTimestamps = histogramTimestamps;
            return this;
        }

        public Builder setBuyer(AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer, SetAdCounterHistogramOverrideRequest.NULL_BUYER_MESSAGE);
            this.mBuyer = buyer;
            return this;
        }

        public Builder setCustomAudienceOwner(String customAudienceOwner) {
            Objects.requireNonNull(customAudienceOwner, SetAdCounterHistogramOverrideRequest.NULL_CUSTOM_AUDIENCE_OWNER_MESSAGE);
            this.mCustomAudienceOwner = customAudienceOwner;
            return this;
        }

        public Builder setCustomAudienceName(String customAudienceName) {
            Objects.requireNonNull(customAudienceName, SetAdCounterHistogramOverrideRequest.NULL_CUSTOM_AUDIENCE_NAME_MESSAGE);
            this.mCustomAudienceName = customAudienceName;
            return this;
        }

        public SetAdCounterHistogramOverrideRequest build() throws NullPointerException, IllegalArgumentException {
            Preconditions.checkArgument(this.mAdEventType != -1, "Ad event type must be set");
            Objects.requireNonNull(this.mAdCounterKey, SetAdCounterHistogramOverrideRequest.NULL_AD_COUNTER_KEY_MESSAGE);
            Objects.requireNonNull(this.mBuyer, SetAdCounterHistogramOverrideRequest.NULL_BUYER_MESSAGE);
            Objects.requireNonNull(this.mCustomAudienceOwner, SetAdCounterHistogramOverrideRequest.NULL_CUSTOM_AUDIENCE_OWNER_MESSAGE);
            Objects.requireNonNull(this.mCustomAudienceName, SetAdCounterHistogramOverrideRequest.NULL_CUSTOM_AUDIENCE_NAME_MESSAGE);
            return new SetAdCounterHistogramOverrideRequest(this);
        }
    }
}

