/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import java.util.Objects;
import java.util.Set;

public class SetAppInstallAdvertisersInput
implements Parcelable {
    private final Set<AdTechIdentifier> mAdvertisers;
    private final String mCallerPackageName;
    public static final Parcelable.Creator<SetAppInstallAdvertisersInput> CREATOR = new Parcelable.Creator<SetAppInstallAdvertisersInput>(){

        @Override
        public SetAppInstallAdvertisersInput createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new SetAppInstallAdvertisersInput(in);
        }

        public SetAppInstallAdvertisersInput[] newArray(int size) {
            return new SetAppInstallAdvertisersInput[size];
        }
    };

    private SetAppInstallAdvertisersInput(Set<AdTechIdentifier> advertisers, String callerPackageName) {
        Objects.requireNonNull(advertisers);
        Objects.requireNonNull(callerPackageName);
        this.mAdvertisers = advertisers;
        this.mCallerPackageName = callerPackageName;
    }

    private SetAppInstallAdvertisersInput(Parcel in) {
        Objects.requireNonNull(in);
        this.mAdvertisers = AdServicesParcelableUtil.readSetFromParcel(in, AdTechIdentifier.CREATOR);
        this.mCallerPackageName = in.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        AdServicesParcelableUtil.writeSetToParcel(dest, this.mAdvertisers);
        dest.writeString(this.mCallerPackageName);
    }

    public Set<AdTechIdentifier> getAdvertisers() {
        return this.mAdvertisers;
    }

    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    public static class Builder {
        private Set<AdTechIdentifier> mAdvertisers;
        private String mCallerPackageName;

        public Builder setAdvertisers(Set<AdTechIdentifier> advertisers) {
            Objects.requireNonNull(advertisers);
            this.mAdvertisers = advertisers;
            return this;
        }

        public Builder setCallerPackageName(String callerPackageName) {
            Objects.requireNonNull(callerPackageName);
            this.mCallerPackageName = callerPackageName;
            return this;
        }

        public SetAppInstallAdvertisersInput build() {
            Objects.requireNonNull(this.mAdvertisers);
            Objects.requireNonNull(this.mCallerPackageName);
            return new SetAppInstallAdvertisersInput(this.mAdvertisers, this.mCallerPackageName);
        }
    }
}

