/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.adselection.AdSelectionManager;
import android.adservices.adselection.AdSelectionOverrideCallback;
import android.adservices.adselection.AdSelectionService;
import android.adservices.adselection.AddAdSelectionFromOutcomesOverrideRequest;
import android.adservices.adselection.AddAdSelectionOverrideRequest;
import android.adservices.adselection.RemoveAdCounterHistogramOverrideInput;
import android.adservices.adselection.RemoveAdCounterHistogramOverrideRequest;
import android.adservices.adselection.RemoveAdSelectionFromOutcomesOverrideRequest;
import android.adservices.adselection.RemoveAdSelectionOverrideRequest;
import android.adservices.adselection.SetAdCounterHistogramOverrideInput;
import android.adservices.adselection.SetAdCounterHistogramOverrideRequest;
import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.FledgeErrorResponse;
import android.annotation.RequiresPermission;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import androidx.annotation.RequiresApi;
import com.android.adservices.LoggerFactory;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(value=31)
public class TestAdSelectionManager {
    private static final LoggerFactory.Logger sLogger = LoggerFactory.getFledgeLogger();
    private final AdSelectionManager mAdSelectionManager;

    TestAdSelectionManager(AdSelectionManager adSelectionManager) {
        Objects.requireNonNull(adSelectionManager);
        this.mAdSelectionManager = adSelectionManager;
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void overrideAdSelectionConfigRemoteInfo(AddAdSelectionOverrideRequest request, final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.mAdSelectionManager.getService();
            service.overrideAdSelectionConfigRemoteInfo(request.getAdSelectionConfig(), request.getDecisionLogicJs(), request.getTrustedScoringSignals(), request.getBuyersDecisionLogic(), new AdSelectionOverrideCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void removeAdSelectionConfigRemoteInfoOverride(RemoveAdSelectionOverrideRequest request, final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.mAdSelectionManager.getService();
            service.removeAdSelectionConfigRemoteInfoOverride(request.getAdSelectionConfig(), new AdSelectionOverrideCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void resetAllAdSelectionConfigRemoteOverrides(final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.mAdSelectionManager.getService();
            service.resetAllAdSelectionConfigRemoteOverrides(new AdSelectionOverrideCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void overrideAdSelectionFromOutcomesConfigRemoteInfo(AddAdSelectionFromOutcomesOverrideRequest request, final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.mAdSelectionManager.getService();
            service.overrideAdSelectionFromOutcomesConfigRemoteInfo(request.getAdSelectionFromOutcomesConfig(), request.getOutcomeSelectionLogicJs(), request.getOutcomeSelectionTrustedSignals(), new AdSelectionOverrideCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void removeAdSelectionFromOutcomesConfigRemoteInfoOverride(RemoveAdSelectionFromOutcomesOverrideRequest request, final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.mAdSelectionManager.getService();
            service.removeAdSelectionFromOutcomesConfigRemoteInfoOverride(request.getAdSelectionFromOutcomesConfig(), new AdSelectionOverrideCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void resetAllAdSelectionFromOutcomesConfigRemoteOverrides(final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.mAdSelectionManager.getService();
            service.resetAllAdSelectionFromOutcomesConfigRemoteOverrides(new AdSelectionOverrideCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void setAdCounterHistogramOverride(SetAdCounterHistogramOverrideRequest setRequest, final Executor executor, final OutcomeReceiver<Object, Exception> outcomeReceiver) {
        Objects.requireNonNull(setRequest, "Request must not be null");
        Objects.requireNonNull(executor, "Executor must not be null");
        Objects.requireNonNull(outcomeReceiver, "Outcome receiver must not be null");
        try {
            AdSelectionService service = Objects.requireNonNull(this.mAdSelectionManager.getService());
            service.setAdCounterHistogramOverride(new SetAdCounterHistogramOverrideInput.Builder().setAdEventType(setRequest.getAdEventType()).setAdCounterKey(setRequest.getAdCounterKey()).setHistogramTimestamps(setRequest.getHistogramTimestamps()).setBuyer(setRequest.getBuyer()).setCustomAudienceOwner(setRequest.getCustomAudienceOwner()).setCustomAudienceName(setRequest.getCustomAudienceName()).build(), new AdSelectionOverrideCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> outcomeReceiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> outcomeReceiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service");
            outcomeReceiver.onError(new IllegalStateException("Unable to find the AdSelection service", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Remote exception encountered while updating ad counter histogram");
            outcomeReceiver.onError(new IllegalStateException("Failure of AdSelection service", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void removeAdCounterHistogramOverride(RemoveAdCounterHistogramOverrideRequest removeRequest, final Executor executor, final OutcomeReceiver<Object, Exception> outcomeReceiver) {
        Objects.requireNonNull(removeRequest, "Request must not be null");
        Objects.requireNonNull(executor, "Executor must not be null");
        Objects.requireNonNull(outcomeReceiver, "Outcome receiver must not be null");
        try {
            AdSelectionService service = Objects.requireNonNull(this.mAdSelectionManager.getService());
            service.removeAdCounterHistogramOverride(new RemoveAdCounterHistogramOverrideInput.Builder().setAdEventType(removeRequest.getAdEventType()).setAdCounterKey(removeRequest.getAdCounterKey()).setBuyer(removeRequest.getBuyer()).build(), new AdSelectionOverrideCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> outcomeReceiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> outcomeReceiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service");
            outcomeReceiver.onError(new IllegalStateException("Unable to find the AdSelection service", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Remote exception encountered while updating ad counter histogram");
            outcomeReceiver.onError(new IllegalStateException("Failure of AdSelection service", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void resetAllAdCounterHistogramOverrides(final Executor executor, final OutcomeReceiver<Object, Exception> outcomeReceiver) {
        Objects.requireNonNull(executor, "Executor must not be null");
        Objects.requireNonNull(outcomeReceiver, "Outcome receiver must not be null");
        try {
            AdSelectionService service = Objects.requireNonNull(this.mAdSelectionManager.getService());
            service.resetAllAdCounterHistogramOverrides(new AdSelectionOverrideCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> outcomeReceiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> outcomeReceiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service");
            outcomeReceiver.onError(new IllegalStateException("Unable to find the AdSelection service", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Remote exception encountered while updating ad counter histogram");
            outcomeReceiver.onError(new IllegalStateException("Failure of AdSelection service", e));
        }
    }
}

