/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class UpdateAdCounterHistogramInput
implements Parcelable {
    private static final String UNSET_CALLER_PACKAGE_NAME_MESSAGE = "Caller package name must not be null";
    private final long mAdSelectionId;
    private final int mAdEventType;
    private final AdTechIdentifier mCallerAdTech;
    private final String mCallerPackageName;
    public static final Parcelable.Creator<UpdateAdCounterHistogramInput> CREATOR = new Parcelable.Creator<UpdateAdCounterHistogramInput>(){

        @Override
        public UpdateAdCounterHistogramInput createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new UpdateAdCounterHistogramInput(in);
        }

        public UpdateAdCounterHistogramInput[] newArray(int size) {
            return new UpdateAdCounterHistogramInput[size];
        }
    };

    private UpdateAdCounterHistogramInput(Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdSelectionId = builder.mAdSelectionId;
        this.mAdEventType = builder.mAdEventType;
        this.mCallerAdTech = builder.mCallerAdTech;
        this.mCallerPackageName = builder.mCallerPackageName;
    }

    private UpdateAdCounterHistogramInput(Parcel in) {
        Objects.requireNonNull(in);
        this.mAdSelectionId = in.readLong();
        this.mAdEventType = in.readInt();
        this.mCallerAdTech = AdTechIdentifier.CREATOR.createFromParcel(in);
        this.mCallerPackageName = in.readString();
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    public int getAdEventType() {
        return this.mAdEventType;
    }

    public AdTechIdentifier getCallerAdTech() {
        return this.mCallerAdTech;
    }

    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mAdSelectionId);
        dest.writeInt(this.mAdEventType);
        this.mCallerAdTech.writeToParcel(dest, flags);
        dest.writeString(this.mCallerPackageName);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAdCounterHistogramInput)) {
            return false;
        }
        UpdateAdCounterHistogramInput that = (UpdateAdCounterHistogramInput)o;
        return this.mAdSelectionId == that.mAdSelectionId && this.mAdEventType == that.mAdEventType && this.mCallerAdTech.equals(that.mCallerAdTech) && this.mCallerPackageName.equals(that.mCallerPackageName);
    }

    public int hashCode() {
        return Objects.hash(this.mAdSelectionId, this.mAdEventType, this.mCallerAdTech, this.mCallerPackageName);
    }

    public String toString() {
        return "UpdateAdCounterHistogramInput{mAdSelectionId=" + this.mAdSelectionId + ", mAdEventType=" + this.mAdEventType + ", mCallerAdTech=" + this.mCallerAdTech + ", mCallerPackageName='" + this.mCallerPackageName + '\'' + '}';
    }

    public static class Builder {
        private long mAdSelectionId = 0L;
        private int mAdEventType = -1;
        private AdTechIdentifier mCallerAdTech;
        private String mCallerPackageName;

        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        public Builder setAdEventType(int adEventType) {
            Preconditions.checkArgument(adEventType != 0, "Win event types cannot be manually updated");
            this.mAdEventType = adEventType;
            return this;
        }

        public Builder setCallerAdTech(AdTechIdentifier callerAdTech) {
            Objects.requireNonNull(callerAdTech, "Caller ad tech must not be null");
            this.mCallerAdTech = callerAdTech;
            return this;
        }

        public Builder setCallerPackageName(String callerPackageName) {
            Objects.requireNonNull(callerPackageName, UpdateAdCounterHistogramInput.UNSET_CALLER_PACKAGE_NAME_MESSAGE);
            this.mCallerPackageName = callerPackageName;
            return this;
        }

        public UpdateAdCounterHistogramInput build() throws NullPointerException, IllegalArgumentException {
            Preconditions.checkArgument(this.mAdSelectionId != 0L, "Ad selection ID must be set");
            Preconditions.checkArgument(this.mAdEventType != -1, "Ad event type must be set");
            Objects.requireNonNull(this.mCallerAdTech, "Caller ad tech must not be null");
            Objects.requireNonNull(this.mCallerPackageName, UpdateAdCounterHistogramInput.UNSET_CALLER_PACKAGE_NAME_MESSAGE);
            return new UpdateAdCounterHistogramInput(this);
        }
    }
}

