/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class UpdateAdCounterHistogramRequest {
    public static final String UNSET_AD_EVENT_TYPE_MESSAGE = "Ad event type must be set";
    public static final String DISALLOW_AD_EVENT_TYPE_WIN_MESSAGE = "Win event types cannot be manually updated";
    public static final String UNSET_CALLER_ADTECH_MESSAGE = "Caller ad tech must not be null";
    private final long mAdSelectionId;
    private final int mAdEventType;
    private final AdTechIdentifier mCallerAdTech;

    private UpdateAdCounterHistogramRequest(Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdSelectionId = builder.mAdSelectionId;
        this.mAdEventType = builder.mAdEventType;
        this.mCallerAdTech = builder.mCallerAdTech;
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    public int getAdEventType() {
        return this.mAdEventType;
    }

    public AdTechIdentifier getCallerAdTech() {
        return this.mCallerAdTech;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAdCounterHistogramRequest)) {
            return false;
        }
        UpdateAdCounterHistogramRequest that = (UpdateAdCounterHistogramRequest)o;
        return this.mAdSelectionId == that.mAdSelectionId && this.mAdEventType == that.mAdEventType && this.mCallerAdTech.equals(that.mCallerAdTech);
    }

    public int hashCode() {
        return Objects.hash(this.mAdSelectionId, this.mAdEventType, this.mCallerAdTech);
    }

    public String toString() {
        return "UpdateAdCounterHistogramRequest{mAdSelectionId=" + this.mAdSelectionId + ", mAdEventType=" + this.mAdEventType + ", mCallerAdTech=" + this.mCallerAdTech + '}';
    }

    public static class Builder {
        private long mAdSelectionId = 0L;
        private int mAdEventType = -1;
        private AdTechIdentifier mCallerAdTech;

        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        public Builder setAdEventType(int adEventType) {
            Preconditions.checkArgument(adEventType != 0, UpdateAdCounterHistogramRequest.DISALLOW_AD_EVENT_TYPE_WIN_MESSAGE);
            this.mAdEventType = adEventType;
            return this;
        }

        public Builder setCallerAdTech(AdTechIdentifier callerAdTech) {
            Objects.requireNonNull(callerAdTech, UpdateAdCounterHistogramRequest.UNSET_CALLER_ADTECH_MESSAGE);
            this.mCallerAdTech = callerAdTech;
            return this;
        }

        public UpdateAdCounterHistogramRequest build() throws NullPointerException, IllegalArgumentException {
            Preconditions.checkArgument(this.mAdSelectionId != 0L, "Ad selection ID must be set");
            Preconditions.checkArgument(this.mAdEventType != -1, UpdateAdCounterHistogramRequest.UNSET_AD_EVENT_TYPE_MESSAGE);
            Objects.requireNonNull(this.mCallerAdTech, UpdateAdCounterHistogramRequest.UNSET_CALLER_ADTECH_MESSAGE);
            return new UpdateAdCounterHistogramRequest(this);
        }
    }
}

