/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.appsetid;

import android.adservices.appsetid.AppSetId;
import android.adservices.appsetid.GetAppSetIdParam;
import android.adservices.appsetid.GetAppSetIdResult;
import android.adservices.appsetid.IAppSetIdService;
import android.adservices.appsetid.IGetAppSetIdCallback;
import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.CallerMetadata;
import android.adservices.common.SandboxedSdkContextUtils;
import android.app.sdksandbox.SandboxedSdkContext;
import android.content.Context;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os._Original_Build;
import androidx.annotation.RequiresApi;
import com.android.adservices.LogUtil;
import com.android.adservices.ServiceBinder;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(value=31)
public class AppSetIdManager {
    public static final String APPSETID_SERVICE = "appsetid_service";
    static final String EMPTY_SDK = "";
    private Context mContext;
    private ServiceBinder<IAppSetIdService> mServiceBinder;

    public static AppSetIdManager get(Context context) {
        return _Original_Build.VERSION.SDK_INT >= 33 ? context.getSystemService(AppSetIdManager.class) : new AppSetIdManager(context);
    }

    public AppSetIdManager(Context context) {
        this.initialize(context);
    }

    public AppSetIdManager initialize(Context context) {
        this.mContext = context;
        this.mServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.APPSETID_SERVICE", IAppSetIdService.Stub::asInterface);
        return this;
    }

    private IAppSetIdService getService() {
        IAppSetIdService service = this.mServiceBinder.getService();
        if (service == null) {
            throw new IllegalStateException("Unable to find the service");
        }
        return service;
    }

    private Context getContext() {
        return this.mContext;
    }

    public void getAppSetId(final Executor executor, final OutcomeReceiver<AppSetId, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        CallerMetadata callerMetadata = new CallerMetadata.Builder().setBinderElapsedTimestamp(SystemClock.elapsedRealtime()).build();
        IAppSetIdService service = this.getService();
        String appPackageName = EMPTY_SDK;
        String sdkPackageName = EMPTY_SDK;
        Context getAppSetIdRequestContext = this.getContext();
        SandboxedSdkContext requestContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(getAppSetIdRequestContext);
        if (requestContext != null) {
            sdkPackageName = requestContext.getSdkPackageName();
            appPackageName = requestContext.getClientPackageName();
        } else {
            appPackageName = getAppSetIdRequestContext.getPackageName();
        }
        try {
            service.getAppSetId(new GetAppSetIdParam.Builder().setAppPackageName(appPackageName).setSdkPackageName(sdkPackageName).build(), callerMetadata, new IGetAppSetIdCallback.Stub(){

                @Override
                public void onResult(GetAppSetIdResult resultParcel) {
                    executor.execute(() -> {
                        if (resultParcel.isSuccess()) {
                            callback.onResult(new AppSetId(resultParcel.getAppSetId(), resultParcel.getAppSetIdScope()));
                        } else {
                            callback.onError(AdServicesStatusUtils.asException(resultParcel));
                        }
                    });
                }

                @Override
                public void onError(int resultCode) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(resultCode)));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e("RemoteException", e);
            callback.onError(e);
        }
    }

    public void unbindFromService() {
        this.mServiceBinder.unbindFromService();
    }
}

