/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.appsetid;

import android.adservices.common.AdServicesResponse;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class GetAppSetIdResult
extends AdServicesResponse {
    private final String mAppSetId;
    public static final int SCOPE_APP = 1;
    public static final int SCOPE_DEVELOPER = 2;
    private final int mAppSetIdScope;
    public static final Parcelable.Creator<GetAppSetIdResult> CREATOR = new Parcelable.Creator<GetAppSetIdResult>(){

        @Override
        public GetAppSetIdResult createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new GetAppSetIdResult(in);
        }

        public GetAppSetIdResult[] newArray(int size) {
            return new GetAppSetIdResult[size];
        }
    };

    private GetAppSetIdResult(int resultCode, String errorMessage, String appSetId, int appSetIdScope) {
        super(resultCode, errorMessage);
        this.mAppSetId = appSetId;
        this.mAppSetIdScope = appSetIdScope;
    }

    private GetAppSetIdResult(Parcel in) {
        super(in);
        Objects.requireNonNull(in);
        this.mAppSetId = in.readString();
        this.mAppSetIdScope = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mStatusCode);
        out.writeString(this.mErrorMessage);
        out.writeString(this.mAppSetId);
        out.writeInt(this.mAppSetIdScope);
    }

    @Override
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public String getAppSetId() {
        return this.mAppSetId;
    }

    public int getAppSetIdScope() {
        return this.mAppSetIdScope;
    }

    public String toString() {
        return "GetAppSetIdResult{mResultCode=" + this.mStatusCode + ", mErrorMessage='" + this.mErrorMessage + '\'' + ", mAppSetId=" + this.mAppSetId + ", mAppSetIdScope=" + this.mAppSetIdScope + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAppSetIdResult)) {
            return false;
        }
        GetAppSetIdResult that = (GetAppSetIdResult)o;
        return this.mStatusCode == that.mStatusCode && Objects.equals(this.mErrorMessage, that.mErrorMessage) && Objects.equals(this.mAppSetId, that.mAppSetId) && this.mAppSetIdScope == that.mAppSetIdScope;
    }

    public int hashCode() {
        return Objects.hash(this.mStatusCode, this.mErrorMessage, this.mAppSetId, this.mAppSetIdScope);
    }

    public static class Builder {
        private int mStatusCode;
        private String mErrorMessage;
        private String mAppSetId;
        private int mAppSetIdScope;

        public Builder setStatusCode(int statusCode) {
            this.mStatusCode = statusCode;
            return this;
        }

        public Builder setErrorMessage(String errorMessage) {
            this.mErrorMessage = errorMessage;
            return this;
        }

        public Builder setAppSetId(String appSetId) {
            this.mAppSetId = appSetId;
            return this;
        }

        public Builder setAppSetIdScope(int scope) {
            this.mAppSetIdScope = scope;
            return this;
        }

        public GetAppSetIdResult build() {
            if (this.mAppSetId == null) {
                throw new IllegalArgumentException("appSetId is null");
            }
            return new GetAppSetIdResult(this.mStatusCode, this.mErrorMessage, this.mAppSetId, this.mAppSetIdScope);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AppSetIdScope {
    }
}

