/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.adservices.common.AdFilters;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AdData
implements Parcelable {
    private final Uri mRenderUri;
    private final String mMetadata;
    private final Set<String> mAdCounterKeys;
    private final AdFilters mAdFilters;
    public static final Parcelable.Creator<AdData> CREATOR = new Parcelable.Creator<AdData>(){

        @Override
        public AdData createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new AdData(in);
        }

        public AdData[] newArray(int size) {
            return new AdData[size];
        }
    };

    private AdData(Builder builder) {
        Objects.requireNonNull(builder);
        this.mRenderUri = builder.mRenderUri;
        this.mMetadata = builder.mMetadata;
        this.mAdCounterKeys = builder.mAdCounterKeys;
        this.mAdFilters = builder.mAdFilters;
    }

    private AdData(Parcel in) {
        Objects.requireNonNull(in);
        this.mRenderUri = Uri.CREATOR.createFromParcel(in);
        this.mMetadata = in.readString();
        this.mAdCounterKeys = AdServicesParcelableUtil.readNullableFromParcel(in, AdServicesParcelableUtil::readStringSetFromParcel);
        this.mAdFilters = AdServicesParcelableUtil.readNullableFromParcel(in, AdFilters.CREATOR::createFromParcel);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        this.mRenderUri.writeToParcel(dest, flags);
        dest.writeString(this.mMetadata);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mAdCounterKeys, AdServicesParcelableUtil::writeStringSetToParcel);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mAdFilters, (targetParcel, sourceFilters) -> sourceFilters.writeToParcel(targetParcel, flags));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public Uri getRenderUri() {
        return this.mRenderUri;
    }

    public String getMetadata() {
        return this.mMetadata;
    }

    public Set<String> getAdCounterKeys() {
        return this.mAdCounterKeys;
    }

    public AdFilters getAdFilters() {
        return this.mAdFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdData)) {
            return false;
        }
        AdData adData = (AdData)o;
        return this.mRenderUri.equals(adData.mRenderUri) && this.mMetadata.equals(adData.mMetadata) && this.mAdCounterKeys.equals(adData.mAdCounterKeys) && Objects.equals(this.mAdFilters, adData.mAdFilters);
    }

    public int hashCode() {
        return Objects.hash(this.mRenderUri, this.mMetadata, this.mAdCounterKeys, this.mAdFilters);
    }

    public String toString() {
        return "AdData{mRenderUri=" + this.mRenderUri + ", mMetadata='" + this.mMetadata + '\'' + this.generateAdCounterKeyString() + this.generateAdFilterString() + '}';
    }

    private String generateAdCounterKeyString() {
        return "";
    }

    private String generateAdFilterString() {
        return "";
    }

    public static class Builder {
        private Uri mRenderUri;
        private String mMetadata;
        private Set<String> mAdCounterKeys = new HashSet<String>();
        private AdFilters mAdFilters;

        public Builder setRenderUri(Uri renderUri) {
            Objects.requireNonNull(renderUri);
            this.mRenderUri = renderUri;
            return this;
        }

        public Builder setMetadata(String metadata) {
            Objects.requireNonNull(metadata);
            this.mMetadata = metadata;
            return this;
        }

        public Builder setAdCounterKeys(Set<String> adCounterKeys) {
            Objects.requireNonNull(adCounterKeys);
            this.mAdCounterKeys = adCounterKeys;
            return this;
        }

        public Builder setAdFilters(AdFilters adFilters) {
            this.mAdFilters = adFilters;
            return this;
        }

        public AdData build() {
            Objects.requireNonNull(this.mRenderUri);
            Objects.requireNonNull(this.mMetadata);
            return new AdData(this);
        }
    }
}

