/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.IAdServicesCommonCallback;
import android.adservices.common.IAdServicesCommonService;
import android.adservices.common.IsAdServicesEnabledResult;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os._Original_Build;
import androidx.annotation.RequiresApi;
import com.android.adservices.LogUtil;
import com.android.adservices.ServiceBinder;
import java.util.concurrent.Executor;

@SystemApi
@RequiresApi(value=31)
public class AdServicesCommonManager {
    public static final String AD_SERVICES_COMMON_SERVICE = "ad_services_common_service";
    private final Context mContext;
    private final ServiceBinder<IAdServicesCommonService> mAdServicesCommonServiceBinder;

    public static AdServicesCommonManager get(Context context) {
        return _Original_Build.VERSION.SDK_INT >= 33 ? context.getSystemService(AdServicesCommonManager.class) : new AdServicesCommonManager(context);
    }

    public AdServicesCommonManager(Context context) {
        this.mContext = context;
        this.mAdServicesCommonServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.AD_SERVICES_COMMON_SERVICE", IAdServicesCommonService.Stub::asInterface);
    }

    private IAdServicesCommonService getService() {
        IAdServicesCommonService service = this.mAdServicesCommonServiceBinder.getService();
        if (service == null) {
            throw new IllegalStateException("Unable to find the service");
        }
        return service;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_STATE")
    public void isAdServicesEnabled(final Executor executor, final OutcomeReceiver<Boolean, Exception> callback) {
        IAdServicesCommonService service = this.getService();
        try {
            service.isAdServicesEnabled(new IAdServicesCommonCallback.Stub(){

                @Override
                public void onResult(IsAdServicesEnabledResult result) {
                    executor.execute(() -> callback.onResult(result.getAdServicesEnabled()));
                }

                @Override
                public void onFailure(int statusCode) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(statusCode)));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
            executor.execute(() -> callback.onError(new IllegalStateException("Internal Error!", e)));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_ADSERVICES_STATE")
    public void setAdServicesEnabled(boolean adServicesEntryPointEnabled, boolean adIdEnabled) {
        IAdServicesCommonService service = this.getService();
        try {
            service.setAdServicesEnabled(adServicesEntryPointEnabled, adIdEnabled);
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
        }
    }
}

