/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.adservices.common.AdServicesResponse;
import android.os.LimitExceededException;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.TimeoutException;

public class AdServicesStatusUtils {
    public static final int STATUS_UNSET = -1;
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_INTERNAL_ERROR = 1;
    public static final int STATUS_INVALID_ARGUMENT = 2;
    public static final int STATUS_UNKNOWN_ERROR = 3;
    public static final int STATUS_IO_ERROR = 4;
    public static final int STATUS_RATE_LIMIT_REACHED = 5;
    public static final int STATUS_KILLSWITCH_ENABLED = 6;
    public static final int STATUS_USER_CONSENT_REVOKED = 7;
    public static final int STATUS_ADSERVICES_DISABLED = 8;
    public static final int STATUS_PERMISSION_NOT_REQUESTED = 9;
    public static final int STATUS_CALLER_NOT_ALLOWED = 10;
    public static final int STATUS_BACKGROUND_CALLER = 11;
    public static final int STATUS_UNAUTHORIZED = 12;
    public static final int STATUS_TIMEOUT = 13;
    public static final int STATUS_JS_SANDBOX_UNAVAILABLE = 14;
    public static final String ILLEGAL_STATE_EXCEPTION_ERROR_MESSAGE = "Service is not available.";
    public static final String RATE_LIMIT_REACHED_ERROR_MESSAGE = "API rate limit exceeded.";
    public static final String SECURITY_EXCEPTION_PERMISSION_NOT_REQUESTED_ERROR_MESSAGE = "Caller is not authorized to call this API. Permission was not requested.";
    public static final String SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ERROR_MESSAGE = "Caller is not authorized to call this API. Caller is not allowed.";
    public static final String ILLEGAL_STATE_BACKGROUND_CALLER_ERROR_MESSAGE = "Background thread is not allowed to call this service.";
    public static final String SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ON_BEHALF_ERROR_MESSAGE = "Caller is not allowed to perform this operation on behalf of the given package.";
    public static final String TIMED_OUT_ERROR_MESSAGE = "API timed out.";

    public static boolean isSuccess(int statusCode) {
        return statusCode == 0;
    }

    public static Exception asException(int statusCode) {
        switch (statusCode) {
            case 2: {
                return new IllegalArgumentException();
            }
            case 4: {
                return new IOException();
            }
            case 6: 
            case 7: 
            case 14: {
                return new IllegalStateException(ILLEGAL_STATE_EXCEPTION_ERROR_MESSAGE);
            }
            case 9: {
                return new SecurityException(SECURITY_EXCEPTION_PERMISSION_NOT_REQUESTED_ERROR_MESSAGE);
            }
            case 10: {
                return new SecurityException(SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ERROR_MESSAGE);
            }
            case 11: {
                return new IllegalStateException(ILLEGAL_STATE_BACKGROUND_CALLER_ERROR_MESSAGE);
            }
            case 12: {
                return new SecurityException(SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ON_BEHALF_ERROR_MESSAGE);
            }
            case 13: {
                return new TimeoutException(TIMED_OUT_ERROR_MESSAGE);
            }
            case 5: {
                return new LimitExceededException(RATE_LIMIT_REACHED_ERROR_MESSAGE);
            }
        }
        return new IllegalStateException();
    }

    public static Exception asException(AdServicesResponse adServicesResponse) {
        return AdServicesStatusUtils.asException(adServicesResponse.getStatusCode());
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatusCode {
    }
}

