/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import com.android.internal.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppInstallFilters
implements Parcelable {
    @VisibleForTesting
    public static final String PACKAGE_NAMES_FIELD_NAME = "package_names";
    private final Set<String> mPackageNames;
    public static final Parcelable.Creator<AppInstallFilters> CREATOR = new Parcelable.Creator<AppInstallFilters>(){

        @Override
        public AppInstallFilters createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new AppInstallFilters(in);
        }

        public AppInstallFilters[] newArray(int size) {
            return new AppInstallFilters[size];
        }
    };

    private AppInstallFilters(Builder builder) {
        Objects.requireNonNull(builder);
        this.mPackageNames = builder.mPackageNames;
    }

    private AppInstallFilters(Parcel in) {
        Objects.requireNonNull(in);
        this.mPackageNames = AdServicesParcelableUtil.readStringSetFromParcel(in);
    }

    public Set<String> getPackageNames() {
        return this.mPackageNames;
    }

    public int getSizeInBytes() {
        int totalSize = 0;
        for (String packageName : this.mPackageNames) {
            totalSize += packageName.getBytes().length;
        }
        return totalSize;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject toReturn = new JSONObject();
        JSONArray packageNames = new JSONArray();
        for (String packageName : this.mPackageNames) {
            packageNames.put(packageName);
        }
        toReturn.put(PACKAGE_NAMES_FIELD_NAME, packageNames);
        return toReturn;
    }

    public static AppInstallFilters fromJson(JSONObject json) throws JSONException {
        JSONArray serializedPackageNames = json.getJSONArray(PACKAGE_NAMES_FIELD_NAME);
        HashSet<String> packageNames = new HashSet<String>();
        for (int i = 0; i < serializedPackageNames.length(); ++i) {
            Object packageName = serializedPackageNames.get(i);
            if (!(packageName instanceof String)) {
                throw new JSONException("Found non-string package name when de-serializing AppInstallFilters");
            }
            packageNames.add((String)packageName);
        }
        return new Builder().setPackageNames(packageNames).build();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        AdServicesParcelableUtil.writeStringSetToParcel(dest, this.mPackageNames);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppInstallFilters)) {
            return false;
        }
        AppInstallFilters that = (AppInstallFilters)o;
        return this.mPackageNames.equals(that.mPackageNames);
    }

    public int hashCode() {
        return Objects.hash(this.mPackageNames);
    }

    public String toString() {
        return "AppInstallFilters{mPackageNames=" + this.mPackageNames + '}';
    }

    public static class Builder {
        private Set<String> mPackageNames = new HashSet<String>();

        public Builder setPackageNames(Set<String> packageNames) {
            Objects.requireNonNull(packageNames);
            this.mPackageNames = packageNames;
            return this;
        }

        public AppInstallFilters build() {
            return new AppInstallFilters(this);
        }
    }
}

