/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.adservices.common.KeyedFrequencyCap;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FrequencyCapFilters
implements Parcelable {
    public static final int AD_EVENT_TYPE_INVALID = -1;
    public static final int AD_EVENT_TYPE_WIN = 0;
    public static final int AD_EVENT_TYPE_IMPRESSION = 1;
    public static final int AD_EVENT_TYPE_VIEW = 2;
    public static final int AD_EVENT_TYPE_CLICK = 3;
    @VisibleForTesting
    public static final String WIN_EVENTS_FIELD_NAME = "win";
    @VisibleForTesting
    public static final String IMPRESSION_EVENTS_FIELD_NAME = "impression";
    @VisibleForTesting
    public static final String VIEW_EVENTS_FIELD_NAME = "view";
    @VisibleForTesting
    public static final String CLICK_EVENTS_FIELD_NAME = "click";
    private final Set<KeyedFrequencyCap> mKeyedFrequencyCapsForWinEvents;
    private final Set<KeyedFrequencyCap> mKeyedFrequencyCapsForImpressionEvents;
    private final Set<KeyedFrequencyCap> mKeyedFrequencyCapsForViewEvents;
    private final Set<KeyedFrequencyCap> mKeyedFrequencyCapsForClickEvents;
    public static final Parcelable.Creator<FrequencyCapFilters> CREATOR = new Parcelable.Creator<FrequencyCapFilters>(){

        @Override
        public FrequencyCapFilters createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new FrequencyCapFilters(in);
        }

        public FrequencyCapFilters[] newArray(int size) {
            return new FrequencyCapFilters[size];
        }
    };

    private FrequencyCapFilters(Builder builder) {
        Objects.requireNonNull(builder);
        this.mKeyedFrequencyCapsForWinEvents = builder.mKeyedFrequencyCapsForWinEvents;
        this.mKeyedFrequencyCapsForImpressionEvents = builder.mKeyedFrequencyCapsForImpressionEvents;
        this.mKeyedFrequencyCapsForViewEvents = builder.mKeyedFrequencyCapsForViewEvents;
        this.mKeyedFrequencyCapsForClickEvents = builder.mKeyedFrequencyCapsForClickEvents;
    }

    private FrequencyCapFilters(Parcel in) {
        Objects.requireNonNull(in);
        this.mKeyedFrequencyCapsForWinEvents = AdServicesParcelableUtil.readSetFromParcel(in, KeyedFrequencyCap.CREATOR);
        this.mKeyedFrequencyCapsForImpressionEvents = AdServicesParcelableUtil.readSetFromParcel(in, KeyedFrequencyCap.CREATOR);
        this.mKeyedFrequencyCapsForViewEvents = AdServicesParcelableUtil.readSetFromParcel(in, KeyedFrequencyCap.CREATOR);
        this.mKeyedFrequencyCapsForClickEvents = AdServicesParcelableUtil.readSetFromParcel(in, KeyedFrequencyCap.CREATOR);
    }

    public Set<KeyedFrequencyCap> getKeyedFrequencyCapsForWinEvents() {
        return this.mKeyedFrequencyCapsForWinEvents;
    }

    public Set<KeyedFrequencyCap> getKeyedFrequencyCapsForImpressionEvents() {
        return this.mKeyedFrequencyCapsForImpressionEvents;
    }

    public Set<KeyedFrequencyCap> getKeyedFrequencyCapsForViewEvents() {
        return this.mKeyedFrequencyCapsForViewEvents;
    }

    public Set<KeyedFrequencyCap> getKeyedFrequencyCapsForClickEvents() {
        return this.mKeyedFrequencyCapsForClickEvents;
    }

    public int getSizeInBytes() {
        return this.getSizeInBytesOfFcapSet(this.mKeyedFrequencyCapsForWinEvents) + this.getSizeInBytesOfFcapSet(this.mKeyedFrequencyCapsForImpressionEvents) + this.getSizeInBytesOfFcapSet(this.mKeyedFrequencyCapsForViewEvents) + this.getSizeInBytesOfFcapSet(this.mKeyedFrequencyCapsForClickEvents);
    }

    private int getSizeInBytesOfFcapSet(Set<KeyedFrequencyCap> fcaps) {
        int toReturn = 0;
        for (KeyedFrequencyCap fcap : fcaps) {
            toReturn += fcap.getSizeInBytes();
        }
        return toReturn;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject toReturn = new JSONObject();
        toReturn.put(WIN_EVENTS_FIELD_NAME, FrequencyCapFilters.fcapSetToJsonArray(this.mKeyedFrequencyCapsForWinEvents));
        toReturn.put(IMPRESSION_EVENTS_FIELD_NAME, FrequencyCapFilters.fcapSetToJsonArray(this.mKeyedFrequencyCapsForImpressionEvents));
        toReturn.put(VIEW_EVENTS_FIELD_NAME, FrequencyCapFilters.fcapSetToJsonArray(this.mKeyedFrequencyCapsForViewEvents));
        toReturn.put(CLICK_EVENTS_FIELD_NAME, FrequencyCapFilters.fcapSetToJsonArray(this.mKeyedFrequencyCapsForClickEvents));
        return toReturn;
    }

    private static JSONArray fcapSetToJsonArray(Set<KeyedFrequencyCap> fcapSet) throws JSONException {
        JSONArray toReturn = new JSONArray();
        for (KeyedFrequencyCap fcap : fcapSet) {
            toReturn.put(fcap.toJson());
        }
        return toReturn;
    }

    public static FrequencyCapFilters fromJson(JSONObject json) throws JSONException {
        Builder builder = new Builder();
        if (json.has(WIN_EVENTS_FIELD_NAME)) {
            builder.setKeyedFrequencyCapsForWinEvents(FrequencyCapFilters.jsonArrayToFcapSet(json.getJSONArray(WIN_EVENTS_FIELD_NAME)));
        }
        if (json.has(IMPRESSION_EVENTS_FIELD_NAME)) {
            builder.setKeyedFrequencyCapsForImpressionEvents(FrequencyCapFilters.jsonArrayToFcapSet(json.getJSONArray(IMPRESSION_EVENTS_FIELD_NAME)));
        }
        if (json.has(VIEW_EVENTS_FIELD_NAME)) {
            builder.setKeyedFrequencyCapsForViewEvents(FrequencyCapFilters.jsonArrayToFcapSet(json.getJSONArray(VIEW_EVENTS_FIELD_NAME)));
        }
        if (json.has(CLICK_EVENTS_FIELD_NAME)) {
            builder.setKeyedFrequencyCapsForClickEvents(FrequencyCapFilters.jsonArrayToFcapSet(json.getJSONArray(CLICK_EVENTS_FIELD_NAME)));
        }
        return builder.build();
    }

    private static Set<KeyedFrequencyCap> jsonArrayToFcapSet(JSONArray json) throws JSONException {
        HashSet<KeyedFrequencyCap> toReturn = new HashSet<KeyedFrequencyCap>();
        for (int i = 0; i < json.length(); ++i) {
            toReturn.add(KeyedFrequencyCap.fromJson(json.getJSONObject(i)));
        }
        return toReturn;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        AdServicesParcelableUtil.writeSetToParcel(dest, this.mKeyedFrequencyCapsForWinEvents);
        AdServicesParcelableUtil.writeSetToParcel(dest, this.mKeyedFrequencyCapsForImpressionEvents);
        AdServicesParcelableUtil.writeSetToParcel(dest, this.mKeyedFrequencyCapsForViewEvents);
        AdServicesParcelableUtil.writeSetToParcel(dest, this.mKeyedFrequencyCapsForClickEvents);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FrequencyCapFilters)) {
            return false;
        }
        FrequencyCapFilters that = (FrequencyCapFilters)o;
        return this.mKeyedFrequencyCapsForWinEvents.equals(that.mKeyedFrequencyCapsForWinEvents) && this.mKeyedFrequencyCapsForImpressionEvents.equals(that.mKeyedFrequencyCapsForImpressionEvents) && this.mKeyedFrequencyCapsForViewEvents.equals(that.mKeyedFrequencyCapsForViewEvents) && this.mKeyedFrequencyCapsForClickEvents.equals(that.mKeyedFrequencyCapsForClickEvents);
    }

    public int hashCode() {
        return Objects.hash(this.mKeyedFrequencyCapsForWinEvents, this.mKeyedFrequencyCapsForImpressionEvents, this.mKeyedFrequencyCapsForViewEvents, this.mKeyedFrequencyCapsForClickEvents);
    }

    public String toString() {
        return "FrequencyCapFilters{mKeyedFrequencyCapsForWinEvents=" + this.mKeyedFrequencyCapsForWinEvents + ", mKeyedFrequencyCapsForImpressionEvents=" + this.mKeyedFrequencyCapsForImpressionEvents + ", mKeyedFrequencyCapsForViewEvents=" + this.mKeyedFrequencyCapsForViewEvents + ", mKeyedFrequencyCapsForClickEvents=" + this.mKeyedFrequencyCapsForClickEvents + '}';
    }

    public static class Builder {
        private Set<KeyedFrequencyCap> mKeyedFrequencyCapsForWinEvents = new HashSet<KeyedFrequencyCap>();
        private Set<KeyedFrequencyCap> mKeyedFrequencyCapsForImpressionEvents = new HashSet<KeyedFrequencyCap>();
        private Set<KeyedFrequencyCap> mKeyedFrequencyCapsForViewEvents = new HashSet<KeyedFrequencyCap>();
        private Set<KeyedFrequencyCap> mKeyedFrequencyCapsForClickEvents = new HashSet<KeyedFrequencyCap>();

        public Builder setKeyedFrequencyCapsForWinEvents(Set<KeyedFrequencyCap> keyedFrequencyCapsForWinEvents) {
            Objects.requireNonNull(keyedFrequencyCapsForWinEvents);
            this.mKeyedFrequencyCapsForWinEvents = keyedFrequencyCapsForWinEvents;
            return this;
        }

        public Builder setKeyedFrequencyCapsForImpressionEvents(Set<KeyedFrequencyCap> keyedFrequencyCapsForImpressionEvents) {
            Objects.requireNonNull(keyedFrequencyCapsForImpressionEvents);
            this.mKeyedFrequencyCapsForImpressionEvents = keyedFrequencyCapsForImpressionEvents;
            return this;
        }

        public Builder setKeyedFrequencyCapsForViewEvents(Set<KeyedFrequencyCap> keyedFrequencyCapsForViewEvents) {
            Objects.requireNonNull(keyedFrequencyCapsForViewEvents);
            this.mKeyedFrequencyCapsForViewEvents = keyedFrequencyCapsForViewEvents;
            return this;
        }

        public Builder setKeyedFrequencyCapsForClickEvents(Set<KeyedFrequencyCap> keyedFrequencyCapsForClickEvents) {
            Objects.requireNonNull(keyedFrequencyCapsForClickEvents);
            this.mKeyedFrequencyCapsForClickEvents = keyedFrequencyCapsForClickEvents;
            return this;
        }

        public FrequencyCapFilters build() {
            return new FrequencyCapFilters(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdEventType {
    }
}

