/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.time.Duration;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyedFrequencyCap
implements Parcelable {
    @VisibleForTesting
    public static final String AD_COUNTER_KEY_FIELD_NAME = "ad_counter_key";
    @VisibleForTesting
    public static final String MAX_COUNT_FIELD_NAME = "max_count";
    @VisibleForTesting
    public static final String INTERVAL_FIELD_NAME = "interval_in_seconds";
    @VisibleForTesting
    public static final String JSON_ERROR_POSTFIX = " must be a String.";
    private static final int SIZE_OF_FIXED_FIELDS = 16;
    private final String mAdCounterKey;
    private final int mMaxCount;
    private final Duration mInterval;
    public static final Parcelable.Creator<KeyedFrequencyCap> CREATOR = new Parcelable.Creator<KeyedFrequencyCap>(){

        @Override
        public KeyedFrequencyCap createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new KeyedFrequencyCap(in);
        }

        public KeyedFrequencyCap[] newArray(int size) {
            return new KeyedFrequencyCap[size];
        }
    };

    private KeyedFrequencyCap(Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdCounterKey = builder.mAdCounterKey;
        this.mMaxCount = builder.mMaxCount;
        this.mInterval = builder.mInterval;
    }

    private KeyedFrequencyCap(Parcel in) {
        Objects.requireNonNull(in);
        this.mAdCounterKey = in.readString();
        this.mMaxCount = in.readInt();
        this.mInterval = Duration.ofSeconds(in.readLong());
    }

    public String getAdCounterKey() {
        return this.mAdCounterKey;
    }

    public int getMaxCount() {
        return this.mMaxCount;
    }

    public Duration getInterval() {
        return this.mInterval;
    }

    public int getSizeInBytes() {
        return this.mAdCounterKey.getBytes().length + 16;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject toReturn = new JSONObject();
        toReturn.put(AD_COUNTER_KEY_FIELD_NAME, this.mAdCounterKey);
        toReturn.put(MAX_COUNT_FIELD_NAME, this.mMaxCount);
        toReturn.put(INTERVAL_FIELD_NAME, this.mInterval.getSeconds());
        return toReturn;
    }

    public static KeyedFrequencyCap fromJson(JSONObject json) throws JSONException {
        Object adCounterKey = json.get(AD_COUNTER_KEY_FIELD_NAME);
        if (!(adCounterKey instanceof String)) {
            throw new JSONException("ad_counter_key must be a String.");
        }
        return new Builder().setAdCounterKey((String)adCounterKey).setMaxCount(json.getInt(MAX_COUNT_FIELD_NAME)).setInterval(Duration.ofSeconds(json.getLong(INTERVAL_FIELD_NAME))).build();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeString(this.mAdCounterKey);
        dest.writeInt(this.mMaxCount);
        dest.writeLong(this.mInterval.getSeconds());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyedFrequencyCap)) {
            return false;
        }
        KeyedFrequencyCap that = (KeyedFrequencyCap)o;
        return this.mMaxCount == that.mMaxCount && this.mInterval.equals(that.mInterval) && this.mAdCounterKey.equals(that.mAdCounterKey);
    }

    public int hashCode() {
        return Objects.hash(this.mAdCounterKey, this.mMaxCount, this.mInterval);
    }

    public String toString() {
        return "KeyedFrequencyCap{mAdCounterKey='" + this.mAdCounterKey + '\'' + ", mMaxCount=" + this.mMaxCount + ", mInterval=" + this.mInterval + '}';
    }

    public static class Builder {
        private String mAdCounterKey;
        private int mMaxCount;
        private Duration mInterval;

        public Builder setAdCounterKey(String adCounterKey) {
            Objects.requireNonNull(adCounterKey, "Ad counter key must not be null");
            Preconditions.checkStringNotEmpty(adCounterKey, "Ad counter key must not be empty");
            this.mAdCounterKey = adCounterKey;
            return this;
        }

        public Builder setMaxCount(int maxCount) {
            Preconditions.checkArgument(maxCount >= 0, "Max count must be non-negative");
            this.mMaxCount = maxCount;
            return this;
        }

        public Builder setInterval(Duration interval) {
            Objects.requireNonNull(interval, "Interval must not be null");
            Preconditions.checkArgument(interval.getSeconds() > 0L, "Interval in seconds must be positive and non-zero");
            this.mInterval = interval;
            return this;
        }

        public KeyedFrequencyCap build() throws NullPointerException, IllegalArgumentException {
            Objects.requireNonNull(this.mAdCounterKey, "Event key must be set");
            Preconditions.checkArgument(this.mMaxCount >= 0, "Max count must be non-negative");
            Objects.requireNonNull(this.mInterval, "Interval must not be null");
            return new KeyedFrequencyCap(this);
        }
    }
}

