/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.customaudience;

import android.adservices.common.AdData;
import android.adservices.common.AdSelectionSignals;
import android.adservices.common.AdTechIdentifier;
import android.adservices.customaudience.TrustedBiddingData;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

public class CustomAudience
implements Parcelable {
    private final AdTechIdentifier mBuyer;
    private final String mName;
    private final Instant mActivationTime;
    private final Instant mExpirationTime;
    private final Uri mDailyUpdateUri;
    private final AdSelectionSignals mUserBiddingSignals;
    private final TrustedBiddingData mTrustedBiddingData;
    private final Uri mBiddingLogicUri;
    private final List<AdData> mAds;
    public static final Parcelable.Creator<CustomAudience> CREATOR = new Parcelable.Creator<CustomAudience>(){

        @Override
        public CustomAudience createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new CustomAudience(in);
        }

        public CustomAudience[] newArray(int size) {
            return new CustomAudience[size];
        }
    };

    private CustomAudience(Builder builder) {
        Objects.requireNonNull(builder);
        this.mBuyer = builder.mBuyer;
        this.mName = builder.mName;
        this.mActivationTime = builder.mActivationTime;
        this.mExpirationTime = builder.mExpirationTime;
        this.mDailyUpdateUri = builder.mDailyUpdateUri;
        this.mUserBiddingSignals = builder.mUserBiddingSignals;
        this.mTrustedBiddingData = builder.mTrustedBiddingData;
        this.mBiddingLogicUri = builder.mBiddingLogicUri;
        this.mAds = builder.mAds;
    }

    private CustomAudience(Parcel in) {
        Objects.requireNonNull(in);
        this.mBuyer = AdTechIdentifier.CREATOR.createFromParcel(in);
        this.mName = in.readString();
        this.mActivationTime = AdServicesParcelableUtil.readNullableFromParcel(in, sourceParcel -> Instant.ofEpochMilli(sourceParcel.readLong()));
        this.mExpirationTime = AdServicesParcelableUtil.readNullableFromParcel(in, sourceParcel -> Instant.ofEpochMilli(sourceParcel.readLong()));
        this.mDailyUpdateUri = Uri.CREATOR.createFromParcel(in);
        this.mUserBiddingSignals = AdServicesParcelableUtil.readNullableFromParcel(in, AdSelectionSignals.CREATOR::createFromParcel);
        this.mTrustedBiddingData = AdServicesParcelableUtil.readNullableFromParcel(in, TrustedBiddingData.CREATOR::createFromParcel);
        this.mBiddingLogicUri = Uri.CREATOR.createFromParcel(in);
        this.mAds = in.createTypedArrayList(AdData.CREATOR);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        this.mBuyer.writeToParcel(dest, flags);
        dest.writeString(this.mName);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mActivationTime, (targetParcel, sourceInstant) -> targetParcel.writeLong(sourceInstant.toEpochMilli()));
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mExpirationTime, (targetParcel, sourceInstant) -> targetParcel.writeLong(sourceInstant.toEpochMilli()));
        this.mDailyUpdateUri.writeToParcel(dest, flags);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mUserBiddingSignals, (targetParcel, sourceSignals) -> sourceSignals.writeToParcel(targetParcel, flags));
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mTrustedBiddingData, (targetParcel, sourceData) -> sourceData.writeToParcel(targetParcel, flags));
        this.mBiddingLogicUri.writeToParcel(dest, flags);
        dest.writeTypedList(this.mAds);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    public String getName() {
        return this.mName;
    }

    public Instant getActivationTime() {
        return this.mActivationTime;
    }

    public Instant getExpirationTime() {
        return this.mExpirationTime;
    }

    public Uri getDailyUpdateUri() {
        return this.mDailyUpdateUri;
    }

    public AdSelectionSignals getUserBiddingSignals() {
        return this.mUserBiddingSignals;
    }

    public TrustedBiddingData getTrustedBiddingData() {
        return this.mTrustedBiddingData;
    }

    public Uri getBiddingLogicUri() {
        return this.mBiddingLogicUri;
    }

    public List<AdData> getAds() {
        return this.mAds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomAudience)) {
            return false;
        }
        CustomAudience that = (CustomAudience)o;
        return this.mBuyer.equals(that.mBuyer) && this.mName.equals(that.mName) && Objects.equals(this.mActivationTime, that.mActivationTime) && Objects.equals(this.mExpirationTime, that.mExpirationTime) && this.mDailyUpdateUri.equals(that.mDailyUpdateUri) && Objects.equals(this.mUserBiddingSignals, that.mUserBiddingSignals) && Objects.equals(this.mTrustedBiddingData, that.mTrustedBiddingData) && this.mBiddingLogicUri.equals(that.mBiddingLogicUri) && this.mAds.equals(that.mAds);
    }

    public int hashCode() {
        return Objects.hash(this.mBuyer, this.mName, this.mActivationTime, this.mExpirationTime, this.mDailyUpdateUri, this.mUserBiddingSignals, this.mTrustedBiddingData, this.mBiddingLogicUri, this.mAds);
    }

    public static class Builder {
        private AdTechIdentifier mBuyer;
        private String mName;
        private Instant mActivationTime;
        private Instant mExpirationTime;
        private Uri mDailyUpdateUri;
        private AdSelectionSignals mUserBiddingSignals;
        private TrustedBiddingData mTrustedBiddingData;
        private Uri mBiddingLogicUri;
        private List<AdData> mAds;

        public Builder setBuyer(AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer);
            this.mBuyer = buyer;
            return this;
        }

        public Builder setName(String name) {
            Objects.requireNonNull(name);
            this.mName = name;
            return this;
        }

        public Builder setActivationTime(Instant activationTime) {
            this.mActivationTime = activationTime;
            return this;
        }

        public Builder setExpirationTime(Instant expirationTime) {
            this.mExpirationTime = expirationTime;
            return this;
        }

        public Builder setDailyUpdateUri(Uri dailyUpdateUri) {
            Objects.requireNonNull(dailyUpdateUri);
            this.mDailyUpdateUri = dailyUpdateUri;
            return this;
        }

        public Builder setUserBiddingSignals(AdSelectionSignals userBiddingSignals) {
            this.mUserBiddingSignals = userBiddingSignals;
            return this;
        }

        public Builder setTrustedBiddingData(TrustedBiddingData trustedBiddingData) {
            this.mTrustedBiddingData = trustedBiddingData;
            return this;
        }

        public Builder setBiddingLogicUri(Uri biddingLogicUri) {
            Objects.requireNonNull(biddingLogicUri);
            this.mBiddingLogicUri = biddingLogicUri;
            return this;
        }

        public Builder setAds(List<AdData> ads) {
            this.mAds = ads;
            return this;
        }

        public CustomAudience build() {
            Objects.requireNonNull(this.mBuyer);
            Objects.requireNonNull(this.mName);
            Objects.requireNonNull(this.mDailyUpdateUri);
            Objects.requireNonNull(this.mBiddingLogicUri);
            if (this.mAds == null) {
                this.mAds = List.of();
            }
            return new CustomAudience(this);
        }
    }
}

