/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.customaudience;

import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.AdTechIdentifier;
import android.adservices.common.FledgeErrorResponse;
import android.adservices.common.SandboxedSdkContextUtils;
import android.adservices.customaudience.CustomAudience;
import android.adservices.customaudience.ICustomAudienceCallback;
import android.adservices.customaudience.ICustomAudienceService;
import android.adservices.customaudience.JoinCustomAudienceRequest;
import android.adservices.customaudience.LeaveCustomAudienceRequest;
import android.adservices.customaudience.TestCustomAudienceManager;
import android.annotation.RequiresPermission;
import android.app.sdksandbox.SandboxedSdkContext;
import android.content.Context;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os._Original_Build;
import androidx.annotation.RequiresApi;
import com.android.adservices.LoggerFactory;
import com.android.adservices.ServiceBinder;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(value=31)
public class CustomAudienceManager {
    private static final LoggerFactory.Logger sLogger = LoggerFactory.getFledgeLogger();
    public static final String CUSTOM_AUDIENCE_SERVICE = "custom_audience_service";
    private Context mContext;
    private ServiceBinder<ICustomAudienceService> mServiceBinder;

    public static CustomAudienceManager get(Context context) {
        return _Original_Build.VERSION.SDK_INT >= 33 ? context.getSystemService(CustomAudienceManager.class) : new CustomAudienceManager(context);
    }

    public CustomAudienceManager(Context context) {
        Objects.requireNonNull(context);
        this.initialize(context);
    }

    public CustomAudienceManager initialize(Context context) {
        Objects.requireNonNull(context);
        this.mContext = context;
        this.mServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.customaudience.CUSTOM_AUDIENCE_SERVICE", ICustomAudienceService.Stub::asInterface);
        return this;
    }

    public TestCustomAudienceManager getTestCustomAudienceManager() {
        return new TestCustomAudienceManager(this, this.getCallerPackageName());
    }

    ICustomAudienceService getService() {
        ICustomAudienceService service = this.mServiceBinder.getService();
        Objects.requireNonNull(service);
        return service;
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void joinCustomAudience(JoinCustomAudienceRequest joinCustomAudienceRequest, final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(joinCustomAudienceRequest);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        CustomAudience customAudience = joinCustomAudienceRequest.getCustomAudience();
        try {
            ICustomAudienceService service = this.getService();
            service.joinCustomAudience(customAudience, this.getCallerPackageName(), new ICustomAudienceCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Internal Error!", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void leaveCustomAudience(LeaveCustomAudienceRequest leaveCustomAudienceRequest, final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(leaveCustomAudienceRequest);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        AdTechIdentifier buyer = leaveCustomAudienceRequest.getBuyer();
        String name = leaveCustomAudienceRequest.getName();
        try {
            ICustomAudienceService service = this.getService();
            service.leaveCustomAudience(this.getCallerPackageName(), buyer, name, new ICustomAudienceCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Internal Error!", e));
        }
    }

    private String getCallerPackageName() {
        SandboxedSdkContext sandboxedSdkContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(this.mContext);
        return sandboxedSdkContext == null ? this.mContext.getPackageName() : sandboxedSdkContext.getClientPackageName();
    }
}

