/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.customaudience;

import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.FledgeErrorResponse;
import android.adservices.customaudience.AddCustomAudienceOverrideRequest;
import android.adservices.customaudience.CustomAudienceManager;
import android.adservices.customaudience.CustomAudienceOverrideCallback;
import android.adservices.customaudience.ICustomAudienceService;
import android.adservices.customaudience.RemoveCustomAudienceOverrideRequest;
import android.annotation.RequiresPermission;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import androidx.annotation.RequiresApi;
import com.android.adservices.LoggerFactory;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(value=31)
public class TestCustomAudienceManager {
    private static final LoggerFactory.Logger sLogger = LoggerFactory.getFledgeLogger();
    private final CustomAudienceManager mCustomAudienceManager;
    private final String mCallerPackageName;

    TestCustomAudienceManager(CustomAudienceManager customAudienceManager, String callerPackageName) {
        Objects.requireNonNull(customAudienceManager);
        Objects.requireNonNull(callerPackageName);
        this.mCustomAudienceManager = customAudienceManager;
        this.mCallerPackageName = callerPackageName;
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void overrideCustomAudienceRemoteInfo(AddCustomAudienceOverrideRequest request, final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            ICustomAudienceService service = this.mCustomAudienceManager.getService();
            service.overrideCustomAudienceRemoteInfo(this.mCallerPackageName, request.getBuyer(), request.getName(), request.getBiddingLogicJs(), request.getBiddingLogicJsVersion(), request.getTrustedBiddingSignals(), new CustomAudienceOverrideCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Internal Error!", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void removeCustomAudienceRemoteInfoOverride(RemoveCustomAudienceOverrideRequest request, final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            ICustomAudienceService service = this.mCustomAudienceManager.getService();
            service.removeCustomAudienceRemoteInfoOverride(this.mCallerPackageName, request.getBuyer(), request.getName(), new CustomAudienceOverrideCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Internal Error!", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void resetAllCustomAudienceOverrides(final Executor executor, final OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            ICustomAudienceService service = this.mCustomAudienceManager.getService();
            service.resetAllCustomAudienceOverrides(new CustomAudienceOverrideCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Internal Error!", e));
        }
    }
}

