/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.net.Uri;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DeletionRequest {
    public static final int DELETION_MODE_ALL = 0;
    public static final int DELETION_MODE_EXCLUDE_INTERNAL_DATA = 1;
    public static final int MATCH_BEHAVIOR_DELETE = 0;
    public static final int MATCH_BEHAVIOR_PRESERVE = 1;
    private final Instant mStart;
    private final Instant mEnd;
    private final List<Uri> mOriginUris;
    private final List<Uri> mDomainUris;
    private final int mMatchBehavior;
    private final int mDeletionMode;

    private DeletionRequest(Builder builder) {
        this.mOriginUris = builder.mOriginUris;
        this.mDomainUris = builder.mDomainUris;
        this.mMatchBehavior = builder.mMatchBehavior;
        this.mDeletionMode = builder.mDeletionMode;
        this.mStart = builder.mStart;
        this.mEnd = builder.mEnd;
    }

    public List<Uri> getOriginUris() {
        return this.mOriginUris;
    }

    public List<Uri> getDomainUris() {
        return this.mDomainUris;
    }

    public int getDeletionMode() {
        return this.mDeletionMode;
    }

    public int getMatchBehavior() {
        return this.mMatchBehavior;
    }

    public Instant getStart() {
        return this.mStart;
    }

    public Instant getEnd() {
        return this.mEnd;
    }

    public static class Builder {
        private Instant mStart = Instant.MIN;
        private Instant mEnd = Instant.MAX;
        private List<Uri> mOriginUris;
        private List<Uri> mDomainUris;
        private int mMatchBehavior;
        private int mDeletionMode;

        public Builder setOriginUris(List<Uri> originUris) {
            this.mOriginUris = originUris;
            return this;
        }

        public Builder setDomainUris(List<Uri> domainUris) {
            this.mDomainUris = domainUris;
            return this;
        }

        public Builder setMatchBehavior(int matchBehavior) {
            this.mMatchBehavior = matchBehavior;
            return this;
        }

        public Builder setDeletionMode(int deletionMode) {
            this.mDeletionMode = deletionMode;
            return this;
        }

        public Builder setStart(Instant start) {
            Objects.requireNonNull(start);
            this.mStart = start;
            return this;
        }

        public Builder setEnd(Instant end) {
            Objects.requireNonNull(end);
            this.mEnd = end;
            return this;
        }

        public DeletionRequest build() {
            if (this.mDomainUris == null) {
                this.mDomainUris = new ArrayList<Uri>();
            }
            if (this.mOriginUris == null) {
                this.mOriginUris = new ArrayList<Uri>();
            }
            return new DeletionRequest(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MatchBehavior {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeletionMode {
    }
}

