/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.adservices.measurement.MeasurementErrorResponse;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMeasurementCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.adservices.measurement.IMeasurementCallback";

    public void onResult() throws RemoteException;

    public void onFailure(MeasurementErrorResponse var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMeasurementCallback {
        static final int TRANSACTION_onResult = 1;
        static final int TRANSACTION_onFailure = 2;

        public Stub() {
            this.attachInterface(this, IMeasurementCallback.DESCRIPTOR);
        }

        public static IMeasurementCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMeasurementCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IMeasurementCallback) {
                return (IMeasurementCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onResult";
                }
                case 2: {
                    return "onFailure";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMeasurementCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.onResult();
                    break;
                }
                case 2: {
                    MeasurementErrorResponse _arg0 = data.readTypedObject(MeasurementErrorResponse.CREATOR);
                    this.onFailure(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IMeasurementCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMeasurementCallback.DESCRIPTOR;
            }

            @Override
            public void onResult() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMeasurementCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(MeasurementErrorResponse responseParcel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMeasurementCallback.DESCRIPTOR);
                    _data.writeTypedObject(responseParcel, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMeasurementCallback {
        @Override
        public void onResult() throws RemoteException {
        }

        @Override
        public void onFailure(MeasurementErrorResponse responseParcel) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

