/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.adservices.common.CallerMetadata;
import android.adservices.measurement.DeletionParam;
import android.adservices.measurement.IMeasurementApiStatusCallback;
import android.adservices.measurement.IMeasurementCallback;
import android.adservices.measurement.RegistrationRequest;
import android.adservices.measurement.StatusParam;
import android.adservices.measurement.WebSourceRegistrationRequestInternal;
import android.adservices.measurement.WebTriggerRegistrationRequestInternal;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMeasurementService
extends IInterface {
    public static final String DESCRIPTOR = "android.adservices.measurement.IMeasurementService";

    public void register(RegistrationRequest var1, CallerMetadata var2, IMeasurementCallback var3) throws RemoteException;

    public void registerWebSource(WebSourceRegistrationRequestInternal var1, CallerMetadata var2, IMeasurementCallback var3) throws RemoteException;

    public void registerWebTrigger(WebTriggerRegistrationRequestInternal var1, CallerMetadata var2, IMeasurementCallback var3) throws RemoteException;

    public void getMeasurementApiStatus(StatusParam var1, CallerMetadata var2, IMeasurementApiStatusCallback var3) throws RemoteException;

    public void deleteRegistrations(DeletionParam var1, CallerMetadata var2, IMeasurementCallback var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMeasurementService {
        static final int TRANSACTION_register = 1;
        static final int TRANSACTION_registerWebSource = 2;
        static final int TRANSACTION_registerWebTrigger = 3;
        static final int TRANSACTION_getMeasurementApiStatus = 4;
        static final int TRANSACTION_deleteRegistrations = 5;

        public Stub() {
            this.attachInterface(this, IMeasurementService.DESCRIPTOR);
        }

        public static IMeasurementService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMeasurementService.DESCRIPTOR);
            if (iin != null && iin instanceof IMeasurementService) {
                return (IMeasurementService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "register";
                }
                case 2: {
                    return "registerWebSource";
                }
                case 3: {
                    return "registerWebTrigger";
                }
                case 4: {
                    return "getMeasurementApiStatus";
                }
                case 5: {
                    return "deleteRegistrations";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMeasurementService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    RegistrationRequest _arg0 = data.readTypedObject(RegistrationRequest.CREATOR);
                    CallerMetadata _arg1 = data.readTypedObject(CallerMetadata.CREATOR);
                    IMeasurementCallback _arg2 = IMeasurementCallback.Stub.asInterface(data.readStrongBinder());
                    this.register(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    WebSourceRegistrationRequestInternal _arg0 = data.readTypedObject(WebSourceRegistrationRequestInternal.CREATOR);
                    CallerMetadata _arg1 = data.readTypedObject(CallerMetadata.CREATOR);
                    IMeasurementCallback _arg2 = IMeasurementCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerWebSource(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    WebTriggerRegistrationRequestInternal _arg0 = data.readTypedObject(WebTriggerRegistrationRequestInternal.CREATOR);
                    CallerMetadata _arg1 = data.readTypedObject(CallerMetadata.CREATOR);
                    IMeasurementCallback _arg2 = IMeasurementCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerWebTrigger(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    StatusParam _arg0 = data.readTypedObject(StatusParam.CREATOR);
                    CallerMetadata _arg1 = data.readTypedObject(CallerMetadata.CREATOR);
                    IMeasurementApiStatusCallback _arg2 = IMeasurementApiStatusCallback.Stub.asInterface(data.readStrongBinder());
                    this.getMeasurementApiStatus(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    DeletionParam _arg0 = data.readTypedObject(DeletionParam.CREATOR);
                    CallerMetadata _arg1 = data.readTypedObject(CallerMetadata.CREATOR);
                    IMeasurementCallback _arg2 = IMeasurementCallback.Stub.asInterface(data.readStrongBinder());
                    this.deleteRegistrations(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IMeasurementService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMeasurementService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void register(RegistrationRequest params, CallerMetadata callerMetadata, IMeasurementCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMeasurementService.DESCRIPTOR);
                    _data.writeTypedObject(params, 0);
                    _data.writeTypedObject(callerMetadata, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerWebSource(WebSourceRegistrationRequestInternal params, CallerMetadata callerMetadata, IMeasurementCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMeasurementService.DESCRIPTOR);
                    _data.writeTypedObject(params, 0);
                    _data.writeTypedObject(callerMetadata, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerWebTrigger(WebTriggerRegistrationRequestInternal params, CallerMetadata callerMetadata, IMeasurementCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMeasurementService.DESCRIPTOR);
                    _data.writeTypedObject(params, 0);
                    _data.writeTypedObject(callerMetadata, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getMeasurementApiStatus(StatusParam statusParam, CallerMetadata callerMetadata, IMeasurementApiStatusCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMeasurementService.DESCRIPTOR);
                    _data.writeTypedObject(statusParam, 0);
                    _data.writeTypedObject(callerMetadata, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteRegistrations(DeletionParam params, CallerMetadata callerMetadata, IMeasurementCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMeasurementService.DESCRIPTOR);
                    _data.writeTypedObject(params, 0);
                    _data.writeTypedObject(callerMetadata, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMeasurementService {
        @Override
        public void register(RegistrationRequest params, CallerMetadata callerMetadata, IMeasurementCallback callback) throws RemoteException {
        }

        @Override
        public void registerWebSource(WebSourceRegistrationRequestInternal params, CallerMetadata callerMetadata, IMeasurementCallback callback) throws RemoteException {
        }

        @Override
        public void registerWebTrigger(WebTriggerRegistrationRequestInternal params, CallerMetadata callerMetadata, IMeasurementCallback callback) throws RemoteException {
        }

        @Override
        public void getMeasurementApiStatus(StatusParam statusParam, CallerMetadata callerMetadata, IMeasurementApiStatusCallback callback) throws RemoteException {
        }

        @Override
        public void deleteRegistrations(DeletionParam params, CallerMetadata callerMetadata, IMeasurementCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

