/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.adservices.adid.AdId;
import android.adservices.adid.AdIdManager;
import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.CallerMetadata;
import android.adservices.common.SandboxedSdkContextUtils;
import android.adservices.measurement.DeletionParam;
import android.adservices.measurement.DeletionRequest;
import android.adservices.measurement.IMeasurementApiStatusCallback;
import android.adservices.measurement.IMeasurementCallback;
import android.adservices.measurement.IMeasurementService;
import android.adservices.measurement.MeasurementErrorResponse;
import android.adservices.measurement.RegistrationRequest;
import android.adservices.measurement.StatusParam;
import android.adservices.measurement.WebSourceRegistrationRequest;
import android.adservices.measurement.WebSourceRegistrationRequestInternal;
import android.adservices.measurement.WebTriggerRegistrationRequest;
import android.adservices.measurement.WebTriggerRegistrationRequestInternal;
import android.annotation.RequiresPermission;
import android.app.sdksandbox.SandboxedSdkContext;
import android.content.Context;
import android.net.Uri;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os._Original_Build;
import android.view.InputEvent;
import androidx.annotation.RequiresApi;
import com.android.adservices.LogUtil;
import com.android.adservices.ServiceBinder;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@RequiresApi(value=31)
public class MeasurementManager {
    public static final String MEASUREMENT_SERVICE = "measurement_service";
    public static final int MEASUREMENT_API_STATE_DISABLED = 0;
    public static final int MEASUREMENT_API_STATE_ENABLED = 1;
    private final long AD_ID_TIMEOUT_MS = 400L;
    private Context mContext;
    private ServiceBinder<IMeasurementService> mServiceBinder;
    private AdIdManager mAdIdManager;
    private Executor mAdIdExecutor = Executors.newCachedThreadPool();
    private static final String DEBUG_API_WARNING_MESSAGE = "To enable debug api, include ACCESS_ADSERVICES_AD_ID permission and enable advertising ID under device settings";

    public static MeasurementManager get(Context context) {
        return _Original_Build.VERSION.SDK_INT >= 33 ? context.getSystemService(MeasurementManager.class) : new MeasurementManager(context);
    }

    @VisibleForTesting
    public static MeasurementManager get(Context context, AdIdManager adIdManager) {
        MeasurementManager measurementManager = MeasurementManager.get(context);
        measurementManager.mAdIdManager = adIdManager;
        return measurementManager;
    }

    public MeasurementManager(Context context) {
        if (_Original_Build.VERSION.SDK_INT < 31) {
            throw new IllegalStateException("Service is not available.");
        }
        this.initialize(context);
    }

    public MeasurementManager initialize(Context context) {
        this.mContext = context;
        this.mServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.MEASUREMENT_SERVICE", IMeasurementService.Stub::asInterface);
        this.mAdIdManager = AdIdManager.get(context);
        return this;
    }

    @VisibleForTesting
    public IMeasurementService getService() throws IllegalStateException {
        IMeasurementService service = this.mServiceBinder.getService();
        if (service == null) {
            throw new IllegalStateException("Unable to find the service");
        }
        return service;
    }

    private boolean isAdIdPermissionEnabled(AdId adId) {
        return !"00000000-0000-0000-0000-000000000000".equals(adId.getAdId());
    }

    private void register(RegistrationRequest registrationRequest, IMeasurementService service, final Executor executor, final OutcomeReceiver<Object, Exception> callback) {
        block3: {
            Objects.requireNonNull(registrationRequest);
            String registrationType = "source";
            if (registrationRequest.getRegistrationType() == 2) {
                registrationType = "trigger";
            }
            LogUtil.d("Registering " + registrationType);
            try {
                service.register(registrationRequest, this.generateCallerMetadataWithCurrentTime(), new IMeasurementCallback.Stub(){

                    @Override
                    public void onResult() {
                        if (callback != null && executor != null) {
                            executor.execute(() -> callback.onResult(new Object()));
                        }
                    }

                    @Override
                    public void onFailure(MeasurementErrorResponse failureParcel) {
                        if (callback != null && executor != null) {
                            executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(failureParcel)));
                        }
                    }
                });
            }
            catch (RemoteException e) {
                LogUtil.e(e, "RemoteException");
                if (callback == null || executor == null) break block3;
                executor.execute(() -> callback.onError(new IllegalStateException(e)));
            }
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerSource(Uri attributionSource, InputEvent inputEvent, Executor executor, OutcomeReceiver<Object, Exception> callback) {
        Objects.requireNonNull(attributionSource);
        IMeasurementService service = this.getServiceWrapper(executor, callback);
        if (service == null) {
            LogUtil.d("Measurement service not found");
            return;
        }
        RegistrationRequest.Builder builder = new RegistrationRequest.Builder(1, attributionSource, this.getAppPackageName(), this.getSdkPackageName()).setRequestTime(SystemClock.uptimeMillis()).setInputEvent(inputEvent);
        this.getAdId((isAdIdEnabled, adIdValue) -> this.register(builder.setAdIdPermissionGranted(isAdIdEnabled).setAdIdValue(adIdValue).build(), service, executor, callback));
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerWebSource(WebSourceRegistrationRequest request, final Executor executor, final OutcomeReceiver<Object, Exception> callback) {
        Objects.requireNonNull(request);
        IMeasurementService service = this.getServiceWrapper(executor, callback);
        if (service == null) {
            LogUtil.d("Measurement service not found");
            return;
        }
        CallerMetadata callerMetadata = this.generateCallerMetadataWithCurrentTime();
        IMeasurementCallback.Stub measurementCallback = new IMeasurementCallback.Stub(){

            @Override
            public void onResult() {
                if (callback != null && executor != null) {
                    executor.execute(() -> callback.onResult(new Object()));
                }
            }

            @Override
            public void onFailure(MeasurementErrorResponse failureParcel) {
                if (callback != null && executor != null) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            }
        };
        WebSourceRegistrationRequestInternal.Builder builder = new WebSourceRegistrationRequestInternal.Builder(request, this.getAppPackageName(), this.getSdkPackageName(), SystemClock.uptimeMillis());
        this.getAdId((isAdIdEnabled, adIdValue) -> this.registerWebSourceWrapper(builder.setAdIdPermissionGranted(isAdIdEnabled).build(), service, executor, callerMetadata, measurementCallback, callback));
    }

    private void registerWebSourceWrapper(WebSourceRegistrationRequestInternal request, IMeasurementService service, Executor executor, CallerMetadata callerMetadata, IMeasurementCallback measurementCallback, OutcomeReceiver<Object, Exception> callback) {
        block2: {
            try {
                LogUtil.d("Registering web source");
                service.registerWebSource(request, callerMetadata, measurementCallback);
            }
            catch (RemoteException e) {
                LogUtil.e(e, "RemoteException");
                if (callback == null || executor == null) break block2;
                executor.execute(() -> callback.onError(new IllegalStateException(e)));
            }
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerWebTrigger(WebTriggerRegistrationRequest request, final Executor executor, final OutcomeReceiver<Object, Exception> callback) {
        Objects.requireNonNull(request);
        IMeasurementService service = this.getServiceWrapper(executor, callback);
        if (service == null) {
            LogUtil.d("Measurement service not found");
            return;
        }
        CallerMetadata callerMetadata = this.generateCallerMetadataWithCurrentTime();
        IMeasurementCallback.Stub measurementCallback = new IMeasurementCallback.Stub(){

            @Override
            public void onResult() {
                if (callback != null && executor != null) {
                    executor.execute(() -> callback.onResult(new Object()));
                }
            }

            @Override
            public void onFailure(MeasurementErrorResponse failureParcel) {
                if (callback != null && executor != null) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            }
        };
        WebTriggerRegistrationRequestInternal.Builder builder = new WebTriggerRegistrationRequestInternal.Builder(request, this.getAppPackageName(), this.getSdkPackageName());
        this.getAdId((isAdIdEnabled, adIdValue) -> this.registerWebTriggerWrapper(builder.setAdIdPermissionGranted(isAdIdEnabled).build(), service, executor, callerMetadata, measurementCallback, callback));
    }

    private void registerWebTriggerWrapper(WebTriggerRegistrationRequestInternal request, IMeasurementService service, Executor executor, CallerMetadata callerMetadata, IMeasurementCallback measurementCallback, OutcomeReceiver<Object, Exception> callback) {
        block2: {
            try {
                LogUtil.d("Registering web trigger");
                service.registerWebTrigger(request, callerMetadata, measurementCallback);
            }
            catch (RemoteException e) {
                LogUtil.e(e, "RemoteException");
                if (callback == null || executor == null) break block2;
                executor.execute(() -> callback.onError(new IllegalStateException(e)));
            }
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerTrigger(Uri trigger, Executor executor, OutcomeReceiver<Object, Exception> callback) {
        Objects.requireNonNull(trigger);
        IMeasurementService service = this.getServiceWrapper(executor, callback);
        if (service == null) {
            LogUtil.d("Measurement service not found");
            return;
        }
        RegistrationRequest.Builder builder = new RegistrationRequest.Builder(2, trigger, this.getAppPackageName(), this.getSdkPackageName());
        this.getAdId((isAdIdEnabled, adIdValue) -> this.register(builder.setAdIdPermissionGranted(isAdIdEnabled).setAdIdValue(adIdValue).build(), service, executor, callback));
    }

    private void deleteRegistrations(DeletionParam deletionParam, final Executor executor, final OutcomeReceiver<Object, Exception> callback) {
        Objects.requireNonNull(deletionParam);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        IMeasurementService service = this.getServiceWrapper(executor, callback);
        if (service == null) {
            LogUtil.d("Measurement service not found");
            return;
        }
        try {
            service.deleteRegistrations(deletionParam, this.generateCallerMetadataWithCurrentTime(), new IMeasurementCallback.Stub(){

                @Override
                public void onResult() {
                    executor.execute(() -> callback.onResult(new Object()));
                }

                @Override
                public void onFailure(MeasurementErrorResponse failureParcel) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
            executor.execute(() -> callback.onError(new IllegalStateException(e)));
        }
    }

    public void deleteRegistrations(DeletionRequest deletionRequest, Executor executor, OutcomeReceiver<Object, Exception> callback) {
        this.deleteRegistrations(new DeletionParam.Builder(deletionRequest.getOriginUris(), deletionRequest.getDomainUris(), deletionRequest.getStart(), deletionRequest.getEnd(), this.getAppPackageName(), this.getSdkPackageName()).setDeletionMode(deletionRequest.getDeletionMode()).setMatchBehavior(deletionRequest.getMatchBehavior()).build(), executor, callback);
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void getMeasurementApiStatus(final Executor executor, final OutcomeReceiver<Integer, Exception> callback) {
        IMeasurementService service;
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            service = this.getService();
        }
        catch (IllegalStateException e) {
            LogUtil.e(e, "Failed to bind to measurement service");
            executor.execute(() -> callback.onResult(0));
            return;
        }
        catch (RuntimeException e) {
            LogUtil.e(e, "Unknown failure while binding measurement service");
            executor.execute(() -> callback.onError(e));
            return;
        }
        try {
            service.getMeasurementApiStatus(new StatusParam.Builder(this.getAppPackageName(), this.getSdkPackageName()).build(), this.generateCallerMetadataWithCurrentTime(), new IMeasurementApiStatusCallback.Stub(){

                @Override
                public void onResult(int result) {
                    executor.execute(() -> callback.onResult(result));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
            executor.execute(() -> callback.onResult(0));
        }
        catch (RuntimeException e) {
            LogUtil.e(e, "Unknown failure while getting measurement status");
            executor.execute(() -> callback.onError(e));
        }
    }

    @VisibleForTesting
    public void unbindFromService() {
        this.mServiceBinder.unbindFromService();
    }

    private String getAppPackageName() {
        SandboxedSdkContext sandboxedSdkContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(this.mContext);
        return sandboxedSdkContext == null ? this.mContext.getPackageName() : sandboxedSdkContext.getClientPackageName();
    }

    private String getSdkPackageName() {
        SandboxedSdkContext sandboxedSdkContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(this.mContext);
        return sandboxedSdkContext == null ? "" : sandboxedSdkContext.getSdkPackageName();
    }

    private CallerMetadata generateCallerMetadataWithCurrentTime() {
        return new CallerMetadata.Builder().setBinderElapsedTimestamp(SystemClock.elapsedRealtime()).build();
    }

    private IMeasurementService getServiceWrapper(Executor executor, OutcomeReceiver<Object, Exception> callback) {
        IMeasurementService service;
        block2: {
            service = null;
            try {
                service = this.getService();
            }
            catch (RuntimeException e) {
                LogUtil.e(e, "Failed binding to measurement service");
                if (callback == null || executor == null) break block2;
                executor.execute(() -> callback.onError(e));
            }
        }
        return service;
    }

    private void getAdId(MeasurementAdIdCallback measurementAdIdCallback) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicBoolean isAdIdEnabled = new AtomicBoolean();
        final AtomicReference adIdValue = new AtomicReference();
        this.mAdIdManager.getAdId(this.mAdIdExecutor, new OutcomeReceiver<AdId, Exception>(){

            @Override
            public void onResult(AdId adId) {
                isAdIdEnabled.set(MeasurementManager.this.isAdIdPermissionEnabled(adId));
                adIdValue.set(adId.getAdId().equals("00000000-0000-0000-0000-000000000000") ? null : adId.getAdId());
                LogUtil.d("AdId permission enabled %b", isAdIdEnabled.get());
                countDownLatch.countDown();
            }

            @Override
            public void onError(Exception error) {
                boolean isExpected;
                boolean bl = isExpected = error instanceof IllegalStateException || error instanceof SecurityException;
                if (isExpected) {
                    LogUtil.w(MeasurementManager.DEBUG_API_WARNING_MESSAGE);
                } else {
                    LogUtil.w(error, MeasurementManager.DEBUG_API_WARNING_MESSAGE, new Object[0]);
                }
                countDownLatch.countDown();
            }
        });
        boolean timedOut = false;
        try {
            timedOut = !countDownLatch.await(400L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LogUtil.w(e, "InterruptedException while waiting for AdId", new Object[0]);
        }
        if (timedOut) {
            LogUtil.w("AdId call timed out");
        }
        measurementAdIdCallback.onAdIdCallback(isAdIdEnabled.get(), (String)adIdValue.get());
    }

    private static interface MeasurementAdIdCallback {
        public void onAdIdCallback(boolean var1, String var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MeasurementApiState {
    }
}

